/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class FetchNvResponse
extends LonMessage
implements NetMessages {
    private int nvIndex;
    private byte[] nvData;

    public int getNvIndex() {
        return this.nvIndex;
    }

    public void setNvIndex(int n) {
        this.nvIndex = n;
    }

    public byte[] getNvData() {
        return this.nvData;
    }

    public int getNvDataLength() {
        return this.nvData.length;
    }

    public void setNvData(byte[] byArray) {
        this.nvData = byArray;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        if (this.nvIndex > 254) {
            lonOutputStream.writeUnsigned8(255);
            lonOutputStream.writeUnsigned16(this.nvIndex);
        } else {
            lonOutputStream.writeUnsigned8(this.nvIndex);
        }
        lonOutputStream.writeByteArray(this.nvData);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 51) {
            throw new InvalidResponseException(n);
        }
        this.nvIndex = lonInputStream.readUnsigned8();
        if (this.nvIndex == 255) {
            this.nvIndex = lonInputStream.readUnsigned16();
        }
        this.nvData = new byte[lonInputStream.available()];
        this.nvData = lonInputStream.readByteArray();
    }

    public FetchNvResponse(int n, byte[] byArray) {
        this.code = 51;
        this.nvIndex = n;
        this.nvData = byArray;
    }

    public FetchNvResponse(LonInputStream lonInputStream) throws LonException {
        this.code = 51;
        this.fromInputStream(lonInputStream);
    }
}

