/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.FetchNvResponse;
import com.tridium.lonworks.netmessages.NetMessages;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class FetchNvRequest
extends LonMessage
implements NetMessages {
    private int nvIndex;

    public int getNvIndex() {
        return this.nvIndex;
    }

    public void setNvIndex(int n) {
        this.nvIndex = n;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        if (this.nvIndex > 254) {
            lonOutputStream.write(255);
            lonOutputStream.writeUnsigned16(this.nvIndex);
        } else {
            lonOutputStream.write(this.nvIndex);
        }
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 115) {
            throw new InvalidResponseException(n);
        }
        this.nvIndex = lonInputStream.read();
        if (this.nvIndex == 255) {
            this.nvIndex = lonInputStream.readUnsigned16();
        }
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 19) {
            throw new FailedResponseException();
        }
        if (n != 51) {
            throw new InvalidResponseException(n);
        }
        lonInputStream.reset();
        return new FetchNvResponse(lonInputStream);
    }

    public FetchNvRequest() {
        this.code = 115;
    }

    public FetchNvRequest(int n) {
        this.code = 115;
        this.nvIndex = n;
    }
}

