/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryNvConfigResponse;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonInputStream;

public class ExEnumerateNvConfigResponse
extends QueryNvConfigResponse
implements NetMessages {
    int index;
    int tgtNvIndex;
    boolean nvWriteByIndex;
    boolean nvRemoteNvAuth;
    boolean nvReadByIndex;

    public boolean isExtended() {
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTgtNvIndex() {
        return this.tgtNvIndex;
    }

    public boolean getNvWriteByIndex() {
        return this.nvWriteByIndex;
    }

    public boolean getNvRemoteNvAuth() {
        return this.nvRemoteNvAuth;
    }

    public boolean getNvReadByIndex() {
        return this.nvReadByIndex;
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        this.code = lonInputStream.readUnsigned8();
        if (this.code != 48) {
            throw new InvalidResponseException(this.code);
        }
        this.index = lonInputStream.readUnsigned16();
        int n = lonInputStream.setBitFieldMark();
        if (this.configData == null) {
            this.configData = new BNvConfigData();
        }
        this.configData.setPriority(lonInputStream.readBooleanBit(0, 7, 1));
        BLonNvDirection bLonNvDirection = lonInputStream.readBooleanBit(0, 6, 1) ? BLonNvDirection.output : BLonNvDirection.input;
        this.configData.setDirection(bLonNvDirection);
        this.configData.setSelector(lonInputStream.readBit(0, 0, 6) << 8 | lonInputStream.readUnsigned8());
        this.configData.setTurnAround(lonInputStream.readBooleanBit(2, 7, 1));
        this.configData.setAuthenticated(lonInputStream.readBooleanBit(2, 6, 1));
        this.nvWriteByIndex = lonInputStream.readBooleanBit(2, 5, 1);
        this.nvRemoteNvAuth = lonInputStream.readBooleanBit(2, 4, 1);
        this.nvReadByIndex = lonInputStream.readBooleanBit(3, 7, 1);
        this.configData.setServiceType(BLonServiceType.make(lonInputStream.readBit(3, 5, 2)));
        int n2 = lonInputStream.readUnsigned16();
        if (n2 == (char)-1) {
            n2 = -1;
        }
        this.configData.setAddrIndex(n2);
        this.tgtNvIndex = lonInputStream.readUnsigned16();
        lonInputStream.resetBitFieldMark(n);
    }

    public ExEnumerateNvConfigResponse(LonInputStream lonInputStream) throws LonException {
        this.fromInputStream(lonInputStream);
    }
}

