/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryAliasResponse;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonInputStream;

public class ExEnumerateAliasResponse
extends QueryAliasResponse
implements NetMessages {
    int aliasIndex;
    int tgtNvIndex;
    boolean nvWriteByIndex;
    boolean nvRemoteNvAuth;
    boolean nvReadByIndex;

    public boolean isExtended() {
        return true;
    }

    public int getAliasIndex() {
        return this.aliasIndex;
    }

    public int getTgtNvIndex() {
        return this.tgtNvIndex;
    }

    public boolean getNvWriteByIndex() {
        return this.nvWriteByIndex;
    }

    public boolean getNvRemoteNvAuth() {
        return this.nvRemoteNvAuth;
    }

    public boolean getNvReadByIndex() {
        return this.nvReadByIndex;
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        this.code = lonInputStream.readUnsigned8();
        if (this.code != 48) {
            throw new InvalidResponseException(this.code);
        }
        this.aliasIndex = lonInputStream.readUnsigned16();
        int n = lonInputStream.setBitFieldMark();
        if (this.aliasData == null) {
            this.aliasData = new BAliasConfigData();
        }
        this.aliasData.setPriority(lonInputStream.readBooleanBit(0, 7, 1));
        BLonNvDirection bLonNvDirection = lonInputStream.readBooleanBit(0, 6, 1) ? BLonNvDirection.output : BLonNvDirection.input;
        this.aliasData.setDirection(bLonNvDirection);
        this.aliasData.setSelector((lonInputStream.readBit(0, 0, 6) << 8) + lonInputStream.readUnsigned8());
        this.aliasData.setTurnAround(lonInputStream.readBooleanBit(2, 7, 1));
        this.aliasData.setAuthenticated(lonInputStream.readBooleanBit(2, 6, 1));
        this.nvWriteByIndex = lonInputStream.readBooleanBit(2, 5, 1);
        this.nvRemoteNvAuth = lonInputStream.readBooleanBit(2, 4, 1);
        this.nvReadByIndex = lonInputStream.readBooleanBit(3, 7, 1);
        int n2 = lonInputStream.readBit(3, 5, 2);
        this.aliasData.setServiceType(BLonServiceType.make(n2));
        this.aliasData.setAddrIndex(lonInputStream.readUnsigned16());
        this.tgtNvIndex = lonInputStream.readUnsigned16();
        this.aliasData.setPrimary(lonInputStream.readUnsigned16());
        lonInputStream.resetBitFieldMark(n);
    }

    public ExEnumerateAliasResponse(LonInputStream lonInputStream) throws LonException {
        this.fromInputStream(lonInputStream);
    }
}

