/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.enums.BLonCompletionCode;
import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.loncomm.RawMessage;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BBroadcast;
import javax.baja.lonworks.datatypes.BImplicit;
import javax.baja.lonworks.datatypes.BLonCommConfig;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.AppBuffer;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.spy.SpyWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NAppBuffer
implements AppBuffer,
LinkedQueue.Linkable {
    protected static final int NI_HDR_SIZE = 2;
    public static final int niTQ = 2;
    public static final int niTQ_P = 3;
    public static final int niNTQ = 4;
    public static final int niNTQ_P = 5;
    public static final int niRESPONSE = 6;
    public static final int niINCOMING = 8;
    public static final int niCOMM = 16;
    public static final int niNETMGMT = 32;
    public static final int niRESET = 80;
    public static final int niFLUSH_CANCEL = 96;
    public static final int niFLUSH_COMPLETE = 96;
    public static final int niONLINE = 112;
    public static final int niOFFLINE = 128;
    public static final int niFLUSH = 144;
    public static final int niFLUSH_IGN = 160;
    public static final int niSLEEP = 176;
    public static final int niSSTATUS = 224;
    public static final int niIRQENA = 229;
    public static final int niSERVICE = 230;
    public static final int QUEUE_MASK = 15;
    public static final int CMD_MASK = 240;
    protected static final int MSG_HDR_OFFSET = 2;
    protected static final int MSG_HDR_SIZE = 3;
    protected static final int NETVAR_BIT = 128;
    protected static final int AUTH_BIT = 16;
    protected static final int PRIORITY_BIT = 128;
    protected static final int PATH_BIT = 64;
    protected static final int ADDR_MODE_BIT = 8;
    protected static final int ALT_PATH_BIT = 4;
    protected static final int TRNARND_BIT = 4;
    protected static final int POOL_BIT = 2;
    protected static final int RESP_BIT = 1;
    protected static final int POLL_BIT = 64;
    protected static final int MSG_HDR_TYPE_MASK = 128;
    protected static final int SERVICE_TYPE_MASK = 96;
    protected static final int TAG_MASK = 15;
    protected static final int COMPL_CODE_MASK = 48;
    protected static final int ADDR_SIZE = 11;
    protected static final int ADDR_OFFSET = 5;
    private static final int TYPE_INDEX = 5;
    private static final int RSP_DOMAIN_INDEX = 5;
    private static final int IMPLICIT_TAG = 6;
    private static final int DOMAIN_INDEX = 6;
    private static final int NODE_INDEX = 6;
    private static final int RETRY_COUNT_INDEX = 7;
    private static final int REPEAT_TIMER_INDEX = 7;
    private static final int TRANSMIT_TIMER_INDEX = 8;
    private static final int SUBNET_INDEX = 9;
    private static final int NEURON_ID_INDEX = 10;
    private static final int DOMAIN_MASK = 128;
    private static final int NODE_MASK = 127;
    private static final int RETRY_COUNT_MASK = 15;
    private static final int REPEAT_TIMER_MASK = 240;
    private static final int TRANSMIT_TIMER_MASK = 15;
    private static final int SRC_SUBNET_INDEX = 6;
    private static final int SRC_NODE_INDEX = 7;
    protected static final int MSG_OFFSET = 16;
    public static final int APP_BUFFER_HDR_LEN = 16;
    private static final int MAX_APP_BUFFERS = 32;
    private static NAppBuffer[] appPool = new NAppBuffer[32];
    private static int appCnt = 0;
    private static int appInstanceCnt = 0;
    LonAddress destAddr;
    BLonRepeatTimer repeatTimer;
    BLonRepeatTimer transmitTimer;
    BLonServiceType serviceType;
    int retryCount;
    AppBuffInputStream inputStream;
    AppBuffOutputStream outputStream;
    public boolean farSide;
    private byte[] buf;
    private boolean freeBuf;
    private boolean localCommand;
    private boolean retryCountSet;
    private boolean repeatTimerSet;
    private boolean transmitTimerSet;
    private boolean noTransaction;
    public LonException exception;
    public NAppBuffer nextAppBuffer;
    static /* synthetic */ Class class$com$tridium$lonworks$loncomm$RawMessage;

    public boolean isResponse() {
        boolean bl = false;
        if (this.getQueue() == 6) {
            bl = true;
        }
        return bl;
    }

    public boolean isIncoming() {
        boolean bl = false;
        if (this.getQueue() == 8) {
            bl = true;
        }
        return bl;
    }

    public int getQueue() {
        return this.buf[0] & 0xF;
    }

    public void setQueue(int n) {
        this.buf[0] = (byte)(this.buf[0] & 0xFFFFFFF0);
        this.buf[0] = (byte)(this.buf[0] | n);
    }

    public int getCommand() {
        return this.buf[0] & 0xF0;
    }

    public void setCommand(int n) {
        this.buf[0] = (byte)(this.buf[0] & 0xFFFFFF0F);
        this.buf[0] = (byte)(this.buf[0] | n);
    }

    public void setLocalCommand(int n) {
        this.setCommand(n);
        this.localCommand = true;
    }

    public boolean isLocalCommand() {
        return this.localCommand;
    }

    public int getBufferLength() {
        return this.getByte(1);
    }

    public void setBufferLength(int n) {
        this.buf[1] = (byte)n;
    }

    public boolean isNetVar() {
        boolean bl = false;
        if ((this.buf[2] & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public int getTag() {
        return this.buf[2] & 0xF;
    }

    public void setTag(int n) {
        this.buf[2] = (byte)(this.buf[2] & 0xFFFFFFF0);
        this.buf[2] = (byte)(this.buf[2] | (byte)(n & 0xF));
    }

    public boolean isPriority() {
        boolean bl = false;
        if ((this.buf[3] & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setPriority(boolean bl) {
        this.buf[3] = bl ? (byte)(this.buf[3] | 0x80) : (byte)(this.buf[3] & 0xFFFFFF7F);
    }

    public boolean isPath() {
        boolean bl = false;
        if ((this.buf[3] & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setPath(boolean bl) {
        this.buf[3] = bl ? (byte)(this.buf[3] | 0x40) : (byte)(this.buf[3] & 0xFFFFFFBF);
    }

    public BLonCompletionCode getComplCode() {
        return (BLonCompletionCode)BLonCompletionCode.notComp.getRange().get((this.buf[3] & 0x30) >> 4);
    }

    public boolean isCompletionEvent() {
        boolean bl = false;
        if ((this.buf[3] & 0x30) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setComplCode(BLonCompletionCode bLonCompletionCode) {
        if (bLonCompletionCode == BLonCompletionCode.notComp || bLonCompletionCode == BLonCompletionCode.succeeds || bLonCompletionCode == BLonCompletionCode.fails) {
            this.buf[3] = (byte)(this.buf[3] & 0xFFFFFFCF);
            this.buf[3] = (byte)(this.buf[3] | bLonCompletionCode.getOrdinal() << 4);
        }
    }

    public boolean isExplicitAddress() {
        boolean bl = false;
        if ((this.buf[3] & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isImplicitAddress() {
        return this.isExplicitAddress() ^ true;
    }

    public void setExplicitAddress(boolean bl) {
        this.buf[3] = bl ? (byte)(this.buf[3] | 8) : (byte)(this.buf[3] & 0xFFFFFFF7);
    }

    public boolean isPool() {
        boolean bl = false;
        if ((this.buf[3] & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setPool(boolean bl) {
        this.buf[3] = bl ? (byte)(this.buf[3] | 2) : (byte)(this.buf[3] & 0xFFFFFFFD);
    }

    public boolean isResp() {
        boolean bl = false;
        if ((this.buf[3] & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setResp(boolean bl) {
        this.buf[3] = bl ? (byte)(this.buf[3] | 1) : (byte)(this.buf[3] & 0xFFFFFFFE);
    }

    public int getDataLength() {
        return this.getByte(4);
    }

    public void setDataLength(int n) {
        this.buf[4] = (byte)n;
    }

    public BLonServiceType getServiceType() {
        return (BLonServiceType)BLonServiceType.unacked.getRange().get((this.buf[2] & 0x60) >> 5);
    }

    public boolean isRequest() {
        BLonServiceType bLonServiceType = this.getServiceType();
        boolean bl = false;
        if (bLonServiceType == BLonServiceType.request) {
            bl = true;
        }
        return bl;
    }

    public void setServiceType(BLonServiceType bLonServiceType) {
        this.setServiceType(bLonServiceType, false);
    }

    public void setServiceType(BLonServiceType bLonServiceType, boolean bl) {
        this.serviceType = bLonServiceType;
        if (bl) {
            this.setQueue(8);
        } else if (this.serviceType == BLonServiceType.unacked) {
            this.setQueue(4);
        } else {
            this.setQueue(2);
        }
        this.buf[2] = (byte)(this.buf[2] & 0xFFFFFF9F);
        this.buf[2] = (byte)(this.buf[2] | this.serviceType.getOrdinal() << 5);
    }

    public boolean isAuthenticate() {
        boolean bl = false;
        if ((this.buf[2] & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setAuthenticate(boolean bl) {
        this.buf[2] = bl ? (byte)(this.buf[2] | 0x10) : (byte)(this.buf[2] & 0xFFFFFFEF);
    }

    public boolean isAltPath() {
        boolean bl = false;
        if ((this.buf[3] & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setAltPath(boolean bl) {
        this.buf[3] = bl ? (byte)(this.buf[3] | 4) : (byte)(this.buf[3] & 0xFFFFFFFB);
    }

    public boolean isPoll() {
        boolean bl = false;
        if ((this.buf[2] & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setPoll(boolean bl) {
        this.buf[2] = bl ? (byte)(this.buf[2] | 0x40) : (byte)(this.buf[2] & 0xFFFFFFBF);
    }

    public boolean isTurnaround() {
        boolean bl = false;
        if ((this.buf[3] & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setTurnaround(boolean bl) {
        this.buf[3] = bl ? (byte)(this.buf[3] | 4) : (byte)(this.buf[3] & 0xFFFFFFFB);
    }

    public void setDestAddress(LonAddress lonAddress) {
        byte by;
        this.destAddr = lonAddress;
        boolean bl = true;
        this.buf[5] = by = (byte)lonAddress.getAddressType();
        int n = 16;
        switch (by) {
            case 1: {
                this.buf[6] = (byte)(this.buf[6] | (byte)(((BSubnetNode)lonAddress).getNodeId() & 0x7F));
                this.buf[9] = (byte)((BSubnetNode)lonAddress).getSubnetId();
                break;
            }
            case 2: {
                System.arraycopy(((BNeuronId)lonAddress).getByteArray(), 0, this.buf, 10, 6);
                break;
            }
            case 0: {
                break;
            }
            case 127: {
                n = 32;
                break;
            }
            case 3: {
                this.setDomainIndex(((BBroadcast)lonAddress).getDomainIndex());
                break;
            }
            case 126: {
                this.setTag(((BImplicit)lonAddress).getTag());
                bl = false;
                this.disableSetDefaultTimer();
                break;
            }
        }
        this.setCommand(n);
        this.setExplicitAddress(bl);
    }

    public LonAddress getDestAddress() {
        return this.destAddr;
    }

    public void setDomainIndex(int n) {
        this.buf[6] = n == 0 ? (byte)(this.buf[6] & 0x7F) : (byte)(this.buf[6] | 0xFFFFFF80);
    }

    private final int getDomainIndex() {
        int n = 6 - this.isResponse();
        int n2 = 0;
        if ((this.buf[n] & 0x80) == 0) {
            n2 = 1;
        }
        int n3 = 1 - n2;
        return n3;
    }

    public void setRetryCount(int n) {
        if (n > 15) {
            n = 15;
        }
        this.buf[7] = (byte)(n | this.buf[7] & 0xF0);
        this.retryCountSet = true;
        this.retryCount = n;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRepeatTimer(BLonRepeatTimer bLonRepeatTimer) {
        int n = bLonRepeatTimer.getOrdinal();
        this.buf[7] = (byte)(n << 4 | this.buf[7] & 0xF);
        this.repeatTimerSet = true;
        this.repeatTimer = bLonRepeatTimer;
    }

    public BLonRepeatTimer getRepeatTimer() {
        return this.repeatTimer;
    }

    public void setTransmitTimer(BLonRepeatTimer bLonRepeatTimer) {
        int n = bLonRepeatTimer.getOrdinal();
        this.buf[8] = (byte)(this.buf[8] | (byte)n);
        this.transmitTimerSet = true;
        this.transmitTimer = bLonRepeatTimer;
    }

    public BLonRepeatTimer getTransmitTimer() {
        return this.transmitTimer;
    }

    public long getMaxTransactionTime() {
        if (this.serviceType == null) {
            return 8000L;
        }
        int n = 8000;
        if (this.serviceType == BLonServiceType.request || this.serviceType == BLonServiceType.acked) {
            if (this.transmitTimer != null && this.retryCount != 0) {
                n = this.transmitTimer.getTime() * (this.retryCount + 1);
            }
        } else if (this.serviceType == BLonServiceType.unackedRpt && this.repeatTimer != null && this.retryCount != 0) {
            n = this.repeatTimer.getTime() * (this.retryCount + 1);
        }
        return n;
    }

    public void disableSetDefaultTimer() {
        this.retryCountSet = true;
        this.repeatTimerSet = true;
        this.transmitTimerSet = true;
    }

    public void setDefaultTimers(BLonNetwork bLonNetwork) {
        BLonCommConfig bLonCommConfig = bLonNetwork.getLonCommConfig();
        if (!this.repeatTimerSet) {
            this.setRepeatTimer(bLonCommConfig.getRepeatTimer());
        }
        if (!this.transmitTimerSet) {
            this.setTransmitTimer(bLonCommConfig.getTransmitTimer());
        }
        if (!this.retryCountSet) {
            this.setRetryCount(bLonCommConfig.getRetryCount());
        }
    }

    public boolean isLocalAddress() {
        boolean bl = false;
        if (this.getCommand() == 32) {
            bl = true;
        }
        return bl;
    }

    public int getHiddenImplicitTransactionTag() {
        return this.getByte(6);
    }

    public void hideImplicitTransactionTag(int n) {
        this.buf[6] = (byte)n;
    }

    public void setTransactionTag(int n) {
        if (this.isImplicitAddress()) {
            this.hideImplicitTransactionTag(n);
        } else {
            this.setTag(n);
        }
    }

    public int getTransactionTag() {
        if (this.isImplicitAddress() && (this.buf[3] & 0x30) != 0) {
            return this.getHiddenImplicitTransactionTag();
        }
        return this.getTag();
    }

    public BSubnetNode getSourceAddress() {
        int n = this.buf[6] & 0xFF;
        int n2 = this.buf[7] & 0x7F;
        return BSubnetNode.make(n, n2);
    }

    public void setSourceAddress(BSubnetNode bSubnetNode) {
        this.buf[6] = (byte)bSubnetNode.getSubnetId();
        this.buf[7] = (byte)bSubnetNode.getNodeId();
    }

    public int getMessageCode() {
        return this.getByte(16);
    }

    public void setMessage(LonMessage lonMessage) {
        BLonRepeatTimer bLonRepeatTimer;
        BLonRepeatTimer bLonRepeatTimer2;
        int n;
        LonOutputStream lonOutputStream = this.getMsgOutputStream();
        if (lonMessage.isFarSide()) {
            lonOutputStream.writeUnsigned8(126);
        }
        lonMessage.toOutputStream(lonOutputStream);
        this.setDataLength(lonOutputStream.size() - 16);
        if (lonMessage.isPriority()) {
            this.setPriority(true);
        }
        if (lonMessage.isAuthenticate()) {
            this.setAuthenticate(true);
        }
        if ((n = lonMessage.getRetryCount()) > 15) {
            n = 15;
        }
        if (n >= 0) {
            this.setRetryCount(n);
        }
        if ((bLonRepeatTimer2 = lonMessage.getTransmitTimer()) != null) {
            this.setTransmitTimer(bLonRepeatTimer2);
        }
        if ((bLonRepeatTimer = lonMessage.getRepeatTimer()) != null) {
            this.setRepeatTimer(bLonRepeatTimer);
        }
    }

    public LonMessage getLonMessage(Class clazz) throws LonException {
        LonMessage lonMessage;
        try {
            if (clazz != null) {
                Class clazz2 = class$com$tridium$lonworks$loncomm$RawMessage;
                if (clazz2 == null) {
                    clazz2 = class$com$tridium$lonworks$loncomm$RawMessage = NAppBuffer.class("[Lcom.tridium.lonworks.loncomm.RawMessage;", false);
                }
                if (clazz == clazz2) {
                    return new RawMessage(this.buf, 16 + this.getDataLength());
                }
                lonMessage = (LonMessage)clazz.newInstance();
                lonMessage.fromInputStream(this.getMsgInputStream());
            } else {
                lonMessage = new LonMessage(this.getMsgInputStream());
            }
        }
        catch (Throwable throwable) {
            throw new LonException("Unable to create LonMessage.", throwable);
        }
        this.setMessageAttributes(lonMessage);
        return lonMessage;
    }

    private final void setMessageAttributes(LonMessage lonMessage) {
        lonMessage.setRequest(this.isRequest());
        lonMessage.setPriority(this.isPriority());
        lonMessage.setSourceAddress(this.getSourceAddress());
        lonMessage.setTag(this.getTag());
        lonMessage.setDomainIndex(this.getDomainIndex());
    }

    public LonMessage makeResponse(LonMessage lonMessage) throws LonException {
        LonMessage lonMessage2 = lonMessage.toResponse(this.getMsgInputStream());
        this.setMessageAttributes(lonMessage2);
        return lonMessage2;
    }

    private final LonInputStream getMsgInputStream() {
        if (this.inputStream == null) {
            this.inputStream = new AppBuffInputStream(this.buf, this.getDataLength());
        } else {
            this.inputStream.init(this.buf, this.getDataLength());
        }
        return this.inputStream;
    }

    private final LonOutputStream getMsgOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new AppBuffOutputStream(this.buf);
        } else {
            this.outputStream.init(this.buf);
        }
        return this.outputStream;
    }

    private final int getByte(int n) {
        return this.buf[n] & 0xFF;
    }

    public String toString() {
        return LonByteArrayUtil.toString(this.buf, this.getWriteBufferLen());
    }

    byte[] getReadBuffer() {
        return this.buf;
    }

    byte[] getWriteBuffer() {
        this.setBufferLength(this.getDataLength() + 3 + 11);
        return this.buf;
    }

    public int getWriteBufferLen() {
        if (this.localCommand) {
            return 2;
        }
        return 16 + this.getDataLength();
    }

    public byte[] toNetworkBytes() {
        byte[] byArray = new byte[this.getWriteBufferLen()];
        System.arraycopy(this.buf, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void writeMessage(LonOutputStream lonOutputStream) {
        if (this.farSide) {
            lonOutputStream.writeUnsigned8(126);
        }
        int n = 16;
        int n2 = this.getDataLength();
        lonOutputStream.write(this.buf, n, n2);
    }

    public void readMessage(LonInputStream lonInputStream, int n) {
        boolean bl = false;
        if (lonInputStream.read() == 126) {
            bl = this.farSide = true;
        }
        if (this.farSide) {
            --n;
        } else {
            lonInputStream.reset(lonInputStream.position() - 1);
        }
        this.setDataLength(n);
        int n2 = 16;
        int n3 = n2 + n;
        while (n2 < n3) {
            this.buf[n2] = (byte)lonInputStream.read();
            ++n2;
        }
    }

    public LinkedQueue.Linkable getNext() {
        return this.nextAppBuffer;
    }

    public void setNext(LinkedQueue.Linkable linkable) {
        this.nextAppBuffer = (NAppBuffer)linkable;
    }

    public void setNoTransaction(boolean bl) {
        this.noTransaction = bl;
    }

    public boolean isNoTransaction() {
        return this.noTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NAppBuffer makeAppBuffer() {
        NAppBuffer[] nAppBufferArray = appPool;
        synchronized (appPool) {
            NAppBuffer nAppBuffer;
            block5: {
                block4: {
                    if (appCnt <= 0) break block4;
                    nAppBuffer = appPool[--appCnt];
                    break block5;
                }
                nAppBuffer = new NAppBuffer();
                ++appInstanceCnt;
            }
            nAppBuffer.freeBuf = false;
            // ** MonitorExit[var1] (shouldn't be in output)
            int n = 0;
            while (n < nAppBuffer.buf.length) {
                nAppBuffer.buf[n] = 0;
                ++n;
            }
            nAppBuffer.nextAppBuffer = null;
            nAppBuffer.exception = null;
            nAppBuffer.localCommand = false;
            nAppBuffer.retryCountSet = false;
            nAppBuffer.repeatTimerSet = false;
            nAppBuffer.transmitTimerSet = false;
            nAppBuffer.noTransaction = false;
            nAppBuffer.farSide = false;
            nAppBuffer.repeatTimer = null;
            nAppBuffer.transmitTimer = null;
            nAppBuffer.serviceType = null;
            nAppBuffer.retryCount = 0;
            return nAppBuffer;
        }
    }

    public static NAppBuffer makeAppBuffer(byte[] byArray) {
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        System.arraycopy(byArray, 0, nAppBuffer.buf, 0, byArray.length);
        return nAppBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseAppBuffer() {
        NAppBuffer[] nAppBufferArray = appPool;
        synchronized (appPool) {
            NAppBuffer nAppBuffer = this;
            while (true) {
                if (nAppBuffer == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (nAppBuffer.freeBuf) {
                    System.out.println("already free ");
                    Thread.dumpStack();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (appCnt < appPool.length) {
                    NAppBuffer.appPool[NAppBuffer.appCnt++] = nAppBuffer;
                }
                nAppBuffer.freeBuf = true;
                nAppBuffer = nAppBuffer.nextAppBuffer;
            }
        }
    }

    public static void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("Application Buffers");
        spyWriter.prop((Object)"App Buffers created", appInstanceCnt);
        spyWriter.prop((Object)"App Buffers available", appCnt);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.destAddr = null;
        this.repeatTimer = null;
        this.transmitTimer = null;
        this.serviceType = null;
        this.retryCount = 0;
        this.inputStream = null;
        this.outputStream = null;
        this.buf = new byte[255];
        this.freeBuf = false;
        this.localCommand = false;
        this.exception = null;
        this.nextAppBuffer = null;
    }

    public NAppBuffer() {
        this.this();
    }

    static class AppBuffInputStream
    extends LonInputStream {
        private final void init(byte[] byArray, int n) {
            this.buf = byArray;
            this.pos = 16;
            this.count = 16 + n;
        }

        public void reset() {
            this.pos = 16;
        }

        AppBuffInputStream(byte[] byArray, int n) {
            super(byArray);
            this.init(byArray, n);
        }
    }

    static class AppBuffOutputStream
    extends LonOutputStream {
        private final void init(byte[] byArray) {
            this.buf = byArray;
            this.count = 16;
        }

        AppBuffOutputStream(byte[] byArray) {
            this.init(byArray);
        }
    }
}

