/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.datatypes.BLinkFilterEntry;
import com.tridium.lonworks.datatypes.BLinkFilterTable;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.loncomm.NLonLinkLayer;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLinkFilter
extends BComponent
implements NLonLinkLayer.LinkListener {
    public static final Property enableSubnetNode = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property subnetNode = BLinkFilter.newProperty((int)0, (BValue)BSubnetNode.DEFAULT, null);
    public static final Property enableDevice = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property deviceName = BLinkFilter.newProperty((int)0, (String)"", null);
    public static final Property enableSelector = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property selector = BLinkFilter.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)16383)));
    public static final Property maxEntries = BLinkFilter.newProperty((int)0, (int)1000, null);
    public static final Property entries = BLinkFilter.newProperty((int)7, (BValue)new BLinkFilterTable(), null);
    public static final Property toStandardOut = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property includeCompletionEvents = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Action clearTable = BLinkFilter.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    NLonLinkLayer llink;
    BLonDevice dev;
    static /* synthetic */ Class class$com$tridium$lonworks$loncomm$BLinkFilter;

    public boolean getEnableSubnetNode() {
        return this.getBoolean(enableSubnetNode);
    }

    public void setEnableSubnetNode(boolean bl) {
        this.setBoolean(enableSubnetNode, bl, null);
    }

    public BSubnetNode getSubnetNode() {
        return (BSubnetNode)this.get(subnetNode);
    }

    public void setSubnetNode(BSubnetNode bSubnetNode) {
        this.set(subnetNode, (BValue)bSubnetNode, null);
    }

    public boolean getEnableDevice() {
        return this.getBoolean(enableDevice);
    }

    public void setEnableDevice(boolean bl) {
        this.setBoolean(enableDevice, bl, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public boolean getEnableSelector() {
        return this.getBoolean(enableSelector);
    }

    public void setEnableSelector(boolean bl) {
        this.setBoolean(enableSelector, bl, null);
    }

    public int getSelector() {
        return this.getInt(selector);
    }

    public void setSelector(int n) {
        this.setInt(selector, n, null);
    }

    public int getMaxEntries() {
        return this.getInt(maxEntries);
    }

    public void setMaxEntries(int n) {
        this.setInt(maxEntries, n, null);
    }

    public BLinkFilterTable getEntries() {
        return (BLinkFilterTable)this.get(entries);
    }

    public void setEntries(BLinkFilterTable bLinkFilterTable) {
        this.set(entries, (BValue)bLinkFilterTable, null);
    }

    public boolean getToStandardOut() {
        return this.getBoolean(toStandardOut);
    }

    public void setToStandardOut(boolean bl) {
        this.setBoolean(toStandardOut, bl, null);
    }

    public boolean getIncludeCompletionEvents() {
        return this.getBoolean(includeCompletionEvents);
    }

    public void setIncludeCompletionEvents(boolean bl) {
        this.setBoolean(includeCompletionEvents, bl, null);
    }

    public void clearTable() {
        this.invoke(clearTable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getLinkLayer().registerLinkListener(this);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getLinkLayer().unregisterLinkListener(this);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        this.dev = null;
    }

    public void doClearTable() {
        this.getEntries().clearEntries();
    }

    public void receive(NAppBuffer nAppBuffer) {
        if (this.passFilter(nAppBuffer, true)) {
            this.display(nAppBuffer, true);
        }
    }

    public void send(NAppBuffer nAppBuffer) {
        if (this.passFilter(nAppBuffer, false)) {
            this.display(nAppBuffer, false);
        }
    }

    private final boolean passFilter(NAppBuffer nAppBuffer, boolean bl) {
        if (nAppBuffer.isCompletionEvent() && !this.getIncludeCompletionEvents()) {
            return false;
        }
        boolean bl2 = false;
        if (this.getEnableSubnetNode()) {
            if (this.dev == null) {
                this.dev = NmUtil.getLonNetwork(this).addressManager().getDeviceByAddress(this.getSubnetNode());
            }
            if (!this.passDeviceFilter(this.dev, nAppBuffer, bl)) {
                return false;
            }
            bl2 = true;
        }
        if (this.getEnableDevice()) {
            if (this.dev == null) {
                this.dev = NmUtil.getLonNetwork(this).addressManager().getDeviceByName(this.getDeviceName());
            }
            if (!this.passDeviceFilter(this.dev, nAppBuffer, bl)) {
                return false;
            }
            bl2 = true;
        }
        if (this.getEnableSelector()) {
            if (nAppBuffer.getMessageCode() < 128) {
                return false;
            }
            byte[] byArray = nAppBuffer.getWriteBuffer();
            int n = (byArray[16] & 0x3F) << 8 | byArray[17] & 0xFF;
            if (n != this.getSelector()) {
                return false;
            }
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean passDeviceFilter(BLonDevice bLonDevice, NAppBuffer nAppBuffer, boolean bl) {
        if (!bl || nAppBuffer.isCompletionEvent()) {
            byte[] byArray = nAppBuffer.getReadBuffer();
            byte by = byArray[5];
            if (by == 1) {
                BSubnetNode bSubnetNode = BSubnetNode.make(byArray[9], byArray[6] & 0x7F);
                if (bSubnetNode.equals(bLonDevice.getSubnetNodeAddress())) return true;
                return false;
            }
            if (by != 2) return false;
            byte[] byArray2 = new byte[6];
            System.arraycopy(byArray, 10, byArray2, 0, 6);
            BNeuronId bNeuronId = BNeuronId.make(byArray2);
            if (bNeuronId.equals(bLonDevice.getNeuronIdAddress())) return true;
            return false;
        }
        BSubnetNode bSubnetNode = nAppBuffer.getSourceAddress();
        if (bSubnetNode.equals(bLonDevice.getSubnetNodeAddress())) return true;
        return false;
    }

    private final void display(NAppBuffer nAppBuffer, boolean bl) {
        if (this.getToStandardOut()) {
            this.toStandardOut(nAppBuffer, bl);
            return;
        }
        BLinkFilterTable bLinkFilterTable = this.getEntries();
        if (bLinkFilterTable.getMaxIndex() >= this.getMaxEntries()) {
            return;
        }
        BAbsTime bAbsTime = BAbsTime.make((long)System.currentTimeMillis());
        BBlob bBlob = BBlob.make((byte[])nAppBuffer.getReadBuffer(), (int)0, (int)nAppBuffer.getWriteBufferLen());
        this.getEntries().addEntry(new BLinkFilterEntry(bl, bAbsTime, bBlob));
    }

    private final void toStandardOut(NAppBuffer nAppBuffer, boolean bl) {
        byte[] byArray = nAppBuffer.getWriteBuffer();
        if (bl) {
            this.getLinkLayer().writeLinkDebug("recv: ", byArray, byArray[1] + 2);
        } else {
            this.getLinkLayer().writeLinkDebug("send: ", byArray, byArray[1] + 2);
        }
    }

    NLonLinkLayer getLinkLayer() {
        if (this.llink == null) {
            this.llink = (NLonLinkLayer)((NLonComm)NmUtil.getLonNetwork((BComponent)this).lonComm()).linkLayer;
        }
        return this.llink;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.llink = null;
        this.dev = null;
    }

    public BLinkFilter() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$lonworks$loncomm$BLinkFilter;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$loncomm$BLinkFilter = BLinkFilter.class("[Lcom.tridium.lonworks.loncomm.BLinkFilter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/linkFilter.png");
    }
}

