/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.local;

import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.local.BLocalNci;
import com.tridium.lonworks.local.BLocalNv;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import com.tridium.lonworks.xml.XTypeDef;
import java.util.ArrayList;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BLocalImportXmlParameter;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.naming.BOrd;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.util.SortUtil;
import javax.baja.util.TextUtil;

public class LocalDev {
    public static void importXLon(BLocalLonDevice bLocalLonDevice, BLocalImportXmlParameter bLocalImportXmlParameter) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            BOrd bOrd = bLocalImportXmlParameter.getFile();
            XLonInterfaceFile xLonInterfaceFile = LonXMLReader.decode(bOrd);
            BDynamicDevice bDynamicDevice = new BDynamicDevice();
            DynaDev.importXLon(bDynamicDevice, xLonInterfaceFile, null);
            Context context = Transaction.start((BComponent)bLocalLonDevice, (Context)BLocalLonDevice.noInfoChange);
            XLonDevice xLonDevice = xLonInterfaceFile.getLonDevice();
            bLocalLonDevice.setSelfDoc(xLonDevice.deviceData.nodeSelfID);
            BINetworkVariable[] bINetworkVariableArray = bLocalLonDevice.getNetworkVariables();
            BINetworkVariable[] bINetworkVariableArray2 = bDynamicDevice.getNetworkVariables();
            XNetworkVariable[] xNetworkVariableArray = xLonDevice.getNetworkVariables();
            XNetworkConfig[] xNetworkConfigArray = xLonDevice.getNetworkConfigs();
            int n = 0;
            while (n < bINetworkVariableArray.length) {
                if (bINetworkVariableArray[n] != null) {
                    if (n >= bINetworkVariableArray2.length || bINetworkVariableArray2[n] == null || !LocalDev.isEquivalent(bINetworkVariableArray2[n], bINetworkVariableArray[n])) {
                        bLocalLonDevice.remove(((BComponent)bINetworkVariableArray[n]).getPropertyInParent(), context);
                        bl2 = true;
                    } else if (n < bINetworkVariableArray2.length) {
                        bINetworkVariableArray2[n] = null;
                        bl = true;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < bINetworkVariableArray2.length) {
                if (bINetworkVariableArray2[n] != null) {
                    BLonComponent bLonComponent;
                    BLonComponent bLonComponent2;
                    if (bINetworkVariableArray2[n].isNetworkVariable()) {
                        bLonComponent2 = (BNetworkVariable)bINetworkVariableArray2[n];
                        bLonComponent = new BLocalNv();
                        ((BLocalNv)bLonComponent).getNvProps().copyFrom((BComplex)((BNetworkVariable)bLonComponent2).getNvProps());
                        ((BLocalNv)bLonComponent).getNvConfigData().copyFrom((BComplex)((BNetworkVariable)bLonComponent2).getNvConfigData());
                        ((BLocalNv)bLonComponent).getNvConfigData().setUnbound(((BLocalNv)bLonComponent).getNvProps().getNvIndex());
                        ((BLocalNv)bLonComponent).setSelfDoc(LocalDev.getSelfDoc(LocalDev.getNv(xNetworkVariableArray, n)));
                        LocalDev.setData(bLonComponent2, bLonComponent);
                        bLocalLonDevice.add(bLonComponent2.getName(), (BValue)bLonComponent, context);
                    } else if (bINetworkVariableArray2[n].isNetworkConfig()) {
                        bLonComponent2 = (BNetworkConfig)bINetworkVariableArray2[n];
                        bLonComponent = new BLocalNci();
                        ((BLocalNci)bLonComponent).getNcProps().copyFrom((BComplex)((BNetworkConfig)bLonComponent2).getNcProps());
                        ((BLocalNci)bLonComponent).getNvConfigData().copyFrom((BComplex)((BNetworkConfig)bLonComponent2).getNvConfigData());
                        ((BLocalNci)bLonComponent).setSelfDoc(LocalDev.getSelfDoc(LocalDev.getNci(xNetworkConfigArray, n), xLonInterfaceFile));
                        LocalDev.setData(bLonComponent2, bLonComponent);
                        bLocalLonDevice.add(bLonComponent2.getName(), (BValue)bLonComponent, context);
                    }
                }
                ++n;
            }
            Transaction.end((BComponent)bLocalLonDevice, (Context)context);
            if (bl2 && bl) {
                LocalDev.reorder(bLocalLonDevice);
            }
        }
        catch (Throwable throwable) {
            bLocalLonDevice.lonNetwork().log().error("Error importing xml.", throwable);
        }
    }

    private static final String getSelfDoc(XNetworkVariable xNetworkVariable) {
        if (xNetworkVariable == null || xNetworkVariable.memberIndex < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@").append(xNetworkVariable.objectIndex);
        stringBuffer.append(xNetworkVariable.mfgMember ? "#" : "|");
        stringBuffer.append(Integer.toString(xNetworkVariable.memberIndex));
        if (xNetworkVariable.memberArraySize > 1) {
            stringBuffer.append("[").append(Integer.toString(xNetworkVariable.memberArraySize)).append("]");
        }
        return stringBuffer.toString();
    }

    private static final String getSelfDoc(XNetworkConfig xNetworkConfig, XLonInterfaceFile xLonInterfaceFile) {
        Object object;
        int n;
        int n2;
        if (xNetworkConfig == null) {
            return "";
        }
        if (xNetworkConfig.scptType.length() > 0) {
            n2 = 0;
            n = XLonDataUtil.scptTypeFromString(xNetworkConfig.scptType);
        } else if (xNetworkConfig.typeDef.length() > 0) {
            object = xLonInterfaceFile.resolveTypeDef(xNetworkConfig.typeDef);
            if (object == null) {
                return "";
            }
            String string = ((XTypeDef)object).typeScope;
            if (string.length() == 0) {
                return "";
            }
            n2 = Integer.parseInt(string.substring(0, string.indexOf(44)));
            n = Integer.parseInt(string.substring(string.indexOf(44) + 1));
        } else {
            return "";
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("&").append(XLonDataUtil.scopeFromString(xNetworkConfig.scope)).append(",");
        ((StringBuffer)object).append(xNetworkConfig.select).append(",");
        ((StringBuffer)object).append(Integer.toString(n2)).append("\\x");
        ((StringBuffer)object).append(Integer.toString(XLonDataUtil.flagFromString(xNetworkConfig.modifyFlag), 16)).append(",");
        ((StringBuffer)object).append(Integer.toString(n)).append(";");
        return ((StringBuffer)object).toString();
    }

    private static final XNetworkVariable getNv(XNetworkVariable[] xNetworkVariableArray, int n) {
        int n2 = 0;
        while (n2 < xNetworkVariableArray.length) {
            if (xNetworkVariableArray[n2] != null && xNetworkVariableArray[n2].index == n) {
                return xNetworkVariableArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static final XNetworkConfig getNci(XNetworkConfig[] xNetworkConfigArray, int n) {
        int n2 = 0;
        while (n2 < xNetworkConfigArray.length) {
            if (xNetworkConfigArray[n2] != null && xNetworkConfigArray[n2].index <= n && n <= xNetworkConfigArray[n2].getMaxIndex()) {
                return xNetworkConfigArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static final boolean isEquivalent(BINetworkVariable bINetworkVariable, BINetworkVariable bINetworkVariable2) {
        if (!bINetworkVariable.getName().equals(bINetworkVariable2.getName())) {
            return false;
        }
        if (!bINetworkVariable.getNvConfigData().getDirection().equals((Object)bINetworkVariable2.getNvConfigData().getDirection())) {
            return false;
        }
        if (bINetworkVariable.isNetworkVariable() && bINetworkVariable2.isLocalNv()) {
            if (!((BNetworkVariable)bINetworkVariable).getNvProps().equivalent((Object)((BLocalNv)bINetworkVariable2).getNvProps())) {
                return false;
            }
        } else if (bINetworkVariable.isNetworkConfig() && bINetworkVariable2.isLocalNci()) {
            if (!((BNetworkConfig)bINetworkVariable).getNcProps().equivalent((Object)((BLocalNci)bINetworkVariable2).getNcProps())) {
                return false;
            }
        } else {
            return false;
        }
        return bINetworkVariable.getData().hasEquivalentElements(bINetworkVariable2.getData());
    }

    private static final void setData(BLonData bLonData, BLonComponent bLonComponent) {
        Property[] propertyArray = bLonData.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            BValue bValue = bLonData.get(property);
            if (bValue instanceof BLonPrimitive || bValue instanceof BLonData) {
                bLonComponent.add(property.getName(), bValue, property.getDefaultFlags(), property.getFacets(), null);
            }
            ++n;
        }
    }

    private static final void reorder(BLocalLonDevice bLocalLonDevice) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        SlotCursor slotCursor = bLocalLonDevice.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            if (property.isFrozen()) continue;
            arrayList.add(property);
        }
        int n = arrayList.size();
        Object[] objectArray = arrayList.toArray(new Property[n]);
        Object[] objectArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            BValue bValue = bLocalLonDevice.get((Property)objectArray[n2]);
            objectArray2[n2] = bValue.getType().is(BINetworkVariable.TYPE) ? LocalDev.getKey("b", ((BINetworkVariable)bValue).getNvIndex()) : LocalDev.getKey("z", n2);
            ++n2;
        }
        SortUtil.sort((Object[])objectArray2, (Object[])objectArray, (boolean)true);
        bLocalLonDevice.reorder((Property[])objectArray);
    }

    private static final String getKey(String string, int n) {
        String string2 = Integer.toString(n);
        return string + TextUtil.getSpaces((int)(5 - string2.length())) + string2;
    }
}

