/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.file;

import com.tridium.lonworks.file.NoDirectoryException;
import com.tridium.lonworks.netmessages.FileXferData;
import com.tridium.lonworks.netmessages.FileXferResponse;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import java.io.ByteArrayOutputStream;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonListener;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonFileRequestEnum;
import javax.baja.lonworks.enums.BLonFileStatusEnum;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFilePos;
import javax.baja.lonworks.londata.BLonFileReq;
import javax.baja.lonworks.londata.BLonFileStatus;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonSimple;
import javax.baja.lonworks.util.LonFile;
import javax.baja.sys.BEnum;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonFileTransfer
extends LonFile {
    private static final int MAX_DATA_LENGTH = 32;
    private static final int RECEIVE_TIMEOUT = 30000;
    private static final int DEFAULT_TIMEOUT = 240000;
    private boolean opened;
    private BAddressEntry adrEntry;
    private LonAddress sendAddr;
    public LonComm lonComm;
    private String devName;
    private boolean authenticate;
    private BLocalLonDevice localDevice;
    int reqNvSel;
    int posNvSel;
    int statNvNdx;
    private boolean randomAccess;
    private int fileNum;
    private boolean modified;
    private XferDataReceive receive;
    private FileDirectory dir;
    private byte[] data;
    private int offset;
    static /* synthetic */ Class class$com$tridium$lonworks$netmessages$FileXferData;

    private final void init() throws LonException {
        this.dir = new FileDirectory(this.sendAddr, this.lonComm, this.devName);
        this.receive = new XferDataReceive();
    }

    public boolean supportsRandomAccess() {
        boolean bl = false;
        if (this.posNvSel != -1) {
            bl = true;
        }
        return bl;
    }

    public LonFile copy() {
        return new LonFileTransfer(this);
    }

    public void open(int n, boolean bl, boolean bl2) throws LonException {
        if (this.opened) {
            return;
        }
        this.adrEntry = null;
        this.fileNum = n;
        if (n >= this.dir.numFiles) {
            throw new LonException("Invalid fileNum " + Integer.toString(n));
        }
        try {
            this.offset = 0;
            this.modified = false;
            boolean bl3 = false;
            if (bl2 && this.posNvSel != -1) {
                bl3 = this.randomAccess = true;
            }
            if (bl) {
                this.data = new byte[this.dir.files[n].size];
            } else if (!this.randomAccess) {
                this.readFile();
            }
        }
        catch (LonException lonException) {
            try {
                this.fileRequest(BLonFileRequestEnum.closeFile);
            }
            catch (LonException lonException2) {}
            throw lonException;
        }
        this.opened = true;
    }

    public byte[] read(int n, int n2) throws LonException {
        this.offset = n;
        return this.read(n2);
    }

    public byte[] read(int n) throws LonException {
        byte[] byArray = new byte[n];
        if (this.randomAccess) {
            this.readFileRandom(n);
            System.arraycopy(this.data, 0, byArray, 0, n);
        } else {
            if (n + this.offset > this.data.length) {
                throw new IndexOutOfBoundsException("Invalid length for available data. {fnum=" + this.fileNum + ":flen=" + this.data.length + ":off=" + this.offset + ":len=" + n);
            }
            System.arraycopy(this.data, this.offset, byArray, 0, n);
        }
        this.offset += n;
        return byArray;
    }

    public byte[] read() throws LonException {
        this.offset = 0;
        return this.read(this.dir.files[this.fileNum].size);
    }

    public void write(byte[] byArray, int n) throws LonException {
        this.offset = n;
        this.write(byArray);
    }

    public void write(byte[] byArray) throws LonException {
        if (this.randomAccess) {
            this.writeFileRandom(byArray);
        } else {
            if (byArray.length + this.offset > this.data.length) {
                throw new IndexOutOfBoundsException("Invalid length for available data.");
            }
            System.arraycopy(byArray, 0, this.data, this.offset, byArray.length);
            this.offset += byArray.length;
            this.modified = true;
        }
    }

    public void close() throws LonException {
        this.flush();
        this.opened = false;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public void flush() throws LonException {
        if (this.modified) {
            try {
                this.writeFile();
            }
            catch (LonException lonException) {
                this.fileRequest(BLonFileRequestEnum.closeFile);
                this.opened = false;
                throw lonException;
            }
            this.modified = false;
        }
    }

    public String getDirectoryString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("File Directory Structure for " + this.devName);
        stringBuffer.append("\n   Number of files =  " + this.dir.numFiles);
        int n = 0;
        while (n < this.dir.numFiles) {
            FileDescriptor fileDescriptor = this.dir.files[n];
            stringBuffer.append("\n\n   File #" + n);
            stringBuffer.append("\n   size " + fileDescriptor.size);
            stringBuffer.append("\n   type " + fileDescriptor.type);
            String string = fileDescriptor.fileInfo;
            int n2 = string.indexOf(0);
            if (n2 > 0) {
                stringBuffer.append("\n   " + string.substring(0, n2));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int findFileNum(int n) {
        return this.findFileNum(n, -1);
    }

    public int findFileNum(int n, int n2) {
        if (this.dir == null) {
            return -1;
        }
        int n3 = n2 + 1;
        while (n3 < this.dir.numFiles) {
            if (this.dir.files[n3].type == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readFile() throws LonException {
        LonAddress lonAddress = this.sendAddr;
        synchronized (lonAddress) {
            this.receive.reset(this.dir.files[this.fileNum].size);
            try {
                this.fileRequest(BLonFileRequestEnum.openToSend, this.fileNum);
                this.doReadFile(BLonFileRequestEnum.openToSend);
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.receive.endSession();
                throw throwable;
            }
            {
                Object var4_4 = null;
                this.receive.endSession();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readFileRandom(int n) throws LonException {
        LonAddress lonAddress = this.sendAddr;
        synchronized (lonAddress) {
            this.receive.reset(n);
            try {
                this.fileRequest(BLonFileRequestEnum.openToSendRa, this.fileNum);
                this.verifySeekWake(BLonFileRequestEnum.openToSendRa);
                this.filePosition(this.offset, n);
                this.doReadFile(null);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.receive.endSession();
                throw throwable;
            }
            {
                Object var5_5 = null;
                this.receive.endSession();
            }
            return;
        }
    }

    private final void doReadFile(BLonFileRequestEnum bLonFileRequestEnum) throws LonException {
        BLonFileStatusEnum bLonFileStatusEnum = this.getFileStatus();
        int n = bLonFileStatusEnum.getOrdinal();
        if (n == -1 && bLonFileRequestEnum != null) {
            this.retryOpen(bLonFileRequestEnum);
            n = this.getFileStatus().getOrdinal();
        }
        if (n != 0 && n != 4 && n != 11) {
            this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
            throw new LonException("Invalid lon file status for read: " + bLonFileStatusEnum.toString());
        }
        this.data = this.receive.getFileXferData(240000);
        this.closeFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeFile() throws LonException {
        LonAddress lonAddress = this.sendAddr;
        synchronized (lonAddress) {
            this.fileRequest(BLonFileRequestEnum.openToReceive, this.fileNum);
            this.doWriteFile(BLonFileRequestEnum.openToReceive);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeFileRandom(byte[] byArray) throws LonException {
        LonAddress lonAddress = this.sendAddr;
        synchronized (lonAddress) {
            this.fileRequest(BLonFileRequestEnum.openToReceiveRa, this.fileNum);
            this.verifySeekWake(BLonFileRequestEnum.openToReceiveRa);
            this.filePosition(this.offset, byArray.length);
            this.data = byArray;
            this.doWriteFile(null);
            return;
        }
    }

    private final void doWriteFile(BLonFileRequestEnum bLonFileRequestEnum) throws LonException {
        this.verifyTransferUnderWay(bLonFileRequestEnum);
        int n = 0;
        int n2 = this.data.length / 32;
        byte[] byArray = new byte[32];
        while (n <= n2) {
            FileXferData fileXferData;
            Object object;
            int n3 = n / 6;
            int n4 = n % 6;
            int n5 = 32;
            int n6 = n * 32;
            boolean bl = false;
            if (n == n2) {
                n5 = this.data.length - n * 32;
                object = new byte[n5];
                System.arraycopy(this.data, n6, object, 0, n5);
                fileXferData = new FileXferData(n3 & 0xF, n4, (byte[])object);
                bl = true;
            } else {
                System.arraycopy(this.data, n6, byArray, 0, n5);
                fileXferData = new FileXferData(n3 & 0xF, n4, byArray);
            }
            ++n;
            if (n4 == 5 || bl) {
                try {
                    object = (FileXferResponse)this.lonComm.sendRequest(this.sendAddr, fileXferData);
                    if (((LonMessage)object).getMessageCode() == 6) continue;
                    n = n3 * 6 + ((LonMessage)object).getMessageCode();
                    continue;
                }
                catch (LonException lonException) {
                    this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
                    throw lonException;
                }
            }
            this.lonComm.sendUnacknowledged(this.sendAddr, fileXferData);
        }
        this.closeFile();
    }

    private final void verifySeekWake(BLonFileRequestEnum bLonFileRequestEnum) throws LonException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 30;
        while (!bl) {
            BLonFileStatusEnum bLonFileStatusEnum = this.getFileStatus();
            switch (bLonFileStatusEnum.getOrdinal()) {
                case 11: {
                    bl = true;
                    break;
                }
                case 0: 
                case 1: 
                case 4: {
                    NmUtil.wait(70);
                    break;
                }
                case -1: {
                    if (!bl2 && bLonFileRequestEnum != null) {
                        this.retryOpen(bLonFileRequestEnum);
                        bl2 = true;
                        break;
                    }
                }
                default: {
                    this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
                    throw new LonException("Invalid lon file status for access: " + bLonFileStatusEnum.toString());
                }
            }
            if (n-- != 0) continue;
            throw new LonException("File status never enters FS_SEEK_WAKE.");
        }
    }

    private final void retryOpen(BLonFileRequestEnum bLonFileRequestEnum) throws LonException {
        this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
        NmUtil.wait(10);
        this.fileRequest(bLonFileRequestEnum, this.fileNum);
    }

    private final void verifyTransferUnderWay(BLonFileRequestEnum bLonFileRequestEnum) throws LonException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            BLonFileStatusEnum bLonFileStatusEnum = this.getFileStatus();
            switch (bLonFileStatusEnum.getOrdinal()) {
                case 4: {
                    bl2 = true;
                    break;
                }
                case 0: 
                case 1: 
                case 11: {
                    if (n++ > 20) {
                        this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
                        throw new LonException("Requested file transfer never initiated by " + this.devName);
                    }
                    NmUtil.wait(70);
                    break;
                }
                case -1: {
                    if (!bl && bLonFileRequestEnum != null) {
                        this.retryOpen(bLonFileRequestEnum);
                        bl = true;
                        break;
                    }
                }
                default: {
                    this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
                    throw new LonException("Invalid lon file status for access: " + bLonFileStatusEnum.toString());
                }
            }
        }
    }

    private final void closeFile() throws LonException {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            BLonFileStatusEnum bLonFileStatusEnum = this.getFileStatus();
            switch (bLonFileStatusEnum.getOrdinal()) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: 
                case 4: 
                case 11: {
                    if (!bl2) {
                        this.fileRequest(BLonFileRequestEnum.closeFile);
                    } else {
                        NmUtil.wait(200);
                    }
                    bl2 = true;
                    break;
                }
                default: {
                    this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
                    throw new LonException("Unable to close lon file. Invalid status " + bLonFileStatusEnum.toString());
                }
            }
        }
        if (!bl2) {
            this.fileRequest(BLonFileRequestEnum.closeFile);
        }
    }

    private final BLonFileStatusEnum getFileStatus() throws LonException {
        return (BLonFileStatusEnum)this.getStatus().getFileStatus().getEnum();
    }

    private final BLonFileStatus getStatus() throws LonException {
        LonException lonException = null;
        int n = 0;
        while (n < 4) {
            try {
                BLonFileStatus bLonFileStatus = new BLonFileStatus();
                bLonFileStatus.fromNetBytes(NmUtil.fetchNv(this.lonComm, this.sendAddr, this.statNvNdx, this.authenticate));
                return bLonFileStatus;
            }
            catch (LonException lonException2) {
                lonException = lonException2;
                NmUtil.wait(2000);
                ++n;
            }
        }
        if (lonException != null) {
            throw lonException;
        }
        return null;
    }

    private final void fileRequest(BLonFileRequestEnum bLonFileRequestEnum) throws LonException {
        this.fileRequest(bLonFileRequestEnum, this.fileNum);
    }

    private final void fileRequest(BLonFileRequestEnum bLonFileRequestEnum, int n) throws LonException {
        BLonFileReq bLonFileReq = new BLonFileReq();
        bLonFileReq.setRequest(BLonEnum.make((BEnum)bLonFileRequestEnum));
        bLonFileReq.setIndex(BLonInteger.make(n));
        bLonFileReq.setRecvTimeout(BLonInteger.make(30000));
        bLonFileReq.setAddress(BLonSimple.make(this.getMyDeviceAddressEntry()));
        bLonFileReq.setAuthenticate(BLonBoolean.make(this.authenticate));
        bLonFileReq.setPriority(BLonBoolean.FALSE);
        NmUtil.setNvValue(this.sendAddr, this.lonComm, BLonNvDirection.input, this.reqNvSel, BLonServiceType.acked, this.authenticate, bLonFileReq.toNetBytes());
    }

    private final BAddressEntry getMyDeviceAddressEntry() {
        if (this.adrEntry == null) {
            BDeviceData bDeviceData = this.localDevice.getDeviceData();
            BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
            byte[] byArray = new byte[]{1, (byte)((bDeviceData.getWorkingDomain() << 7) + bSubnetNode.getNodeId()), 127, 7, (byte)bSubnetNode.getSubnetId()};
            this.adrEntry = BAddressEntry.make(byArray);
        }
        return this.adrEntry;
    }

    private final void filePosition(int n, int n2) throws LonException {
        BLonFilePos bLonFilePos = new BLonFilePos();
        bLonFilePos.setPointer(BLonInteger.make(n));
        bLonFilePos.setLength(BLonInteger.make(n2));
        NmUtil.setNvValue(this.sendAddr, this.lonComm, BLonNvDirection.input, this.posNvSel, BLonServiceType.acked, this.authenticate, bLonFilePos.toNetBytes());
    }

    static /* synthetic */ int access$3() {
        return 32;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.opened = false;
        this.adrEntry = null;
        this.devName = "";
        this.posNvSel = -1;
        this.randomAccess = false;
        this.modified = false;
        this.receive = null;
        this.offset = 0;
    }

    public LonFileTransfer(BLonDevice bLonDevice, BNetworkVariable bNetworkVariable, BNetworkVariable bNetworkVariable2, BNetworkVariable bNetworkVariable3) throws LonException {
        this.this();
        this.sendAddr = NmUtil.getSendAddress(bLonDevice);
        this.lonComm = bLonDevice.lonComm();
        this.devName = bLonDevice.getDisplayName(null);
        this.authenticate = bLonDevice.getDeviceData().getAuthenticate();
        this.reqNvSel = bNetworkVariable.getNvConfigData().getSelector();
        this.statNvNdx = bNetworkVariable2.getNvIndex();
        if (bNetworkVariable3 != null) {
            this.posNvSel = bNetworkVariable3.getNvConfigData().getSelector();
        }
        this.localDevice = bLonDevice.lonNetwork().getLocalLonDevice();
        this.init();
    }

    public LonFileTransfer(LonAddress lonAddress, LonComm lonComm, int n, int n2, int n3) throws LonException {
        this.this();
        this.sendAddr = lonAddress;
        this.lonComm = lonComm;
        this.devName = "xdev";
        this.authenticate = Neuron.isNMAuthSet(lonComm, lonAddress, false, false);
        this.statNvNdx = n2;
        boolean bl = NmUtil.isExtended(lonComm, lonAddress, this.authenticate);
        this.reqNvSel = NmUtil.queryNvConfigData(lonComm, this.sendAddr, n, this.authenticate, bl).getSelector();
        if (n3 >= 0) {
            this.posNvSel = NmUtil.queryNvConfigData(lonComm, this.sendAddr, n3, this.authenticate, bl).getSelector();
        }
        this.localDevice = lonComm.lonNetwork().getLocalLonDevice();
        this.init();
    }

    private LonFileTransfer(LonFileTransfer lonFileTransfer) {
        this.this();
        this.sendAddr = lonFileTransfer.sendAddr;
        this.lonComm = lonFileTransfer.lonComm;
        this.devName = lonFileTransfer.devName;
        this.authenticate = lonFileTransfer.authenticate;
        this.localDevice = lonFileTransfer.localDevice;
        this.reqNvSel = lonFileTransfer.reqNvSel;
        this.posNvSel = lonFileTransfer.posNvSel;
        this.statNvNdx = lonFileTransfer.statNvNdx;
        this.dir = lonFileTransfer.dir;
        this.randomAccess = lonFileTransfer.randomAccess;
        this.receive = new XferDataReceive();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class FileDirectory {
        public int numFiles;
        public FileDescriptor[] files;

        private final BLonFileStatus getDirectoryStatus(int n) throws LonException {
            int n2 = 0;
            LonFileTransfer.this.fileRequest(BLonFileRequestEnum.directoryLookup, n);
            BLonFileStatus bLonFileStatus = LonFileTransfer.this.getStatus();
            while (bLonFileStatus.getFileStatus().getEnum().getOrdinal() == 0) {
                if (n2++ == 20) break;
                NmUtil.wait(500);
                bLonFileStatus = LonFileTransfer.this.getStatus();
            }
            if (bLonFileStatus.getFileStatus().getEnum().getOrdinal() == 3) {
                throw new NoDirectoryException();
            }
            if (bLonFileStatus.getFileStatus().getEnum().getOrdinal() != 1) {
                throw new LonException("Unable to access lon file directory.");
            }
            return bLonFileStatus;
        }

        public FileDirectory(LonAddress lonAddress, LonComm lonComm, String string) throws LonException {
            BLonFileStatus bLonFileStatus = this.getDirectoryStatus(0);
            this.numFiles = bLonFileStatus.getNumberOfFiles().getInt();
            if (this.numFiles <= 0) {
                LonFileTransfer.this.fileRequest(BLonFileRequestEnum.closeFile);
                throw new LonException("Device reports no files.");
            }
            this.files = new FileDescriptor[this.numFiles];
            this.files[0] = new FileDescriptor(bLonFileStatus);
            int n = 1;
            while (n < this.numFiles) {
                bLonFileStatus = this.getDirectoryStatus(n);
                this.files[n] = new FileDescriptor(bLonFileStatus);
                ++n;
            }
            LonFileTransfer.this.fileRequest(BLonFileRequestEnum.closeFile);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class XferDataReceive
    implements Runnable,
    LonListener,
    NetMessages {
        private int expectedWindow;
        private int expectedPacket;
        private Queue rcvQueue;
        private Thread receiveThread;
        private boolean done;
        private boolean dataComplete;
        private FileTransferOutStream rcvData;
        private LonException error;

        public void run() {
            boolean bl = true;
            this.expectedWindow = 0;
            this.expectedPacket = 0;
            this.rcvData.reset();
            LonComm lonComm = LonFileTransfer.this.lonComm;
            Class clazz = class$com$tridium$lonworks$netmessages$FileXferData;
            if (clazz == null) {
                clazz = class$com$tridium$lonworks$netmessages$FileXferData = LonFileTransfer.class("[Lcom.tridium.lonworks.netmessages.FileXferData;", false);
            }
            lonComm.registerLonListener(this, 62, null, clazz);
            while (!this.done) {
                try {
                    FileXferData fileXferData = null;
                    fileXferData = (FileXferData)this.rcvQueue.dequeue(bl ? 10000 : 3000);
                    bl = false;
                    if (this.done) break;
                    if (fileXferData == null) {
                        throw new RuntimeException("Timeout waiting for next transfer data.");
                    }
                    byte[] byArray = fileXferData.getData();
                    int n = fileXferData.getPacket();
                    int n2 = fileXferData.getWindow();
                    if (n == this.expectedPacket && n2 == this.expectedWindow) {
                        if (!this.rcvData.doForceWrite(byArray)) {
                            this.endTransfer();
                            System.out.println("Device transferred too much data.");
                        }
                        ++this.expectedPacket;
                    } else {
                        System.out.println("\n*****Expected win " + this.expectedWindow + " pack = " + this.expectedPacket + "*****");
                    }
                    if (fileXferData.isRequest()) {
                        LonFileTransfer.this.lonComm.sendResponse(fileXferData, new FileXferResponse(this.expectedPacket));
                        if (this.expectedPacket == 6) {
                            this.expectedWindow = n2 + 1 & 0xF;
                            this.expectedPacket = 0;
                        }
                    }
                    if (byArray.length >= 32) continue;
                    this.endTransfer();
                }
                catch (Throwable throwable) {
                    this.error = new LonException("Lon File Transfer interrupted", throwable);
                    this.endTransfer();
                    this.done = true;
                }
            }
            LonFileTransfer.this.lonComm.unregisterLonListener(this, 62, null);
            this.exitingThread();
        }

        public void receiveLonMessage(LonMessage lonMessage) {
            try {
                this.rcvQueue.enqueue((Object)lonMessage);
            }
            catch (QueueFullException queueFullException) {
                this.error = new LonException("Queue full. File transfer data possibly lost.");
            }
        }

        public synchronized void reset(int n) {
            this.rcvData.setLength(n);
            this.error = null;
            if (this.done) {
                this.done = false;
                this.dataComplete = false;
                this.receiveThread = new Thread((Runnable)LonFileTransfer.this.receive, LonFileTransfer.this.lonComm.lonNetwork().getLogName() + ".FileXfer\\" + LonFileTransfer.this.devName);
                this.receiveThread.start();
            }
        }

        public synchronized byte[] getFileXferData(int n) throws LonException {
            if (!this.dataComplete) {
                try {
                    this.wait(n);
                }
                catch (Exception exception) {}
            }
            if (this.error != null) {
                LonFileTransfer.this.fileRequest(BLonFileRequestEnum.closeDeleteFile);
                throw this.error;
            }
            return this.rcvData.toByteArray();
        }

        private final synchronized void endTransfer() {
            this.dataComplete = true;
            this.notify();
        }

        public synchronized void endSession() {
            this.done = true;
            this.rcvQueue.clear();
            if (this.receiveThread.isAlive()) {
                try {
                    this.wait(2000L);
                }
                catch (Exception exception) {
                    System.out.println("timed out waiting for receiveThread to complete");
                }
            }
        }

        private final synchronized void exitingThread() {
            this.notify();
        }

        public boolean isDone() {
            return this.done;
        }

        private final /* synthetic */ void this() {
            this.expectedWindow = 0;
            this.expectedPacket = 0;
            this.done = true;
            this.dataComplete = false;
            this.error = null;
        }

        public XferDataReceive() {
            this.this();
            this.rcvQueue = new Queue(16);
            this.rcvData = new FileTransferOutStream();
        }
    }

    private static class FileDescriptor {
        public int size;
        public int type;
        public String fileInfo;

        public FileDescriptor(BLonFileStatus bLonFileStatus) throws LonException {
            this.size = bLonFileStatus.getSize().getInt();
            this.type = bLonFileStatus.getFileType().getInt();
            this.fileInfo = bLonFileStatus.getFileInfo().getString();
        }
    }

    private static class FileTransferOutStream
    extends ByteArrayOutputStream {
        int maxCount;

        public void setLength(int n) {
            this.maxCount = n;
        }

        public boolean doForceWrite(byte[] byArray) {
            int n = this.maxCount - this.count;
            if (n > byArray.length) {
                n = byArray.length;
            }
            if (n > 0) {
                this.write(byArray, 0, n);
            }
            return n >= byArray.length;
        }

        private FileTransferOutStream() {
        }
    }
}

