/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.device;

import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public final class NvDev {
    public static final void knobAdded(BComponent bComponent, Knob knob, Context context) {
        BLink bLink = knob.getLink();
        if (!(bLink instanceof BLonLink)) {
            return;
        }
        BLonLink bLonLink = (BLonLink)bLink;
        bLonLink.lonActivate();
        if (bLonLink.getMessageTag()) {
            return;
        }
        BNetworkVariable bNetworkVariable = (BNetworkVariable)bComponent.get(knob.getSourceSlot().asProperty());
        bNetworkVariable.lonKnobAdded(knob);
    }

    public static final void knobRemoved(BComponent bComponent, Knob knob, Context context) {
        BLink bLink = knob.getLink();
        if (!(bLink instanceof BLonLink) || ((BLonLink)bLink).getMessageTag()) {
            return;
        }
        BValue bValue = bComponent.get(knob.getSourceSlot().asProperty());
        ((BNetworkVariable)bValue).lonKnobRemove(knob);
    }

    public static final LinkCheck doNvCheckLink(BComponent bComponent, Slot slot, BComponent bComponent2, Slot slot2, Context context) {
        if (!(bComponent.getType().is(BLonDevice.TYPE) || bComponent.getType().is(BLonObject.TYPE) || slot.isProperty() && slot.asProperty().getType().is(BPseudoNV.TYPE))) {
            return LinkCheck.makeValid();
        }
        if (!slot2.isProperty()) {
            return LinkCheck.makeValid();
        }
        Type type = slot2.asProperty().getType();
        Type type2 = slot.asProperty().getType();
        if (type.is(BConfigParameter.TYPE) || type2.is(BConfigParameter.TYPE)) {
            return LinkCheck.makeInvalid((String)"can not link cps");
        }
        boolean bl = type.is(BNetworkVariable.TYPE);
        boolean bl2 = type.is(BMessageTag.TYPE);
        if (!bl && !bl2) {
            return LinkCheck.makeValid();
        }
        NvDev.linkUpdate(bComponent2, bComponent);
        if (!slot.isProperty()) {
            if (bl) {
                return LinkCheck.makeInvalid((String)"can only link nvs to other nvs");
            }
            return LinkCheck.makeInvalid((String)"can only link message tags to other message tags");
        }
        if (bl && !type2.is(BNetworkVariable.TYPE)) {
            return LinkCheck.makeInvalid((String)"can only link nvs to other nvs");
        }
        if (bl2) {
            if (!type2.is(BMessageTag.TYPE)) {
                return LinkCheck.makeInvalid((String)"can only link message tags to other message tags");
            }
            BMessageTag bMessageTag = (BMessageTag)bComponent.get(slot.asProperty());
            if (bMessageTag.isInput()) {
                return LinkCheck.makeInvalid((String)"cannot link two inputs");
            }
            if (bComponent2.getKnobs(slot2).length > 0) {
                return LinkCheck.makeInvalid((String)"Message tag already linked as source");
            }
            if (bComponent.getLinks(slot).length > 0) {
                return LinkCheck.makeInvalid((String)"Message tag already linked as target");
            }
            return LinkCheck.makeValid();
        }
        BNetworkVariable bNetworkVariable = (BNetworkVariable)bComponent.get(slot.asProperty());
        BNetworkVariable bNetworkVariable2 = (BNetworkVariable)bComponent2.get(slot2.asProperty());
        if (bNetworkVariable2.getNvConfigData().isOutput()) {
            return LinkCheck.makeInvalid((String)"target must be an input nv");
        }
        if (bNetworkVariable.getNvConfigData().isInput()) {
            return LinkCheck.makeInvalid((String)"cannot link two inputs");
        }
        if (bNetworkVariable.getSnvtType() > 0 || bNetworkVariable2.getSnvtType() > 0) {
            if (bNetworkVariable.getSnvtType() != bNetworkVariable2.getSnvtType()) {
                return LinkCheck.makeInvalid((String)"snvt type mismatch");
            }
        } else if (bNetworkVariable.getData().getByteLength() != bNetworkVariable2.getData().getByteLength()) {
            return LinkCheck.makeInvalid((String)"nv length mismatch");
        }
        if (bNetworkVariable.getNvProps().getPolled() && !bNetworkVariable2.getNvProps().getPolled()) {
            return LinkCheck.makeInvalid((String)"polled output must link to polled input");
        }
        BLonDevice bLonDevice = bNetworkVariable.getDevice();
        if (bLonDevice != null && bLonDevice.getDeviceData().getAliasTable().getAliasCount() == 0 && NvDev.alreadyLinked(bComponent2, bComponent, slot)) {
            return LinkCheck.makeInvalid((String)"multiple links to same device require alias nvs");
        }
        return LinkCheck.makeValid();
    }

    private static final boolean alreadyLinked(BComponent bComponent, BComponent bComponent2, Slot slot) {
        if (!(bComponent instanceof BINvContainer)) {
            return false;
        }
        BINvContainer[] bINvContainerArray = ((BINvContainer)bComponent).getLonDevice().getNvContainers();
        int n = 0;
        while (n < bINvContainerArray.length) {
            BLink[] bLinkArray = bINvContainerArray[n].asComponent().getLinks();
            BOrd bOrd = bComponent2.getOrdInSpace();
            int n2 = 0;
            while (n2 < bLinkArray.length) {
                BLink bLink = bLinkArray[n2];
                if (bLink.getSourceOrd().equals((Object)bOrd) && bLink.getSourceSlotName().equals(slot.getName())) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private static final void linkUpdate(BComponent bComponent, BComponent bComponent2) {
        if (bComponent.getType().is(BINvContainer.TYPE)) {
            ((BINvContainer)bComponent).linkUpdate();
        }
        if (bComponent2.getType().is(BINvContainer.TYPE)) {
            ((BINvContainer)bComponent2).linkUpdate();
        }
    }

    public static final boolean requiresLonLink(Slot slot) {
        if (!slot.isProperty()) {
            return false;
        }
        Type type = slot.asProperty().getType();
        boolean bl = false;
        if (type.is(BMessageTag.TYPE) || type.is(BLonComponent.TYPE)) {
            bl = true;
        }
        return bl;
    }

    public static final BLink makeLonLink(BComponent bComponent, Slot slot, BComponent bComponent2, Slot slot2, Context context) {
        boolean bl = slot2.asProperty().getType().is(BMessageTag.TYPE);
        BOrd bOrd = bComponent.getHandleOrd();
        BLonLink bLonLink = new BLonLink(bOrd, slot.getName(), slot2.getName(), true);
        bLonLink.setMessageTag(bl);
        boolean bl2 = false;
        if (bComponent instanceof BLonDevice) {
            bl2 = ((BINvContainer)bComponent2).getLonNetwork().getHandle().equals(((BINvContainer)bComponent).getLonNetwork().getHandle()) ^ true;
        }
        bLonLink.setRemoteLink(bl2);
        if (slot.asProperty().getType().is(BPseudoNV.TYPE) || slot2.asProperty().getType().is(BPseudoNV.TYPE)) {
            bLonLink.setPseudoLink(true);
        }
        if (bComponent.isRunning() && slot.asProperty().getType().is(BNetworkVariable.TYPE)) {
            BNetworkVariable bNetworkVariable = (BNetworkVariable)bComponent.get(slot.asProperty());
            BLonLinkType bLonLinkType = NvDev.getLinkType(bNetworkVariable);
            if (bLonLinkType == BLonLinkType.unknown) {
                bNetworkVariable = (BNetworkVariable)bComponent2.get(slot2.asProperty());
                bLonLinkType = NvDev.getLinkType(bNetworkVariable);
            }
            if (bLonLinkType == BLonLinkType.unknown) {
                bLonLinkType = BLonLinkType.standard;
            }
            bLonLink.setLinkType(bLonLinkType);
        }
        return bLonLink;
    }

    public static final BLonLinkType getLinkType(BNetworkVariable bNetworkVariable) {
        BLonLinkType bLonLinkType;
        BNvConfigData bNvConfigData = bNetworkVariable.getNvConfigData();
        if (bNvConfigData.isBoundNv()) {
            return NmUtil.getLinkType(bNvConfigData);
        }
        Knob[] knobArray = bNetworkVariable.getKnobs();
        int n = 0;
        while (knobArray != null && n < knobArray.length) {
            BLink bLink = knobArray[n].getLink();
            if (bLink instanceof BLonLink && (bLonLinkType = ((BLonLink)bLink).getLinkType()) != BLonLinkType.unknown) {
                return bLonLinkType;
            }
            ++n;
        }
        BControlPoint[] bControlPointArray = bNetworkVariable.getData().getProxies(true);
        int n2 = 0;
        while (bControlPointArray != null && n2 < bControlPointArray.length) {
            BLonLinkType bLonLinkType2;
            bLonLinkType = bControlPointArray[n2].getProxyExt();
            if (bLonLinkType instanceof BLonProxyExt && (bLonLinkType2 = ((BLonProxyExt)((Object)bLonLinkType)).getLinkType()) != BLonLinkType.unknown) {
                return bLonLinkType2;
            }
            ++n2;
        }
        return BLonLinkType.unknown;
    }

    public static final AgentList fixWireSheet(AgentList agentList, Context context) {
        int n = agentList.indexOf("wiresheet:WireSheet");
        if (n >= 0) {
            agentList.add(n, "lonworks:WireSheet");
            agentList.remove("wiresheet:WireSheet");
        }
        return agentList;
    }

    public static final SaveNv checkRemove(BComponent bComponent, Property property, Context context) {
        BLonLink bLonLink;
        if (bComponent.isRunning() && property.getType().is(BLonLink.TYPE) && !(bLonLink = (BLonLink)bComponent.get(property)).getMessageTag()) {
            BNetworkVariable bNetworkVariable = null;
            try {
                bNetworkVariable = bLonLink.getDestinationNv();
            }
            catch (Throwable throwable) {}
            if (bNetworkVariable == null) {
                return null;
            }
            if (bNetworkVariable.getPropertyInParent().isFrozen()) {
                SaveNv saveNv = new SaveNv();
                saveNv.saveNv = bNetworkVariable;
                saveNv.nvProp = bNetworkVariable.getPropertyInParent();
                return saveNv;
            }
        }
        return null;
    }

    public static final void removed(BComponent bComponent, SaveNv saveNv, Property property, BValue bValue, Context context) {
        BLonLink bLonLink;
        if (bComponent.isRunning() && property.getType().is(BLonLink.TYPE) && !(bLonLink = (BLonLink)bComponent.get(property)).getMessageTag()) {
            try {
                if (saveNv != null) {
                    BNetworkVariable bNetworkVariable = (BNetworkVariable)bComponent.get(saveNv.nvProp);
                    bNetworkVariable.setNvProps((BNvProps)saveNv.saveNv.getNvProps().newCopy(true));
                    bNetworkVariable.setNvConfigData((BNvConfigData)saveNv.saveNv.getNvConfigData().newCopy(true));
                    bNetworkVariable.lonLinkRemoved();
                } else {
                    bLonLink.getDestinationNv().lonLinkRemoved();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class SaveNv {
        BNetworkVariable saveNv;
        Property nvProp;

        private final /* synthetic */ void this() {
            this.saveNv = null;
            this.nvProp = null;
        }

        public SaveNv() {
            this.this();
        }
    }
}

