/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.RouterManager;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NAddressManager
implements AddressManager {
    private static final int SUBNET_NODE_MASK = Short.MAX_VALUE;
    public static final int MAX_NODEID = 127;
    public static final int FIRST_SUBNET = 1;
    public static final int MAX_SUBNET = 255;
    public static final int DEFAULT_LON_NODE = 0;
    public static final int UNASSIGNED_CHANNEL_ID = 0;
    public static final int FIRST_CHANNEL_ID = 1;
    public static final int MAX_CHANNEL_ID = 65535;
    public static final int DEFAULT_CHANNEL_ID = 1;
    public static final Context localChange = new BasicContext();
    private boolean updateRouterManager;
    private RouterManager routerManager;
    private IntHashMap deviceHash;
    private int[] subnetMap;
    private Vector devVect;
    private BLocalLonDevice local;
    private BLonDevice[] devList;
    private boolean staleDeviceList;
    private Vector rtrVect;
    private BLonRouter[] rtrList;
    private boolean staleRtrList;
    private BLonNetwork lon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerLonDevice(BLonDevice bLonDevice) {
        try {
            IntHashMap intHashMap = this.deviceHash;
            synchronized (intHashMap) {
                block6: {
                    block5: {
                        this.registerAddress(bLonDevice.getDeviceData(), (BComponent)bLonDevice, 0);
                        if (!bLonDevice.isLocal()) break block5;
                        this.local = (BLocalLonDevice)bLonDevice;
                        break block6;
                    }
                    this.devVect.addElement(bLonDevice);
                }
                this.staleDeviceList = true;
            }
            this.lon.log().trace("registerLonDevice " + bLonDevice.getDisplayName(null) + ' ' + Integer.toString(bLonDevice.getDeviceData().getLastHash(), 16));
            this.lon.fireDeviceChange(null);
            NmUtil.validateNeuronId(bLonDevice.getDeviceData().getNeuronId(), (BComponent)bLonDevice);
            bLonDevice.configOk();
            return;
        }
        catch (Throwable throwable) {
            bLonDevice.configFail(throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterLonDevice(BLonDevice bLonDevice) {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            block4: {
                block3: {
                    if (!bLonDevice.isLocal()) break block3;
                    this.local = null;
                    break block4;
                }
                this.devVect.removeElement(bLonDevice);
            }
            this.lon.log().trace("unregisterLonDevice " + bLonDevice.getDisplayName(null) + ' ' + Integer.toString(bLonDevice.getDeviceData().getLastHash(), 16));
            this.unregisterAddress(bLonDevice.getDeviceData());
            this.staleDeviceList = true;
        }
        this.lon.fireDeviceChange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerLonRouter(BLonRouter bLonRouter) {
        try {
            IntHashMap intHashMap = this.deviceHash;
            synchronized (intHashMap) {
                this.registerAddress(bLonRouter.getNearDeviceData(), bLonRouter, 0);
                try {
                    this.registerAddress(bLonRouter.getFarDeviceData(), bLonRouter, 1);
                }
                catch (Throwable throwable) {
                    this.unregisterAddress(bLonRouter.getNearDeviceData());
                    throw throwable;
                }
                this.rtrVect.addElement(bLonRouter);
                this.lon.log().trace("registerLonRouter " + bLonRouter.getDisplayName(null) + ' ' + Integer.toString(bLonRouter.getNearDeviceData().getLastHash(), 16) + ' ' + Integer.toString(bLonRouter.getFarDeviceData().getLastHash(), 16));
                this.staleRtrList = true;
                this.updateRouterManager = true;
            }
            this.lon.fireDeviceChange(null);
            NmUtil.validateNeuronId(bLonRouter.getNearDeviceData().getNeuronId(), bLonRouter);
            bLonRouter.setStatus(BStatus.ok);
            bLonRouter.setFaultCause("");
            return;
        }
        catch (Throwable throwable) {
            bLonRouter.setStatus(BStatus.fault);
            bLonRouter.setFaultCause(throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterLonRouter(BLonRouter bLonRouter) {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            this.rtrVect.removeElement((Object)bLonRouter);
            this.lon.log().trace("unregisterLonRouter " + bLonRouter.getDisplayName(null) + ' ' + Integer.toString(bLonRouter.getNearDeviceData().getLastHash(), 16) + ' ' + Integer.toString(bLonRouter.getFarDeviceData().getLastHash(), 16));
            this.unregisterAddress(bLonRouter.getNearDeviceData());
            this.unregisterAddress(bLonRouter.getFarDeviceData());
            this.staleRtrList = true;
            this.updateRouterManager = true;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
            this.lon.fireDeviceChange(null);
            return;
        }
    }

    private final void registerAddress(BDeviceData bDeviceData, BComponent bComponent, int n) throws LonException {
        int n2;
        if (bDeviceData.getChannelId() == 0) {
            bDeviceData.setInt(BDeviceData.channelId, 1 + n, AddressManager.noDeviceChange);
        }
        if (((n2 = NAddressManager.getDeviceHash(bDeviceData)) & Short.MAX_VALUE) == 0) {
            n2 = this.claimSubnetNodeId(bDeviceData);
        }
        if (!this.verifySubnetChannel(n2)) {
            String string = bComponent.getDisplayName(null) + " has invalid subnet " + NAddressManager.getSubnetFromHash(n2) + " for channel " + NAddressManager.getChanIdFromHash(n2) + ". " + bComponent.getDisplayName(null) + " not registered.";
            this.lon.log().error(string);
            throw new LonException(string);
        }
        BComplex bComplex = (BComplex)this.deviceHash.get(n2);
        if (bComplex != null) {
            if (bComplex == bComponent) {
                return;
            }
            String string = "Duplicate nodeId detected with " + bComplex.getDisplayName(null) + ". " + bComponent.getDisplayName(null) + " not registered. {" + Integer.toString(n2, 16) + '}';
            this.lon.log().error(string);
            throw new LonException(string);
        }
        this.deviceHash.put(n2, (Object)bComponent);
        bDeviceData.setInt(BDeviceData.lastHash, n2, localChange);
    }

    private final void unregisterAddress(BDeviceData bDeviceData) {
        int n = bDeviceData.getLastHash();
        this.deviceHash.remove(n);
        this.checkFreeSubnet(n);
        bDeviceData.setInt(BDeviceData.lastHash, -1, localChange);
    }

    public void deviceDataChanged(BDeviceData bDeviceData, Context context) {
        if (context == localChange) {
            return;
        }
        int n = bDeviceData.getLastHash();
        if (n == -1 || n != NAddressManager.getDeviceHash(bDeviceData)) {
            BComplex bComplex = bDeviceData.getParent();
            if (bComplex instanceof BLonDevice) {
                BLonDevice bLonDevice = (BLonDevice)bComplex;
                this.unregisterLonDevice(bLonDevice);
                this.registerLonDevice(bLonDevice);
            } else if (bComplex instanceof BLonRouter) {
                BLonRouter bLonRouter = (BLonRouter)bComplex;
                this.unregisterLonRouter(bLonRouter);
                this.registerLonRouter(bLonRouter);
            }
        } else {
            this.validateNeuronId(bDeviceData);
        }
        if (context != AddressManager.noDeviceChange) {
            this.lon.fireDeviceChange(null);
        }
    }

    private final boolean validateNeuronId(BDeviceData bDeviceData) {
        BComplex bComplex = bDeviceData.getParent();
        String string = "";
        boolean bl = true;
        try {
            NmUtil.validateNeuronId(bDeviceData.getNeuronId(), (BComponent)bComplex);
        }
        catch (LonException lonException) {
            string = lonException.getMessage();
            bl = false;
        }
        if (bComplex instanceof BLonRouter) {
            BLonRouter bLonRouter = (BLonRouter)bComplex;
            if (!bl) {
                bLonRouter.setFaultCause(string);
                bLonRouter.setStatus(BStatus.make((int)(bLonRouter.getStatus().getBits() | 2)));
            } else if (bLonRouter.getFaultCause().indexOf("NeuronId") >= 0) {
                bLonRouter.setFaultCause("");
                bLonRouter.setStatus(BStatus.make((int)(bLonRouter.getStatus().getBits() & 0xFFFFFFFD)));
            }
        } else if (bComplex instanceof BLonDevice) {
            BLonDevice bLonDevice = (BLonDevice)bComplex;
            if (!bl) {
                bLonDevice.configFail(string);
            } else if (bLonDevice.getFaultCause().indexOf("NeuronId") >= 0) {
                bLonDevice.configOk();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BString newAddress(BLonDevice bLonDevice, int n, int n2, int n3) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n4 = bDeviceData.getLastHash();
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            if (!this.isValidSubnet(n2, n)) {
                if (n == NAddressManager.getChanIdFromHash(n4)) {
                    return BString.make((String)"Invalid Subnet for channel id.");
                }
                int n5 = this.findSubnetNode(n);
                n2 = NAddressManager.getSubnetFromHash(n5);
                n3 = NAddressManager.getNodeFromHash(n5);
            }
            if (!this.isAddressAvailable(n2, n3, n)) {
                return BString.make((String)("Subnet node " + n2 + '\\' + n3 + " is already inuse."));
            }
            this.unregisterLonDevice(bLonDevice);
            bDeviceData.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(n2, n3), localChange);
            bDeviceData.setInt(BDeviceData.channelId, n, localChange);
            if (bLonDevice.isConfigured()) {
                bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.unconfigured, localChange);
            }
            this.registerLonDevice(bLonDevice);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BString newAddress(BLonRouter bLonRouter, int n, BSubnetNode bSubnetNode, int n2, BSubnetNode bSubnetNode2) {
        BDeviceData bDeviceData = bLonRouter.getNearDeviceData();
        BDeviceData bDeviceData2 = bLonRouter.getFarDeviceData();
        int n3 = bSubnetNode.getSubnetId();
        int n4 = bSubnetNode.getNodeId();
        int n5 = bSubnetNode2.getSubnetId();
        int n6 = bSubnetNode2.getNodeId();
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            int n7;
            int n8;
            if (n == n2) {
                return BString.make((String)"Near and far channelIds must be different.");
            }
            if (!this.isValidSubnet(n3, n)) {
                n8 = bDeviceData.getLastHash();
                if (n == NAddressManager.getChanIdFromHash(n8)) {
                    return BString.make((String)("Subnet " + n3 + " is invalid  for channel " + n + '.'));
                }
                n7 = this.findSubnetNode(n);
                n3 = NAddressManager.getSubnetFromHash(n7);
                n4 = NAddressManager.getNodeFromHash(n7);
            }
            if (!this.isValidSubnet(n5, n2)) {
                n8 = bDeviceData2.getLastHash();
                if (n2 == NAddressManager.getChanIdFromHash(n8)) {
                    return BString.make((String)("Subnet " + n5 + " is invalid  for channel " + n2 + '.'));
                }
                n7 = this.findSubnetNode(n2);
                n5 = NAddressManager.getSubnetFromHash(n7);
                n6 = NAddressManager.getNodeFromHash(n7);
            }
            if (!this.isAddressAvailable(n3, n4, n)) {
                return BString.make((String)("Subnet node " + n3 + '\\' + n4 + " is already inuse."));
            }
            if (!this.isAddressAvailable(n5, n6, n2)) {
                return BString.make((String)("Subnet node " + n5 + '\\' + n6 + " is already inuse."));
            }
            this.unregisterLonRouter(bLonRouter);
            bDeviceData.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(n3, n4), localChange);
            bDeviceData.setInt(BDeviceData.channelId, n, localChange);
            bDeviceData2.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(n5, n6), localChange);
            bDeviceData2.setInt(BDeviceData.channelId, n2, localChange);
            if (bLonRouter.isConfigured()) {
                bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.unconfigured, localChange);
                bDeviceData2.set(BDeviceData.nodeState, (BValue)BLonNodeState.unconfigured, localChange);
            }
            this.registerLonRouter(bLonRouter);
            return null;
        }
    }

    private final boolean isAddressAvailable(int n, int n2, int n3) {
        int n4 = NAddressManager.getDeviceHash(n, n2, n3);
        Object object = this.deviceHash.get(n4);
        if (object == null) {
            return true;
        }
        if (object instanceof BLonDevice) {
            BLonDevice bLonDevice = (BLonDevice)object;
            if (bLonDevice.isConfigured()) {
                return false;
            }
            this.claimSubnetNodeId(bLonDevice.getDeviceData());
            this.unregisterLonDevice(bLonDevice);
            this.registerLonDevice(bLonDevice);
        } else if (object instanceof BLonRouter) {
            BLonRouter bLonRouter = (BLonRouter)((Object)object);
            if (bLonRouter.isConfigured()) {
                return false;
            }
            if (bLonRouter.getNearDeviceData().getLastHash() == n4) {
                this.claimSubnetNodeId(bLonRouter.getNearDeviceData());
            } else if (bLonRouter.getFarDeviceData().getLastHash() == n4) {
                this.claimSubnetNodeId(bLonRouter.getFarDeviceData());
            }
            this.unregisterLonRouter(bLonRouter);
            this.registerLonRouter(bLonRouter);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BLonDevice[] getDeviceList(boolean bl) {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            BLonDevice[] bLonDeviceArray;
            block4: {
                BLonDevice[] bLonDeviceArray2;
                block3: {
                    bLonDeviceArray2 = this.makeDeviceList();
                    bLonDeviceArray = new BLonDevice[bLonDeviceArray2.length + bl];
                    if (!bl) break block3;
                    bLonDeviceArray[0] = this.local;
                    System.arraycopy(bLonDeviceArray2, 0, bLonDeviceArray, 1, bLonDeviceArray2.length);
                    break block4;
                }
                System.arraycopy(bLonDeviceArray2, 0, bLonDeviceArray, 0, bLonDeviceArray2.length);
            }
            return bLonDeviceArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BLonDevice[] makeDeviceList() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            if (this.staleDeviceList) {
                this.devList = new BLonDevice[this.devVect.size()];
                this.devVect.copyInto(this.devList);
                this.orderList(this.devList);
                this.staleDeviceList = false;
            }
            return this.devList;
        }
    }

    private final void orderList(BLonDevice[] bLonDeviceArray) {
        int n = 0;
        int n2 = bLonDeviceArray.length - 1;
        int n3 = n;
        while (n3 < n2) {
            if (NAddressManager.getDeviceHash(bLonDeviceArray[n3]) > NAddressManager.getDeviceHash(bLonDeviceArray[n3 + 1])) {
                BLonDevice bLonDevice = bLonDeviceArray[n3];
                bLonDeviceArray[n3] = bLonDeviceArray[n3 + 1];
                bLonDeviceArray[n3 + 1] = bLonDevice;
                if (n3 > n) {
                    --n3;
                    continue;
                }
                ++n3;
                continue;
            }
            ++n3;
        }
    }

    private final void orderList(BLonRouter[] bLonRouterArray) {
        int n = 0;
        int n2 = bLonRouterArray.length - 1;
        int n3 = n;
        while (n3 < n2) {
            if (NAddressManager.getDeviceHash(bLonRouterArray[n3].getNearDeviceData()) > NAddressManager.getDeviceHash(bLonRouterArray[n3 + 1].getNearDeviceData())) {
                BLonRouter bLonRouter = bLonRouterArray[n3];
                bLonRouterArray[n3] = bLonRouterArray[n3 + 1];
                bLonRouterArray[n3 + 1] = bLonRouter;
                if (n3 > n) {
                    --n3;
                    continue;
                }
                ++n3;
                continue;
            }
            ++n3;
        }
    }

    public BLonDevice getDeviceByName(String string) {
        if (this.local != null && this.local.getName().equals(string)) {
            return this.local;
        }
        BLonDevice[] bLonDeviceArray = this.makeDeviceList();
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (bLonDeviceArray[n].getName().equals(string)) {
                return bLonDeviceArray[n];
            }
            ++n;
        }
        return null;
    }

    public BLonDevice getDeviceByAddress(BSubnetNode bSubnetNode) {
        if (this.local != null && this.local.getDeviceData().getSubnetNodeId().equals(bSubnetNode)) {
            return this.local;
        }
        BLonDevice[] bLonDeviceArray = this.makeDeviceList();
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (bLonDeviceArray[n].getDeviceData().getSubnetNodeId().equals(bSubnetNode)) {
                return bLonDeviceArray[n];
            }
            ++n;
        }
        return null;
    }

    public BLonDevice getDeviceByAddress(BNeuronId bNeuronId) {
        if (this.local != null && this.local.getDeviceData().getNeuronId().equals(bNeuronId)) {
            return this.local;
        }
        BLonDevice[] bLonDeviceArray = this.makeDeviceList();
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (bLonDeviceArray[n].getDeviceData().getNeuronId().equals(bNeuronId)) {
                return bLonDeviceArray[n];
            }
            ++n;
        }
        return null;
    }

    public BLonRouter getRouterByName(String string) {
        BLonRouter[] bLonRouterArray = this.makeRouterList();
        int n = 0;
        while (n < bLonRouterArray.length) {
            if (bLonRouterArray[n].getName().equals(string)) {
                return bLonRouterArray[n];
            }
            ++n;
        }
        return null;
    }

    public BLonRouter getRouterByAddress(BSubnetNode bSubnetNode) {
        BLonRouter[] bLonRouterArray = this.makeRouterList();
        int n = 0;
        while (n < bLonRouterArray.length) {
            BLonRouter bLonRouter = bLonRouterArray[n];
            if (bLonRouter.getNearDeviceData().getSubnetNodeId().equals(bSubnetNode) || bLonRouter.getFarDeviceData().getSubnetNodeId().equals(bSubnetNode)) {
                return bLonRouter;
            }
            ++n;
        }
        return null;
    }

    public BLonRouter getRouterByAddress(BNeuronId bNeuronId) {
        BLonRouter[] bLonRouterArray = this.makeRouterList();
        int n = 0;
        while (n < bLonRouterArray.length) {
            BLonRouter bLonRouter = bLonRouterArray[n];
            if (bLonRouter.getNearDeviceData().getNeuronId().equals(bNeuronId) || bLonRouter.getFarDeviceData().getNeuronId().equals(bNeuronId)) {
                return bLonRouter;
            }
            ++n;
        }
        return null;
    }

    public BLocalLonDevice getLocalDevice() {
        return this.local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BLonRouter[] getRouterList() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            BLonRouter[] bLonRouterArray = this.makeRouterList();
            BLonRouter[] bLonRouterArray2 = new BLonRouter[bLonRouterArray.length];
            System.arraycopy(bLonRouterArray, 0, bLonRouterArray2, 0, bLonRouterArray.length);
            return bLonRouterArray2;
        }
    }

    public boolean isRouted() {
        boolean bl = false;
        if (this.makeRouterList().length > 0) {
            bl = true;
        }
        return bl;
    }

    protected int[] getSubnetMap() {
        return this.subnetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxChannelId() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            int n = 1;
            int n2 = 0;
            while (n2 < this.subnetMap.length) {
                if (this.subnetMap[n2] > n) {
                    n = this.subnetMap[n2];
                }
                ++n2;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BLonRouter[] makeRouterList() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            if (this.staleRtrList) {
                this.rtrList = new BLonRouter[this.rtrVect.size()];
                this.rtrVect.copyInto((Object[])this.rtrList);
                this.orderList(this.rtrList);
                this.staleRtrList = false;
            }
            return this.rtrList;
        }
    }

    private final boolean verifySubnetChannel(int n) {
        int n2;
        int n3 = NAddressManager.getSubnetFromHash(n);
        int n4 = this.subnetMap[n3];
        if (n4 == (n2 = NAddressManager.getChanIdFromHash(n))) {
            return true;
        }
        if (n4 == 0) {
            this.subnetMap[n3] = n2;
            this.updateRouterManager = true;
            return true;
        }
        return false;
    }

    private final void checkFreeSubnet(int n) {
        int n2 = NAddressManager.getSubnetFromHash(n);
        if (this.local != null && this.isAnotherWithSameSubnet(n2, n, this.local.getDeviceData())) {
            return;
        }
        BLonDevice[] bLonDeviceArray = this.makeDeviceList();
        int n3 = 0;
        while (n3 < bLonDeviceArray.length) {
            if (this.isAnotherWithSameSubnet(n2, n, bLonDeviceArray[n3].getDeviceData())) {
                return;
            }
            ++n3;
        }
        BLonRouter[] bLonRouterArray = this.makeRouterList();
        int n4 = 0;
        while (n4 < bLonRouterArray.length) {
            if (this.isAnotherWithSameSubnet(n2, n, bLonRouterArray[n4].getNearDeviceData())) {
                return;
            }
            if (this.isAnotherWithSameSubnet(n2, n, bLonRouterArray[n4].getFarDeviceData())) {
                return;
            }
            ++n4;
        }
        this.lon.log().trace("free subnet " + n2);
        this.subnetMap[n2] = 0;
        this.updateRouterManager = true;
    }

    private final boolean isAnotherWithSameSubnet(int n, int n2, BDeviceData bDeviceData) {
        if (bDeviceData.getLastHash() == n2) {
            return false;
        }
        return bDeviceData.getSubnetNodeId().getSubnetId() == n;
    }

    private final boolean isValidSubnet(int n, int n2) {
        int n3 = this.subnetMap[n];
        boolean bl = false;
        if (n3 == n2 || n3 == 0) {
            bl = true;
        }
        return bl;
    }

    private final int claimSubnetNodeId(BDeviceData bDeviceData) {
        int n = bDeviceData.getChannelId();
        int n2 = this.findSubnetNode(n);
        BSubnetNode bSubnetNode = BSubnetNode.make(NAddressManager.getSubnetFromHash(n2), NAddressManager.getNodeFromHash(n2));
        bDeviceData.set(BDeviceData.subnetNodeId, (BValue)bSubnetNode, localChange);
        return n2;
    }

    private final int findSubnetNode(int n) {
        int n2 = this.getNextSubnet(0, n);
        int n3 = 1;
        while (this.deviceHash.get(NAddressManager.getDeviceHash(n2, n3, n)) != null) {
            if (++n3 < 127) continue;
            n2 = this.getNextSubnet(n2, n);
            n3 = 1;
        }
        return NAddressManager.getDeviceHash(n2, n3, n);
    }

    private final int getNextSubnet(int n, int n2) {
        int n3 = ++n;
        while (n3 <= 255) {
            if (this.subnetMap[n3] == n2) {
                return n3;
            }
            ++n3;
        }
        n3 = -1;
        int n4 = n2;
        while (n4 <= 255) {
            if (this.subnetMap[n4] == 0) {
                this.lon.log().trace("claim subnet " + n4 + " for channel " + n2);
                this.subnetMap[n4] = n2;
                this.updateRouterManager = true;
                return n4;
            }
            ++n4;
        }
        throw new RuntimeException("No more available subnets.");
    }

    public static int getDeviceHash(BLonDevice bLonDevice) {
        return NAddressManager.getDeviceHash(bLonDevice.getDeviceData());
    }

    private static final int getDeviceHash(BDeviceData bDeviceData) {
        BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
        return NAddressManager.getDeviceHash(bSubnetNode.getSubnetId(), bSubnetNode.getNodeId(), bDeviceData.getChannelId());
    }

    private static final int getDeviceHash(int n, int n2, int n3) {
        return (n3 << 15) + (n << 7) + n2;
    }

    public static int getSubnetFromHash(int n) {
        return n >> 7 & 0xFF;
    }

    public static int getNodeFromHash(int n) {
        return n & 0x7F;
    }

    public static int getChanIdFromHash(int n) {
        return n >> 15 & (char)-1;
    }

    public RouterManager routerManager() {
        if (this.routerManager == null) {
            this.routerManager = new RouterManager(this, this.lon);
        }
        if (this.updateRouterManager) {
            this.routerManager.update();
        }
        this.updateRouterManager = false;
        return this.routerManager;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"subnetMap", 2);
        spyWriter.w((Object)"<tr>").th((Object)"Subnet").th((Object)"Channel").w((Object)"</tr>\n");
        int n = 0;
        while (n < this.subnetMap.length) {
            if (this.subnetMap[n] != 0) {
                spyWriter.tr((Object)Integer.toString(n), (Object)Integer.toString(this.subnetMap[n]));
            }
            ++n;
        }
        spyWriter.endTable();
        spyWriter.startProps("Misc");
        spyWriter.prop((Object)"updateRouterManager", this.updateRouterManager);
        spyWriter.prop((Object)"staleDeviceList", this.staleDeviceList);
        spyWriter.prop((Object)"staleRtrList", this.staleRtrList);
        spyWriter.prop((Object)"local", (Object)this.local.getName());
        spyWriter.endProps();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"deviceHash", 4);
        spyWriter.w((Object)"<tr>").th((Object)"dev").th((Object)"chan").th((Object)"s/n").th((Object)"hash").w((Object)"</tr>\n");
        IntHashMap.Iterator iterator = this.deviceHash.iterator();
        while (iterator.hasNext()) {
            BComponent bComponent = (BComponent)iterator.next();
            int n2 = iterator.key();
            spyWriter.tr((Object)bComponent.getName(), (Object)Integer.toString(NAddressManager.getChanIdFromHash(n2)), (Object)(Integer.toString(NAddressManager.getSubnetFromHash(n2)) + '/' + Integer.toString(NAddressManager.getNodeFromHash(n2))), (Object)Integer.toString(n2, 16));
        }
        spyWriter.endTable();
        if (this.devList != null) {
            spyWriter.startProps("devList");
            int n3 = 0;
            while (n3 < this.devList.length) {
                if (this.devList[n3] != null) {
                    spyWriter.prop((Object)Integer.toString(n3), (Object)this.devList[n3].getName());
                }
                ++n3;
            }
            spyWriter.endProps();
        }
        if (this.rtrList != null) {
            spyWriter.startProps("rtrList");
            int n4 = 0;
            while (n4 < this.rtrList.length) {
                if (this.rtrList[n4] != null) {
                    spyWriter.prop((Object)Integer.toString(n4), (Object)this.rtrList[n4].getName());
                }
                ++n4;
            }
            spyWriter.endProps();
        }
        this.routerManager().spy(spyWriter);
    }

    private final /* synthetic */ void this() {
        this.updateRouterManager = true;
        this.routerManager = null;
        this.deviceHash = new IntHashMap(127);
        this.devVect = new Vector(200);
        this.local = null;
        this.devList = null;
        this.staleDeviceList = true;
        this.rtrVect = new Vector(200);
        this.rtrList = null;
        this.staleRtrList = true;
    }

    public NAddressManager(BLonNetwork bLonNetwork) {
        this.this();
        this.lon = bLonNetwork;
        this.subnetMap = new int[256];
        int n = 0;
        while (n < 256) {
            this.subnetMap[n] = 0;
            ++n;
        }
    }
}

