/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks;

import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import com.tridium.lonworks.enums.BLonRouterMode;
import com.tridium.lonworks.enums.BLonRouterType;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonRouter
extends BComponent
implements BIStatus {
    public static final Property status = BLonRouter.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BLonRouter.newProperty((int)67, (String)"", null);
    public static final Property routerType = BLonRouter.newProperty((int)0, (BValue)BLonRouterType.unknown, null);
    public static final Property routerMode = BLonRouter.newProperty((int)0, (BValue)BLonRouterMode.unknown, null);
    public static final Property nearDeviceData = BLonRouter.newProperty((int)0, (BValue)new BDeviceData(), null);
    public static final Property farDeviceData = BLonRouter.newProperty((int)0, (BValue)new BDeviceData(), null);
    public static final Property nearSubnetTable = BLonRouter.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    public static final Property farSubnetTable = BLonRouter.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    public static final Property nearGroupTable = BLonRouter.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    public static final Property farGroupTable = BLonRouter.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    public static final Action setType = BLonRouter.newAction((int)0, (BValue)BLonRouterType.unknown, null);
    public static final Action reset = BLonRouter.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private LonComm loncomm;
    protected Log log;
    private BLonNetwork lonNetwork;
    static /* synthetic */ Class class$com$tridium$lonworks$BLonRouter;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BLonRouterType getRouterType() {
        return (BLonRouterType)this.get(routerType);
    }

    public void setRouterType(BLonRouterType bLonRouterType) {
        this.set(routerType, (BValue)bLonRouterType, null);
    }

    public BLonRouterMode getRouterMode() {
        return (BLonRouterMode)this.get(routerMode);
    }

    public void setRouterMode(BLonRouterMode bLonRouterMode) {
        this.set(routerMode, (BValue)bLonRouterMode, null);
    }

    public BDeviceData getNearDeviceData() {
        return (BDeviceData)this.get(nearDeviceData);
    }

    public void setNearDeviceData(BDeviceData bDeviceData) {
        this.set(nearDeviceData, (BValue)bDeviceData, null);
    }

    public BDeviceData getFarDeviceData() {
        return (BDeviceData)this.get(farDeviceData);
    }

    public void setFarDeviceData(BDeviceData bDeviceData) {
        this.set(farDeviceData, (BValue)bDeviceData, null);
    }

    public BLonRouteTable getNearSubnetTable() {
        return (BLonRouteTable)this.get(nearSubnetTable);
    }

    public void setNearSubnetTable(BLonRouteTable bLonRouteTable) {
        this.set(nearSubnetTable, (BValue)bLonRouteTable, null);
    }

    public BLonRouteTable getFarSubnetTable() {
        return (BLonRouteTable)this.get(farSubnetTable);
    }

    public void setFarSubnetTable(BLonRouteTable bLonRouteTable) {
        this.set(farSubnetTable, (BValue)bLonRouteTable, null);
    }

    public BLonRouteTable getNearGroupTable() {
        return (BLonRouteTable)this.get(nearGroupTable);
    }

    public void setNearGroupTable(BLonRouteTable bLonRouteTable) {
        this.set(nearGroupTable, (BValue)bLonRouteTable, null);
    }

    public BLonRouteTable getFarGroupTable() {
        return (BLonRouteTable)this.get(farGroupTable);
    }

    public void setFarGroupTable(BLonRouteTable bLonRouteTable) {
        this.set(farGroupTable, (BValue)bLonRouteTable, null);
    }

    public void setType(BLonRouterType bLonRouterType) {
        this.invoke(setType, (BValue)bLonRouterType, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isConfigOnline() {
        boolean bl = false;
        if (this.getNearDeviceData().getNodeState() == BLonNodeState.configOnline) {
            bl = true;
        }
        return bl;
    }

    public boolean isConfigOffline() {
        boolean bl = false;
        if (this.getNearDeviceData().getNodeState() == BLonNodeState.configOffline) {
            bl = true;
        }
        return bl;
    }

    public boolean isConfigured() {
        boolean bl = false;
        if (this.isConfigOnline() || this.isConfigOffline()) {
            bl = true;
        }
        return bl;
    }

    public boolean authenticate() {
        return this.getNearDeviceData().getAuthenticate();
    }

    public void started() throws Exception {
        super.started();
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BLonNetwork)) {
            bComplex = bComplex.getParent();
        }
        if (bComplex == null) {
            return;
        }
        this.lonNetwork = (BLonNetwork)bComplex;
        this.loncomm = this.lonNetwork.lonComm();
        ((NAddressManager)this.lonNetwork.addressManager()).registerLonRouter(this);
    }

    public void stopped() throws Exception {
        super.started();
        ((NAddressManager)this.lonNetwork.addressManager()).unregisterLonRouter(this);
    }

    public void doSetType(BLonRouterType bLonRouterType) {
        this.setRouterType(bLonRouterType);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (BLonNetwork.lonNoWrite.equals(context)) {
            return;
        }
        if (property == routerType) {
            this.lonNetwork().postAsync(new asyncRouterUpdate(this, (BValue)this.getRouterType()));
        } else if (property == routerMode) {
            this.lonNetwork().postAsync(new asyncRouterUpdate(this, (BValue)this.getRouterMode()));
        }
    }

    public void doReset() {
        try {
            NmUtil.resetNode(this);
        }
        catch (Throwable throwable) {
            this.log().error("Exception in LonRouter.reset()", throwable);
        }
    }

    public BNeuronId getNeuronIdAddress() {
        return this.getNearDeviceData().getNeuronId();
    }

    public LonComm lonComm() {
        return this.loncomm;
    }

    public Log log() {
        if (this.log == null) {
            this.log = this.lonNetwork().log();
        }
        return this.log;
    }

    public BLonNetwork lonNetwork() {
        return this.lonNetwork;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.loncomm = null;
        this.log = null;
        this.lonNetwork = null;
    }

    public BLonRouter() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$lonworks$BLonRouter;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$BLonRouter = BLonRouter.class("[Lcom.tridium.lonworks.BLonRouter;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/router.png");
    }

    private static class asyncRouterUpdate
    implements Runnable {
        BLonRouter rtr;
        BValue obj;

        public void run() {
            try {
                if (this.obj.getType() == BLonRouterType.TYPE) {
                    RouterUtil.setRouterType(this.rtr, (BLonRouterType)this.obj);
                } else if (this.obj.getType() == BLonRouterMode.TYPE) {
                    RouterUtil.setRouterMode(this.rtr, (BLonRouterMode)this.obj);
                }
            }
            catch (LonException lonException) {
                this.rtr.log().error("Unable to set router type or mode " + this.rtr.getDisplayName(null), (Throwable)((Object)lonException));
            }
        }

        asyncRouterUpdate(BLonRouter bLonRouter, BValue bValue) {
            this.rtr = bLonRouter;
            this.obj = bValue;
        }
    }
}

