/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.util;

import com.tridium.aaphp.util.AaPhpTextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AaPhpAttributeConversion {
    private static final String SIXTEEN_ZEROS = "0000000000000000";
    private static final double[] TEN_TO_THE_MINUS = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9};
    static final BEnumRange RANGE_120;
    static final BEnumRange RANGE_121;
    final long rawData;
    final int aaphpType;
    final boolean bit7;
    final boolean bit6;
    final boolean bit5;
    final boolean bit4;
    final boolean bit3;
    final boolean bit2;
    final boolean bit1;
    final boolean bit0;
    boolean bitmapped;
    boolean enumerated;
    boolean unreliable;
    boolean unsigned;
    boolean timeInBcd;
    boolean dateInBcd;
    boolean ieeeFloatingPoint;
    double scale;
    double offset;
    long mask;
    BFacets facets;

    public int getAaPhpType() {
        return this.aaphpType;
    }

    public long getRawValueFor(double d) {
        if (this.ieeeFloatingPoint) {
            return Float.floatToRawIntBits((float)d);
        }
        return (long)((d - this.offset) / this.scale + 0.5);
    }

    public double getNumericVal(Context context) {
        if (this.ieeeFloatingPoint) {
            return Float.intBitsToFloat((int)(this.rawData & this.mask));
        }
        long l = this.rawData & this.mask & 0xFFFFL;
        if (!this.unsigned && (this.rawData & 0x8000L) == 32768L) {
            l = (long)-1 * (((l | 0xFFFFFFFFFFFF0000L) ^ -1L) + 1L);
            if (this.aaphpType == 2) {
                this.scale = 0.1;
            }
            return (double)l * this.scale + this.offset;
        }
        if (this.aaphpType == 2) {
            this.scale = 0.1;
        }
        return (double)(l & 0xFFFFL) * this.scale + this.offset;
    }

    public long getRawValueFor(int n) {
        return this.getRawValueFor((double)n);
    }

    public int getEnumOrdinal(Context context) {
        return (int)Math.round(this.getNumericVal(context));
    }

    public long getRawValueFor(boolean bl) {
        return this.getRawValueFor(bl ? 1 : 0);
    }

    public boolean getBoolVal(Context context) {
        boolean bl = false;
        if (this.getNumericVal(context) != 0.0) {
            bl = true;
        }
        return bl;
    }

    public long getRawValueFor(String string, Context context) {
        if (this.bitmapped) {
            return Long.parseLong(string, 2);
        }
        BFacets bFacets = null;
        bFacets = context instanceof BFacets ? (BFacets)context : this.getDefaultFacets();
        BEnumRange bEnumRange = (BEnumRange)bFacets.get("range");
        if (bEnumRange != null) {
            return bEnumRange.get(string).getOrdinal();
        }
        BInteger bInteger = (BInteger)bFacets.get("radix");
        if (bInteger != null) {
            return Long.parseLong(string, bInteger.getInt());
        }
        if (bFacets.get("trueText") != null) {
            return this.getRawValueFor(string.toLowerCase().equals(bFacets.gets("trueText", "true").toLowerCase()) ? 1 : 0);
        }
        if (this.timeInBcd) {
            throw new BajaRuntimeException("Unsupported operation: setting time attribute in AaPhp controller.");
        }
        if (this.dateInBcd) {
            throw new BajaRuntimeException("Unsupported operation: setting date attribute in AaPhp controller.");
        }
        return this.getRawValueFor(Long.parseLong(string));
    }

    public String getStringVal(Context context) {
        if (this.bitmapped) {
            return AaPhpTextUtil.truncate((String)(SIXTEEN_ZEROS + Long.toString(this.rawData, 2)), (int)16);
        }
        BFacets bFacets = null;
        bFacets = context instanceof BFacets ? (BFacets)context : this.getDefaultFacets();
        BEnumRange bEnumRange = (BEnumRange)bFacets.get("range");
        if (bEnumRange != null) {
            return bEnumRange.getTag((int)this.rawData);
        }
        BInteger bInteger = (BInteger)bFacets.get("radix");
        if (bInteger != null) {
            int n = bInteger.getInt();
            String string = Long.toString(this.rawData, n);
            if (n == 2) {
                string = AaPhpTextUtil.padLeft(string, 32, '0');
            } else if (n == 16) {
                string = AaPhpTextUtil.padLeft(string, 4, '0');
            }
            return string;
        }
        if (bFacets.get("trueText") != null) {
            boolean bl = false;
            if (this.rawData != 0L) {
                bl = true;
            }
            return BBoolean.toString((boolean)bl, (Context)bFacets);
        }
        if (this.timeInBcd) {
            int n = Integer.parseInt(Integer.toString((int)(this.rawData & 0xFF00L) >> 8, 16));
            int n2 = Integer.parseInt(Integer.toString((int)(this.rawData & 0xFFL), 16));
            try {
                return BTime.make((int)n2, (int)n, (int)0).toString((Context)bFacets);
            }
            catch (Exception exception) {
                return "Time Error: " + exception;
            }
        }
        if (this.dateInBcd) {
            int n = Integer.parseInt(Integer.toString((int)((this.rawData & 0xFFFFFFFFFFFF0000L) >> 16), 16));
            int n3 = Integer.parseInt(Integer.toString((int)((this.rawData & 0xFF00L) >> 8), 16));
            int n4 = Integer.parseInt(Integer.toString((int)(this.rawData & 0xFFL), 16));
            return BAbsTime.make((int)n, (BMonth)BMonth.make((int)n3), (int)n4).toString((Context)bFacets);
        }
        return BDouble.toString((double)this.getNumericVal((Context)bFacets), (Context)bFacets);
    }

    void convert() {
        if (this.bit7) {
            this.unreliableData();
        }
        if (this.bit6) {
            this.structuredData();
        } else {
            this.enumeratedData();
        }
    }

    void structuredData() {
        if (this.bit5) {
            this.numericSpecialOrBitmapData();
        } else {
            this.indexedData();
        }
    }

    void numericSpecialOrBitmapData() {
        int n = (this.aaphpType & 0x1C) >> 2;
        if (n < 0 || n > 7) {
            throw new IllegalStateException("Error in program. The variable 'aNumber' should be in the range 0-7 not " + n);
        }
        if (n == 7) {
            this.bitmapData();
        } else if (n == 6) {
            this.specialData();
        } else {
            this.numericData(n);
        }
    }

    void bitmapData() {
        int n = this.aaphpType & 3;
        this.bitmapped = true;
    }

    void specialData() {
        int n = this.aaphpType & 3;
    }

    double tenToTheMinus(int n) {
        return TEN_TO_THE_MINUS[n];
    }

    void numericData(int n) {
        this.scale = this.tenToTheMinus(n);
        this.unsigned = this.bit0 ^ true;
    }

    void indexedData() {
        int n = this.aaphpType & 0x1F;
    }

    void enumeratedData() {
        this.getDefaultFacets();
        this.enumerated = true;
    }

    void unreliableData() {
        this.unreliable = true;
    }

    public BFacets getDefaultFacets() {
        if (this.facets != null) {
            return this.facets;
        }
        this.facets = BFacets.DEFAULT;
        switch (this.aaphpType & 0x7F) {
            case 0: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)-32768.0, (double)32767.0));
                break;
            }
            case 1: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 2: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)100.0));
                this.unsigned = true;
                this.scale = 0.1;
                break;
            }
            case 3: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"second"), (int)0, (double)0.0, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 4: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"second"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 5: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"minute"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 6: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"hour"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 7: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)6.0));
                int[] nArray = new int[7];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"})));
                break;
            }
            case 8: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)365.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"word Day of Year (0=Jan 1)"));
                this.unsigned = true;
                break;
            }
            case 9: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)2));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"byte Channel bitmap, 8-bit"));
                this.unsigned = true;
                break;
            }
            case 10: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"True", (String)"False"));
                break;
            }
            case 11: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Auto", (String)"Manual"));
                break;
            }
            case 12: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Enabled", (String)"Disabled"));
                break;
            }
            case 13: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Normally_Closed", (String)"Normally_Open"));
                break;
            }
            case 14: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Calibrate", (String)"Run"));
                break;
            }
            case 15: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 16: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Bipolar", (String)"Unipolar"));
                break;
            }
            case 17: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"byte Days of week bitmap (1=Mon,2=Tue..128=Holiday"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{1, 2, 4, 8, 16, 32, 64, 128}, (String[])new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun", "Holiday"})));
                break;
            }
            case 18: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 19: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3));
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Supervise", "Close_to_Open", "Open_to_Close", "Change_Of_State"})));
                break;
            }
            case 20: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Number of Changes"));
                this.unsigned = true;
                break;
            }
            case 21: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"System Type"));
                int[] nArray = new int[5];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"RCUa", "RCUm_or_2m", "RCUg", "RCUd_or_2d", "STAR"})));
                break;
            }
            case 22: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Module Type"));
                int[] nArray = new int[28];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                nArray[8] = 8;
                nArray[9] = 9;
                nArray[10] = 10;
                nArray[11] = 11;
                nArray[12] = 12;
                nArray[13] = 13;
                nArray[14] = 14;
                nArray[15] = 15;
                nArray[16] = 16;
                nArray[17] = 17;
                nArray[18] = 18;
                nArray[19] = 19;
                nArray[20] = 20;
                nArray[21] = 21;
                nArray[22] = 22;
                nArray[23] = 129;
                nArray[24] = 130;
                nArray[25] = 131;
                nArray[26] = 132;
                nArray[27] = 133;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"None", "DIDO_B1", "BMON_B2", "AMON_A1_or_MONWB_A1", "MDDC_A2", "BCTL_B3", "ADDC_A3", "FSEC_A1", "FSEC_A2", "FSEC_B3", "DDC16_B3", "MCDR_A2", "ICDR_A2_or_ICDRWB_A2", "PDDC_A4", "ALY_A2", "DLDC_B1", "CHPS_B3", "TSPU_B3", "STAT_A2", "BOKU_B3", "ALC8_A3", "DASS_B1", "UMON_A", "BCMF_C1", "JCUC_C2", "APUP_C1", "TVAV_C1", "GPUP_C1"})));
                break;
            }
            case 23: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Reverse", (String)"Normal"));
                break;
            }
            case 24: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Time in BCD lsb=HH, msb=MM 00:00 23:59"));
                this.timeInBcd = true;
                break;
            }
            case 25: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"reserved"));
                int[] nArray = new int[7];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"DisableLimit", "EnableLimit", "DisableLoop", "EnableLoop", "Disable_Loop_And_Set_Desired_Position", "Turn_On_Outputs", "Turn_Off_Outputs"})));
                break;
            }
            case 26: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Channel_bitmap, 16-bit 0 65535"));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)2));
                this.bitmapped = true;
                break;
            }
            case 27: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Channel_Type"));
                int[] nArray = new int[16];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                nArray[8] = 8;
                nArray[9] = 9;
                nArray[10] = 10;
                nArray[11] = 11;
                nArray[12] = 12;
                nArray[13] = 13;
                nArray[14] = 14;
                nArray[15] = 15;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"NoScaling", "mA_0_20_mA", "mA_4_20_mA", "LookupTable3", "LookupTable4", "LookupTable5", "LookupTable6", "LookupTable7", "LookupTable8", "LookupTable9", "LookupTable10", "LookupTable11", "LookupTable12", "LookupTable13", "LookupTable14", "LookupTable15"})));
                break;
            }
            case 28: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 29: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3));
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Normal_Off", "Normal_On", "Fail_Off", "Fail_On"})));
                break;
            }
            case 30: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)1.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeBoolean((String)"Totalize_Input", (String)"Totalize_Output"));
                break;
            }
            case 31: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3));
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Text_From_Eng_Unit_For_Point", "Text_From_Next_Seq_Eng_Unit", "Text_From_2nd_Eng_Unit_Past_The_One_Specified", "Text_From_3r_dEng_Unit_Past_The_One_Specified"})));
                break;
            }
            case 32: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3));
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Unused", "Security", "Fire", "Loop"})));
                break;
            }
            case 33: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"(Seconds, Minutes)(msb=0, 0..127 Seconds)(msb=1, 0..127 Minutes)"));
                this.facets = (this.rawData & 0x8000L) > 0L ? BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"minute"), (int)0, (double)0.0, (double)127.0)) : BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"second"), (int)0, (double)0.0, (double)127.0));
                this.mask = 127L;
                break;
            }
            case 34: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)5));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Program Status"));
                int[] nArray = new int[6];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Inactive", "Run", "Wait", "Pause", "Abort", "Resume"})));
                break;
            }
            case 35: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)2));
                int[] nArray = new int[6];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Secure", "Access", "Timed Access"})));
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"reserved"));
                break;
            }
            case 48: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"IEEE 784 32 bit Floating Point"));
                this.ieeeFloatingPoint = true;
                break;
            }
            case 49: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"(BCD Date)(MSW is year, i.e. 1988h),[LSW is month(MSB), day(LSB)]"));
                this.dateInBcd = true;
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"reserved"));
                break;
            }
            case 61: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)7.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Program Status"));
                int[] nArray = new int[8];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"unloaded", "run", "stop", "error", "restart", "abort", "loading", "shutdown"})));
                break;
            }
            case 62: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Record number, msb=drive 0 or 1 0 65535"));
                this.unsigned = true;
                break;
            }
            case 63: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Hexadecimal Word 0000-FFFFh"));
                this.unsigned = true;
                break;
            }
            case 64: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)2));
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"Unoccupied", "Warm-up", "Occupied"})));
                break;
            }
            case 65: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)5));
                int[] nArray = new int[6];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])new String[]{"CER_Cooling_With_Electric_Reheat", "CHWR_Cooling_With_Hot_Water_Reheat", "CFPER_Cooling_With_Fan_Electric_Heat", "CFPHWR_Cooling_With_Fan_Hot_Water_Reheat", "CIHWR_Cooling_Induction_With_Hot_Water_Reheat"})));
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)15.0));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)("indexed Type " + ((this.aaphpType & 0x7F) - 64))));
                break;
            }
            case 96: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 97: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)-32768.0, (double)32767.0));
                break;
            }
            case 98: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)65535.0));
                this.unsigned = true;
                break;
            }
            case 99: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)-32768.0, (double)32767.0));
                break;
            }
            case 100: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)0.0, (double)6553.5));
                this.unsigned = true;
                this.scale = 0.1;
                break;
            }
            case 101: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 102: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)0.0, (double)6553.5));
                this.unsigned = true;
                this.scale = 0.1;
                break;
            }
            case 103: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)1, (double)-3276.8, (double)3276.7));
                this.scale = 0.1;
                break;
            }
            case 104: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)655.35));
                this.unsigned = true;
                this.scale = 0.01;
                break;
            }
            case 105: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)-327.68, (double)327.67));
                this.scale = 0.01;
                break;
            }
            case 106: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)655.35));
                this.unsigned = true;
                this.scale = 0.01;
                break;
            }
            case 107: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)-327.68, (double)327.67));
                this.scale = 0.01;
                break;
            }
            case 108: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)65.535));
                this.unsigned = true;
                this.scale = 0.001;
                break;
            }
            case 109: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)-32.768, (double)32.767));
                this.scale = 0.001;
                break;
            }
            case 110: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)2, (double)0.0, (double)65.535));
                this.unsigned = true;
                this.scale = 0.001;
                break;
            }
            case 111: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)-3, (double)32.768, (double)32.767));
                this.scale = 0.001;
                break;
            }
            case 112: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)0.0, (double)6.5535));
                this.unsigned = true;
                this.scale = 1.0E-4;
                break;
            }
            case 113: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)-3.2768, (double)3.2767));
                this.scale = 1.0E-4;
                break;
            }
            case 114: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)0.0, (double)6.5535));
                this.unsigned = true;
                this.scale = 1.0E-4;
                break;
            }
            case 115: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)4, (double)-3.2768, (double)3.2767));
                this.scale = 1.0E-4;
                break;
            }
            case 116: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)0.0, (double)0.65535));
                this.unsigned = true;
                this.scale = 1.0E-5;
                break;
            }
            case 117: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)-0.32768, (double)0.32767));
                this.scale = 1.0E-5;
                break;
            }
            case 118: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)0.0, (double)0.65535));
                this.unsigned = true;
                this.scale = 1.0E-5;
                break;
            }
            case 119: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)5, (double)-0.32768, (double)0.32767));
                this.scale = 1.0E-5;
                break;
            }
            case 120: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)RANGE_120));
                break;
            }
            case 121: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeEnum((BEnumRange)RANGE_121));
                break;
            }
            case 122: 
            case 123: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Special Types"));
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.makeNumeric(null, (int)0, (double)0.0, (double)3));
                this.facets = BFacets.make((BFacets)this.facets, (BFacets)BFacets.make((String)"description", (String)"Bitmap Types"));
                break;
            }
        }
        return this.facets;
    }

    private final /* synthetic */ void this() {
        this.bitmapped = false;
        this.enumerated = false;
        this.unreliable = false;
        this.unsigned = false;
        this.timeInBcd = false;
        this.dateInBcd = false;
        this.ieeeFloatingPoint = false;
        this.scale = 1.0;
        this.offset = 0.0;
        this.mask = -1;
        this.facets = null;
    }

    public AaPhpAttributeConversion(long l, int n) {
        this.this();
        this.rawData = l;
        this.aaphpType = n;
        boolean bl = false;
        if ((n & 0x80) != 0) {
            bl = true;
        }
        this.bit7 = bl;
        boolean bl2 = false;
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        this.bit6 = bl2;
        boolean bl3 = false;
        if ((n & 0x20) != 0) {
            bl3 = true;
        }
        this.bit5 = bl3;
        boolean bl4 = false;
        if ((n & 0x10) != 0) {
            bl4 = true;
        }
        this.bit4 = bl4;
        boolean bl5 = false;
        if ((n & 8) != 0) {
            bl5 = true;
        }
        this.bit3 = bl5;
        boolean bl6 = false;
        if ((n & 4) != 0) {
            bl6 = true;
        }
        this.bit2 = bl6;
        boolean bl7 = false;
        if ((n & 2) != 0) {
            bl7 = true;
        }
        this.bit1 = bl7;
        boolean bl8 = false;
        if ((n & 1) != 0) {
            bl8 = true;
        }
        this.bit0 = bl8;
        this.convert();
    }

    static {
        int[] nArray = new int[256];
        String[] stringArray = new String[256];
        int n = 0;
        while (n < 256) {
            nArray[n] = n;
            stringArray[n] = "v" + Integer.toString(n);
            ++n;
        }
        stringArray[254] = "SeriesFan";
        stringArray[255] = "NotAvailable";
        RANGE_120 = BEnumRange.make((int[])nArray, (String[])stringArray);
        int[] nArray2 = new int[256];
        String[] stringArray2 = new String[256];
        int n2 = 0;
        while (n2 < 256) {
            nArray2[n2] = n2;
            stringArray2[n2] = "v" + Integer.toString(n2);
            ++n2;
        }
        stringArray2[255] = "NotAvailable";
        RANGE_121 = BEnumRange.make((int[])nArray2, (String[])stringArray2);
    }
}

