/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpStarDevice;
import com.tridium.aaphp.datatypes.BAaPhpLearnStarPointsParam;
import com.tridium.aaphp.datatypes.BAaPhpStarAttribute;
import com.tridium.aaphp.job.BAaPhpLearnStarPointsJob;
import com.tridium.aaphp.ui.AaPhpTextFileCompare;
import com.tridium.aaphp.ui.BAaPhpPointManager;
import com.tridium.aaphp.ui.BAaPhpStarPointManager;
import com.tridium.aaphp.ui.BAaPhpVisualDiffDialog;
import com.tridium.aaphp.ui.BAaPhpVisualDiffPane;
import com.tridium.ui.file.BNFileChooser;
import com.tridium.util.TimeFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.io.BogEncoder;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFolder;
import javax.baja.util.SortUtil;
import javax.baja.util.TextUtil;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class AaPhpExaminePointDiscoveryCommand
extends MgrController.MgrCommand {
    public static final String MODULE_NAME = BAaPhpStarDevice.TYPE.getModule().getModuleName();
    static final String TITLE1 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.label");
    static final String QUESTION1 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.question1");
    static final String TITLE2 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.comparing");
    static final String TITLE3 = BAaPhpStarPointManager.TYPE.getModule().getLexicon().getText("examinePointDiscovery.compare.prompt");
    static final IFileFilter BOG_FILE_FILTER = new IFileFilter(){

        public final boolean accept(BIFile bIFile) {
            return bIFile.getExtension().equalsIgnoreCase("bog");
        }

        public final String getDescription(Context context) {
            return "Bog Files (*.bog)";
        }
    };
    static final IFileFilter TXT_FILE_FILTER = new IFileFilter(){

        public final boolean accept(BIFile bIFile) {
            return bIFile.getExtension().equalsIgnoreCase("txt");
        }

        public final String getDescription(Context context) {
            return "Text Files(*.txt)";
        }
    };
    final BAaPhpStarPointManager pointMgr;
    final BAaPhpStarDevice starDevice;
    final String starDeviceName;
    final String aaPhpStationHostName;

    public CommandArtifact doInvoke() throws Exception {
        BJob bJob = this.pointMgr.getLearn().getJob();
        if (bJob != null && bJob.getJobState() == BJobState.success && bJob instanceof BAaPhpLearnStarPointsJob) {
            this.doInvoke((BAaPhpLearnStarPointsJob)bJob);
        }
        return null;
    }

    private final BOrd promptForSaveDisOrd() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextUtil.capitalize((String)MODULE_NAME));
        stringBuffer.append(TextUtil.capitalize((String)this.aaPhpStationHostName));
        stringBuffer.append(TextUtil.capitalize((String)this.starDeviceName));
        stringBuffer.append("Dis");
        stringBuffer.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYYYMMDDHHmmss")).append(".txt");
        BNFileChooser bNFileChooser = (BNFileChooser)BNFileChooser.makeSave((BWidget)this.pointMgr);
        bNFileChooser.setTitle(this.starDevice.getLexicon().getText("examinePointDiscovery.save.prompt"));
        bNFileChooser.setDefaultFileName(stringBuffer.toString());
        bNFileChooser.setCurrentNavDirectory((BINavNode)BFileSystem.INSTANCE.getSysHome());
        bNFileChooser.setCurrentFilter(TXT_FILE_FILTER);
        BOrd bOrd = bNFileChooser.show();
        return bOrd;
    }

    private static final void getSummary(String string, BComponent bComponent, PrintWriter printWriter) {
        if (bComponent instanceof BAaPhpStarAttribute) {
            printWriter.println(string + ' ' + bComponent.toString(null));
        }
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            AaPhpExaminePointDiscoveryCommand.getSummary(bComponentArray[n].getPropertyInParent().getName(), bComponentArray[n], printWriter);
            ++n;
        }
    }

    private static final void reorderByName(BComponent bComponent) {
        Object[] objectArray = bComponent.getDynamicPropertiesArray();
        if (objectArray != null && objectArray.length > 0) {
            Object[] objectArray2 = new String[objectArray.length];
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = objectArray[n].getName();
                ++n;
            }
            SortUtil.sort((Object[])objectArray2, (Object[])objectArray, (boolean)true);
            bComponent.reorder((Property[])objectArray);
            n = 0;
            while (n < objectArray.length) {
                BValue bValue = bComponent.get((Property)objectArray[n]);
                if (bValue instanceof BComponent) {
                    AaPhpExaminePointDiscoveryCommand.reorderByName((BComponent)bValue);
                }
                ++n;
            }
        }
    }

    private static final BComponent cloneDynamically(BAaPhpLearnStarPointsParam bAaPhpLearnStarPointsParam) {
        BComponent bComponent = new BComponent();
        Property[] propertyArray = bAaPhpLearnStarPointsParam.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            bComponent.add(propertyArray[n].getName(), bAaPhpLearnStarPointsParam.get(propertyArray[n]).newCopy());
            ++n;
        }
        return bComponent;
    }

    private final void saveToTextFile(BAaPhpLearnStarPointsJob bAaPhpLearnStarPointsJob, BOrd bOrd) throws Exception {
        BFolder bFolder = (BFolder)bAaPhpLearnStarPointsJob.getLearnedPoints().newCopy();
        AaPhpExaminePointDiscoveryCommand.reorderByName((BComponent)bFolder);
        BIFile bIFile = (BIFile)bOrd.get();
        OutputStream outputStream = bIFile.getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("Discovery List: " + bAaPhpLearnStarPointsJob.getDiscoveryParameters().toString(null));
        printWriter.println("--------------------------------------------------------------------------------");
        AaPhpExaminePointDiscoveryCommand.getSummary(null, (BComponent)bFolder, printWriter);
        printWriter.flush();
        printWriter.close();
    }

    private final void saveToBog(BAaPhpLearnStarPointsJob bAaPhpLearnStarPointsJob, BOrd bOrd) throws Exception {
        BFolder bFolder = (BFolder)bAaPhpLearnStarPointsJob.getLearnedPoints().newCopy();
        AaPhpExaminePointDiscoveryCommand.reorderByName((BComponent)bFolder);
        BFolder bFolder2 = new BFolder();
        bFolder2.add("Discovered", (BValue)bFolder);
        bFolder2.add("Parameters", (BValue)AaPhpExaminePointDiscoveryCommand.cloneDynamically(bAaPhpLearnStarPointsJob.getDiscoveryParameters()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BogEncoder bogEncoder = new BogEncoder((OutputStream)byteArrayOutputStream);
        bogEncoder.setZipped(false);
        bogEncoder.setEncodeComments(false);
        bogEncoder.encodeDocument((BValue)bFolder2);
        bogEncoder.flush();
        bogEncoder.close();
        XElem xElem = XParser.make((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).parse();
        AaPhpExaminePointDiscoveryCommand.removeHandles(xElem);
        BIFile bIFile = (BIFile)bOrd.get();
        OutputStream outputStream = bIFile.getOutputStream();
        XWriter xWriter = new XWriter(outputStream);
        xElem.write(xWriter);
        xWriter.flush();
        xWriter.close();
        outputStream.flush();
        outputStream.close();
    }

    private static final void removeHandles(XElem xElem) {
        xElem.removeAttr("h");
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            AaPhpExaminePointDiscoveryCommand.removeHandles(xElemArray[n]);
            ++n;
        }
    }

    private final void doInvoke(BAaPhpLearnStarPointsJob bAaPhpLearnStarPointsJob) throws Exception {
        BOrd bOrd = this.promptForSaveDisOrd();
        if (bOrd != null) {
            BOrd bOrd2;
            this.saveToTextFile(bAaPhpLearnStarPointsJob, bOrd);
            if (BDialog.confirm((BWidget)this.pointMgr, (String)TITLE1, (Object)QUESTION1) == 4 && (bOrd2 = AaPhpTextFileCompare.promptForFile((BWidget)this.pointMgr, TITLE3, this.starDevice.getLastDiscoverySaveOrd(), TXT_FILE_FILTER)) != null) {
                this.showComparison(bOrd, bOrd2);
            }
            this.starDevice.setLastDiscoverySaveOrd(bOrd);
        }
    }

    private final void showComparison(BOrd bOrd, BOrd bOrd2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextUtil.capitalize((String)MODULE_NAME));
        stringBuffer.append(TextUtil.capitalize((String)this.aaPhpStationHostName));
        stringBuffer.append(TextUtil.capitalize((String)this.starDeviceName));
        stringBuffer.append("DisComp");
        stringBuffer.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYYYMMDDHHmmss")).append(".txt");
        BAaPhpVisualDiffPane bAaPhpVisualDiffPane = new BAaPhpVisualDiffPane();
        bAaPhpVisualDiffPane.computeDiff((BIFile)bOrd2.resolve().get(), (BIFile)bOrd.resolve().get());
        BAaPhpVisualDiffDialog bAaPhpVisualDiffDialog = new BAaPhpVisualDiffDialog((BWidget)this.pointMgr, TITLE2, bAaPhpVisualDiffPane, stringBuffer.toString());
        bAaPhpVisualDiffDialog.open();
        this.starDevice.setLastDiscoverySaveOrd(bOrd);
    }

    public AaPhpExaminePointDiscoveryCommand(BAaPhpStarPointManager bAaPhpStarPointManager) {
        super((BWidget)bAaPhpStarPointManager, BAaPhpPointManager.TYPE.getModule().getLexicon(), "examinePointDiscovery");
        this.pointMgr = bAaPhpStarPointManager;
        this.starDevice = bAaPhpStarPointManager.getAaPhpStarDevice();
        this.starDeviceName = this.starDevice.getName();
        this.aaPhpStationHostName = this.starDevice.getHost().getNavName();
    }
}

