/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpSimpleAckResponse;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpReadMessageTextResponse
extends AaPhpSimpleAckResponse {
    final char firstChar;
    private String messageText;

    public boolean isEmpty() {
        boolean bl = false;
        if (this.firstChar == '\u0000' && this.messageText.length() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isContinuation() {
        boolean bl = false;
        if (this.firstChar == '-') {
            bl = true;
        }
        return bl;
    }

    public boolean isUnrestricted() {
        boolean bl = false;
        if (!Character.isDigit(this.firstChar) && this.firstChar != '-') {
            bl = true;
        }
        return bl;
    }

    public boolean isUnstructuredTransaction() {
        boolean bl = false;
        if (Character.isDigit(this.firstChar) && this.messageText.charAt(5) != '/') {
            bl = true;
        }
        return bl;
    }

    public boolean isStructuredTransaction() {
        boolean bl = false;
        if (Character.isDigit(this.firstChar) && this.messageText.charAt(5) == '/') {
            bl = true;
        }
        return bl;
    }

    public boolean isTransaction() {
        return Character.isDigit(this.firstChar);
    }

    public int getTransactionId() {
        if (this.isTransaction()) {
            return Integer.parseInt(this.messageText.substring(0, 5));
        }
        throw new BajaRuntimeException("Sorry, this is not a transaction message!");
    }

    public int getTransactionSource() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(6, 11));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public String getAaPhpMsgClassName() {
        if (this.isStructuredTransaction() || this.isContinuation()) {
            return this.messageText.substring(12, 15).trim();
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public String getDayOfWeek() {
        if (this.isStructuredTransaction()) {
            return this.messageText.substring(16, 19).trim();
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getDayOfMonth() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(20, 22).trim());
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public String getMonthOfYear() {
        if (this.isStructuredTransaction()) {
            return this.messageText.substring(23, 26).trim();
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public BMonth getBMonth() {
        String string = this.getMonthOfYear().toUpperCase();
        if (string.equals("JAN")) {
            return BMonth.january;
        }
        if (string.equals("FEB")) {
            return BMonth.february;
        }
        if (string.equals("MAR")) {
            return BMonth.march;
        }
        if (string.equals("APR")) {
            return BMonth.april;
        }
        if (string.equals("MAY")) {
            return BMonth.may;
        }
        if (string.equals("JUN")) {
            return BMonth.june;
        }
        if (string.equals("JUL")) {
            return BMonth.july;
        }
        if (string.equals("AUG")) {
            return BMonth.august;
        }
        if (string.equals("SEP")) {
            return BMonth.september;
        }
        if (string.equals("OCT")) {
            return BMonth.october;
        }
        if (string.equals("NOV")) {
            return BMonth.november;
        }
        if (string.equals("DEC")) {
            return BMonth.december;
        }
        throw new BajaRuntimeException("Unrecognized aaphp month: " + string + ". Please have my program fixed!");
    }

    public int getYear() {
        if (this.isStructuredTransaction()) {
            int n = Integer.parseInt(this.messageText.substring(27, 29));
            return n >= 80 ? 1900 + n : 2000 + n;
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getHour() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(30, 32));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getMinute() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(33, 35));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getSecond() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(36, 38));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public BAbsTime getAbsTime() {
        return BAbsTime.make((int)this.getYear(), (BMonth)this.getBMonth(), (int)this.getDayOfMonth(), (int)this.getHour(), (int)this.getMinute(), (int)this.getSecond(), (int)0);
    }

    public String getText() {
        if (this.isStructuredTransaction()) {
            return this.messageText.substring(37);
        }
        if (this.isUnstructuredTransaction()) {
            return this.messageText.substring(6);
        }
        if (this.isUnstructuredTransaction()) {
            return this.messageText;
        }
        if (this.isContinuation()) {
            return this.messageText.substring(16);
        }
        throw new BajaRuntimeException("Unsupported message type - please have my program fixed.");
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void appendText(String string) {
        this.messageText = this.messageText + string;
    }

    public AaPhpReadMessageTextResponse(int n, AaPhpInputStream aaPhpInputStream) {
        super(n, aaPhpInputStream);
        if (aaPhpInputStream.available() > 1) {
            this.messageText = aaPhpInputStream.readMessageText();
            this.firstChar = this.messageText.charAt(0);
        } else {
            this.messageText = "";
            this.firstChar = '\u0000';
        }
    }
}

