/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpResponse;
import com.tridium.aaphp.util.AaPhpAttributeConversion;
import javax.baja.sys.Context;

public class AaPhpReadAttributeResponse
extends AaPhpResponse {
    final int encodingValue;
    final String attributeName;
    final long rawDataHex;
    final AaPhpAttributeConversion attrConv;

    public boolean getBooleanValue(Context context) {
        return this.attrConv.getBoolVal(context);
    }

    public double getFloatValue(Context context) {
        return this.attrConv.getNumericVal(context);
    }

    public String getStringValue(Context context) {
        return this.attrConv.getStringVal(context);
    }

    public int getIntValue(Context context) {
        return this.attrConv.getEnumOrdinal(context);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getEncodingValue() {
        return this.encodingValue;
    }

    public long getRawDataHex() {
        return this.rawDataHex;
    }

    public AaPhpAttributeConversion getAttrConv() {
        return this.attrConv;
    }

    AaPhpReadAttributeResponse(AaPhpInputStream aaPhpInputStream) {
        super(aaPhpInputStream);
        if (this.isError()) {
            this.attributeName = null;
            this.encodingValue = 0;
            this.rawDataHex = Long.MAX_VALUE;
            this.attrConv = null;
        } else {
            this.attributeName = aaPhpInputStream.readAttributeName();
            this.encodingValue = aaPhpInputStream.readEncodingType();
            this.rawDataHex = aaPhpInputStream.readRawDataHex32();
            this.attrConv = new AaPhpAttributeConversion(this.rawDataHex, this.encodingValue);
        }
    }
}

