/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.datatypes.BAaPhpLearnDeviceEntry;
import com.tridium.aaphp.datatypes.BAaPhpLearnDevicesParameter;
import com.tridium.aaphp.messages.AaPhpSayHelloRequest;
import com.tridium.aaphp.messages.AaPhpSayHelloResponse;
import com.tridium.aaphp.messages.AaPhpWhoAreYouRequest;
import com.tridium.aaphp.messages.AaPhpWhoAreYouResponse;
import com.tridium.aaphp.util.AaPhpTextUtil;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAaPhpLearnDevicesJob
extends BSimpleJob {
    public static final Property learnedDevices = BAaPhpLearnDevicesJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE;
    private static final String TWO_ZEROS = "00";
    private static final String LEARN_NAME_PREFIX = "Device";
    final BAaPhpNetwork aaphpNet;
    final BAaPhpLearnDevicesParameter learnParameter;
    static /* synthetic */ Class class$com$tridium$aaphp$job$BAaPhpLearnDevicesJob;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public Type getType() {
        return TYPE;
    }

    AaPhpWhoAreYouResponse sendWhoAreYou() {
        return (AaPhpWhoAreYouResponse)this.aaphpNet.sendSync(new AaPhpWhoAreYouRequest());
    }

    String getLearnName(int n) {
        return LEARN_NAME_PREFIX + AaPhpTextUtil.truncateRight(TWO_ZEROS + Integer.toString(n, 16), 2);
    }

    void addLearnedDevice(int n) {
        String string = this.getLearnName(n);
        if (this.getLearnedDevices().get(string) == null) {
            this.getLearnedDevices().add(string, (BValue)new BAaPhpLearnDeviceEntry(n, string));
            this.logMessage("found device " + n);
        }
    }

    void removeLearnedDevice(int n) {
        String string = this.getLearnName(n);
        if (this.getLearnedDevices().get(string) != null) {
            this.getLearnedDevices().remove(string);
        }
    }

    void doExhaustiveLearn(int n, int n2, int n3, BRelTime bRelTime) {
        AaPhpSayHelloRequest aaPhpSayHelloRequest = new AaPhpSayHelloRequest(this.aaphpNet.translateAddress(n));
        AaPhpSayHelloResponse aaPhpSayHelloResponse = (AaPhpSayHelloResponse)this.aaphpNet.sendSync(aaPhpSayHelloRequest, bRelTime, 0);
        if (aaPhpSayHelloResponse == null) {
            this.removeLearnedDevice(n);
        } else {
            this.addLearnedDevice(n);
        }
        this.progress((int)((float)(n - n2) / (float)(n3 - n2) * 100.0f));
    }

    boolean doWhoAreYouLearn() {
        AaPhpWhoAreYouResponse aaPhpWhoAreYouResponse = this.sendWhoAreYou();
        if (aaPhpWhoAreYouResponse != null) {
            this.addLearnedDevice(aaPhpWhoAreYouResponse.getStarUnitNumber());
            return true;
        }
        return false;
    }

    boolean doQuickWhoAreYouLearn() {
        if (this.learnParameter.getSendWhoAreYou()) {
            return this.doWhoAreYouLearn();
        }
        return false;
    }

    void doExhaustiveLearn() {
        this.logMessage("exhaustive learn");
        BRelTime bRelTime = this.learnParameter.getTimeout();
        int n = this.learnParameter.getFrom();
        int n2 = this.learnParameter.getTo();
        int n3 = n;
        while (n3 <= n2) {
            if (this.isAlive()) {
                this.doExhaustiveLearn(n3, n, n2, bRelTime);
            } else if (this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled) {
                throw new JobCancelException();
            }
            ++n3;
        }
    }

    public void run(Context context) throws Exception {
        this.logMessage("starting");
        if (!this.doQuickWhoAreYouLearn()) {
            this.doExhaustiveLearn();
        }
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.aaphpNet != null) {
            int n = this.aaphpNet.getLog().getSeverity();
            this.aaphpNet.getLog().setSeverity(1);
            this.aaphpNet.getLog().message("Learn PHP Devices Job:" + string);
            this.aaphpNet.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAaPhpLearnDevicesJob() {
        this.aaphpNet = null;
        this.learnParameter = null;
    }

    public BAaPhpLearnDevicesJob(BAaPhpNetwork bAaPhpNetwork, BAaPhpLearnDevicesParameter bAaPhpLearnDevicesParameter) {
        this.aaphpNet = bAaPhpNetwork;
        this.learnParameter = bAaPhpLearnDevicesParameter;
    }

    static {
        Class clazz = class$com$tridium$aaphp$job$BAaPhpLearnDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$aaphp$job$BAaPhpLearnDevicesJob = BAaPhpLearnDevicesJob.class("[Lcom.tridium.aaphp.job.BAaPhpLearnDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

