/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.ui.theme.Theme;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.PropertiesCollection;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;
import javax.baja.ui.BBorder;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.util.Version;
import javax.baja.web.UserAgent;
import javax.baja.web.WebOp;

public class HxUtil {
    static Version IE_10_VERSION = new Version("10");
    static String IE_6 = "MSIE/6";
    static int pollFreq = 5000;
    static boolean disablePngFixing = false;

    public static AgentInfo getDefaultView(HxOp hxOp) {
        try {
            return hxOp.getWebEnv().getDefaultView((WebOp)hxOp, HxUtil.getViews(hxOp));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static AgentList getViews(HxOp hxOp) {
        return HxHyperlinkInfo.getViews(hxOp);
    }

    public static String makeFont(BFont bFont) throws Exception {
        String string = bFont.getName();
        double d = bFont.getSize();
        int n = bFont.getStyle();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("bold ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("italic ");
        }
        stringBuffer.append(BDouble.encode((double)d)).append("px ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static BColor makeColor(BBrush bBrush, BColor bColor) throws Exception {
        if (bBrush.isNull()) {
            return bColor;
        }
        if (bBrush.getPaint() instanceof BBrush.Solid) {
            BColor bColor2 = ((BBrush.Solid)bBrush.getPaint()).getColor();
            return bColor2;
        }
        if (bBrush.getPaint() instanceof BBrush.Gradient) {
            BBrush.Stop[] stopArray = ((BBrush.Gradient)bBrush.getPaint()).getStops();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < stopArray.length) {
                BColor bColor3 = stopArray[n4].getColor();
                n += bColor3.getRed();
                n2 += bColor3.getBlue();
                n3 += bColor3.getGreen();
                ++n4;
            }
            return BColor.make((int)(n / stopArray.length), (int)(n3 / stopArray.length), (int)(n2 / stopArray.length));
        }
        return bColor;
    }

    public static String makeColor(BBrush bBrush, String string) throws Exception {
        BColor bColor = HxUtil.makeColor(bBrush, BColor.NULL);
        if (bColor.equals((Object)BColor.NULL)) {
            return string;
        }
        return bColor.toHtmlString();
    }

    public static String makeInsets(BInsets bInsets) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bInsets.top).append("px ");
        stringBuffer.append(bInsets.right).append("px ");
        stringBuffer.append(bInsets.bottom).append("px ");
        stringBuffer.append(bInsets.left).append("px");
        return stringBuffer.toString();
    }

    public static String makeBorder(BBorder bBorder) throws Exception {
        BBorder bBorder2 = bBorder;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("border-top:");
        HxUtil.makeBorder(bBorder2.topWidth, bBorder2.topStyle, bBorder2.topBrush, stringBuffer);
        stringBuffer.append("border-left:");
        HxUtil.makeBorder(bBorder2.leftWidth, bBorder2.leftStyle, bBorder2.leftBrush, stringBuffer);
        stringBuffer.append("border-right:");
        HxUtil.makeBorder(bBorder2.rightWidth, bBorder2.rightStyle, bBorder2.rightBrush, stringBuffer);
        stringBuffer.append("border-bottom:");
        HxUtil.makeBorder(bBorder2.bottomWidth, bBorder2.bottomStyle, bBorder2.bottomBrush, stringBuffer);
        return stringBuffer.toString();
    }

    private static final void makeBorder(double d, int n, BBrush bBrush, StringBuffer stringBuffer) throws Exception {
        stringBuffer.append(d).append("px ");
        switch (n) {
            case 0: {
                stringBuffer.append("none ");
                break;
            }
            case 1: {
                stringBuffer.append("solid ");
                break;
            }
            case 2: {
                stringBuffer.append("dotted ");
                break;
            }
            case 3: {
                stringBuffer.append("dashed ");
                break;
            }
            case 4: {
                stringBuffer.append("groove ");
                break;
            }
            case 5: {
                stringBuffer.append("solid ");
                break;
            }
            case 6: {
                stringBuffer.append("inset ");
                break;
            }
            case 7: {
                stringBuffer.append("outset ");
                break;
            }
        }
        if (n == 6 || n == 7) {
            stringBuffer.append("#ccc");
        } else if (n == 5) {
            stringBuffer.append(((BBrush.Solid)Theme.widget().getControlHighlight().getPaint()).getColor().toHtmlString());
        } else {
            stringBuffer.append(HxUtil.makeColor(bBrush, BColor.black).toHtmlString());
        }
        stringBuffer.append(";");
    }

    public static void makeAlignment(BHalign bHalign, BValign bValign, PropertiesCollection propertiesCollection) {
        if (bHalign == BHalign.center) {
            propertiesCollection.add("textAlign", "center");
        } else if (bHalign == BHalign.right) {
            propertiesCollection.add("textAlign", "right");
        } else if (bHalign != null) {
            propertiesCollection.add("textAlign", "left");
        }
        if (bValign == BValign.center) {
            propertiesCollection.add("verticalAlign", "middle");
        } else if (bValign == BValign.top) {
            propertiesCollection.add("verticalAlign", "top");
        } else if (bValign != null) {
            propertiesCollection.add("verticalAlign", "bottom");
        }
    }

    public static void makeAlignment(BAlign bAlign, PropertiesCollection propertiesCollection) {
        if (bAlign == BAlign.center) {
            propertiesCollection.add("textAlign", "center");
        } else if (bAlign == BAlign.right) {
            propertiesCollection.add("textAlign", "right");
        } else if (bAlign != null) {
            propertiesCollection.add("textAlign", "left");
        }
        if (bAlign == BAlign.center) {
            propertiesCollection.add("verticalAlign", "middle");
        } else if (bAlign == BAlign.bottom) {
            propertiesCollection.add("verticalAlign", "bottom");
        } else if (bAlign != null) {
            propertiesCollection.add("verticalAlign", "top");
        }
    }

    public static void makeFont(BBrush bBrush, BFont bFont, PropertiesCollection propertiesCollection) throws Exception {
        HxUtil.makeFont(bBrush, bFont, propertiesCollection, false);
    }

    public static void makeFont(BBrush bBrush, BFont bFont, PropertiesCollection propertiesCollection, boolean bl) throws Exception {
        if (!bl) {
            propertiesCollection.add("whiteSpace", "nowrap");
        }
        if (!bFont.isNull()) {
            propertiesCollection.add("fontSize", (int)bFont.getSize() + "px");
            propertiesCollection.add("fontFamily", bFont.getName());
        }
        if (!bFont.isNull() && bFont.isBold()) {
            propertiesCollection.add("fontWeight", "bold");
        } else {
            propertiesCollection.add("fontWeight", "normal");
        }
        if (!bFont.isNull() && bFont.isUnderline()) {
            propertiesCollection.add("textDecoration", "underline");
        } else {
            propertiesCollection.add("textDecoration", "none");
        }
        if (!bFont.isNull() && bFont.isItalic()) {
            propertiesCollection.add("fontStyle", "italic");
        } else {
            propertiesCollection.add("fontStyle", "none");
        }
        propertiesCollection.add("color", HxUtil.makeColor(bBrush, BColor.black).toHtmlString());
    }

    public static void makeBackground(BBrush bBrush, BBrush bBrush2, PropertiesCollection propertiesCollection, HxOp hxOp) throws Exception {
        if (!bBrush.isNull()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bBrush.getPaint() instanceof BBrush.Solid || bBrush.getPaint() instanceof BBrush.Gradient) {
                stringBuffer.append(HxUtil.makeColor(bBrush, BColor.NULL).toHtmlString());
                propertiesCollection.add("opacity", "" + (double)HxUtil.makeColor(bBrush, BColor.NULL).getAlpha() / 255.0);
                if (hxOp.getUserAgent().isIE()) {
                    int n = (int)((double)HxUtil.makeColor(bBrush, BColor.NULL).getAlpha() / 255.0 * 100.0);
                    if (n < 100) {
                        propertiesCollection.add("filter", "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + n + ')');
                    } else {
                        propertiesCollection.add("filter", "");
                    }
                }
            } else {
                propertiesCollection.add("opacity", "");
                if (hxOp.getUserAgent().isIE()) {
                    propertiesCollection.add("filter", "");
                }
            }
            if (bBrush.getPaint() instanceof BBrush.Image) {
                BBrush.Image image = (BBrush.Image)bBrush.getPaint();
                BImage bImage = image.getImage();
                stringBuffer.append("url(" + bImage.getOrdList().get(0) + ") ");
                switch (image.getTile()) {
                    case 0: {
                        stringBuffer.append("no-repeat ");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("repeat ");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("repeat-x ");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("repeat-y ");
                        break;
                    }
                }
                block6 : switch (image.getValign()) {
                    case 0: {
                        switch (image.getHalign()) {
                            case 3: {
                                stringBuffer.append("center left ");
                                break block6;
                            }
                            case 4: {
                                stringBuffer.append("center right ");
                                break block6;
                            }
                            case 0: {
                                stringBuffer.append("center center ");
                                break block6;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (image.getHalign()) {
                            case 3: {
                                stringBuffer.append("top left ");
                                break block6;
                            }
                            case 4: {
                                stringBuffer.append("top right ");
                                break block6;
                            }
                            case 0: {
                                stringBuffer.append("top center ");
                                break block6;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (image.getHalign()) {
                            case 3: {
                                stringBuffer.append("bottom left ");
                                break block6;
                            }
                            case 4: {
                                stringBuffer.append("bottom right ");
                                break block6;
                            }
                            case 0: {
                                stringBuffer.append("bottom center ");
                                break block6;
                            }
                        }
                        break;
                    }
                }
            }
            propertiesCollection.add("background", stringBuffer.toString());
        } else if (bBrush2 != null && !bBrush2.isNull()) {
            HxUtil.makeBackground(bBrush2, null, propertiesCollection, hxOp);
        } else {
            propertiesCollection.add("background", "none");
        }
    }

    public static void makeBorder(BBorder bBorder, PropertiesCollection propertiesCollection) throws Exception {
        propertiesCollection.add("borderTopWidth", (int)bBorder.topWidth + "px");
        propertiesCollection.add("borderTopColor", ((BBrush.Solid)bBorder.topBrush.getPaint()).getColor().toHtmlString());
        switch (bBorder.topStyle) {
            case 0: {
                propertiesCollection.add("borderTopStyle", "none");
                break;
            }
            case 1: {
                propertiesCollection.add("borderTopStyle", "solid");
                break;
            }
            case 2: {
                propertiesCollection.add("borderTopStyle", "dotted");
                break;
            }
            case 3: {
                propertiesCollection.add("borderTopStyle", "dashed");
                break;
            }
            case 4: {
                propertiesCollection.add("borderTopStyle", "groove");
                break;
            }
            case 5: {
                propertiesCollection.add("borderTopColor", ((BBrush.Solid)Theme.widget().getControlHighlight().getPaint()).getColor().toHtmlString());
                propertiesCollection.add("borderTopStyle", "solid");
                break;
            }
            case 6: {
                propertiesCollection.add("borderTopStyle", "inset");
                break;
            }
            case 7: {
                propertiesCollection.add("borderTopStyle", "outset");
                break;
            }
        }
        propertiesCollection.add("borderLeftWidth", (int)bBorder.leftWidth + "px");
        propertiesCollection.add("borderLeftColor", ((BBrush.Solid)bBorder.leftBrush.getPaint()).getColor().toHtmlString());
        switch (bBorder.leftStyle) {
            case 0: {
                propertiesCollection.add("borderLeftStyle", "none");
                break;
            }
            case 1: {
                propertiesCollection.add("borderLeftStyle", "solid");
                break;
            }
            case 2: {
                propertiesCollection.add("borderLeftStyle", "dotted");
                break;
            }
            case 3: {
                propertiesCollection.add("borderLeftStyle", "dashed");
                break;
            }
            case 4: {
                propertiesCollection.add("borderLeftStyle", "groove");
                break;
            }
            case 5: {
                propertiesCollection.add("borderLeftColor", ((BBrush.Solid)Theme.widget().getControlHighlight().getPaint()).getColor().toHtmlString());
                propertiesCollection.add("borderLeftStyle", "solid");
                break;
            }
            case 6: {
                propertiesCollection.add("borderLeftStyle", "inset");
                break;
            }
            case 7: {
                propertiesCollection.add("borderLeftStyle", "outset");
                break;
            }
        }
        propertiesCollection.add("borderRightWidth", (int)bBorder.rightWidth + "px");
        propertiesCollection.add("borderRightColor", ((BBrush.Solid)bBorder.rightBrush.getPaint()).getColor().toHtmlString());
        switch (bBorder.rightStyle) {
            case 0: {
                propertiesCollection.add("borderRightStyle", "none");
                break;
            }
            case 1: {
                propertiesCollection.add("borderRightStyle", "solid");
                break;
            }
            case 2: {
                propertiesCollection.add("borderRightStyle", "dotted");
                break;
            }
            case 3: {
                propertiesCollection.add("borderRightStyle", "dashed");
                break;
            }
            case 4: {
                propertiesCollection.add("borderRightStyle", "groove");
                break;
            }
            case 5: {
                propertiesCollection.add("borderRightColor", ((BBrush.Solid)Theme.widget().getControlHighlight().getPaint()).getColor().toHtmlString());
                propertiesCollection.add("borderRightStyle", "solid");
                break;
            }
            case 6: {
                propertiesCollection.add("borderRightStyle", "inset");
                break;
            }
            case 7: {
                propertiesCollection.add("borderRightStyle", "outset");
                break;
            }
        }
        propertiesCollection.add("borderBottomWidth", (int)bBorder.bottomWidth + "px");
        propertiesCollection.add("borderBottomColor", ((BBrush.Solid)bBorder.bottomBrush.getPaint()).getColor().toHtmlString());
        switch (bBorder.bottomStyle) {
            case 0: {
                propertiesCollection.add("borderBottomStyle", "none");
                break;
            }
            case 1: {
                propertiesCollection.add("borderBottomStyle", "solid");
                break;
            }
            case 2: {
                propertiesCollection.add("borderBottomStyle", "dotted");
                break;
            }
            case 3: {
                propertiesCollection.add("borderBottomStyle", "dashed");
                break;
            }
            case 4: {
                propertiesCollection.add("borderBottomStyle", "groove");
                break;
            }
            case 5: {
                propertiesCollection.add("borderBottomColor", ((BBrush.Solid)Theme.widget().getControlHighlight().getPaint()).getColor().toHtmlString());
                propertiesCollection.add("borderBottomStyle", "solid");
                break;
            }
            case 6: {
                propertiesCollection.add("borderBottomStyle", "inset");
                break;
            }
            case 7: {
                propertiesCollection.add("borderBottomStyle", "outset");
                break;
            }
        }
    }

    public static void makePadding(BInsets bInsets, PropertiesCollection propertiesCollection) throws Exception {
        propertiesCollection.add("paddingTop", (int)bInsets.top + "px");
        propertiesCollection.add("paddingBottom", (int)bInsets.bottom + "px");
        propertiesCollection.add("paddingLeft", (int)bInsets.left + "px");
        propertiesCollection.add("paddingRight", (int)bInsets.right + "px");
    }

    public static void makeMargin(BInsets bInsets, PropertiesCollection propertiesCollection) throws Exception {
        propertiesCollection.add("marginTop", (int)bInsets.top + "px");
        propertiesCollection.add("marginBottom", (int)bInsets.bottom + "px");
        propertiesCollection.add("marginLeft", (int)bInsets.left + "px");
        propertiesCollection.add("marginRight", (int)bInsets.right + "px");
    }

    public static void writeFormValue(String string, String string2, HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        htmlWriter.w((Object)"<input ");
        htmlWriter.attr("style", "display: none");
        htmlWriter.attr("type", "text");
        htmlWriter.attr("id", hxOp.scope(string));
        htmlWriter.attr("name", hxOp.scope(string));
        htmlWriter.attr("value", string2);
        htmlWriter.w((Object)"/>");
    }

    public static void persistFormValue(String string, HxOp hxOp) throws Exception {
        if (hxOp.getFormValue(string) != null) {
            HxUtil.writeFormValue(string, hxOp.getFormValue(string), hxOp);
        }
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '+') {
                stringBuffer.append(" ");
            } else if (cArray[n] == '%') {
                int n2;
                int n3;
                int n4 = 0;
                int n5 = ++n;
                n4 += HxUtil.fromHex(cArray[n5]) * 16;
                if (((n4 += HxUtil.fromHex(cArray[++n])) & 0xE0) == 192) {
                    n3 = n4;
                    n2 = 0;
                    ++n;
                    n2 += HxUtil.fromHex(cArray[++n]) * 16;
                    n2 += HxUtil.fromHex(cArray[++n]);
                    n2 = (n3 & 1) << 6 | n2 & 0x3F;
                    n3 = n3 >> 1 & 0xF;
                    n4 = n3 << 7 | n2;
                } else if ((n4 & 0xE0) == 224) {
                    n3 = n4;
                    n2 = 0;
                    int n6 = 0;
                    ++n;
                    n2 += HxUtil.fromHex(cArray[++n]) * 16;
                    n2 += HxUtil.fromHex(cArray[++n]);
                    ++n;
                    n6 += HxUtil.fromHex(cArray[++n]) * 16;
                    n4 = (n3 & 0xF) << 12 | (n2 & 0x3F) << 6 | (n6 += HxUtil.fromHex(cArray[++n])) & 0x3F;
                }
                stringBuffer.append((char)n4);
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final int fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public static void addTouchScroll(String string, HxOp hxOp) {
        if (HxUtil.isUserAgentWithoutInnerDivTouchScroll(hxOp)) {
            if (BHxView.log.isTraceOn()) {
                BHxView.log.trace("Adding Touch Scroll for inner div: " + hxOp.getPath());
            }
            String string2 = !HxUtil.isPost(hxOp) ? "\"" : "&quot;";
            hxOp.addOnload("hx.addTouchScroll($(" + string2 + string + string2 + "));");
        }
    }

    public static boolean isPost(HxOp hxOp) {
        String string = hxOp.getRequest().getMethod().toLowerCase();
        return string.equals("get") ^ true;
    }

    public static void makeImage(BImage bImage, HxOp hxOp) throws Exception {
        HxUtil.makeImage(bImage, null, "", hxOp);
    }

    public static void makeImage(BImage bImage, String string, HxOp hxOp) throws Exception {
        HxUtil.makeImage(bImage, string, "", hxOp);
    }

    public static void makeImage(BImage bImage, String string, String string2, HxOp hxOp) throws Exception {
        String string3;
        boolean bl;
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        String string4 = bImage.getOrdList().get(0).toString();
        boolean bl2 = false;
        if (HxUtil.isUserAgentIE6(hxOp) && string4.endsWith(".png")) {
            bl2 = bl = true;
        }
        if (disablePngFixing) {
            bl = false;
        }
        if (bl) {
            try {
                bImage.sync();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (bl) {
            string3 = Integer.toString((int)bImage.getWidth());
            String string5 = Integer.toString((int)bImage.getHeight());
            htmlWriter.w((Object)"<span style='width:").w((Object)string3).w((Object)"px; height:").w((Object)string5).w((Object)"px; ");
            if (hxOp.getRequest().getMethod().toLowerCase().equals("get")) {
                htmlWriter.w((Object)"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src=\"");
                htmlWriter.w((Object)string4);
                htmlWriter.w((Object)"\");'>");
            } else {
                htmlWriter.w((Object)"'");
                htmlWriter.w((Object)("ord='" + string4 + "' class='pngFix'"));
                htmlWriter.w((Object)">");
            }
        }
        htmlWriter.w((Object)"<img").attr(" alt", string2);
        if (string2 != null && string2.length() > 0) {
            htmlWriter.attr(" title", string2);
        }
        htmlWriter.attr(" src", string4);
        if (bl) {
            string3 = "filter:progid:DXImageTransform.Microsoft.Alpha(opacity=0);";
            if (string != null && string.indexOf("style=") != -1) {
                int n = string.indexOf("style=");
                int n2 = n + "style=".length() + 1;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n2));
                stringBuffer.append(string3).append(" ");
                stringBuffer.append(string.substring(n2));
                string = stringBuffer.toString();
            } else {
                htmlWriter.attr(" style", string3);
            }
        }
        if (string != null && string.length() > 0) {
            htmlWriter.w((Object)" ").w((Object)string);
        }
        htmlWriter.w((Object)"/>");
        if (bl) {
            htmlWriter.w((Object)"</span>");
        }
    }

    public static boolean isUserAgentWithoutInnerDivTouchScroll(HxOp hxOp) {
        return hxOp.getUserAgent().isMozilla() && (hxOp.getUserAgent().toString().indexOf("Android 2.") > -1 || hxOp.getUserAgent().toString().indexOf("CPU OS 4_") > -1 && hxOp.getUserAgent().toString().indexOf("like Mac OS X") > -1);
    }

    public static boolean isUserAgentIE6(HxOp hxOp) {
        UserAgent.Product product = hxOp.getUserAgent().getProduct();
        if (product != null) {
            boolean bl = false;
            if (product.toString().indexOf(IE_6) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static boolean isUserAgentWithoutCanvas(HxOp hxOp) {
        UserAgent.Product product = hxOp.getUserAgent().getProduct();
        if (product != null && hxOp.getUserAgent().isIE() && product.version != null) {
            boolean bl = false;
            if (product.version.compareTo((Object)IE_10_VERSION) < 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static int getPollFreq() {
        return pollFreq;
    }

    public static String encodeText(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < ' ' || c > '~' || c == '\'' || c == '\"') {
                if (c == '\n' || c == '\r') {
                    stringBuffer.append("<br/>");
                } else if (c == '\"') {
                    stringBuffer.append("\\\"");
                } else if (c == '\'') {
                    stringBuffer.append("\\'");
                } else {
                    stringBuffer.append("&#x");
                    stringBuffer.append(Integer.toHexString(c));
                    stringBuffer.append(';');
                }
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getUpdateValueInvokeCode(String string, String string2, String string3, HxOp hxOp) throws Exception {
        char c;
        boolean bl = false;
        char c2 = '\\';
        char c3 = '\ufffd';
        String string4 = "\\";
        if (string2.indexOf(string4) > -1) {
            string2 = TextUtil.replace((String)string2, (String)string4, (String)("" + c3 + 's'));
            bl = true;
        }
        string4 = string3;
        if (string2.indexOf(string3) > -1) {
            string2 = TextUtil.replace((String)string2, (String)string4, (String)(c2 + string3));
        }
        if (string2.indexOf(c = '\n') > -1) {
            string2 = TextUtil.replace((String)string2, (String)("" + c), (String)("" + c3 + 'n'));
            bl = true;
        }
        if (string2.indexOf(c = '\r') > -1) {
            string2 = TextUtil.replace((String)string2, (String)("" + c), (String)("" + c3 + 'r'));
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("hx.updateValue(").append(string3).append(string).append(string3).append(",");
        stringBuffer.append(string3).append(string2).append(string3).append(",");
        stringBuffer.append(bl).append(");");
        return stringBuffer.toString();
    }

    static {
        try {
            pollFreq = new Integer(System.getProperty("hx.poll.freq", "5000"));
        }
        catch (Exception exception) {}
        try {
            disablePngFixing = new Boolean(System.getProperty("hx.disablePngFixing", "false"));
        }
        catch (Exception exception) {}
    }
}

