/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import com.tridium.sys.Nre;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.workbench.CannotSaveException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHxNumericFE
extends BHxFieldEditor {
    public static final BHxNumericFE INSTANCE = new BHxNumericFE();
    public static final Type TYPE;
    private static DecimalFormat fSN;
    private static final long MAX_LONG_PREC = 0x20000000000000L;
    HashMap formatters;
    static /* synthetic */ Class class$com$tridium$hx$fieldeditors$BHxNumericFE;

    public Type getType() {
        return TYPE;
    }

    public void write(HxOp hxOp) throws Exception {
        Parser parser;
        BNumber bNumber = (BNumber)hxOp.get();
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        if (bNumber instanceof BFloat) {
            parser = new FloatParser(hxOp);
        } else if (bNumber instanceof BInteger) {
            parser = new IntegerParser(hxOp);
        } else if (bNumber instanceof BLong) {
            parser = new LongParser(hxOp);
        } else if (bNumber instanceof BDouble) {
            parser = new DoubleParser(hxOp);
        } else {
            throw new IllegalStateException("Should never get here!");
        }
        htmlWriter.w((Object)"<span style='white-space:nowrap;'>");
        htmlWriter.safe(parser.formatPreMeta());
        htmlWriter.w((Object)"<input type='text' size='10'");
        if (!hxOp.canWrite()) {
            htmlWriter.w((Object)" readonly='readonly'");
        }
        htmlWriter.w((Object)" ").attr("name", hxOp.scope("value"));
        htmlWriter.w((Object)" ").attr("id", hxOp.scope("value"));
        htmlWriter.w((Object)" ").attr("value", parser.formatValue((BObject)bNumber));
        htmlWriter.w((Object)"/>");
        htmlWriter.safe(parser.formatPostMeta());
        htmlWriter.w((Object)"</span>");
    }

    public void update(HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        if (!hxOp.canWrite()) {
            Parser parser;
            BNumber bNumber = (BNumber)hxOp.get();
            if (bNumber instanceof BFloat) {
                parser = new FloatParser(hxOp);
            } else if (bNumber instanceof BInteger) {
                parser = new IntegerParser(hxOp);
            } else if (bNumber instanceof BLong) {
                parser = new LongParser(hxOp);
            } else if (bNumber instanceof BDouble) {
                parser = new DoubleParser(hxOp);
            } else {
                throw new IllegalStateException("Should never get here!");
            }
            htmlWriter.w((Object)"var editor_value='").w((Object)parser.formatValue((BObject)bNumber)).w((Object)"';");
            htmlWriter.w((Object)"if(document.getElementById('").w((Object)hxOp.scope("value")).w((Object)"').value!=editor_value) {");
            htmlWriter.w((Object)"document.getElementById('").w((Object)hxOp.scope("value")).w((Object)"').value=editor_value;}");
        }
    }

    public BObject save(HxOp hxOp) throws Exception {
        Parser parser;
        String string = hxOp.getFormValue("value");
        BObject bObject = hxOp.get();
        if (bObject instanceof BFloat) {
            parser = new FloatParser(hxOp);
        } else if (bObject instanceof BInteger) {
            parser = new IntegerParser(hxOp);
        } else if (bObject instanceof BLong) {
            parser = new LongParser(hxOp);
        } else if (bObject instanceof BDouble) {
            parser = new DoubleParser(hxOp);
        } else {
            throw new IllegalStateException("Should never get here!");
        }
        return ((Parser)parser).parse(string);
    }

    DecimalFormat getFormat(int n, boolean bl) {
        String string = "" + n + bl;
        DecimalFormat decimalFormat = (DecimalFormat)this.formatters.get(string);
        if (decimalFormat == null) {
            StringBuffer stringBuffer = new StringBuffer(16);
            if (bl) {
                stringBuffer.append("#,##0");
            } else {
                stringBuffer.append("#0");
            }
            if (n > 0) {
                stringBuffer.append('.');
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append('0');
                    ++n2;
                }
            }
            decimalFormat = new DecimalFormat(stringBuffer.toString());
            this.formatters.put(string, decimalFormat);
        }
        return decimalFormat;
    }

    static /* synthetic */ long access$0() {
        return 0x20000000000000L;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.formatters = new HashMap();
    }

    protected BHxNumericFE() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$hx$fieldeditors$BHxNumericFE;
        if (clazz == null) {
            clazz = class$com$tridium$hx$fieldeditors$BHxNumericFE = BHxNumericFE.class("[Lcom.tridium.hx.fieldeditors.BHxNumericFE;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        fSN = new DecimalFormat("0.###############E0");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FloatParser
    extends RealParser {
        public double getTypeMin() {
            return Double.NEGATIVE_INFINITY;
        }

        public double getTypeMax() {
            return Double.POSITIVE_INFINITY;
        }

        public BValue make(double d) {
            return BFloat.make((float)((float)d));
        }

        public FloatParser(HxOp hxOp) {
            super(hxOp);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class IntegerParser
    extends IntParser {
        public double getTypeMin() {
            return -2.147483648E9;
        }

        public double getTypeMax() {
            return 2.147483647E9;
        }

        public BValue make(long l) {
            return BInteger.make((int)((int)l));
        }

        public String formatValue(long l) {
            if (this.displayUnits != this.realUnits) {
                l = (long)this.realUnits.convertTo(this.displayUnits, (double)l);
            }
            if ((double)l == this.getTypeMin()) {
                return "min";
            }
            if ((double)l == this.getTypeMax()) {
                return "max";
            }
            if (this.radix != 10) {
                return Long.toString(l & 0xFFFFFFFFL, this.radix);
            }
            if (this.showSeparators) {
                return this.format.format(l);
            }
            return Long.toString(l);
        }

        public IntegerParser(HxOp hxOp) {
            super(hxOp);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class LongParser
    extends IntParser {
        public double getTypeMin() {
            return -9.223372036854776E18;
        }

        public double getTypeMax() {
            return 9.223372036854776E18;
        }

        public BValue make(long l) {
            return BLong.make((long)l);
        }

        public String formatValue(long l) {
            if ((double)l == this.getTypeMin()) {
                return "min";
            }
            if ((double)l == this.getTypeMax()) {
                return "max";
            }
            if (this.radix != 10) {
                return Long.toString(l, this.radix);
            }
            if (this.showSeparators) {
                return this.format.format(l);
            }
            return Long.toString(l);
        }

        public LongParser(HxOp hxOp) {
            super(hxOp);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DoubleParser
    extends RealParser {
        public double getTypeMin() {
            return Double.NEGATIVE_INFINITY;
        }

        public double getTypeMax() {
            return Double.POSITIVE_INFINITY;
        }

        public BValue make(double d) {
            return BDouble.make((double)d);
        }

        public DoubleParser(HxOp hxOp) {
            super(hxOp);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class Parser {
        protected BUnit displayUnits;
        protected int prec;
        protected double min;
        protected double max;
        protected DecimalFormat format;
        protected String range;
        protected String premeta;
        protected String postmeta;
        protected boolean showSeparators;
        protected BUnit realUnits;

        public abstract double getTypeMin();

        public abstract double getTypeMax();

        public abstract BValue parse(String var1) throws CannotSaveException;

        protected abstract int getPrecision(HxOp var1);

        public String formatPostMeta() {
            return this.postmeta;
        }

        public String formatPreMeta() {
            return this.premeta;
        }

        public String formatValue(BObject bObject) {
            return this.formatValue(((BNumber)bObject).getDouble());
        }

        public String formatValue(double d) {
            if (this.displayUnits != this.realUnits) {
                d = this.realUnits.convertTo(this.displayUnits, d);
            }
            if (d == this.getTypeMin()) {
                return "-inf";
            }
            if (d == this.getTypeMax()) {
                return "+inf";
            }
            if (Double.isNaN(d)) {
                return "nan";
            }
            if (Math.IEEEremainder(d, 1.0) == 0.0) {
                if ((long)Math.abs(d) >= 0x20000000000000L) {
                    return fSN.format(d);
                }
                return this.format.format(d);
            }
            return this.format.format(d);
        }

        public Parser(HxOp hxOp) {
            this.showSeparators = hxOp.getFacets().getb("showSeparators", false);
            this.format = BHxNumericFE.this.getFormat(this.getPrecision(hxOp), this.showSeparators);
            this.realUnits = (BUnit)hxOp.getFacet("units");
            if (this.realUnits != null && this.realUnits.isNull()) {
                this.realUnits = null;
            }
            BFacets bFacets = hxOp.getFacets();
            BNumber bNumber = (BNumber)hxOp.getFacet("min");
            this.min = bNumber == null ? this.getTypeMin() : (double)bNumber.getFloat();
            bNumber = (BNumber)hxOp.getFacet("max");
            this.max = bNumber == null ? this.getTypeMax() : (double)bNumber.getFloat();
            int n = bFacets.geti("unitConversion", Nre.unitConversion);
            this.prec = bFacets.geti("precision", 2);
            this.displayUnits = this.realUnits;
            if (n != 0 && this.realUnits != null) {
                BUnitConversion bUnitConversion = BUnitConversion.make((int)n);
                this.displayUnits = bUnitConversion.getDesiredUnit(this.realUnits);
            }
            this.premeta = "";
            this.postmeta = "";
            if (this.displayUnits != null) {
                if (this.displayUnits.getIsPrefix()) {
                    this.premeta = " " + this.displayUnits.getSymbol() + ' ';
                } else {
                    this.postmeta = " " + this.displayUnits.getSymbol();
                }
            }
            if (this.min != this.getTypeMin() || this.max != this.getTypeMax()) {
                this.range = "[" + this.formatValue(this.min) + " - " + this.formatValue(this.max) + ']';
                this.postmeta = this.postmeta + ' ' + this.range;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class IntParser
    extends Parser {
        protected int radix;

        public abstract BValue make(long var1);

        public abstract String formatValue(long var1);

        protected int getPrecision(HxOp hxOp) {
            return 0;
        }

        public String formatValue(BObject bObject) {
            return this.formatValue(((BNumber)bObject).getLong());
        }

        public BValue parse(String string) throws CannotSaveException {
            long l;
            try {
                l = string.equals("min") ? (long)this.getTypeMin() : (string.equals("max") ? (long)this.getTypeMax() : (this.radix != 10 ? Long.parseLong(string, this.radix) : (this.showSeparators ? (long)this.format.parse(string).intValue() : Long.parseLong(string))));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CannotSaveException("Invalid format: " + string);
            }
            long l2 = (long)this.min;
            long l3 = (long)this.max;
            if (this.displayUnits != this.realUnits) {
                l2 = Math.round(this.realUnits.convertTo(this.displayUnits, this.min));
                l3 = Math.round(this.realUnits.convertTo(this.displayUnits, this.max));
            }
            if (l < l2) {
                throw new CannotSaveException(l + " < " + l2 + ' ' + this.range);
            }
            if (l > l3) {
                throw new CannotSaveException(l + " > " + l3 + ' ' + this.range);
            }
            if (this.displayUnits != this.realUnits) {
                l = Math.round(this.displayUnits.convertTo(this.realUnits, (double)l));
            }
            return this.make(l);
        }

        public IntParser(HxOp hxOp) {
            super(hxOp);
            BInteger bInteger = (BInteger)hxOp.getFacet("radix");
            this.radix = bInteger == null ? 10 : bInteger.getInt();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class RealParser
    extends Parser {
        public abstract BValue make(double var1);

        protected int getPrecision(HxOp hxOp) {
            return hxOp.getFacets().geti("precision", 2);
        }

        public BValue parse(String string) throws CannotSaveException {
            double d = 0.0;
            string = TextUtil.toLowerCase((String)string);
            try {
                d = string.equals("-inf") ? this.getTypeMin() : (string.equals("+inf") ? this.getTypeMax() : (string.equals("nan") ? Double.NaN : (string.indexOf(101) != -1 ? fSN.parse(TextUtil.toUpperCase((String)string)).doubleValue() : this.format.parse(string).doubleValue())));
            }
            catch (NumberFormatException numberFormatException) {
                throw new CannotSaveException("Invalid format: " + numberFormatException.getMessage());
            }
            catch (ParseException parseException) {
                throw new CannotSaveException("Invalid format: " + parseException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                throw new CannotSaveException("Invalid format: " + string);
            }
            double d2 = this.min;
            double d3 = this.max;
            if (this.displayUnits != this.realUnits) {
                d2 = this.realUnits.convertTo(this.displayUnits, this.min);
                d3 = this.realUnits.convertTo(this.displayUnits, this.max);
            }
            if (d < d2) {
                throw new CannotSaveException(d + " < " + d2 + ' ' + this.range);
            }
            if (d > d3) {
                throw new CannotSaveException(d + " > " + d3 + ' ' + this.range);
            }
            if (this.realUnits != this.displayUnits) {
                d = this.displayUnits.convertTo(this.realUnits, d);
            }
            return this.make(d);
        }

        public RealParser(HxOp hxOp) {
            super(hxOp);
        }
    }
}

