/*
 * Decompiled with CFR 0.152.
 */
package textuality.xh;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import textuality.lark.Attribute;
import textuality.lark.Element;
import textuality.lark.Text;
import textuality.xh.ElementLogic;
import textuality.xh.XmlOutputStream;

public class SpecPrinter {
    static final int bufSize = 8192;
    boolean mSuppressed;
    XmlOutputStream mBodyStream;
    XmlOutputStream mHead;
    XmlOutputStream mMain;
    Hashtable mElementHandlers = new Hashtable();
    ElementLogic mBaseHandler = new ElementLogic();
    static ElementLogic sNothingForThis = new ElementLogic();
    Hashtable mIDs = new Hashtable();

    public ElementLogic findHandler(String string) {
        return (ElementLogic)this.mElementHandlers.get(string);
    }

    public void endOfHeader() {
        this.mBodyStream = this.mMain;
    }

    private void findIDs(Element element) {
        Attribute attribute = element.attribute("id");
        if (attribute != null) {
            this.mIDs.put(attribute.value(), element);
        }
        Vector vector = element.children();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Element) {
                this.findIDs((Element)e);
            }
            ++n;
        }
    }

    public void setSupression(boolean bl) {
        this.mSuppressed = bl;
    }

    public void registerElementLogic(String string, ElementLogic elementLogic) {
        this.mElementHandlers.put(string, elementLogic);
    }

    private void traverseNode(Element element, XmlOutputStream xmlOutputStream, ElementLogic elementLogic) throws InstantiationException, IllegalAccessException, IOException {
        ElementLogic elementLogic2 = null;
        ElementLogic elementLogic3 = this.findMethod(element);
        elementLogic2 = elementLogic3.atStart(element, xmlOutputStream);
        if (elementLogic == null) {
            elementLogic = elementLogic2;
        }
        if (!this.mSuppressed) {
            Vector vector = element.children();
            int n = 0;
            while (n < vector.size()) {
                Object e = vector.elementAt(n);
                if (e instanceof Element) {
                    this.traverseNode((Element)e, xmlOutputStream, elementLogic);
                } else if (elementLogic != null) {
                    elementLogic.doText((Text)e, xmlOutputStream);
                } else {
                    this.mBaseHandler.doText((Text)e, xmlOutputStream);
                }
                ++n;
            }
        }
        elementLogic3.atEnd(element, xmlOutputStream);
    }

    public String getHeadForID(String string) {
        Element element = (Element)this.mIDs.get(string);
        if (element == null) {
            return "";
        }
        Element element2 = this.findDescendant(element, "head");
        if (element2 == null) {
            return "";
        }
        return element2.content();
    }

    private ElementLogic findMethod(Element element) throws InstantiationException, IllegalAccessException {
        String string = "";
        ElementLogic elementLogic = (ElementLogic)this.mElementHandlers.get(element.type());
        if (elementLogic == sNothingForThis) {
            elementLogic = this.mBaseHandler;
        } else if (elementLogic == null) {
            try {
                int n;
                string = element.type();
                while ((n = string.indexOf(45)) != -1) {
                    string = string.substring(0, n) + string.substring(n + 1);
                }
                Class<?> clazz = Class.forName("textuality.xh.Do" + string);
                elementLogic = (ElementLogic)clazz.newInstance();
                elementLogic.registerController(this);
                this.mElementHandlers.put(element.type(), elementLogic);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.mElementHandlers.put(element.type(), sNothingForThis);
                elementLogic = this.mBaseHandler;
            }
        }
        return elementLogic;
    }

    public XmlOutputStream body() {
        return this.mBodyStream;
    }

    public Element findDescendant(Element element, String string) {
        if (element.type().equals(string)) {
            return element;
        }
        Enumeration enumeration = element.children().elements();
        while (enumeration.hasMoreElements()) {
            Element element2;
            Object e = enumeration.nextElement();
            if (!(e instanceof Element) || (element2 = this.findDescendant((Element)e, string)) == null) continue;
            return element2;
        }
        return null;
    }

    public SpecPrinter() {
        this.mBaseHandler.registerController(this);
    }

    public void writeHTML(Element element, OutputStream outputStream, boolean bl) throws IOException, FileNotFoundException, InstantiationException, IllegalAccessException {
        this.mHead = new XmlOutputStream(new BufferedOutputStream(new FileOutputStream("head")), bl);
        XmlOutputStream xmlOutputStream = new XmlOutputStream(new BufferedOutputStream(new FileOutputStream("toc")), bl);
        this.mMain = new XmlOutputStream(new BufferedOutputStream(new FileOutputStream("main")), bl);
        this.mBodyStream = this.mHead;
        this.findIDs(element);
        this.traverseNode(element, xmlOutputStream, null);
        xmlOutputStream.close();
        this.mHead.close();
        this.mMain.close();
        this.fCopy("head", outputStream);
        this.fCopy("toc", outputStream);
        this.fCopy("main", outputStream);
    }

    private void fCopy(String string, OutputStream outputStream) throws IOException, FileNotFoundException {
        int n;
        byte[] byArray = new byte[8192];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        ((FilterInputStream)bufferedInputStream).close();
    }
}

