/*
 * Decompiled with CFR 0.152.
 */
package textuality.xh;

import textuality.lark.Attribute;
import textuality.lark.Element;
import textuality.lark.Text;
import textuality.xh.SpecPrinter;
import textuality.xh.XmlOutputStream;

public class ElementLogic {
    static String sCRLF = new String("\r\n");
    String mPrefix;
    String mSuffix;
    SpecPrinter mController;

    public void registerController(SpecPrinter specPrinter) {
        this.mController = specPrinter;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void atEnd(Element element, XmlOutputStream xmlOutputStream) {
        if (this.mPrefix != null) {
            this.mController.body().print(this.mPrefix);
        }
    }

    boolean isAncestor(Element element, String string) {
        Element element2 = element.parent();
        while (element2 != null) {
            if (element2.type().equals(string)) {
                return true;
            }
            element2 = element2.parent();
        }
        return false;
    }

    public ElementLogic atStart(Element element, XmlOutputStream xmlOutputStream) {
        if (this.mPrefix != null) {
            this.mController.body().print(this.mPrefix);
        }
        return null;
    }

    static boolean isParent(Element element, String string) {
        element.parent().type();
        return element.parent().type().equals(string);
    }

    public void dump(String string, XmlOutputStream xmlOutputStream) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    xmlOutputStream.print("&lt;");
                    break;
                }
                case '&': {
                    xmlOutputStream.print("&amp;");
                    break;
                }
                case '>': {
                    xmlOutputStream.print("&gt;");
                    break;
                }
                case '\u2028': {
                    xmlOutputStream.print("<BR>");
                    break;
                }
                default: {
                    xmlOutputStream.write(c);
                }
            }
            ++n;
        }
    }

    public static String attributeValue(Element element, String string) {
        Attribute attribute = element.attribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.value();
    }

    public void doText(Text text, XmlOutputStream xmlOutputStream) {
        this.dump(text.toString(), this.mController.body());
    }
}

