/*
 * Decompiled with CFR 0.152.
 */
package textuality.validator;

import java.io.PrintStream;
import java.util.Vector;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.validator.Grammar;

public class Choice
extends Grammar {
    int mTimesThrough;
    boolean mBroken;
    Vector mCrumbs = new Vector();
    static final String sContentModelFor = "Content model for '";
    static final String sAmbiguousFor = "' is ambiguous; multiple matches for '";
    static boolean[] sIsSpace = new boolean[128];

    public Choice(String string, char c, Object[] objectArray, Grammar grammar) {
        this.mType = string;
        this.setRepeat(c);
        this.mMembers = objectArray;
        this.mParent = grammar;
    }

    public Grammar tryElement(String string, Entity entity, Element element, Handler handler) {
        this.mCrumbs.removeAllElements();
        int n = this.probe(string, this.mCrumbs, false, false);
        if (n == 0) {
            this.mBroken = true;
            return null;
        }
        if (n > 1) {
            handler.doValidityError(entity, sContentModelFor + this.type() + sAmbiguousFor + string + "'.");
        }
        Object var7_6 = null;
        Choice choice = this;
        Grammar grammar = this;
        int n2 = 0;
        while (n2 < this.mCrumbs.size()) {
            grammar = (Grammar)this.mCrumbs.elementAt(n2);
            var7_6 = this.mCrumbs.elementAt(n2 + 1);
            if (var7_6 == Grammar.sDown) {
                ((Grammar)choice).forceMatch(grammar);
            } else if (var7_6 == Grammar.sUp) {
                ((Grammar)choice).freeUpOne();
            }
            choice = grammar;
            n2 += 2;
        }
        ((Grammar)grammar).forceMatch(string);
        return grammar;
    }

    public void dumpMe(PrintStream printStream) {
        printStream.print("CHOICE[@" + this.mTimesThrough + "]: (");
        int n = 0;
        while (n < this.mMembers.length) {
            if (this.mMembers[n] instanceof String) {
                printStream.print(this.mMembers[n] + " ");
            } else {
                printStream.print("* ");
            }
            ++n;
        }
        printStream.print(")");
        switch (this.mRepeat) {
            case 1: {
                printStream.print("+");
                break;
            }
            case 2: {
                printStream.print("*");
                break;
            }
            case 3: {
                printStream.print("?");
            }
        }
        printStream.println();
    }

    public boolean hasAncestor(String string) {
        if (this.mType != null) {
            return this.mType.equals(string);
        }
        return ((Choice)this.mParent).hasAncestor(string);
    }

    public int probe(String string, Vector vector, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (bl2 && this.mInUse) {
            return 0;
        }
        n = 0;
        while (n < this.mMembers.length) {
            if (bl && (this.mRepeat == 0 || this.mRepeat == 3)) break;
            if (this.mMembers[n] instanceof String) {
                if (this.mMembers[n] == string) {
                    ++n2;
                    bl = true;
                }
            } else {
                int n4;
                Grammar grammar = (Grammar)this.mMembers[n];
                if (!bl) {
                    n3 = vector.size();
                    vector.addElement(grammar);
                    vector.addElement(Grammar.sDown);
                }
                if ((n4 = grammar.probe(string, vector, bl, true)) == 0) {
                    if (!bl) {
                        vector.setSize(n3);
                    }
                } else {
                    n2 += n4;
                    bl = true;
                }
            }
            ++n;
        }
        if (!bl2 && this.mParent != null) {
            if (!bl) {
                vector.addElement(this.mParent);
                vector.addElement(Grammar.sUp);
            }
            n2 += this.mParent.probe(string, vector, bl, false);
        }
        return n2;
    }

    public boolean checkText(char[] cArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c > '\u007f' || !sIsSpace[c]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean canEnd() {
        return this.mBroken || this.mTimesThrough > 0 || this.canBypass();
    }

    public void freeUp() {
        this.freeUpOne();
        if (this.mParent != null) {
            this.mParent.freeUp();
        }
    }

    static {
        int n = 0;
        do {
            Choice.sIsSpace[n] = false;
        } while (++n < 128);
        Choice.sIsSpace[10] = true;
        Choice.sIsSpace[13] = true;
        Choice.sIsSpace[9] = true;
        Choice.sIsSpace[32] = true;
    }

    public void showInUse() {
        this.mTimesThrough = 0;
        this.mBroken = false;
        this.mInUse = true;
    }

    public void forceMatch(Object object) {
        if (!this.mInUse) {
            this.showInUse();
        }
        ++this.mTimesThrough;
    }

    public void freeUpOne() {
        this.mInUse = false;
    }
}

