/*
 * Decompiled with CFR 0.152.
 */
package textuality.validator;

import java.util.Hashtable;
import java.util.Vector;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.validator.Attlist;
import textuality.validator.DTD;

class CheckENTITIES
extends Attlist {
    Hashtable mUnparsedEntities;

    public CheckENTITIES(DTD dTD) {
        this.mUnparsedEntities = dTD.entityTable();
    }

    public boolean check(Entity entity, Element element, String string, Handler handler) {
        Vector vector = Attlist.tokenize(element.attribute(string).value());
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (!Attlist.isName(string2)) {
                return handler.doValidityError(entity, "'" + string + "' attribute of '" + element.type() + "' should have a Name value, not '" + string2 + "'.");
            }
            if (this.mUnparsedEntities.get(string2) == null) {
                return handler.doValidityError(entity, "'" + string + "' attribute of '" + element.type() + "' refers to nonexistent Entity'" + string2 + "'.");
            }
            ++n;
        }
        return false;
    }
}

