/*
 * Decompiled with CFR 0.152.
 */
package textuality.lark;

import textuality.lark.Entity;

public class Segment {
    Entity mSourceEntity;
    int mSourceOffset = -1;
    int mSourceLength;
    char[] mCharBase;
    byte[] mByteBase;
    int mDataOffset = -1;
    int mDataLength = -1;
    boolean mDataAreChars;
    static final int sBufSize = 8192;
    static char[] sCharBuf = new char[8193];
    static int sCurrentIndex;
    static String sNotSaved;
    static Object sHeapLock;
    static boolean[] sIsSpace;

    public byte[] byteBase() {
        return this.mByteBase;
    }

    public Segment(Entity entity, int n, int n2) {
        this.commonInit(entity, n, n2);
    }

    public Segment(Entity entity, int n, int n2, int n3, byte[] byArray, int n4) {
        this.commonInit(entity, n, n2);
        this.mByteBase = byArray;
        this.mDataLength = n3;
        this.mDataOffset = n4;
        this.mDataAreChars = false;
    }

    public Segment(Entity entity, int n, int n2, int n3, char[] cArray, int n4) {
        this.commonInit(entity, n, n2);
        this.mCharBase = cArray;
        this.mDataLength = n3;
        this.mDataOffset = n4;
        this.mDataAreChars = true;
    }

    public Segment(Entity entity, int n, int n2, int n3, char[] cArray) {
        this.commonInit(entity, n, n2);
        if (n3 > 8192) {
            this.mCharBase = new char[n3];
            int n4 = 0;
            while (n4 < n2) {
                this.mCharBase[n4] = cArray[n4];
                ++n4;
            }
            this.mDataOffset = 0;
            this.mDataLength = n3;
            return;
        }
        Object object = sHeapLock;
        synchronized (object) {
            if (n3 > 8192 - sCurrentIndex) {
                sCharBuf = new char[8192];
                sCurrentIndex = 0;
            }
            this.mDataAreChars = true;
            this.mCharBase = sCharBuf;
            this.mDataOffset = sCurrentIndex;
            this.mDataLength = n3;
            int n5 = 0;
            while (n5 < n3) {
                Segment.sCharBuf[Segment.sCurrentIndex++] = cArray[n5];
                ++n5;
            }
            Object var7_9 = null;
            return;
        }
    }

    public String toString() {
        if (this.mDataAreChars) {
            if (this.mCharBase == null) {
                return sNotSaved;
            }
            return new String(this.mCharBase, this.mDataOffset, this.mDataLength);
        }
        if (this.mByteBase == null) {
            return sNotSaved;
        }
        return new String(this.mByteBase, 0, this.mDataOffset, this.mDataLength);
    }

    private void commonInit(Entity entity, int n, int n2) {
        this.mSourceEntity = entity;
        this.mSourceOffset = n;
        this.mSourceLength = n2;
    }

    public char[] charBase() {
        return this.mCharBase;
    }

    static {
        sNotSaved = "[Lark: not saved]";
        sHeapLock = new Object();
        sIsSpace = new boolean[128];
        int n = 0;
        do {
            Segment.sIsSpace[n] = false;
        } while (++n < 128);
        Segment.sIsSpace[10] = true;
        Segment.sIsSpace[13] = true;
        Segment.sIsSpace[9] = true;
        Segment.sIsSpace[32] = true;
    }

    public static boolean isSpaceChar(char c) {
        return c < '\u0080' && sIsSpace[c];
    }

    public Entity entity() {
        return this.mSourceEntity;
    }

    public int sourceOffset() {
        return this.mSourceOffset;
    }

    public int dataOffset() {
        return this.mDataOffset;
    }

    public int sourceLength() {
        return this.mSourceLength;
    }

    public int dataLength() {
        return this.mDataLength;
    }

    public boolean isSpace() {
        if (this.mDataAreChars) {
            int n = 0;
            while (n < this.mDataLength) {
                char c = this.mCharBase[this.mDataOffset + n];
                if (c > '\u007f' || !sIsSpace[c]) {
                    return false;
                }
                ++n;
            }
        } else {
            if (this.mByteBase == null) {
                return false;
            }
            int n = 0;
            while (n < this.mDataLength) {
                char c = (char)this.mByteBase[this.mDataOffset + n];
                if (c > '\u007f' || !sIsSpace[c]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }
}

