/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo.xml;

import java.util.StringTokenizer;
import java.util.Vector;

public class TextUtil {
    private static final char[] HEX_CHARS;
    private static final int CM_LENGTH = 128;
    private static final int CM_START = 1;
    private static final int CM_PART = 2;
    private static final int CM_HEX = 4;
    private static byte[] charMap;
    public static int MILLIS_IN_HOUR;
    public static int MILLIS_IN_MIN;

    public static String formatBoolean(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public static boolean parseBoolean(String string) {
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new RuntimeException("Invalid boolean text: " + string);
    }

    public static boolean parseBoolean(char[] cArray, int n, int n2) {
        return TextUtil.parseBoolean(new String(cArray, n, n2));
    }

    public static String formatChar(char c) {
        return String.valueOf(c);
    }

    public static char parseChar(String string) {
        if (string.length() != 1) {
            throw new RuntimeException("Invalid char text: " + string);
        }
        return string.charAt(0);
    }

    public static char parseChar(char[] cArray, int n, int n2) {
        if (n2 != 1) {
            throw new RuntimeException("Invalid char text");
        }
        return cArray[n];
    }

    public static String formatByte(byte by, int n) {
        return Integer.toString(by & 0xFF, n);
    }

    public static byte parseByte(String string, int n) {
        try {
            return (byte)TextUtil.parseInt(string, n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid byte text: " + string);
        }
    }

    public static byte parseByte(char[] cArray, int n, int n2, int n3) {
        return TextUtil.parseByte(new String(cArray, n, n2), n3);
    }

    public static String formatShort(short s, int n) {
        return Integer.toString(s & 0xFFFF, n);
    }

    public static short parseShort(String string, int n) {
        try {
            return (short)TextUtil.parseInt(string, n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid short text: " + string);
        }
    }

    public static short parseShort(char[] cArray, int n, int n2, int n3) {
        return TextUtil.parseShort(new String(cArray, n, n2), n3);
    }

    public static String formatInt(int n) {
        return Integer.toString(n, 10);
    }

    public static String formatInt(int n, int n2) {
        return Integer.toString(n, n2);
    }

    public static int parseInt(String string) {
        try {
            return Integer.parseInt(string, 10);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid integer text: " + string);
        }
    }

    public static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string, n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid integer text: " + string);
        }
    }

    public static int parseInt(char[] cArray, int n, int n2, int n3) {
        return TextUtil.parseInt(new String(cArray, n, n2), n3);
    }

    public static String formatLong(long l, int n) {
        return Long.toString(l, n);
    }

    public static long parseLong(String string, int n) {
        try {
            return Long.parseLong(string, n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid long text: " + string);
        }
    }

    public static long parseLong(char[] cArray, int n, int n2, int n3) {
        return TextUtil.parseLong(new String(cArray, n, n2), n3);
    }

    public static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "+Inf";
        }
        return Float.toString(f);
    }

    public static float parseFloat(String string) {
        try {
            if (string.equals("NaN")) {
                return Float.NaN;
            }
            if (string.equals("+Inf")) {
                return Float.POSITIVE_INFINITY;
            }
            if (string.equals("-Inf")) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid float text: " + string);
        }
    }

    public static float parseFloat(char[] cArray, int n, int n2) {
        return TextUtil.parseFloat(new String(cArray, n, n2));
    }

    public static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        return Double.toString(d);
    }

    public static double parseDouble(String string) {
        try {
            if (string.equals("NaN")) {
                return Double.NaN;
            }
            if (string.equals("+Inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (string.equals("-Inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid double text: " + string);
        }
    }

    public static double parseDouble(char[] cArray, int n, int n2) {
        return TextUtil.parseDouble(new String(cArray, n, n2));
    }

    public static String formatStringForXml(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = cArray[i];
            if (n != 60 && n != 62 && n != 38 && n != 13 && TextUtil.isAscii((char)n)) continue;
            ++n3;
        }
        if (n3 == 0) {
            return string;
        }
        char[] cArray2 = new char[n2 + n3 * 8];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (!TextUtil.isAscii(c)) {
                boolean bl;
                char c2 = c;
                boolean bl2 = bl = c >= ' ';
                if (bl) {
                    cArray2[n++] = 38;
                    cArray2[n++] = 35;
                    cArray2[n++] = 120;
                } else {
                    cArray2[n++] = 92;
                    cArray2[n++] = 117;
                }
                cArray2[n++] = HEX_CHARS[c2 >> 12 & 0xF];
                cArray2[n++] = HEX_CHARS[c2 >> 8 & 0xF];
                cArray2[n++] = HEX_CHARS[c2 >> 4 & 0xF];
                cArray2[n++] = HEX_CHARS[c2 >> 0 & 0xF];
                if (!bl) continue;
                cArray2[n++] = 59;
                continue;
            }
            if (c == '<') {
                cArray2[n++] = 38;
                cArray2[n++] = 108;
                cArray2[n++] = 116;
                cArray2[n++] = 59;
                continue;
            }
            if (c == '>') {
                cArray2[n++] = 38;
                cArray2[n++] = 103;
                cArray2[n++] = 116;
                cArray2[n++] = 59;
                continue;
            }
            if (c == '&') {
                cArray2[n++] = 38;
                cArray2[n++] = 97;
                cArray2[n++] = 109;
                cArray2[n++] = 112;
                cArray2[n++] = 59;
                continue;
            }
            if (c == '\r') {
                try {
                    if (cArray[i - 1] == '\n' || cArray[i + 1] == '\n') continue;
                    cArray2[n++] = 10;
                }
                catch (Exception exception) {}
                continue;
            }
            cArray2[n++] = c;
        }
        return new String(cArray2, 0, n);
    }

    public static boolean isAscii(char c) {
        if (c > '\u007f') {
            return false;
        }
        if (c >= ' ') {
            return true;
        }
        if (c == '\n') {
            return true;
        }
        if (c == '\r') {
            return true;
        }
        return c == '\t';
    }

    public static String parseStringFromXml(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        char c = '\u0000';
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == 'u' && c == '\\') {
                stringBuffer.setLength(stringBuffer.length() - 1);
                c2 = (char)(TextUtil.hexDigit(string.charAt(++i)) << 12 | TextUtil.hexDigit(string.charAt(++i)) << 8 | TextUtil.hexDigit(string.charAt(++i)) << 4 | TextUtil.hexDigit(string.charAt(++i)) << 0);
                bl = false;
            }
            c = c2;
            stringBuffer.append(c2);
        }
        if (bl) {
            return string;
        }
        return stringBuffer.toString();
    }

    public static String formatByteArray(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = (by & 0xF0) >> 4;
            int n2 = by & 0xF;
            cArray[i * 2 + 0] = (char)(n < 10 ? 48 + n : 65 + n - 10);
            cArray[i * 2 + 1] = (char)(n2 < 10 ? 48 + n2 : 65 + n2 - 10);
        }
        return new String(cArray);
    }

    public static byte[] parseByteArray(String string) {
        char[] cArray = string.toCharArray();
        return TextUtil.parseByteArray(cArray, 0, cArray.length);
    }

    public static byte[] parseByteArray(char[] cArray, int n, int n2) {
        if (n2 % 2 != 0) {
            throw new RuntimeException("Invalid byte array");
        }
        try {
            byte[] byArray = new byte[n2 / 2];
            for (int i = 0; i < byArray.length; ++i) {
                char c = cArray[(i << 1) + n + 0];
                char c2 = cArray[(i << 1) + n + 1];
                byArray[i] = (byte)(TextUtil.hexDigit(c) << 4 | TextUtil.hexDigit(c2));
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Invalid byte array");
        }
    }

    public static int hexDigit(char c) {
        int n = c - 48;
        if (n >= 0 && n <= 9) {
            return n;
        }
        n = c - 65 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        n = c - 97 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        throw new IllegalArgumentException("'" + c + "'");
    }

    public static String formatIntArray(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 10);
        if (nArray.length > 0) {
            stringBuffer.append(nArray[0]);
        }
        for (int i = 1; i < nArray.length; ++i) {
            stringBuffer.append(',').append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public static int[] parseIntArray(String string) {
        char[] cArray = string.toCharArray();
        return TextUtil.parseIntArray(cArray, 0, cArray.length);
    }

    public static int[] parseIntArray(char[] cArray, int n, int n2) {
        try {
            int[] nArray = new int[n2 / 2 + 1];
            int n3 = 0;
            int n4 = n;
            for (int i = n; i < n + n2; ++i) {
                if (cArray[i] != ',') continue;
                nArray[n3++] = TextUtil.parseInt(cArray, n4, i - n4, 10);
                n4 = i + 1;
            }
            if (n4 < n2) {
                nArray[n3++] = TextUtil.parseInt(cArray, n4, n + n2 - n4, 10);
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid int array");
        }
    }

    public static String formatFloatArray(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer(fArray.length * 10);
        if (fArray.length > 0) {
            stringBuffer.append(fArray[0]);
        }
        for (int i = 1; i < fArray.length; ++i) {
            stringBuffer.append(',').append(TextUtil.formatFloat(fArray[i]));
        }
        return stringBuffer.toString();
    }

    public static float[] parseFloatArray(String string) {
        char[] cArray = string.toCharArray();
        return TextUtil.parseFloatArray(cArray, 0, cArray.length);
    }

    public static float[] parseFloatArray(char[] cArray, int n, int n2) {
        try {
            float[] fArray = new float[n2 / 2 + 1];
            int n3 = 0;
            int n4 = n;
            for (int i = n; i < n + n2; ++i) {
                if (cArray[i] != ',') continue;
                fArray[n3++] = TextUtil.parseFloat(cArray, n4, i - n4);
                n4 = i + 1;
            }
            if (n4 < n2) {
                fArray[n3++] = TextUtil.parseFloat(cArray, n4, n + n2 - n4);
            }
            float[] fArray2 = new float[n3];
            System.arraycopy(fArray, 0, fArray2, 0, n3);
            return fArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid int array");
        }
    }

    public static String formatStringArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 50);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.indexOf(44) >= 0) {
                string = string.replace(',', '.');
            }
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String formatStringArrayForXml(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = TextUtil.formatStringForXml(stringArray[i]);
        }
        return TextUtil.formatStringArray(stringArray2);
    }

    public static String[] parseStringArray(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken().trim());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String escapeXml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<' || c == '>' || c == '&' || c > '\u007f') {
                stringBuffer.append("&#x").append(Integer.toHexString(c)).append(';');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char[] cArray = null;
        int n2 = 0;
        int n3 = n * 6;
        char c = string.charAt(0);
        if (c >= '\u0080' || (charMap[c] & 1) == 0) {
            cArray = new char[n3];
            n2 = TextUtil.escape(c, cArray, n2);
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c < '\u0080' && (charMap[c] & 2) != 0) {
                if (cArray == null) continue;
                cArray[n2++] = c;
                continue;
            }
            if (cArray == null) {
                cArray = new char[n * 6];
                string.getChars(0, i, cArray, 0);
                n2 = i;
            }
            n2 = TextUtil.escape(c, cArray, n2);
        }
        if (cArray == null) {
            return string;
        }
        return new String(cArray, 0, n2);
    }

    public static String unescape(String string) {
        char[] cArray = null;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 != '$') {
                if (cArray == null) continue;
                cArray[n++] = c2;
                continue;
            }
            if (cArray == null) {
                cArray = new char[n2];
                string.getChars(0, i, cArray, 0);
                n = i;
            }
            if ((c = string.charAt(++i)) != 'u') {
                cArray[n++] = (char)(TextUtil.hexCharToInt(c) << 4 | TextUtil.hexCharToInt(string.charAt(++i)));
                continue;
            }
            cArray[n++] = (char)(TextUtil.hexCharToInt(string.charAt(++i)) << 12 | TextUtil.hexCharToInt(string.charAt(++i)) << 8 | TextUtil.hexCharToInt(string.charAt(++i)) << 4 | TextUtil.hexCharToInt(string.charAt(++i)));
        }
        if (cArray == null) {
            return string;
        }
        return new String(cArray, 0, n);
    }

    private static int escape(char c, char[] cArray, int n) {
        String string = Integer.toHexString(c);
        cArray[n++] = 36;
        if (c < '\u0010') {
            cArray[n++] = 48;
            cArray[n++] = string.charAt(0);
        } else if (c < '\u0100') {
            cArray[n++] = string.charAt(0);
            cArray[n++] = string.charAt(1);
        } else if (c < '\u1000') {
            cArray[n++] = 117;
            cArray[n++] = 48;
            cArray[n++] = string.charAt(0);
            cArray[n++] = string.charAt(1);
            cArray[n++] = string.charAt(2);
        } else {
            cArray[n++] = 117;
            cArray[n++] = string.charAt(0);
            cArray[n++] = string.charAt(1);
            cArray[n++] = string.charAt(2);
            cArray[n++] = string.charAt(3);
        }
        return n;
    }

    public static int hexCharToInt(char c) {
        int n = c - 48;
        if (n >= 0 && n <= 9) {
            return n;
        }
        n = c - 65 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        n = c - 97 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        throw new IllegalArgumentException("'" + c + "'");
    }

    static boolean isStart(int n) {
        return n < 128 && (charMap[n] & 1) != 0;
    }

    static boolean isPart(int n) {
        return n < 128 && (charMap[n] & 2) != 0;
    }

    public static void main(String[] stringArray) {
        String string = "abc\u0001\uabcd\u1234";
        String string2 = TextUtil.formatStringForXml(string);
        String string3 = TextUtil.parseStringFromXml(string2);
        System.out.println("s2: \"" + string2 + "\"");
        System.out.println("s1.length: " + string.length());
        System.out.println("s3.length: " + string3.length());
        for (int i = 0; i < string.length(); ++i) {
            System.out.println(Integer.toHexString(string.charAt(i)) + " " + Integer.toHexString(string3.charAt(i)));
        }
    }

    static {
        int n;
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        charMap = new byte[128];
        for (n = 97; n <= 122; ++n) {
            TextUtil.charMap[n] = 3;
        }
        for (n = 65; n <= 90; ++n) {
            TextUtil.charMap[n] = 3;
        }
        for (n = 48; n <= 57; ++n) {
            TextUtil.charMap[n] = 6;
        }
        n = 97;
        while (n <= 102) {
            int n2 = n++;
            charMap[n2] = (byte)(charMap[n2] | 4);
        }
        n = 65;
        while (n <= 70) {
            int n3 = n++;
            charMap[n3] = (byte)(charMap[n3] | 4);
        }
        TextUtil.charMap[95] = 2;
        MILLIS_IN_HOUR = 3600000;
        MILLIS_IN_MIN = 60000;
    }
}

