/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo.xml;

import com.tridium.easdemo.xml.ErrorRecord;
import com.tridium.easdemo.xml.TAttributeList;
import com.tridium.easdemo.xml.TDocumentHandler;
import com.tridium.easdemo.xml.TEntityHandler;
import com.tridium.easdemo.xml.TErrorHandler;
import com.tridium.easdemo.xml.THandlerBase;
import com.tridium.easdemo.xml.TLocation;
import com.tridium.easdemo.xml.TXmlException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import textuality.lark.Attribute;
import textuality.lark.Element;
import textuality.lark.Entity;
import textuality.lark.Handler;
import textuality.lark.Lark;
import textuality.lark.XmlInputStream;

public class TParser
extends Handler
implements TDocumentHandler {
    private THandlerBase base = new THandlerBase();
    private TEntityHandler entityHandler = this.base;
    private TDocumentHandler docHandler = this.base;
    private TErrorHandler errHandler = this.base;
    private TAttributeList attrList = new TAttributeList();
    private TLocation loc = new TLocation();
    private char[] buf = new char[1024];
    private int len = 0;
    private Vector errors = new Vector();
    public PrintWriter trace;

    public TParser() {
        this.setDocumentHandler(this);
    }

    public void setEntityHandler(TEntityHandler tEntityHandler) {
        this.entityHandler = tEntityHandler;
    }

    public void setDocumentHandler(TDocumentHandler tDocumentHandler) {
        this.docHandler = tDocumentHandler;
    }

    public void setErrorHandler(TErrorHandler tErrorHandler) {
        this.errHandler = tErrorHandler;
    }

    public void parse(String string, String string2) throws Exception {
        URL uRL = new URL(string2);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        this.parse(string, string2, uRLConnection.getInputStream());
    }

    public void parse(String string, String string2, InputStream inputStream) throws Exception {
        string2 = this.entityHandler.resolveEntity("[document]", string, string2, this.loc);
        Lark lark = new Lark();
        lark.buildTree(false);
        lark.saveText(false);
        lark.processExternalEntities(true);
        try {
            this.loc.set(string, string2, -1, -1);
            this.docHandler.startDocument(this.loc);
            lark.readXML((Handler)this, new XmlInputStream(inputStream));
            this.loc.set(-1, -1);
            this.docHandler.endDocument(this.loc);
        }
        catch (TunnelException tunnelException) {
            if (tunnelException.ex instanceof TXmlException) {
                TXmlException tXmlException = (TXmlException)tunnelException.ex;
                this.addError(new ErrorRecord(2, tXmlException));
            }
            throw tunnelException.ex;
        }
    }

    public boolean doDoctype(Entity entity, String string, String string2, String string3) {
        return false;
    }

    public boolean doEntityReference(Entity entity, String string) {
        String string2 = entity.baseURL().toString();
        if (!string2.equals(this.loc.getSystemId())) {
            this.loc.setSystemId(string2);
        }
        return false;
    }

    public boolean doETag(Entity entity, Element element) {
        this.processEndTag(element.type(), entity);
        return false;
    }

    public boolean doInternalEntity(Entity entity, String string, char[] cArray) {
        return false;
    }

    public boolean doPI(Entity entity, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        try {
            this.resetLocation(entity);
            this.docHandler.processingInstruction(string, string2, this.loc);
        }
        catch (Exception exception) {
            throw new TunnelException(exception);
        }
        return false;
    }

    public boolean doSTag(Entity entity, Element element) {
        this.attrList.reset();
        Attribute[] attributeArray = element.allAttributes();
        if (attributeArray != null) {
            for (int i = 0; i < attributeArray.length; ++i) {
                this.attrList.add(attributeArray[i].name(), attributeArray[i].value());
            }
        }
        try {
            this.resetLocation(entity);
            if (this.len > 0) {
                this.docHandler.characters(this.buf, 0, this.len, this.loc);
            }
            this.clearBuffer();
            this.docHandler.startElement(element.type(), this.attrList, this.loc);
        }
        catch (Exception exception) {
            throw new TunnelException(exception);
        }
        if (element.empty()) {
            this.processEndTag(element.type(), entity);
        }
        return false;
    }

    private void processEndTag(String string, Entity entity) {
        try {
            this.resetLocation(entity);
            if (this.len > 0) {
                this.docHandler.characters(this.buf, 0, this.len, this.loc);
            }
            this.docHandler.endElement(string, this.loc);
            this.clearBuffer();
        }
        catch (Exception exception) {
            throw new TunnelException(exception);
        }
    }

    public boolean doSyntaxError(Entity entity, String string, int n) {
        try {
            this.resetLocation(entity);
            this.errHandler.fatalError(string, this.loc);
            return false;
        }
        catch (Exception exception) {
            throw new TunnelException(exception);
        }
    }

    public boolean doSystemBinaryEntity(Entity entity, String string, String string2, String string3) {
        return false;
    }

    public boolean doSystemTextEntity(Entity entity, String string, String string2) {
        return false;
    }

    public boolean doText(Entity entity, Element element, char[] cArray, int n) {
        try {
            this.resetLocation(entity);
            this.appendToBuffer(cArray, n);
        }
        catch (Exception exception) {
            throw new TunnelException(exception);
        }
        return false;
    }

    public boolean doValidityError(Entity entity, String string) {
        this.doSyntaxError(entity, string, 0);
        return false;
    }

    public boolean doWarning(Entity entity, String string) {
        try {
            this.resetLocation(entity);
            this.errHandler.warning(string, this.loc);
            return false;
        }
        catch (Exception exception) {
            throw new TunnelException(exception);
        }
    }

    public Element element() {
        return new Element();
    }

    private void resetLocation(Entity entity) {
        this.loc.set(entity.lineCount(), entity.lineOffset());
    }

    private void appendToBuffer(char[] cArray, int n) {
        if (this.buf.length <= this.len + n) {
            char[] cArray2 = this.buf;
            this.buf = new char[Math.max(this.buf.length * 2, this.len + n)];
            System.arraycopy(cArray2, 0, this.buf, 0, this.len);
        }
        System.arraycopy(cArray, 0, this.buf, this.len, n);
        this.len += n;
    }

    private void clearBuffer() {
        this.len = 0;
    }

    public boolean isErrorRecords() {
        return this.errors.size() > 0;
    }

    public boolean isSuccess() {
        return !this.isErrors() && !this.isFatals();
    }

    public boolean isWarnings() {
        return this.isErrors(0);
    }

    public boolean isErrors() {
        return this.isErrors(1);
    }

    public boolean isFatals() {
        return this.isErrors(2);
    }

    public boolean isErrors(int n) {
        for (int i = 0; i < this.errors.size(); ++i) {
            ErrorRecord errorRecord = (ErrorRecord)this.errors.elementAt(i);
            if (errorRecord.getSeverity() != n) continue;
            return true;
        }
        return false;
    }

    public void fatal(String string, TLocation tLocation) throws Exception {
        throw new TXmlException(string, tLocation);
    }

    public void error(String string, TLocation tLocation) {
        this.error(string, tLocation, null);
    }

    public void error(String string, TLocation tLocation, Exception exception) {
        this.addError(new ErrorRecord(1, string, tLocation, exception));
    }

    public void warning(String string, TLocation tLocation) {
        this.warning(string, tLocation, null);
    }

    public void warning(String string, TLocation tLocation, Exception exception) {
        this.addError(new ErrorRecord(0, string, tLocation, exception));
    }

    public ErrorRecord[] getErrors() {
        Object[] objectArray = new ErrorRecord[this.errors.size()];
        this.errors.copyInto(objectArray);
        return objectArray;
    }

    public void addError(ErrorRecord errorRecord) {
        this.errors.addElement(errorRecord);
    }

    public void dumpErrors(PrintWriter printWriter) {
        ErrorRecord errorRecord;
        int n;
        int n2 = Math.min(this.errors.size(), 25);
        int n3 = 0;
        for (n = 0; n3 < n2 && n < this.errors.size(); ++n) {
            errorRecord = (ErrorRecord)this.errors.elementAt(n);
            if (errorRecord.getSeverity() != 2 && errorRecord.getSeverity() != 1) continue;
            errorRecord.dump(printWriter);
            ++n3;
        }
        for (n = 0; n3 < n2 && n < this.errors.size(); ++n) {
            errorRecord = (ErrorRecord)this.errors.elementAt(n);
            if (errorRecord.getSeverity() != 0) continue;
            errorRecord.dump(printWriter);
            ++n3;
        }
        if (n2 != this.errors.size()) {
            printWriter.println("*** There are " + (this.errors.size() - n2) + " more errors!");
        }
        printWriter.flush();
    }

    public void startDocument(TLocation tLocation) throws Exception {
    }

    public void endDocument(TLocation tLocation) throws Exception {
    }

    public void startElement(String string, TAttributeList tAttributeList, TLocation tLocation) throws Exception {
    }

    public void endElement(String string, TLocation tLocation) throws Exception {
    }

    public void characters(char[] cArray, int n, int n2, TLocation tLocation) throws Exception {
    }

    public void processingInstruction(String string, String string2, TLocation tLocation) throws Exception {
    }

    static class TunnelException
    extends RuntimeException {
        Exception ex;

        TunnelException(Exception exception) {
            this.ex = exception;
        }
    }
}

