/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo.xml;

import com.tridium.easdemo.xml.TLocation;
import com.tridium.easdemo.xml.TXmlException;
import java.io.PrintWriter;

public class ErrorRecord {
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    public static final int FATAL = 2;
    private int severity;
    private String msg;
    private TLocation loc;
    private Exception ex;

    public ErrorRecord(int n, TXmlException tXmlException) {
        this(n, tXmlException.getParseMessage(), tXmlException.getLocation(), tXmlException);
    }

    public ErrorRecord(int n, String string, TLocation tLocation) {
        this(n, string, tLocation, null);
    }

    public ErrorRecord(int n, String string, TLocation tLocation, Exception exception) {
        this.severity = n;
        this.msg = string;
        this.loc = tLocation.cloneLocation();
        this.ex = exception;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.msg;
    }

    public TLocation getLocation() {
        return this.loc;
    }

    public Exception getException() {
        return this.ex;
    }

    public String getSeverityString() {
        switch (this.severity) {
            case 0: {
                return "WARNING";
            }
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "FATAL";
            }
        }
        return "REALLY BAD";
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println(this.getSeverityString() + ": " + this.loc + ":");
        printWriter.println("   " + this.msg);
        String string = this.getExceptionString();
        if (string != null) {
            printWriter.println("   " + string);
        }
    }

    public String toString() {
        return this.getSeverityString() + ": " + this.loc + ": " + this.msg;
    }

    public String getExceptionString() {
        if (this.ex == null) {
            return null;
        }
        return this.ex.toString();
    }
}

