/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.easdemo.EasDPNode;
import com.tridium.easdemo.EasMeterNode;
import com.tridium.easdemo.EasNode;
import com.tridium.easdemo.EasNodeProperty;
import com.tridium.easdemo.MasterDemoGen;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Hashtable;
import java.util.Vector;

public class EasSiteNode
extends EasNode {
    private int handle;
    private int id;
    private int[] children;
    private EasNodeProperty[] properties;
    private int childCt;
    private int parent;
    private int propCt;
    private int type;
    private String name;
    private static int siteId = 0;
    private static Hashtable NODES = new Hashtable();

    public EasSiteNode() {
        this.handle = EasNode.getNextHandle();
        this.id = siteId++;
        this.type = 1;
        this.name = "";
        this.childCt = 0;
        this.propCt = 0;
        this.parent = -1;
        EasNode.addNode(this);
        NODES.put(new Integer(this.id), this);
    }

    public EasSiteNode(int n) {
        this.handle = n;
        this.id = -1;
        this.type = 1;
        this.name = "";
        this.childCt = 0;
        this.propCt = 0;
        this.parent = -1;
        EasNode.addNode(this);
    }

    public void addChild(EasNode easNode) {
        if (this.childCt > 0) {
            int[] nArray = new int[this.childCt + 1];
            System.arraycopy(this.children, 0, nArray, 0, this.childCt);
            nArray[this.childCt] = easNode.getHandle();
            this.children = nArray;
        } else {
            this.children = new int[1];
            this.children[0] = easNode.getHandle();
        }
        ++this.childCt;
    }

    public void addProperty(EasNodeProperty easNodeProperty) {
        easNodeProperty.setParent(this.id);
        if (this.propCt > 0) {
            EasNodeProperty[] easNodePropertyArray = new EasNodeProperty[this.propCt + 1];
            System.arraycopy(this.properties, 0, easNodePropertyArray, 0, this.propCt);
            easNodePropertyArray[this.propCt] = easNodeProperty;
            this.properties = easNodePropertyArray;
        } else {
            this.properties = new EasNodeProperty[1];
            this.properties[0] = easNodeProperty;
        }
        ++this.propCt;
    }

    public String getAsXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + NODE_TYPES[this.type] + " handle=\"" + this.handle + "\">\n");
        stringBuffer.append("<id>" + this.id + "</id>\n");
        stringBuffer.append("<name>" + this.name + "</name>\n");
        for (int i = 0; i < this.propCt; ++i) {
            stringBuffer.append(this.properties[i].getAsXML());
        }
        EasNode[] easNodeArray = this.getChildrenByType(3);
        for (int i = 0; i < easNodeArray.length; ++i) {
            stringBuffer.append(((EasMeterNode)easNodeArray[i]).getAsXML());
        }
        EasNode[] easNodeArray2 = this.getChildrenByType(4);
        for (int i = 0; i < easNodeArray2.length; ++i) {
            stringBuffer.append(((EasDPNode)easNodeArray2[i]).getAsXML());
        }
        stringBuffer.append("</" + NODE_TYPES[this.type] + ">\n");
        return stringBuffer.toString();
    }

    public EasNode[] getChildren() {
        if (this.childCt == 0) {
            return null;
        }
        EasNode[] easNodeArray = new EasNode[this.childCt];
        for (int i = 0; i < this.childCt; ++i) {
            easNodeArray[i] = EasSiteNode.getEasNode(this.children[i]);
        }
        return easNodeArray;
    }

    public EasNode[] getChildrenByType(int n) {
        if (this.childCt == 0) {
            return null;
        }
        Vector<EasNode> vector = new Vector<EasNode>();
        for (int i = 0; i < this.childCt; ++i) {
            EasNode easNode = EasSiteNode.getEasNode(this.children[i]);
            if (easNode.getType() != n) continue;
            vector.addElement(easNode);
        }
        EasNode[] easNodeArray = new EasNode[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            easNodeArray[i] = (EasNode)vector.elementAt(i);
        }
        return easNodeArray;
    }

    public int getChildCount() {
        return this.childCt;
    }

    public EasNode getChildById(int n) {
        if (this.childCt == 0) {
            return null;
        }
        for (int i = 0; i < this.childCt; ++i) {
            EasNode easNode = EasSiteNode.getEasNode(this.children[i]);
            if (easNode.getId() != n) continue;
            return easNode;
        }
        return null;
    }

    public EasNode getChildByName(String string) {
        if (this.childCt == 0) {
            return null;
        }
        for (int i = 0; i < this.childCt; ++i) {
            EasNode easNode = EasSiteNode.getEasNode(this.children[i]);
            if (!easNode.getName().equals(string)) continue;
            return easNode;
        }
        return null;
    }

    public int getHandle() {
        return this.handle;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public EasNode getParent() {
        return EasNode.getEasNode(this.parent);
    }

    public EasNodeProperty[] getProperties() {
        if (this.propCt > 0) {
            return this.properties;
        }
        return null;
    }

    public EasNodeProperty getProperty(String string) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].getName().equals(string)) continue;
            return this.properties[i];
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setId(int n) {
        this.id = n;
        NODES.put(new Integer(n), this);
        if (n > siteId) {
            siteId = n + 1;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParent(EasNode easNode) {
        this.parent = easNode.getHandle();
    }

    public static EasSiteNode[] getSites() {
        EasSiteNode[] easSiteNodeArray = new EasSiteNode[NODES.size()];
        for (int i = 0; i < NODES.size(); ++i) {
            easSiteNodeArray[i] = (EasSiteNode)NODES.get(new Integer(i));
        }
        return easSiteNodeArray;
    }

    public static EasSiteNode getSite(int n) {
        return (EasSiteNode)NODES.get(new Integer(n));
    }

    public void addSite(Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into " + MasterDemoGen.getDbTableName(connection, "GROUPS") + " (id, type, name) values(?,?,?)");
            preparedStatement.setInt(1, this.id);
            preparedStatement.setString(2, "P");
            preparedStatement.setString(3, this.name);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

