/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.easdemo.EasNodeProperty;
import com.tridium.easdemo.EasSiteNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EasNode {
    private int handle;
    private int id;
    private int childCt;
    private int[] children;
    private int parent;
    private int type;
    private String name;
    private String desc;
    private static int handleId = 0;
    private static Hashtable NODE_TABLE = new Hashtable();
    public static final int ROOT = 0;
    public static final int SITE = 1;
    public static final int STATION = 2;
    public static final int METER = 3;
    public static final int DATAPOINT = 4;
    public static final String[] NODE_TYPES = new String[]{"db", "site", "station", "meter", "datapoint"};
    public static final EasNode ROOT_NODE = new EasNode(0);

    public EasNode() {
    }

    public EasNode(int n) {
        this.handle = EasNode.getNextHandle();
        this.id = 0;
        this.type = n;
        this.name = "";
        this.childCt = 0;
        this.parent = -1;
    }

    public void addChild(EasNode easNode) {
        if (this.childCt > 0) {
            int[] nArray = new int[this.childCt + 1];
            System.arraycopy(this.children, 0, nArray, 0, this.childCt);
            nArray[this.childCt] = easNode.getHandle();
            this.children = nArray;
        } else {
            this.children = new int[1];
            this.children[0] = easNode.getHandle();
        }
        ++this.childCt;
    }

    public void addProperty(EasNodeProperty easNodeProperty) {
    }

    public String getAsXML() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.childCt; ++i) {
            stringBuffer.append(((EasSiteNode)EasNode.getEasNode(this.children[i])).getAsXML());
        }
        return stringBuffer.toString();
    }

    public EasNode[] getChildren() {
        if (this.childCt == 0) {
            return null;
        }
        EasNode[] easNodeArray = new EasNode[this.childCt];
        for (int i = 0; i < this.childCt; ++i) {
            easNodeArray[i] = EasNode.getEasNode(this.children[i]);
        }
        return easNodeArray;
    }

    public EasNode[] getChildrenByType(int n) {
        return null;
    }

    public int getChildCount() {
        return this.childCt;
    }

    public EasNode getChildById(int n) {
        if (this.childCt > 0) {
            for (int i = 0; i < this.childCt; ++i) {
                EasNode easNode = EasNode.getEasNode(this.children[i]);
                if (easNode.getId() != n) continue;
                return easNode;
            }
        }
        return null;
    }

    public EasNode getChildByName(String string) {
        if (this.childCt > 0) {
            for (int i = 0; i < this.childCt; ++i) {
                EasNode easNode = EasNode.getEasNode(this.children[i]);
                if (easNode.getName() != string) continue;
                return easNode;
            }
        }
        return null;
    }

    public String getDescription() {
        if (this.desc == null) {
            return null;
        }
        return this.desc;
    }

    public int getHandle() {
        return this.handle;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public EasNode getParent() {
        if (this.parent == -1) {
            return null;
        }
        return EasNode.getEasNode(this.parent);
    }

    public int getType() {
        return this.type;
    }

    public void setDescription(String string) {
    }

    public void setFUnit(String string) {
    }

    public void setFValue(int n) {
    }

    public void setIsMain(boolean bl) {
    }

    public void setIsSub(boolean bl) {
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParent(EasNode easNode) {
    }

    public void setParentMeter(EasNode easNode) {
    }

    public void setRcType(String string) {
    }

    public void setRcSubType(String string) {
    }

    public void setVType(String string) {
    }

    public void setVUnit(String string) {
    }

    public static void addNode(EasNode easNode) {
        NODE_TABLE.put(new Integer(easNode.getHandle()), easNode);
        if (easNode.getHandle() > handleId) {
            handleId = easNode.getHandle() + 1;
        }
    }

    public static EasNode getEasNode(int n) {
        return (EasNode)NODE_TABLE.get(new Integer(n));
    }

    public static EasNode getEasNode(String string) {
        Enumeration enumeration = NODE_TABLE.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            EasNode easNode = (EasNode)NODE_TABLE.get(n);
            if (!easNode.getName().equals(string)) continue;
            return easNode;
        }
        return null;
    }

    public static Vector getEasNodes(int n) {
        Vector<EasNode> vector = new Vector<EasNode>();
        Enumeration enumeration = NODE_TABLE.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            EasNode easNode = (EasNode)NODE_TABLE.get(n2);
            if (easNode.getType() != n) continue;
            vector.addElement(easNode);
        }
        return vector;
    }

    public static int getNextHandle() {
        int n = handleId++;
        return n;
    }
}

