/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.eas.api.RcType;
import com.tridium.easdemo.EasDemoConst;
import com.tridium.easdemo.EasNode;
import com.tridium.easdemo.MasterDemoGen;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.units.BUnit;

public class EasMeterNode
extends EasNode {
    private int handle;
    private int id;
    private int[] children;
    private RcType rcType;
    private BUnit fUnit;
    private int childCt;
    private int fValue;
    private int isMain;
    private int parent;
    private int type;
    private String desc;
    private String name;
    private static int meterId = 0;
    private static Hashtable NODES = new Hashtable();

    public EasMeterNode() {
        this.handle = EasNode.getNextHandle();
        this.id = meterId++;
        this.type = 3;
        this.name = "";
        this.desc = "";
        this.isMain = 0;
        this.fValue = -1;
        this.parent = -1;
        this.childCt = 0;
        EasNode.addNode(this);
        NODES.put(new Integer(this.id), this);
    }

    public EasMeterNode(int n) {
        this.handle = n;
        this.id = -1;
        this.type = 3;
        this.name = "";
        this.desc = "";
        this.isMain = 0;
        this.fValue = -1;
        this.parent = -1;
        this.childCt = 0;
        EasNode.addNode(this);
    }

    public void addChild(EasNode easNode) {
        if (this.childCt > 0) {
            int[] nArray = new int[this.childCt + 1];
            System.arraycopy(this.children, 0, nArray, 0, this.childCt);
            nArray[this.childCt] = easNode.getHandle();
            this.children = nArray;
        } else {
            this.children = new int[1];
            this.children[0] = easNode.getHandle();
        }
        ++this.childCt;
    }

    public String getAsXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + EasNode.NODE_TYPES[this.type] + " handle=\"" + this.handle + "\">\n");
        stringBuffer.append("<id>" + this.id + "</id>\n");
        stringBuffer.append("<name>" + this.name + "</name>\n");
        stringBuffer.append("<description>" + this.desc + "</description>\n");
        stringBuffer.append("<rctype>" + this.getRcType() + "</rctype>\n");
        stringBuffer.append("<main>" + this.getIsMain() + "</main>\n");
        stringBuffer.append("<floorareaUnit>" + this.getFUnit() + "</floorareaUnit>\n");
        stringBuffer.append("<floorareaValue>" + this.getFValue() + "</floorareaValue>\n");
        stringBuffer.append("</" + EasNode.NODE_TYPES[this.type] + ">\n");
        return stringBuffer.toString();
    }

    public EasNode[] getChildren() {
        if (this.childCt == 0) {
            return null;
        }
        EasNode[] easNodeArray = new EasNode[this.childCt];
        for (int i = 0; i < this.childCt; ++i) {
            easNodeArray[i] = EasMeterNode.getEasNode(this.children[i]);
        }
        return easNodeArray;
    }

    public int getChildCount() {
        return this.childCt;
    }

    public EasNode getChildById(int n) {
        if (this.childCt == 0) {
            return null;
        }
        for (int i = 0; i < this.childCt; ++i) {
            EasNode easNode = EasMeterNode.getEasNode(this.children[i]);
            if (easNode.getId() != n) continue;
            return easNode;
        }
        return null;
    }

    public EasNode getChildByName(String string) {
        if (this.childCt == 0) {
            return null;
        }
        for (int i = 0; i < this.childCt; ++i) {
            EasNode easNode = EasMeterNode.getEasNode(this.children[i]);
            if (!easNode.getName().equals(string)) continue;
            return easNode;
        }
        return null;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getFUnit() {
        return this.fUnit.getUnitName();
    }

    public int getFValue() {
        return this.fValue;
    }

    public int getHandle() {
        return this.handle;
    }

    public int getId() {
        return this.id;
    }

    public boolean getIsMain() {
        return this.isMain == 1;
    }

    public String getName() {
        return this.name;
    }

    public EasNode getParent() {
        return EasNode.getEasNode(this.parent);
    }

    public String getRcType() {
        return this.rcType.getDescription();
    }

    public int getType() {
        return this.type;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public void setFUnit(String string) {
        this.fUnit = BUnit.getUnit((String)string);
    }

    public void setFValue(String string) {
        this.fValue = Integer.parseInt(string);
    }

    public void setId(int n) {
        this.id = n;
        NODES.put(new Integer(n), this);
        if (n > meterId) {
            meterId = n + 1;
        }
    }

    public void setIsMain(boolean bl) {
        if (bl) {
            this.isMain = 1;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParent(EasNode easNode) {
        this.parent = easNode.getHandle();
    }

    public void setRcType(String string) {
        this.rcType = (RcType)EasDemoConst.RC_TYPES.get(string);
    }

    public static EasMeterNode[] getMeters() {
        EasMeterNode[] easMeterNodeArray = new EasMeterNode[NODES.size()];
        for (int i = 0; i < NODES.size(); ++i) {
            easMeterNodeArray[i] = (EasMeterNode)NODES.get(new Integer(i));
        }
        return easMeterNodeArray;
    }

    public static EasMeterNode getMeter(int n) {
        return (EasMeterNode)NODES.get(new Integer(n));
    }

    public static EasMeterNode getMeter(String string) {
        Enumeration enumeration = NODES.keys();
        while (enumeration.hasMoreElements()) {
            EasMeterNode easMeterNode = (EasMeterNode)NODES.get(enumeration.nextElement());
            if (!string.equals(easMeterNode.getName())) continue;
            return easMeterNode;
        }
        return null;
    }

    public void addMeter(Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into " + MasterDemoGen.getDbTableName(connection, "METER") + " (id, name, descr, site_id, rc_type, main, floorarea_vunit, floorarea_value) values (?,?,?,?,?,?,?,?)");
            preparedStatement.setInt(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setString(3, this.desc);
            preparedStatement.setInt(4, EasNode.getEasNode(this.parent).getId());
            preparedStatement.setInt(5, this.rcType.getCode());
            preparedStatement.setInt(6, this.isMain);
            preparedStatement.setString(7, this.fUnit.getUnitName());
            preparedStatement.setInt(8, this.fValue);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

