/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.easdemo;

import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.easdemo.BEasDemoGenerator;
import com.tridium.easdemo.EasDemoConst;
import com.tridium.easdemo.EasNode;
import com.tridium.easdemo.MasterDemoGen;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Hashtable;
import javax.baja.history.BHistoryId;
import javax.baja.sys.Sys;
import javax.baja.units.BUnit;

public class EasDPNode
extends EasNode {
    private int handle;
    private int id;
    private RcType rcType;
    private RcSubtype rcSubType;
    private BUnit fUnit;
    private int fValue;
    private int isMain;
    private int meter;
    private int site;
    private int type;
    private String desc;
    private String name;
    private static int dpId = 0;
    private static Hashtable NODES = new Hashtable();

    public EasDPNode() {
        this.handle = EasNode.getNextHandle();
        this.id = dpId++;
        this.type = 4;
        this.name = "";
        this.desc = "";
        this.isMain = 0;
        this.fValue = 0;
        this.meter = -1;
        this.site = -1;
        EasNode.addNode(this);
        NODES.put(new Integer(this.id), this);
    }

    public EasDPNode(int n) {
        this.handle = n;
        this.id = -1;
        this.type = 4;
        this.name = "";
        this.desc = "";
        this.isMain = 0;
        this.fValue = 0;
        this.meter = -1;
        this.site = -1;
        EasNode.addNode(this);
    }

    public String getAsXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + EasNode.NODE_TYPES[this.type] + " handle=\"" + this.handle + "\">\n");
        stringBuffer.append("<id>" + this.id + "</id>\n");
        stringBuffer.append("<name>" + this.name + "</name>\n");
        stringBuffer.append("<description>" + this.desc + "</description>\n");
        stringBuffer.append("<type>" + this.getRcType() + "</type>\n");
        stringBuffer.append("<subtype>" + this.getRcSubtype() + "</subtype>\n");
        stringBuffer.append("<main>" + this.getIsMain() + "</main>\n");
        stringBuffer.append("<floorareaUnit>" + this.getFUnit() + "</floorareaUnit>\n");
        stringBuffer.append("<floorareaValue>" + this.fValue + "</floorareaValue>\n");
        if (this.meter != -1) {
            stringBuffer.append("<meterId>" + this.getParentMeter().getId() + "</meterId>\n");
        }
        stringBuffer.append("</" + EasNode.NODE_TYPES[this.type] + ">\n");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return this.desc;
    }

    public String getFUnit() {
        return this.fUnit.getUnitName();
    }

    public int getFValue() {
        return this.fValue;
    }

    public int getHandle() {
        return this.handle;
    }

    public int getId() {
        return this.id;
    }

    public boolean getIsMain() {
        return this.isMain == 1;
    }

    public String getName() {
        return this.name;
    }

    public EasNode getParentMeter() {
        return EasNode.getEasNode(this.meter);
    }

    public EasNode getParentSite() {
        return EasNode.getEasNode(this.site);
    }

    public String getRcType() {
        return this.rcType.getDescription();
    }

    public String getRcSubtype() {
        return this.rcSubType.getDescription();
    }

    public int getType() {
        return this.type;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public void setFUnit(String string) {
        this.fUnit = BUnit.getUnit((String)string);
    }

    public void setFValue(int n) {
        this.fValue = n;
    }

    public void setId(int n) {
        this.id = n;
        NODES.put(new Integer(n), this);
        if (n > dpId) {
            dpId = n + 1;
        }
    }

    public void setIsMain(boolean bl) {
        if (bl) {
            this.isMain = 1;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParentMeter(EasNode easNode) {
        this.meter = easNode.getHandle();
    }

    public void setParentSite(EasNode easNode) {
        this.site = easNode.getHandle();
    }

    public void setRcType(String string) {
        this.rcType = (RcType)EasDemoConst.RC_TYPES.get(string);
        if (this.rcType == null) {
            BEasDemoGenerator.log.error("Could not add rcType with " + string);
            Thread.dumpStack();
        }
    }

    public void setRcSubType(String string) {
        this.rcSubType = (RcSubtype)EasDemoConst.RC_SUBTYPES.get(string);
    }

    public static EasDPNode[] getAllDatapoints() {
        EasDPNode[] easDPNodeArray = new EasDPNode[NODES.size()];
        for (int i = 0; i < NODES.size(); ++i) {
            easDPNodeArray[i] = (EasDPNode)NODES.get(new Integer(i));
        }
        return easDPNodeArray;
    }

    public static EasDPNode getDatapoint(int n) {
        return (EasDPNode)NODES.get(new Integer(n));
    }

    public void addDP(Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into " + MasterDemoGen.getDbTableName(connection, "DATA_POINT") + " (id, name, descr, station_id, group_id, meter_id, rc_type, floorarea_vunit, floorarea_value, rc_subtype, main) " + "values " + "(?,?,?,?,?,?,?,?,?,?,?)");
            preparedStatement.setInt(1, this.id);
            String string = Sys.getStation().getStationName();
            BHistoryId bHistoryId = BHistoryId.make((String)("/" + string + "/" + this.name));
            preparedStatement.setString(2, bHistoryId.encodeToString());
            preparedStatement.setString(3, this.desc);
            preparedStatement.setInt(4, -1);
            preparedStatement.setInt(5, this.getParentSite().getId());
            preparedStatement.setInt(6, this.meter != -1 ? this.getParentMeter().getId() : -1);
            preparedStatement.setInt(7, this.rcType.getCode());
            preparedStatement.setString(8, this.fUnit.getUnitName());
            preparedStatement.setInt(9, this.fValue);
            preparedStatement.setInt(10, this.rcSubType.getCode());
            preparedStatement.setInt(11, this.isMain);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

