/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.batik;

import com.tridium.gx.awt.BImageDecoder;
import com.tridium.gx.awt.ImageAnimator;
import com.tridium.svg.batik.OrdParsedURLProtocolHandler;
import com.tridium.svg.batik.OrdRegistryEntry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.baja.agent.BIAgent;
import javax.baja.gx.BTransform;
import javax.baja.naming.BOrd;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAnimationEngine;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.css.engine.CSSNavigableDocumentListener;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.dom.svg.AnimatedAttributeListener;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMAnimationElement;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BSvgDecoder
extends BImageDecoder
implements BIAgent {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$svg$batik$BSvgDecoder == null ? (class$com$tridium$svg$batik$BSvgDecoder = BSvgDecoder.class$("com.tridium.svg.batik.BSvgDecoder")) : class$com$tridium$svg$batik$BSvgDecoder));
    private static final RenderingHints HINTS;
    private static final Color TRANSPARENT;
    private BufferedImage image;
    private ImageAnimator animator;
    static /* synthetic */ Class class$com$tridium$svg$batik$BSvgDecoder;

    public void decode(BOrd bOrd, byte[] byArray, BTransform.Scale scale) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            String string = "ord://" + bOrd;
            SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            SVGOMDocument sVGOMDocument = (SVGOMDocument)sAXSVGDocumentFactory.createDocument(string, byteArrayInputStream);
            UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
            BridgeContext bridgeContext = new BridgeContext(userAgentAdapter, new DocumentLoader(userAgentAdapter));
            bridgeContext.setDynamicState(2);
            GVTBuilder gVTBuilder = new GVTBuilder();
            GraphicsNode graphicsNode = gVTBuilder.build(bridgeContext, sVGOMDocument);
            this.image = BSvgDecoder.initImage(bridgeContext, scale);
            if (scale != null) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(scale.getX(), scale.getY());
                graphicsNode.setTransform(affineTransform);
            }
            this.image = BSvgDecoder.initImage(bridgeContext, scale);
            BSvgDecoder.renderImage(this.image, graphicsNode);
            this.animator = BSvgDecoder.hasAnimationElement(sVGOMDocument) ? new SvgAnimator(sVGOMDocument, bridgeContext, graphicsNode, scale) : null;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public ImageAnimator getAnimator() {
        return this.animator;
    }

    private static BufferedImage initImage(BridgeContext bridgeContext, BTransform.Scale scale) {
        Dimension2D dimension2D = bridgeContext.getDocumentSize();
        if (scale == null) {
            return new BufferedImage((int)dimension2D.getWidth(), (int)dimension2D.getHeight(), 2);
        }
        return new BufferedImage((int)(scale.getX() * dimension2D.getWidth()), (int)(scale.getY() * dimension2D.getHeight()), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearBackground(Graphics2D graphics2D, int n, int n2) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        try {
            graphics2D2.setBackground(TRANSPARENT);
            graphics2D2.clearRect(0, 0, n, n2);
        }
        finally {
            graphics2D2.dispose();
        }
    }

    private static void renderImage(BufferedImage bufferedImage, GraphicsNode graphicsNode) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.addRenderingHints(HINTS);
        BSvgDecoder.clearBackground(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphicsNode.paint(graphics2D);
    }

    private static boolean hasAnimationElement(Node node) {
        if (node instanceof SVGOMAnimationElement) {
            return true;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!BSvgDecoder.hasAnimationElement(nodeList.item(i))) continue;
            return true;
        }
        return false;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.setProperty("org.apache.batik.warn_destination", "false");
        HINTS = new RenderingHints(null);
        HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HINTS.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        TRANSPARENT = new Color(0, 0, 0, 0);
        ParsedURL.registerHandler(new OrdParsedURLProtocolHandler());
        ImageTagRegistry.getRegistry().register(new OrdRegistryEntry());
    }

    private static class SvgAnimator
    implements ImageAnimator,
    AnimatedAttributeListener,
    CSSNavigableDocumentListener {
        private final BridgeContext bridgeContext;
        private final GraphicsNode gvtRoot;
        private long baseMillis;
        private final BufferedImage[] animImages;
        private int curImage;
        private boolean changed = false;

        private SvgAnimator(SVGOMDocument sVGOMDocument, BridgeContext bridgeContext, GraphicsNode graphicsNode, BTransform.Scale scale) {
            this.bridgeContext = bridgeContext;
            this.gvtRoot = graphicsNode;
            this.baseMillis = System.currentTimeMillis();
            this.animImages = new BufferedImage[2];
            this.curImage = 0;
            this.animImages[0] = BSvgDecoder.initImage(bridgeContext, scale);
            this.animImages[1] = BSvgDecoder.initImage(bridgeContext, scale);
            BSvgDecoder.renderImage(this.animImages[this.curImage], graphicsNode);
            sVGOMDocument.addAnimatedAttributeListener(this);
            sVGOMDocument.addCSSNavigableDocumentListener(this);
            SVGAnimationEngine sVGAnimationEngine = bridgeContext.getAnimationEngine();
            sVGAnimationEngine.start(0L);
            sVGAnimationEngine.setCurrentTime(0.0f);
        }

        public boolean animate() {
            this.changed = false;
            float f = (float)(System.currentTimeMillis() - this.baseMillis) / 1000.0f;
            this.bridgeContext.getAnimationEngine().setCurrentTime(f);
            if (this.changed) {
                int n = (this.curImage + 1) % 2;
                BSvgDecoder.renderImage(this.animImages[n], this.gvtRoot);
                this.curImage = n;
            }
            return this.changed;
        }

        public Image getAnimatedImage() {
            return this.animImages[this.curImage];
        }

        public void animatedAttributeChanged(Element element, AnimatedLiveAttributeValue animatedLiveAttributeValue) {
            this.changed = true;
        }

        public void otherAnimationChanged(Element element, String string) {
            this.changed = true;
        }

        public void nodeInserted(Node node) {
            this.changed = true;
        }

        public void nodeToBeRemoved(Node node) {
            this.changed = true;
        }

        public void subtreeModified(Node node) {
            this.changed = true;
        }

        public void characterDataModified(Node node) {
            this.changed = true;
        }

        public void attrModified(Element element, Attr attr, short s, String string, String string2) {
            this.changed = true;
        }

        public void overrideStyleTextChanged(CSSStylableElement cSSStylableElement, String string) {
            this.changed = true;
        }

        public void overrideStylePropertyRemoved(CSSStylableElement cSSStylableElement, String string) {
            this.changed = true;
        }

        public void overrideStylePropertyChanged(CSSStylableElement cSSStylableElement, String string, String string2, String string3) {
            this.changed = true;
        }
    }
}

