/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.enums.BCcnDiscreteStateEnum;
import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspPicUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.ccn.util.CcnStringNumberConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class CcnRspPicPocUtil
extends CcnRspTableUtil
implements CcnErrorCodes {
    public static int[] EXPECTED_PICPOC_TBL_TYPES = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24};

    public static String getFieldName(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n2 && n2 <= 4) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = CcnRspPicPocUtil.getStartOffset(n, 12);
            int n4 = 8;
            return new String(CcnRspPicPocUtil.getSubByteArray(byArray, n3, n4));
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getFieldName");
    }

    public static byte getDataType(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n2 && n2 <= 4) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = CcnRspPicPocUtil.getStartOffset(n, 12) + 8;
            return (byte)(byArray[n3] & 0x7F);
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDataType");
    }

    public static boolean getDisplayType(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n2 && n2 <= 4) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = CcnRspPicPocUtil.getStartOffset(n, 12) + 8;
            boolean bl = false;
            if ((byArray[n3] & 0x80) != 0) {
                bl = true;
            }
            return bl;
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDisplayType");
    }

    public static byte getDisplayDigits(CcnResponseMessage ccnResponseMessage, int n, int n2) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n3 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n3 && n3 <= 4) {
            if (n == 12 || 16 <= n && n <= 34 || n == 51) {
                return 0;
            }
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n4 = CcnRspPicPocUtil.getStartOffset(n2, 12) + 9;
            return byArray[n4];
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDisplayDigits");
    }

    public static byte getFieldByteCount(CcnResponseMessage ccnResponseMessage, byte by, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n2 && n2 <= 4) {
            byte by2;
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            switch (by) {
                case 0: 
                case 1: 
                case 9: 
                case 25: 
                case 49: 
                case 50: {
                    by2 = 1;
                    break;
                }
                case 2: 
                case 10: 
                case 12: {
                    by2 = 2;
                    break;
                }
                case 7: 
                case 48: 
                case 51: {
                    by2 = 4;
                    break;
                }
                case 16: 
                case 17: 
                case 32: 
                case 33: 
                case 34: {
                    int n3 = CcnRspPicPocUtil.getStartOffset(n, 12) + 9;
                    by2 = byArray[n3];
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    by2 = 8;
                    break;
                }
                default: {
                    by2 = 0;
                }
            }
            return by2;
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getFieldByteCount");
    }

    public static byte getDiscreteTextOffset(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n2 && n2 <= 4) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = CcnRspPicPocUtil.getStartOffset(n, 12) + 9;
            return byArray[n3];
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDiscreteTextOffset");
    }

    public static byte getConfigFlags(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n2 && n2 <= 4) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = CcnRspPicPocUtil.getStartOffset(n, 12) + 10;
            return byArray[n3];
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getConfigFlags");
    }

    public static int getUnits(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (2 <= n2 && n2 <= 4) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = CcnRspPicPocUtil.getStartOffset(n, 12) + 11;
            return byArray[n3] & 0xFF;
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getUnits");
    }

    public static String getLimit(CcnResponseMessage ccnResponseMessage, int n, BCcnPointEntry bCcnPointEntry) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (7 == n2 || 8 == n2) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return CcnRspPicPocUtil.getNextValue(byArray, n, bCcnPointEntry);
        }
        throw new CcnException(6488167, "PicTable - Need block 7 or 8 to getLimit");
    }

    public static String getNextValue(byte[] byArray, int n, BCcnPointEntry bCcnPointEntry) {
        String string;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        int n4 = bCcnPointEntry.getPointDataType();
        int n5 = bCcnPointEntry.getFieldByteCount();
        int n6 = 0;
        if (!bCcnPointEntry.isDiscrete()) {
            n6 = bCcnPointEntry.getDisplayDigits() & 0xF;
        }
        int n7 = (bCcnPointEntry.getDisplayDigits() & 0xF0) >> 4;
        n += 3;
        switch (n4) {
            case 0: {
                String string2;
                n3 = byArray[n];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                if ((string2 = Integer.toBinaryString(n3)).length() == n7) {
                    string = string2;
                    break;
                }
                String string3 = "00000000";
                string3 = string3.substring(string3.length() - n7);
                string = string3 + string2;
                string = string.substring(string.length() - n7);
                break;
            }
            case 1: 
            case 25: 
            case 49: 
            case 50: {
                n3 = byArray[n];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 2: {
                n3 = byArray[n] << 8 | byArray[n + 1] & 0xFF;
                if (n3 < 0) {
                    n3 = 65536 + n3;
                }
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 6: {
                int n8 = byArray[n + 1] << 8 | byArray[n + 2];
                byte by = byArray[n];
                f = (float)((double)n8 * Math.pow(10.0, by));
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(n6);
                numberFormat.setMinimumFractionDigits(n6);
                ((DecimalFormat)numberFormat).setGroupingSize(20);
                string = numberFormat.format(f);
                break;
            }
            case 7: 
            case 48: {
                n3 = byArray[n] << 24 & 0xFF000000;
                n3 |= byArray[n + 1] << 16 & 0xFF0000;
                n3 |= byArray[n + 2] << 8 & 0xFF00;
                f = Float.intBitsToFloat(n3 |= byArray[n + 3] & 0xFF);
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(n6);
                numberFormat.setMinimumFractionDigits(n6);
                ((DecimalFormat)numberFormat).setGroupingSize(20);
                string = ((DecimalFormat)numberFormat).format(f);
                break;
            }
            case 9: {
                n3 = n2 = byArray[n];
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 10: {
                n3 = byArray[n] << 8 | byArray[n + 1] & 0xFF;
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 12: {
                byte by = byArray[n];
                byte by2 = byArray[n + 1];
                string = by < 10 ? "0" + by : "" + by;
                string = by2 < 10 ? string + ":0" + by2 : string + ':' + by2;
                if (!string.equalsIgnoreCase("24:00")) break;
                string = "00:00";
                break;
            }
            case 17: {
                int n9 = 0;
                while (n9 < n5) {
                    byte by = byArray[n + n9];
                    int n10 = by >> 4 & 0xF;
                    int n11 = by & 0xF;
                    n3 = n3 * 100 + n10 * 10 + n11;
                    ++n9;
                }
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 16: 
            case 32: 
            case 33: 
            case 34: {
                string = new String(CcnRspPicPocUtil.getSubByteArray(byArray, n, n5));
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = new String(CcnRspPicPocUtil.getSubByteArray(byArray, n, 8));
                break;
            }
            case 51: {
                byte by = byArray[n];
                byte by3 = byArray[n + 1];
                byte by4 = byArray[n + 2];
                byte by5 = byArray[n + 3];
                String string4 = by < 10 ? "0" + by : "" + by;
                string4 = by3 < 10 ? string4 + ":0" + by3 : string4 + ':' + by3;
                String string5 = by4 < 10 ? "0" + by4 : "" + by4;
                string5 = by5 < 10 ? string5 + ":0" + by5 : string5 + ':' + by5;
                string = string4 + ' ' + string5;
                break;
            }
            default: {
                string = "Invalid data type";
            }
        }
        if (bCcnPointEntry.isDiscrete()) {
            if (string.trim().indexOf("1") == -1) {
                return "0";
            }
            return "1";
        }
        if (bCcnPointEntry.getDisplayType() && (n4 == 1 || n4 == 2 || n4 == 6 || n4 == 7 || n4 == 9 || n4 == 10 || n4 == 17 || n4 == 48)) {
            string = CcnRspPicUtil.toMetric(bCcnPointEntry.getDisplayDigits(), bCcnPointEntry.getUnits(), string);
        }
        return string.trim();
    }

    public static String getNextValue(byte[] byArray, int n, BCcnProxyExt bCcnProxyExt) {
        String string;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        int n4 = bCcnProxyExt.getPointDataType();
        int n5 = bCcnProxyExt.getFieldByteCount();
        int n6 = 0;
        if (!bCcnProxyExt.isDiscrete()) {
            n6 = bCcnProxyExt.getDisplayDigits() & 0xF;
        }
        int n7 = (bCcnProxyExt.getDisplayDigits() & 0xF0) >> 4;
        n += 3;
        switch (n4) {
            case 0: {
                String string2;
                n3 = byArray[n];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                if ((string2 = Integer.toBinaryString(n3)).length() == n7) {
                    string = string2;
                    break;
                }
                String string3 = "00000000";
                string3 = string3.substring(string3.length() - n7);
                string = string3 + string2;
                string = string.substring(string.length() - n7);
                break;
            }
            case 1: 
            case 25: 
            case 49: 
            case 50: {
                n3 = byArray[n];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 2: {
                n3 = byArray[n] << 8 | byArray[n + 1] & 0xFF;
                if (n3 < 0) {
                    n3 = 65536 + n3;
                }
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 6: {
                int n8 = byArray[n + 1] << 8 | byArray[n + 2];
                byte by = byArray[n];
                f = (float)((double)n8 * Math.pow(10.0, by));
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(n6);
                numberFormat.setMinimumFractionDigits(n6);
                ((DecimalFormat)numberFormat).setGroupingSize(20);
                string = numberFormat.format(f);
                break;
            }
            case 7: 
            case 48: {
                n3 = byArray[n] << 24 & 0xFF000000;
                n3 |= byArray[n + 1] << 16 & 0xFF0000;
                n3 |= byArray[n + 2] << 8 & 0xFF00;
                f = Float.intBitsToFloat(n3 |= byArray[n + 3] & 0xFF);
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(n6);
                numberFormat.setMinimumFractionDigits(n6);
                ((DecimalFormat)numberFormat).setGroupingSize(20);
                string = ((DecimalFormat)numberFormat).format(f);
                break;
            }
            case 9: {
                n3 = n2 = byArray[n];
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 10: {
                n3 = byArray[n] << 8 | byArray[n + 1] & 0xFF;
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 12: {
                byte by = byArray[n];
                byte by2 = byArray[n + 1];
                string = by < 10 ? "0" + by : "" + by;
                string = by2 < 10 ? string + ":0" + by2 : string + ':' + by2;
                if (!string.equalsIgnoreCase("24:00")) break;
                string = "00:00";
                break;
            }
            case 17: {
                int n9 = 0;
                while (n9 < n5) {
                    byte by = byArray[n + n9];
                    int n10 = by >> 4 & 0xF;
                    int n11 = by & 0xF;
                    n3 = n3 * 100 + n10 * 10 + n11;
                    ++n9;
                }
                string = CcnRspPicPocUtil.integerImpliedDecimals(n3, n6);
                break;
            }
            case 16: 
            case 32: 
            case 33: 
            case 34: {
                string = new String(CcnRspPicPocUtil.getSubByteArray(byArray, n, n5));
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = new String(CcnRspPicPocUtil.getSubByteArray(byArray, n, 8));
                break;
            }
            case 51: {
                byte by = byArray[n];
                byte by3 = byArray[n + 1];
                byte by4 = byArray[n + 2];
                byte by5 = byArray[n + 3];
                String string4 = by < 10 ? "0" + by : "" + by;
                string4 = by3 < 10 ? string4 + ":0" + by3 : string4 + ':' + by3;
                String string5 = by4 < 10 ? "0" + by4 : "" + by4;
                string5 = by5 < 10 ? string5 + ":0" + by5 : string5 + ':' + by5;
                string = string4 + ' ' + string5;
                break;
            }
            default: {
                string = "Invalid data type";
            }
        }
        if (bCcnProxyExt.isDiscrete()) {
            if (string.trim().indexOf("1") == -1) {
                return "0";
            }
            return "1";
        }
        if (bCcnProxyExt.getDisplayType() && (n4 == 1 || n4 == 2 || n4 == 6 || n4 == 7 || n4 == 9 || n4 == 10 || n4 == 17 || n4 == 48)) {
            string = CcnRspPicUtil.toMetric(bCcnProxyExt.getDisplayDigits(), bCcnProxyExt.getUnits(), string);
        }
        return string.trim();
    }

    private static final String integerImpliedDecimals(int n, int n2) {
        if (n2 == 0) {
            return new Integer(n).toString();
        }
        float f = n;
        float f2 = (float)n2 * 10.0f;
        return new Float(f /= f2).toString();
    }

    private static final String integerImpliedDecimals(String string, int n) {
        if (n == 0) {
            return string;
        }
        float f = new Float(string).floatValue();
        float f2 = (float)n * 10.0f;
        return new Float(f *= f2).toString();
    }

    public static String toMetric(int n, int n2, String string) {
        if (string == null || string.trim().equals("")) {
            return string;
        }
        double d = BCcnUnitMappingEnum.getSlopM(n2);
        double d2 = BCcnUnitMappingEnum.getOffsetC(n2);
        int n3 = BCcnUnitMappingEnum.getDecimalAdjust(n2);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits((n & 0xF) + n3);
        numberFormat.setMinimumFractionDigits((n & 0xF) + n3);
        ((DecimalFormat)numberFormat).setGroupingSize(20);
        Double d3 = new Double(string);
        double d4 = d3 * d + d2;
        return numberFormat.format(d4);
    }

    public static String toImperial(int n, int n2, String string) {
        if (string == null || string.trim().equals("")) {
            return string;
        }
        double d = BCcnUnitMappingEnum.getSlopM(n2);
        double d2 = BCcnUnitMappingEnum.getOffsetC(n2);
        int n3 = BCcnUnitMappingEnum.getDecimalAdjust(n2);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits((n & 0xF) - n3);
        numberFormat.setMinimumFractionDigits((n & 0xF) - n3);
        ((DecimalFormat)numberFormat).setGroupingSize(20);
        Double d3 = new Double(string);
        double d4 = (d3 - d2) / d;
        return numberFormat.format(d4);
    }

    public static String convertToImperial(int n, boolean bl, int n2, int n3, String string) {
        if ((n & 0x80) == 128) {
            return string;
        }
        if (bl) {
            return CcnRspPicPocUtil.toImperial(n2, n3, string);
        }
        return string;
    }

    public static String convertToImperial(BCcnProxyExt bCcnProxyExt) {
        String string = bCcnProxyExt.getFieldValue();
        int n = bCcnProxyExt.getPointDataType();
        if (bCcnProxyExt.isDiscrete()) {
            if (string.equalsIgnoreCase("1")) {
                return "1";
            }
            if (string.equalsIgnoreCase("0")) {
                return "0";
            }
        } else if (bCcnProxyExt.getDisplayType() && (n == 1 || n == 2 || n == 6 || n == 7 || n == 9 || n == 10 || n == 17 || n == 48)) {
            return CcnRspPicPocUtil.toImperial(bCcnProxyExt.getDisplayDigits(), bCcnProxyExt.getUnits(), bCcnProxyExt.getFieldValue());
        }
        return string;
    }

    public static String convertToImperial(BCcnPointEntry bCcnPointEntry) {
        String string = bCcnPointEntry.getPointValue();
        int n = bCcnPointEntry.getPointDataType();
        if (bCcnPointEntry.isDiscrete()) {
            if (string.equalsIgnoreCase("1")) {
                return "1";
            }
            if (string.equalsIgnoreCase("0")) {
                return "0";
            }
        } else if (bCcnPointEntry.getDisplayType() && (n == 1 || n == 2 || n == 6 || n == 7 || n == 9 || n == 10 || n == 17 || n == 48)) {
            return CcnRspPicPocUtil.toImperial(bCcnPointEntry.getDisplayDigits(), bCcnPointEntry.getUnits(), bCcnPointEntry.getPointValue());
        }
        return string;
    }

    public static boolean checkRange(String string, BCcnProxyExt bCcnProxyExt) {
        float f;
        float f2;
        int n = bCcnProxyExt.getPointDataType();
        boolean bl = true;
        boolean bl2 = true;
        if (n == 12) {
            int n2;
            int n3;
            if (string.indexOf(":") != -1) {
                n3 = Integer.parseInt(string.substring(0, string.indexOf(":")));
                n2 = Integer.parseInt(string.substring(string.indexOf(":") + 1));
            } else {
                int n4 = new Float(string).intValue();
                n3 = n4 / 100;
                n2 = n4 % 100;
            }
            if (n3 > 24 || n3 < 0 || n2 > 60 || n2 < 0) {
                return false;
            }
            return n3 != 24 || n2 <= 0;
        }
        if (n == 51) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (string.indexOf(":") != -1) {
                int n9 = string.indexOf(":");
                int n10 = string.indexOf(" ");
                int n11 = string.lastIndexOf(":");
                n8 = Integer.parseInt(string.substring(0, n9));
                n7 = Integer.parseInt(string.substring(n9 + 1, n10).trim());
                n6 = Integer.parseInt(string.substring(n10 + 1, n11).trim());
                n5 = Integer.parseInt(string.substring(n11 + 1));
            } else {
                int n12 = new Float(string).intValue();
                n8 = n12 / 10000 / 100;
                n7 = n12 / 10000 % 100;
                n6 = n12 % 10000 / 100;
                n5 = n12 % 10000 % 100;
            }
            return n8 <= 24 && n8 >= 0 && n6 <= 24 && n6 >= 0 && n7 <= 60 && n7 >= 0 && n5 <= 60 && n5 >= 0;
        }
        if ((bCcnProxyExt.getConfigFlags() & 0x80) == 128) {
            return true;
        }
        if (n == 0) {
            return true;
        }
        if (bCcnProxyExt.getLoLimit() != null && !bCcnProxyExt.getLoLimit().trim().equals("")) {
            if (n == 1 || n == 2 || n == 6 || n == 7 || n == 9 || n == 10 || n == 25 || n == 48 || n == 49 || n == 50) {
                f2 = CcnStringNumberConverter.getFloat(string);
                bl = !(f2 < (f = CcnStringNumberConverter.getFloat(bCcnProxyExt.getLoLimit())));
            }
        } else {
            bl = true;
        }
        if (bCcnProxyExt.getHiLimit() != null && !bCcnProxyExt.getHiLimit().trim().equals("")) {
            if (n == 1 || n == 2 || n == 6 || n == 7 || n == 9 || n == 10 || n == 25 || n == 48 || n == 49 || n == 50) {
                f2 = CcnStringNumberConverter.getFloat(string);
                bl2 = !(f2 > (f = CcnStringNumberConverter.getFloat(bCcnProxyExt.getHiLimit())));
            }
        } else {
            bl2 = true;
        }
        boolean bl3 = false;
        if (bl && bl2) {
            bl3 = true;
        }
        return bl3;
    }

    public static String getDescription(CcnResponseMessage ccnResponseMessage, int n) throws CcnException {
        CcnRspPicPocUtil.checkTableType(ccnResponseMessage.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int n2 = CcnRspPicPocUtil.parseBlockNo(ccnResponseMessage);
        if (10 <= n2 && n2 <= 15) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n3 = CcnRspPicPocUtil.getStartOffset(n, 24);
            int n4 = 24;
            return new String(CcnRspPicPocUtil.getSubByteArray(byArray, n3, n4));
        }
        throw new CcnException(6488167, "PicPocTable - Need block 10-15 to getDescription");
    }

    protected static int getStartOffset(int n, int n2) throws CcnException {
        if (n >= 0 && n <= 59) {
            return 3 + n % (240 / n2) * n2;
        }
        throw new CcnException(6488269, "Field index must be between 0-59");
    }

    public static String getActiveText(int n) {
        return CcnEnumsUtil.setProperDiscreteOffset(BCcnDiscreteStateEnum.parseId(n, 1));
    }

    public static String getInActiveText(int n) {
        return CcnEnumsUtil.setProperDiscreteOffset(BCcnDiscreteStateEnum.parseId(n, 0));
    }

    public static byte[] mergeNewValue(byte[] byArray, int n, int n2, int n3, String string, byte[] byArray2, BCcnPointEntry bCcnPointEntry) {
        n += 3;
        switch (n2) {
            case 0: {
                if (string != null) {
                    byArray[n] = (byte)Integer.parseInt(string, 2);
                    break;
                }
                byArray[n] = byArray2[0];
                break;
            }
            case 1: 
            case 9: 
            case 25: 
            case 49: 
            case 50: {
                if (string != null) {
                    int n4 = 0;
                    if (!bCcnPointEntry.isDiscrete()) {
                        n4 = bCcnPointEntry.getDisplayDigits() & 0xF;
                    }
                    String string2 = CcnRspPicPocUtil.integerImpliedDecimals(string, n4);
                    byArray[n] = (byte)CcnStringNumberConverter.getInt(string2);
                    break;
                }
                byArray[n] = byArray2[0];
                break;
            }
            case 2: 
            case 10: {
                if (string != null) {
                    int n5 = 0;
                    if (!bCcnPointEntry.isDiscrete()) {
                        n5 = bCcnPointEntry.getDisplayDigits() & 0xF;
                    }
                    String string3 = CcnRspPicPocUtil.integerImpliedDecimals(string, n5);
                    int n6 = CcnStringNumberConverter.getInt(string3);
                    byArray[n] = (byte)(n6 >> 8 & 0xFF);
                    byArray[n + 1] = (byte)(n6 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                break;
            }
            case 7: 
            case 48: {
                if (string != null) {
                    Float f = new Float(CcnStringNumberConverter.getFloat(string));
                    int n7 = Float.floatToIntBits(f.floatValue());
                    byArray[n] = (byte)(n7 >> 24 & 0xFF);
                    byArray[n + 1] = (byte)(n7 >> 16 & 0xFF);
                    byArray[n + 2] = (byte)(n7 >> 8 & 0xFF);
                    byArray[n + 3] = (byte)(n7 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                byArray[n + 2] = byArray2[2];
                byArray[n + 3] = byArray2[3];
                break;
            }
            case 12: {
                if (string != null) {
                    String string4 = string.substring(0, string.indexOf(":"));
                    String string5 = string.substring(string.indexOf(":") + 1);
                    int n8 = Integer.valueOf(string4);
                    byArray[n] = (byte)(n8 & 0xFF);
                    n8 = Integer.valueOf(string5);
                    byArray[n + 1] = (byte)(n8 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                break;
            }
            case 17: {
                if (string != null) {
                    int n9 = 0;
                    if (!bCcnPointEntry.isDiscrete()) {
                        n9 = bCcnPointEntry.getDisplayDigits() & 0xF;
                    }
                    String string6 = CcnRspPicPocUtil.integerImpliedDecimals(string, n9);
                    int n10 = Integer.parseInt(string6, 16);
                    int n11 = 0;
                    while (n11 < n3) {
                        byArray[n + n11] = (byte)(n10 >> (n3 - n11 - 1) * 8 & 0xFF);
                        ++n11;
                    }
                } else {
                    int n12 = 0;
                    while (n12 < n3) {
                        byArray[n + n12] = byArray2[n12];
                        ++n12;
                    }
                }
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 33: 
            case 34: {
                int n13 = n3;
                if (string != null) {
                    byte[] byArray3 = string.getBytes();
                    if (byArray3.length < n3) {
                        n13 = byArray3.length;
                    }
                    int n14 = 0;
                    while (n14 < n13) {
                        byArray[n + n14] = byArray3[n14];
                        ++n14;
                    }
                    n14 = n13;
                    while (n14 < n3) {
                        byArray[n + n14] = 0;
                        ++n14;
                    }
                } else {
                    if (byArray2.length < n3) {
                        n13 = byArray2.length;
                    }
                    int n15 = 0;
                    while (n15 < n13) {
                        byArray[n + n15] = byArray2[n15];
                        ++n15;
                    }
                    n15 = n13;
                    while (n15 < n3) {
                        byArray[n + n15] = 0;
                        ++n15;
                    }
                }
                break;
            }
            case 51: {
                if (string != null) {
                    int n16 = string.indexOf(":");
                    int n17 = string.indexOf(" ");
                    int n18 = string.lastIndexOf(":");
                    String string7 = string.substring(0, n16);
                    String string8 = string.substring(n16 + 1, n17).trim();
                    String string9 = string.substring(n17 + 1, n18).trim();
                    String string10 = string.substring(n18 + 1);
                    string = string7 + string8 + string9 + string10;
                    int n19 = Integer.valueOf(string);
                    byArray[n] = (byte)(n19 >> 24 & 0xFF);
                    byArray[n + 1] = (byte)(n19 >> 16 & 0xFF);
                    byArray[n + 2] = (byte)(n19 >> 8 & 0xFF);
                    byArray[n + 3] = (byte)(n19 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                byArray[n + 2] = byArray2[2];
                byArray[n + 3] = byArray2[3];
                break;
            }
            default: {
                System.out.println("Invalid data type");
            }
        }
        return byArray;
    }

    public static byte[] mergeNewValue(byte[] byArray, int n, int n2, int n3, String string, byte[] byArray2, BCcnProxyExt bCcnProxyExt) {
        n += 3;
        switch (n2) {
            case 0: {
                if (string != null) {
                    byArray[n] = (byte)Integer.parseInt(string, 2);
                    break;
                }
                byArray[n] = byArray2[0];
                break;
            }
            case 1: 
            case 9: 
            case 25: 
            case 49: 
            case 50: {
                if (string != null) {
                    int n4 = 0;
                    if (!bCcnProxyExt.isDiscrete()) {
                        n4 = bCcnProxyExt.getDisplayDigits() & 0xF;
                    }
                    String string2 = CcnRspPicPocUtil.integerImpliedDecimals(string, n4);
                    byArray[n] = (byte)CcnStringNumberConverter.getInt(string2);
                    break;
                }
                byArray[n] = byArray2[0];
                break;
            }
            case 2: 
            case 10: {
                if (string != null) {
                    int n5 = 0;
                    if (!bCcnProxyExt.isDiscrete()) {
                        n5 = bCcnProxyExt.getDisplayDigits() & 0xF;
                    }
                    String string3 = CcnRspPicPocUtil.integerImpliedDecimals(string, n5);
                    int n6 = CcnStringNumberConverter.getInt(string3);
                    byArray[n] = (byte)(n6 >> 8 & 0xFF);
                    byArray[n + 1] = (byte)(n6 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                break;
            }
            case 7: 
            case 48: {
                if (string != null) {
                    Float f = new Float(CcnStringNumberConverter.getFloat(string));
                    int n7 = Float.floatToIntBits(f.floatValue());
                    byArray[n] = (byte)(n7 >> 24 & 0xFF);
                    byArray[n + 1] = (byte)(n7 >> 16 & 0xFF);
                    byArray[n + 2] = (byte)(n7 >> 8 & 0xFF);
                    byArray[n + 3] = (byte)(n7 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                byArray[n + 2] = byArray2[2];
                byArray[n + 3] = byArray2[3];
                break;
            }
            case 12: {
                if (string != null) {
                    String string4 = string.substring(0, string.indexOf(":"));
                    String string5 = string.substring(string.indexOf(":") + 1);
                    int n8 = Integer.valueOf(string4);
                    byArray[n] = (byte)(n8 & 0xFF);
                    n8 = Integer.valueOf(string5);
                    byArray[n + 1] = (byte)(n8 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                break;
            }
            case 17: {
                if (string != null) {
                    int n9 = 0;
                    if (!bCcnProxyExt.isDiscrete()) {
                        n9 = bCcnProxyExt.getDisplayDigits() & 0xF;
                    }
                    String string6 = CcnRspPicPocUtil.integerImpliedDecimals(string, n9);
                    int n10 = Integer.parseInt(string6, 16);
                    int n11 = 0;
                    while (n11 < n3) {
                        byArray[n + n11] = (byte)(n10 >> (n3 - n11 - 1) * 8 & 0xFF);
                        ++n11;
                    }
                } else {
                    int n12 = 0;
                    while (n12 < n3) {
                        byArray[n + n12] = byArray2[n12];
                        ++n12;
                    }
                }
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 33: 
            case 34: {
                int n13 = n3;
                if (string != null) {
                    byte[] byArray3 = string.getBytes();
                    if (byArray3.length < n3) {
                        n13 = byArray3.length;
                    }
                    int n14 = 0;
                    while (n14 < n13) {
                        byArray[n + n14] = byArray3[n14];
                        ++n14;
                    }
                    n14 = n13;
                    while (n14 < n3) {
                        byArray[n + n14] = 0;
                        ++n14;
                    }
                } else {
                    if (byArray2.length < n3) {
                        n13 = byArray2.length;
                    }
                    int n15 = 0;
                    while (n15 < n13) {
                        byArray[n + n15] = byArray2[n15];
                        ++n15;
                    }
                    n15 = n13;
                    while (n15 < n3) {
                        byArray[n + n15] = 0;
                        ++n15;
                    }
                }
                break;
            }
            case 51: {
                if (string != null) {
                    int n16 = string.indexOf(":");
                    int n17 = string.indexOf(" ");
                    int n18 = string.lastIndexOf(":");
                    String string7 = string.substring(0, n16);
                    String string8 = string.substring(n16 + 1, n17).trim();
                    String string9 = string.substring(n17 + 1, n18).trim();
                    String string10 = string.substring(n18 + 1);
                    string = string7 + string8 + string9 + string10;
                    int n19 = Integer.valueOf(string);
                    byArray[n] = (byte)(n19 >> 24 & 0xFF);
                    byArray[n + 1] = (byte)(n19 >> 16 & 0xFF);
                    byArray[n + 2] = (byte)(n19 >> 8 & 0xFF);
                    byArray[n + 3] = (byte)(n19 & 0xFF);
                    break;
                }
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
                byArray[n + 2] = byArray2[2];
                byArray[n + 3] = byArray2[3];
                break;
            }
            default: {
                System.out.println("Invalid data type");
            }
        }
        return byArray;
    }

    public static String getTableTypeString(int n) {
        if (n == 16 || n == 20) {
            return BCcnTableGroupTypeEnum.UserConfiguration.getTag();
        }
        if (n == 17) {
            return BCcnTableGroupTypeEnum.StatusDisplay.getTag();
        }
        if (n == 19 || n == 22) {
            return BCcnTableGroupTypeEnum.ServiceConfiguration.getTag();
        }
        if (n == 23 || n == 24) {
            return BCcnTableGroupTypeEnum.SetPoints.getTag();
        }
        if (n == 18 || n == 21) {
            return BCcnTableGroupTypeEnum.Maintenance.getTag();
        }
        if (n == 67) {
            return BCcnTableGroupTypeEnum.AlarmHistory.getTag();
        }
        return BCcnTableGroupTypeEnum.Generic.getTag();
    }
}

