/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspTableUtil;

public final class CcnRspDevUtil
extends CcnRspTableUtil
implements CcnErrorCodes {
    public static int EXPECTED_DEV_TBL_TYPE = 32;

    private static final CcnException wrongTableException() {
        return new CcnException(6488168, "Method needs table " + EXPECTED_DEV_TBL_TYPE + '.');
    }

    public static final String getDevName(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECTED_DEV_TBL_TYPE) {
            throw CcnRspDevUtil.wrongTableException();
        }
        return CcnRspDevUtil.getTableName(ccnResponseMessage);
    }

    public static final int getPrimaryBaudRate(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (3 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return ((byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF) & (char)-1;
        }
        throw new CcnException(6488167, "Device Table - Need block 3 to getPrimaryBaudRate");
    }

    public static final int getSecondaryBaudRate(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (3 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return ((byArray[5] & 0xFF) << 8 | byArray[6] & 0xFF) & (char)-1;
        }
        throw new CcnException(6488167, "Device Table - Need block 3 to getPrimaryBaudRate");
    }

    public static final String getDevDesc(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (4 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 3, 24));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getDevDesc");
    }

    public static final String getLocDesc(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (4 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 27, 24));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getLocDesc");
    }

    public static final String getSwPartNum(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (4 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 51, 16));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getSwPartNum");
    }

    public static final String getModelNum(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (4 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 67, 20));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getModelNum");
    }

    public static final String getSerialNum(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (4 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 87, 12));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getSerialNum");
    }

    public static final String getReferenceNum(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (4 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 99, 24));
        }
        throw new CcnException(6488167, "Device Table - Need block 4 to getReferenceNum");
    }

    public static final String getPlatformId(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 3, 1));
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPlatformId");
    }

    public static final String getPICExecSWVerNum(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            return new String(CcnRspDevUtil.getSubByteArray(byArray, 4, 1));
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPICExecSWVerNum");
    }

    public static final String getPICType(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECTED_DEV_TBL_TYPE) {
            throw CcnRspDevUtil.wrongTableException();
        }
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            int n2 = byArray[5];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            return new String(Integer.toString(n2) + new String(CcnRspDevUtil.getSubByteArray(byArray, 6, 2)));
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPICType");
    }

    public static final String getPICApplSwVerNum(CcnResponseMessage ccnResponseMessage) throws CcnException {
        int n = CcnRspDevUtil.parseBlockNo(ccnResponseMessage);
        if (6 == n) {
            byte[] byArray = ccnResponseMessage.getResponseBuffer().getResponseData();
            byte[] byArray2 = CcnRspDevUtil.getSubByteArray(byArray, 8, 1);
            return Integer.toString(byArray2[0] / 10) + '.' + Integer.toString(byArray2[0] % 10);
        }
        throw new CcnException(6488167, "Device Table - Need block 6 to getPICApplSwVerNum");
    }
}

