/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.util.ByteArrayUtil;

public abstract class CcnRspDTUtil
extends CcnRspTableUtil {
    public static int EXPECT_TBL_TYPE = 33;
    public static byte TIME_BLOCK = (byte)2;
    public static byte DATE_BLOCK = (byte)3;
    public static byte DATE_TIME_PID = (byte)35;
    public static int HOUR_POSITION = 3;
    public static int MINUTE_POSITION = 4;
    public static int HOLIDAY_DOW_POSITION = 5;
    public static final int DAY_POSITION = 3;
    public static final int MONTH_POSITION = 4;
    public static final int YEAR_POSITION = 5;
    public static final byte DATE_TIME_BROADCAST_ADDR = -15;
    public static final byte DATE_TIME_BROADCAST_BUS = -15;
    public static final byte TIME_DATA_SIZE = 3;
    public static final byte DATE_DATA_SIZE = 3;
    public static final byte NO_HOLIDAY_FLAGS = 0;
    private static final CcnTableDef WRITE_DT_TABLE_TIME_BLOCK = new CcnTableDef(-15, -15, CcnMessageConst.NO_TABLE_NAME, 33, 1, TIME_BLOCK, 3, DATE_TIME_PID);
    private static final CcnTableDef WRITE_DT_TABLE_DATE_BLOCK = new CcnTableDef(-15, -15, CcnMessageConst.NO_TABLE_NAME, 33, 1, DATE_BLOCK, 3, DATE_TIME_PID);
    private static int FIRST_BYTE_OFFSET = 8;
    private static int TABLE_NUMBER_MSB_LOCATION = 8 - FIRST_BYTE_OFFSET;
    private static int TABLE_NUMBER_LSB_LOCATION = 9 - FIRST_BYTE_OFFSET;
    private static int TABLE_BLOCK_LOCATION = 10 - FIRST_BYTE_OFFSET;
    private static int TABLE_NAME_LOCATION = 11 - FIRST_BYTE_OFFSET;
    private static int TABLE_NAME_LENGTH = 8;
    private static int TABLE_TYPE_LOCATION_MSB = 11 - FIRST_BYTE_OFFSET;
    private static int TABLE_INST_LOCATION = 13 - FIRST_BYTE_OFFSET;
    private static String BROADCAST_TABLE_NAME = "BROCASTS";
    private static int BROADCAST_TABLE_TYPE = 614;
    private static int BROADCAST_TABLE_BLOCK = 2;

    private static final CcnException wrongTableException() {
        return new CcnException(6488168, "Method needs table " + EXPECT_TBL_TYPE + '.');
    }

    private static final int getHour(CcnResponseMessage ccnResponseMessage) throws CcnException {
        return ccnResponseMessage.getResponseBuffer().getResponseData()[HOUR_POSITION];
    }

    private static final int getMinute(CcnResponseMessage ccnResponseMessage) throws CcnException {
        return ccnResponseMessage.getResponseBuffer().getResponseData()[MINUTE_POSITION];
    }

    public static BAbsTime getDsTime(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnRspDTUtil.wrongTableException();
        }
        if (CcnRspTableUtil.parseBlockNo(ccnResponseMessage) == TIME_BLOCK) {
            return BAbsTime.make((int)0, (BMonth)BMonth.make((int)0), (int)CcnRspDTUtil.getHour(ccnResponseMessage), (int)CcnRspDTUtil.getMinute(ccnResponseMessage), (int)0);
        }
        throw new CcnException(6488167, "Need block " + TIME_BLOCK + " to getHour");
    }

    public boolean isTommorowHoliday(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnRspDTUtil.wrongTableException();
        }
        if (CcnRspTableUtil.parseBlockNo(ccnResponseMessage) == TIME_BLOCK) {
            boolean bl = false;
            if ((ccnResponseMessage.getResponseBuffer().getResponseData()[HOLIDAY_DOW_POSITION] & 0x10) > 0) {
                bl = true;
            }
            return bl;
        }
        throw new CcnException(6488167, "Need block " + TIME_BLOCK + " to determine isTommorowHoliday");
    }

    public boolean isTodayHoliday(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnRspDTUtil.wrongTableException();
        }
        if (CcnRspTableUtil.parseBlockNo(ccnResponseMessage) == TIME_BLOCK) {
            boolean bl = false;
            if ((ccnResponseMessage.getResponseBuffer().getResponseData()[HOLIDAY_DOW_POSITION] & 0x20) > 0) {
                bl = true;
            }
            return bl;
        }
        throw new CcnException(6488167, "Need block " + TIME_BLOCK + " to determine isTodayHoliday");
    }

    public boolean isDaylightSavingsTimeOff(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnRspDTUtil.wrongTableException();
        }
        if (CcnRspTableUtil.parseBlockNo(ccnResponseMessage) == TIME_BLOCK) {
            boolean bl = false;
            if ((ccnResponseMessage.getResponseBuffer().getResponseData()[HOLIDAY_DOW_POSITION] & 0x40) > 0) {
                bl = true;
            }
            return bl;
        }
        throw new CcnException(6488167, "Need block " + TIME_BLOCK + " to determine isDaylightSavingsTimeOff");
    }

    public boolean isDaylightSavingsTimeOn(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnRspDTUtil.wrongTableException();
        }
        if (CcnRspTableUtil.parseBlockNo(ccnResponseMessage) == TIME_BLOCK) {
            boolean bl = false;
            if ((ccnResponseMessage.getResponseBuffer().getResponseData()[HOLIDAY_DOW_POSITION] & 0x80) > 0) {
                bl = true;
            }
            return bl;
        }
        throw new CcnException(6488167, "Need block " + TIME_BLOCK + " to determine isDaylightSavingsTimeOn");
    }

    public static BAbsTime getDsDate(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnRspDTUtil.wrongTableException();
        }
        if (CcnRspTableUtil.parseBlockNo(ccnResponseMessage) == DATE_BLOCK) {
            return BAbsTime.make((int)CcnRspDTUtil.getYear(ccnResponseMessage), (BMonth)BMonth.make((int)CcnRspDTUtil.getMonth(ccnResponseMessage)), (int)CcnRspDTUtil.getDay(ccnResponseMessage));
        }
        throw new CcnException(6488167, "Need block " + DATE_BLOCK + " to getDsDate");
    }

    private static final int getDay(CcnResponseMessage ccnResponseMessage) throws CcnException {
        return ccnResponseMessage.getResponseBuffer().getResponseData()[3];
    }

    private static final int getMonth(CcnResponseMessage ccnResponseMessage) throws CcnException {
        return ccnResponseMessage.getResponseBuffer().getResponseData()[4] - 1;
    }

    private static final int getYear(CcnResponseMessage ccnResponseMessage) throws CcnException {
        return 2000 + ccnResponseMessage.getResponseBuffer().getResponseData()[5];
    }

    public static CcnTableDef getDefTimeBlock() {
        return WRITE_DT_TABLE_TIME_BLOCK;
    }

    public static CcnTableDef getDefDateBlock() {
        return WRITE_DT_TABLE_DATE_BLOCK;
    }

    public static boolean timeJustPassed(BAbsTime bAbsTime, BAbsTime bAbsTime2, BAbsTime bAbsTime3) {
        boolean bl = false;
        if (bAbsTime2.isBefore(bAbsTime) && (bAbsTime3.isAfter(bAbsTime) || bAbsTime3.timeEquals(bAbsTime))) {
            bl = true;
        }
        return bl;
    }

    public static boolean hourJustPassed(int n, BAbsTime bAbsTime, BAbsTime bAbsTime2) {
        boolean bl = false;
        if (bAbsTime2.getHour() == n && bAbsTime.getHour() != n) {
            bl = true;
        }
        return bl;
    }

    public static int getUnsolicitedTableNumber(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        CcnRspDTUtil.verifyWriteTableReq(ccnUnsolicitedMsg);
        return (char)-1 & ccnUnsolicitedMsg.getData()[TABLE_NUMBER_MSB_LOCATION] >> 8 & ccnUnsolicitedMsg.getData()[TABLE_NUMBER_LSB_LOCATION];
    }

    private static final void verifyWriteTableReq(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        if (ccnUnsolicitedMsg.getCommand() == 12) {
            return;
        }
        throw new CcnException(6488170, "Need command 12");
    }

    public static String getUnsolicitedTableName(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        if (CcnRspDTUtil.getUnsolicitedTableNumber(ccnUnsolicitedMsg) == 0) {
            return new String(ccnUnsolicitedMsg.getData(), TABLE_NAME_LOCATION, TABLE_NAME_LENGTH);
        }
        return null;
    }

    public static int getUnsolicitedTableType(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        if (CcnRspDTUtil.getUnsolicitedTableNumber(ccnUnsolicitedMsg) == (char)-1) {
            return ByteArrayUtil.readShort((byte[])ccnUnsolicitedMsg.getData(), (int)TABLE_TYPE_LOCATION_MSB);
        }
        return -1;
    }

    public static int getUnsolicitedTableInst(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        if (CcnRspDTUtil.getUnsolicitedTableNumber(ccnUnsolicitedMsg) == (char)-1) {
            return ccnUnsolicitedMsg.getData()[TABLE_INST_LOCATION] & 0xFF;
        }
        return -1;
    }

    public static int getUnsolicitedTableBlock(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        CcnRspDTUtil.verifyWriteTableReq(ccnUnsolicitedMsg);
        return ccnUnsolicitedMsg.getData()[TABLE_BLOCK_LOCATION] & 0xFF;
    }

    public static boolean isWriteToBroadcastTableByName(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        return BROADCAST_TABLE_NAME.equals(CcnRspDTUtil.getUnsolicitedTableName(ccnUnsolicitedMsg));
    }

    public static boolean isWriteToBroadcastTableByType_Inst(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        boolean bl = false;
        if (CcnRspDTUtil.getUnsolicitedTableType(ccnUnsolicitedMsg) == BROADCAST_TABLE_TYPE && CcnRspDTUtil.getUnsolicitedTableBlock(ccnUnsolicitedMsg) == BROADCAST_TABLE_BLOCK) {
            bl = true;
        }
        return bl;
    }
}

