/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.enums.BCcnDiscreteStateEnum;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnDataWrapper;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;
import javax.baja.util.ByteArrayUtil;

public abstract class CcnAlarmUtil
extends CcnRspTableUtil {
    public static int EXPECT_TBL_TYPE = 67;
    public static int EXPECT_CMD_TYPE = 30;
    public static final int HOST_ALARM_OFFSET = 5;
    public static final int BUILDING_NO_LOCATION = 3;
    public static final int DEV_SYS_NAME_LOCATION = 4;
    public static final int DEV_SYS_NAME_LENGTH_MAX = 8;
    public static final int ALARM_DESC_INDEX_LOCATION = 12;
    public static final int ALARM_CONTROL_LOCATION = 13;
    public static final int ALARM_PRIORITY_LOCATION = 14;
    public static final int VARIABLE_NAME_LOCATION = 15;
    public static final int VARIABLE_NAME_LENGTH_MAX = 8;
    public static final int VARIABLE_VALUE_LOCATION = 23;
    public static final int EXCEED_LIMIT_LOCATION = 27;
    public static final int ALARM_HOUR_LOCATION = 31;
    public static final int ALARM_MINUTE_LOCATION = 32;
    public static final int ALARM_FORMAT_LOCATION = 33;
    public static final int ALARM_FORMAT_LENGTH_MAX = 4;
    public static final int MIN_ALARM_WO_DATE_LENGTH = 38;
    public static final int ALARM_MONTH_LOCATION = 39;
    public static final int ALARM_DAY_LOCATION = 40;
    public static final int ALARM_YEAR_LOCATION = 41;
    public static final int MIN_ALARM_W_DATE_LENGTH = 42;
    public static final int SNAP_SHOT_LOCATION = 42;
    public static final int MIN_EXTENDED_ALARM_LENGTH = 43;
    public static final int TABLE_NAME_LOCATION = 44;
    public static final int TABLE_NAME_LENGTH_MAX = 8;
    public static final int ALARM_TEXT_LOCATION = 52;
    public static final int MIN_EXTENDED_ALARM_TEXT_LENGTH = 53;
    private static final int RETURN_TO_NORMAL = 7;
    private static final int ALARM_PRIORITY_TYPE_MASK = 128;
    private static final int ALARM_PRIORITY_TYPE_SHIFT = 7;
    private static final int ALARM_PRIORITY_SOURCE_MASK = 112;
    private static final int ALARM_PRIORITY_SOURCE_SHIFT = 4;

    private static final CcnException wrongUnsolicitedCommandTypeException() {
        return new CcnException(6488170, "Method needs unsolicited message with command " + EXPECT_CMD_TYPE + '.');
    }

    private static final CcnException wrongDataWrapperException() {
        return new CcnException(6488173, "Method needs either an unsolicited alarm message or a ccn response to a read alarm table request.");
    }

    private static final CcnException wrongTableException() {
        return new CcnException(6488168, "Method needs table " + EXPECT_TBL_TYPE + '.');
    }

    private static final void verifyWrapperType(CcnDataWrapper ccnDataWrapper) throws CcnException {
        if (ccnDataWrapper instanceof CcnUnsolicitedMsg) {
            CcnAlarmUtil.verifyCommandType((CcnUnsolicitedMsg)ccnDataWrapper);
        } else if (ccnDataWrapper instanceof CcnResponseMessage) {
            CcnAlarmUtil.verifyTableType((CcnResponseMessage)ccnDataWrapper);
        } else {
            throw CcnAlarmUtil.wrongDataWrapperException();
        }
    }

    private static final void verifyTableType(CcnResponseMessage ccnResponseMessage) throws CcnException {
        if (ccnResponseMessage.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnAlarmUtil.wrongTableException();
        }
    }

    private static final void verifyCommandType(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        if (ccnUnsolicitedMsg.getCommand() != EXPECT_CMD_TYPE) {
            throw CcnAlarmUtil.wrongUnsolicitedCommandTypeException();
        }
    }

    private static final void verifyStandardAlarmWithDate(CcnDataWrapper ccnDataWrapper) throws CcnException {
        if (ccnDataWrapper.getData().length < 42) {
            throw new CcnException(6488171, "Cannot proceed because the alarm is not a standard alarm with date.");
        }
    }

    private static final void verifyExtendedAlarm(CcnDataWrapper ccnDataWrapper) throws CcnException {
        if (ccnDataWrapper.getData().length < 43) {
            throw new CcnException(6488172, "Cannot proceed because the alarm is not an extended alarm.");
        }
    }

    public static int getBuildingNumber(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ccnDataWrapper.getData()[3];
    }

    public static String getDeviceOrSystemName(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return new String(ccnDataWrapper.getData(), 4, 8).trim();
    }

    public static int getAlarmDescIndex(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ccnDataWrapper.getData()[12];
    }

    public static int getAlarmControl(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ccnDataWrapper.getData()[13];
    }

    public static int getAlarmPriority(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ccnDataWrapper.getData()[14];
    }

    public static String getVariableName(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return new String(ccnDataWrapper.getData(), 15, 8).trim();
    }

    private static final int intFrom2Bytes(byte[] byArray, int n) {
        return ByteArrayUtil.readShort((byte[])byArray, (int)n);
    }

    public static float getVariableValue(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ByteArrayUtil.readLong((byte[])ccnDataWrapper.getData(), (int)23);
    }

    public static float getExceedLimit(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ByteArrayUtil.readLong((byte[])ccnDataWrapper.getData(), (int)27);
    }

    public static int getAlarmHour(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ccnDataWrapper.getData()[31];
    }

    public static int getAlarmMinute(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        return ccnDataWrapper.getData()[32];
    }

    public static BTime getAlarmDsTime(CcnDataWrapper ccnDataWrapper) throws CcnException {
        return BTime.make((int)CcnAlarmUtil.getAlarmHour(ccnDataWrapper), (int)CcnAlarmUtil.getAlarmMinute(ccnDataWrapper), (int)0, (int)0);
    }

    public static boolean isValueMetric(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        byte by = ccnDataWrapper.getData()[33];
        boolean bl = false;
        if ((by & 0x80) == 128) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValueDiscrete(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        byte by = ccnDataWrapper.getData()[35];
        boolean bl = false;
        if ((by & 0x80) == 128) {
            bl = true;
        }
        return bl;
    }

    public static String getFormattedValue(CcnDataWrapper ccnDataWrapper, boolean bl, boolean bl2) throws CcnException {
        StringBuffer stringBuffer = new StringBuffer();
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        float f = !bl ? CcnAlarmUtil.getVariableValue(ccnDataWrapper) : CcnAlarmUtil.getExceedLimit(ccnDataWrapper);
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[n] = ccnDataWrapper.getData()[33 + n];
            ++n;
        }
        if (CcnAlarmUtil.isValueDiscrete(ccnDataWrapper)) {
            n = 0;
            n = (double)f == 0.0 ? 0 : 1;
            String string = CcnEnumsUtil.setProperDiscreteOffset(BCcnDiscreteStateEnum.parseId(byArray[1] & 0x3F, n));
            stringBuffer.append(string);
        } else {
            String string;
            n = byArray[1] & 0xF;
            int n2 = byArray[1] >>> 4 & 0xF;
            int n3 = byArray[3] & 0xFF;
            String string2 = CcnAlarmUtil.formatFloatString(f, n2, n);
            if (bl2) {
                string2 = CcnRspPicPocUtil.toMetric(n, n3, string2);
            }
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            String string3 = string = CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(n3, bl2));
            if (string3.equalsIgnoreCase("none0")) {
                string3 = "";
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String formatFloatString(float var0, int var1_1, int var2_2) {
        var3_3 = new Float(var0);
        var4_4 = var3_3.intValue();
        var3_3 = new Float(Math.abs(var0 - (float)var4_4) * 1.0E7f);
        var5_5 = var3_3.intValue();
        var6_6 = new Integer(var4_4).toString();
        var7_7 = new Integer(var5_5).toString();
        if (var2_2 != 0) ** GOTO lbl10
        return var6_6;
lbl-1000:
        // 1 sources

        {
            var7_7 = var7_7 + '0';
lbl10:
            // 2 sources

            ** while (var7_7.length() < var2_2)
        }
lbl11:
        // 1 sources

        var7_7 = var7_7.substring(0, var2_2);
        return var6_6 + '.' + var7_7;
    }

    public static int getAlarmMonth(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        CcnAlarmUtil.verifyStandardAlarmWithDate(ccnDataWrapper);
        return ccnDataWrapper.getData()[39] - 1;
    }

    public static int getAlarmDay(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        CcnAlarmUtil.verifyStandardAlarmWithDate(ccnDataWrapper);
        return ccnDataWrapper.getData()[40];
    }

    public static int getAlarmYear(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        CcnAlarmUtil.verifyStandardAlarmWithDate(ccnDataWrapper);
        return Clock.time().getYear() / 100 * 100 + ccnDataWrapper.getData()[41];
    }

    public static BAbsTime getAlarmDsDate(CcnDataWrapper ccnDataWrapper) throws CcnException {
        int n = CcnAlarmUtil.getAlarmYear(ccnDataWrapper);
        int n2 = CcnAlarmUtil.getAlarmMonth(ccnDataWrapper);
        int n3 = CcnAlarmUtil.getAlarmDay(ccnDataWrapper);
        if (n == 2000 && n2 == -1 && n3 == 0) {
            throw new CcnException(6488171, "Cannot proceed because the alarm is not a standard alarm with date.");
        }
        return BAbsTime.make((int)n, (BMonth)BMonth.make((int)n2), (int)n3);
    }

    public static int getSnapShotDataTable(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        CcnAlarmUtil.verifyExtendedAlarm(ccnDataWrapper);
        return CcnAlarmUtil.intFrom2Bytes(ccnDataWrapper.getData(), 42);
    }

    public static String getTableName(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        CcnAlarmUtil.verifyExtendedAlarm(ccnDataWrapper);
        return new String(ccnDataWrapper.getData(), 44, 8).trim();
    }

    public static String getAlarmText(CcnDataWrapper ccnDataWrapper) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(ccnDataWrapper);
        CcnAlarmUtil.verifyExtendedAlarm(ccnDataWrapper);
        if (ccnDataWrapper.getData().length < 53) {
            return "";
        }
        return new String(ccnDataWrapper.getData(), 52, ccnDataWrapper.getData().length - 52).trim();
    }

    public static String getCustomAlarmText(CcnDataWrapper ccnDataWrapper, boolean bl) throws CcnException {
        String string = CcnAlarmUtil.getAlarmText(ccnDataWrapper);
        if (string.length() != 0) {
            String string2;
            String string3;
            int n = string.indexOf("#1");
            while (n != -1) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 2);
                string = string3 + CcnAlarmUtil.getTableName(ccnDataWrapper) + string2;
                n = string.indexOf("#1");
            }
            n = string.indexOf("#2");
            while (n != -1) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 2);
                string = string3 + CcnAlarmUtil.getVariableName(ccnDataWrapper) + string2;
                n = string.indexOf("#2");
            }
            n = string.indexOf("#3");
            while (n != -1) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 2);
                string = string3 + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, false, bl) + string2;
                n = string.indexOf("#3");
            }
            n = string.indexOf("#4");
            while (n != -1) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 2);
                string = string3 + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, true, bl) + string2;
                n = string.indexOf("#4");
            }
        }
        return string;
    }

    public static String getIndexedText(CcnDataWrapper ccnDataWrapper, boolean bl) throws CcnException {
        int n = CcnAlarmUtil.getAlarmDescIndex(ccnDataWrapper);
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "discrete state";
            }
            case 2: {
                return "total time exceeds " + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, true, bl);
            }
            case 3: {
                return "starts, limit is " + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, true, bl);
            }
            case 4: {
                return "commanded state is " + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, true, bl);
            }
            case 5: {
                return "safety chain first out";
            }
            case 6: {
                return "interlock " + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, true, bl);
            }
            case 7: {
                return "outside limit of " + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, true, bl);
            }
            case 8: {
                return "interlocked, exceeds limit of " + CcnAlarmUtil.getFormattedValue(ccnDataWrapper, true, bl);
            }
            case 9: {
                return "IO channel failure";
            }
            case 10: {
                return "has illegal configuration";
            }
            case 11: {
                return "additional cooling capacity required";
            }
            case 12: {
                return "communications error";
            }
            case 13: {
                return "clock error";
            }
            case 14: {
                return "alarm buffer full";
            }
            case 15: {
                return "directory not available";
            }
        }
        return "";
    }

    public static String getAlarmState(CcnDataWrapper ccnDataWrapper) throws CcnException {
        if (CcnAlarmUtil.getSourceInt(ccnDataWrapper) == 7) {
            return "Return to Normal";
        }
        return CcnAlarmUtil.getTypeDesc(ccnDataWrapper);
    }

    public static final BAlarmState getToStateEnum(CcnDataWrapper ccnDataWrapper) throws CcnException {
        return CcnAlarmUtil.isRTN(ccnDataWrapper) ? BAlarmState.normal : BAlarmState.offnormal;
    }

    public static final BAlarmState getFromStateEnum(CcnDataWrapper ccnDataWrapper) throws CcnException {
        return CcnAlarmUtil.isRTN(ccnDataWrapper) ? BAlarmState.offnormal : BAlarmState.normal;
    }

    public static int getTypeInt(CcnDataWrapper ccnDataWrapper) throws CcnException {
        int n = CcnAlarmUtil.getAlarmPriority(ccnDataWrapper);
        int n2 = (0x80 & n) >> 7;
        return n2;
    }

    public static String getTypeDesc(CcnDataWrapper ccnDataWrapper) throws CcnException {
        return CcnAlarmUtil.getTypeInt(ccnDataWrapper) == 0 ? "Alarm" : "Alert";
    }

    public static int getSourceInt(CcnDataWrapper ccnDataWrapper) throws CcnException {
        int n = CcnAlarmUtil.getAlarmPriority(ccnDataWrapper);
        int n2 = (n & 0x70) >> 4;
        return n2;
    }

    public static String getSourceDesc(CcnDataWrapper ccnDataWrapper) throws CcnException {
        int n = CcnAlarmUtil.getSourceInt(ccnDataWrapper);
        String string = "";
        switch (n) {
            case 1: {
                string = "Critical";
                break;
            }
            case 2: {
                string = "Service";
                break;
            }
            case 3: {
                string = "reserved";
                break;
            }
            case 4: {
                string = "Maintenance";
                break;
            }
            case 5: {
                string = "reserved";
                break;
            }
            case 6: {
                string = "Control loop problem";
                break;
            }
            case 7: {
                string = "Return to Normal";
                break;
            }
        }
        return string;
    }

    public static boolean isRTN(CcnDataWrapper ccnDataWrapper) throws CcnException {
        int n = CcnAlarmUtil.getAlarmPriority(ccnDataWrapper);
        boolean bl = false;
        if ((n & 0x70) >> 4 == 7) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAlarmNotification(CcnDataWrapper ccnDataWrapper) throws CcnException {
        if (CcnAlarmUtil.isRTN(ccnDataWrapper)) {
            return false;
        }
        int n = CcnAlarmUtil.getAlarmPriority(ccnDataWrapper);
        boolean bl = false;
        if ((n & 0x80) >> 7 == 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRecurring(CcnDataWrapper ccnDataWrapper) throws CcnException {
        int n = CcnAlarmUtil.getAlarmPriority(ccnDataWrapper);
        boolean bl = false;
        if ((n & 4) > 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAlertNotification(CcnDataWrapper ccnDataWrapper) throws CcnException {
        if (CcnAlarmUtil.isRTN(ccnDataWrapper)) {
            return false;
        }
        int n = CcnAlarmUtil.getAlarmPriority(ccnDataWrapper);
        boolean bl = false;
        if ((n & 0x80) >> 7 == 1) {
            bl = true;
        }
        return bl;
    }

    public static int getAlarmLevel(CcnDataWrapper ccnDataWrapper) throws CcnException {
        int n = CcnAlarmUtil.getAlarmPriority(ccnDataWrapper);
        return (n & 0x70) >> 4;
    }

    public static String getAlarmConsoleSummary(CcnUnsolicitedMsg ccnUnsolicitedMsg, boolean bl) throws CcnException {
        return CcnAlarmUtil.getAlarmTextSummary((CcnDataWrapper)ccnUnsolicitedMsg, ccnUnsolicitedMsg.getSrcAddr(), ccnUnsolicitedMsg.getSrcBus()) + ' ' + CcnAlarmUtil.getAlarmTextDetail((CcnDataWrapper)ccnUnsolicitedMsg, bl);
    }

    public static String getAlarmTextSummary(CcnDataWrapper ccnDataWrapper, int n, int n2) throws CcnException {
        StringBuffer stringBuffer;
        block6: {
            stringBuffer = new StringBuffer();
            stringBuffer.append(CcnAlarmUtil.getDeviceOrSystemName(ccnDataWrapper) + ' ');
            stringBuffer.append("" + n2 + ',' + n + ' ');
            if (CcnAlarmUtil.isRTN(ccnDataWrapper)) {
                stringBuffer.append(" RETURN TO NORMAL at ");
            } else if (CcnAlarmUtil.isAlarmNotification(ccnDataWrapper)) {
                stringBuffer.append("ALARM - " + CcnAlarmUtil.getAlarmLevel(ccnDataWrapper) + " at ");
            } else {
                stringBuffer.append("ALERT - " + CcnAlarmUtil.getAlarmLevel(ccnDataWrapper) + " at ");
            }
            stringBuffer.append("" + CcnAlarmUtil.getAlarmDsTime(ccnDataWrapper) + ' ');
            try {
                stringBuffer.append("" + CcnAlarmUtil.getAlarmDsDate(ccnDataWrapper) + ' ');
            }
            catch (CcnException ccnException) {
                if (ccnException.getCode() == 6488171) break block6;
                throw ccnException;
            }
        }
        return stringBuffer.toString();
    }

    public static String getAlarmTextDetail(CcnDataWrapper ccnDataWrapper, boolean bl) throws CcnException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = CcnAlarmUtil.getAlarmDescIndex(ccnDataWrapper);
        if (n > 0 && n < 16) {
            stringBuffer.append(CcnAlarmUtil.getVariableName(ccnDataWrapper) + ' ');
            stringBuffer.append(CcnAlarmUtil.getFormattedValue(ccnDataWrapper, false, bl) + ' ');
            stringBuffer.append(CcnAlarmUtil.getIndexedText(ccnDataWrapper, bl) + ' ');
        } else if (n == 0 || n > 15) {
            stringBuffer.append(CcnAlarmUtil.getCustomAlarmText(ccnDataWrapper, bl));
        }
        return stringBuffer.toString();
    }
}

