/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BFidPointConfig;
import com.tridium.ccn.components.BFidPointList;
import com.tridium.ccn.enums.BCcnAlarmStatusEnum;
import com.tridium.ccn.enums.BCcnForceStatusEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnAddFidPointsJob;
import com.tridium.ccn.job.BCcnLearnFidPointsJob;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnNonForcableProxy;
import com.tridium.ccn.point.BCcnOutputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcnFidTable
extends BCcnTable {
    public static final Property pointList = BCcnFidTable.newProperty((int)4, (BValue)new BCcnPointList(), null);
    public static final Property fidPointList = BCcnFidTable.newProperty((int)4, (BValue)new BFidPointList(), null);
    public static final Property pointLearnCount = BCcnFidTable.newProperty((int)1, (int)0, null);
    public static final Property pointCreateCount = BCcnFidTable.newProperty((int)1, (int)0, null);
    public static final Property setpointType = BCcnFidTable.newProperty((int)0, (int)0, null);
    public static final Property learnedTimeSchedules = BCcnFidTable.newProperty((int)4, (BValue)new BFolder(), null);
    public static final Action submitFidPointDiscoveryJob = BCcnFidTable.newAction((int)4, null);
    public static final Action submitAddFidPointsJob = BCcnFidTable.newAction((int)4, (BValue)new BCcnPointList(), null);
    public static final Type TYPE;
    private boolean changingDisplay;
    BCcnTableEntry entry;
    BCcnNetwork network;
    static /* synthetic */ Class class$com$tridium$ccn$tables$BCcnFidTable;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnPointEntry;
    static /* synthetic */ Class class$com$tridium$ccn$components$BFidPointConfig;

    public BCcnPointList getPointList() {
        return (BCcnPointList)this.get(pointList);
    }

    public void setPointList(BCcnPointList bCcnPointList) {
        this.set(pointList, (BValue)bCcnPointList, null);
    }

    public BFidPointList getFidPointList() {
        return (BFidPointList)this.get(fidPointList);
    }

    public void setFidPointList(BFidPointList bFidPointList) {
        this.set(fidPointList, (BValue)bFidPointList, null);
    }

    public int getPointLearnCount() {
        return this.getInt(pointLearnCount);
    }

    public void setPointLearnCount(int n) {
        this.setInt(pointLearnCount, n, null);
    }

    public int getPointCreateCount() {
        return this.getInt(pointCreateCount);
    }

    public void setPointCreateCount(int n) {
        this.setInt(pointCreateCount, n, null);
    }

    public int getSetpointType() {
        return this.getInt(setpointType);
    }

    public void setSetpointType(int n) {
        this.setInt(setpointType, n, null);
    }

    public BFolder getLearnedTimeSchedules() {
        return (BFolder)this.get(learnedTimeSchedules);
    }

    public void setLearnedTimeSchedules(BFolder bFolder) {
        this.set(learnedTimeSchedules, (BValue)bFolder, null);
    }

    public BOrd submitFidPointDiscoveryJob() {
        return (BOrd)this.invoke(submitFidPointDiscoveryJob, null, null);
    }

    public BOrd submitAddFidPointsJob(BCcnPointList bCcnPointList) {
        return (BOrd)this.invoke(submitAddFidPointsJob, (BValue)bCcnPointList, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        try {
            BCcnPointEntry[] bCcnPointEntryArray;
            super.started();
            int[] nArray = new int[64];
            BCcnProxyExt[] bCcnProxyExtArray = this.getCreatedPoints();
            BCcnPointList bCcnPointList = this.getPointList();
            Class clazz = class$com$tridium$ccn$components$BCcnPointEntry;
            if (clazz == null) {
                clazz = class$com$tridium$ccn$components$BCcnPointEntry = BCcnFidTable.class("[Lcom.tridium.ccn.components.BCcnPointEntry;", false);
            }
            if ((bCcnPointEntryArray = (BCcnPointEntry[])bCcnPointList.getChildren(clazz)).length != 0 && this.getTableType() == 1281) {
                int n = 0;
                while (n < bCcnPointEntryArray.length) {
                    int n2 = bCcnPointEntryArray[n].getFieldIndex();
                    if (bCcnProxyExtArray[n2] != null) {
                        if (bCcnProxyExtArray[n2] instanceof BCcnOutputProxy || bCcnProxyExtArray[n2] instanceof BCcnNonForcableProxy) {
                            nArray[n2] = !((BCcnOutputProxy)bCcnProxyExtArray[n2]).isCommandable() ? 1 : 0;
                        }
                    } else {
                        nArray[n2] = 0;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public boolean isChildLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BCcnPicTable || bComponent instanceof BCcnPocTable || bComponent instanceof BCcnDataTable) {
            throw new LocalizableRuntimeException("ccn", "CcnPicTable, CcnPocTable and CcnDataTable nodes may not be under a CcnFidTable node");
        }
        return true;
    }

    public BOrd doSubmitFidPointDiscoveryJob() {
        BCcnLearnFidPointsJob bCcnLearnFidPointsJob = new BCcnLearnFidPointsJob(this);
        return bCcnLearnFidPointsJob.submit(null);
    }

    public BOrd doSubmitAddFidPointsJob(BCcnPointList bCcnPointList) {
        BCcnAddFidPointsJob bCcnAddFidPointsJob = new BCcnAddFidPointsJob(this, bCcnPointList);
        return bCcnAddFidPointsJob.submit(null);
    }

    public void pollForData() {
        BCcnDevice bCcnDevice = this.getCcnDevice();
        if (this.getCCNNetwork().isDiscoveryInProgress() || !bCcnDevice.isRunning() || this.getCCNNetwork().isChangingDisplay() || this.changingDisplay || this.getPointCreateCount() == 0) {
            return;
        }
        BCcnPointList bCcnPointList = this.getPointList();
        Class clazz = class$com$tridium$ccn$components$BCcnPointEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnPointEntry = BCcnFidTable.class("[Lcom.tridium.ccn.components.BCcnPointEntry;", false);
        }
        BCcnPointEntry[] bCcnPointEntryArray = (BCcnPointEntry[])bCcnPointList.getChildren(clazz);
        int n = this.getTableType();
        int n2 = this.getTableInstance();
        long l = BAbsTime.now().getTimeOfDayMillis();
        if (this.vPollAttributeProxyExts.size() == 0) {
            return;
        }
        if (n == 1281) {
            CcnResponseMessage ccnResponseMessage = this.getReadTableResponse(1280, 1, 6);
            this.ccnTablesLog.trace(this.getTableName() + " Poll Resposne for tabletype::" + n + "is" + (Object)((Object)ccnResponseMessage));
            if (ccnResponseMessage == null) {
                return;
            }
            this.commSuccess(true);
            this.ccnSubscribedPointLog.trace("Number of subscribed points-->::Device::" + bCcnDevice.getDeviceName() + "::Table-->" + this.getTableName() + " are::" + this.vPollAttributeProxyExts.size());
            int n3 = 0;
            while (n3 < this.vPollAttributeProxyExts.size()) {
                BCcnProxyExt bCcnProxyExt = (BCcnProxyExt)this.vPollAttributeProxyExts.get(n3);
                if (bCcnProxyExt != null && bCcnProxyExt instanceof BCcnInputProxy) {
                    try {
                        String string;
                        byte by = 0;
                        byte by2 = 0;
                        String string2 = "";
                        BFidPointConfig bFidPointConfig = this.getFidConfig(bCcnProxyExt.getFieldIndex());
                        if (bFidPointConfig != null) {
                            string2 = bFidPointConfig.getEUC();
                        }
                        if ((string = CcnRspFidUtil.getValue(ccnResponseMessage, bCcnProxyExt.getFieldIndex(), string2, bCcnProxyExt.getDisplayDigits())) == null) {
                            string = "0";
                        }
                        by2 = CcnRspFidUtil.getStatus(ccnResponseMessage, bCcnProxyExt.getFieldIndex());
                        BCcnAlarmStatusEnum bCcnAlarmStatusEnum = BCcnAlarmStatusEnum.make(by2);
                        ((BCcnInputProxy)bCcnProxyExt).setValue(string);
                        by = CcnRspFidUtil.getForceLevel(ccnResponseMessage, bCcnProxyExt.getFieldIndex());
                        bCcnProxyExt.setForceLevel(CcnEnumsUtil.setProperForceLevel(BCcnForceStatusEnum.make(by).getTag()));
                        if (by == 4) {
                            ((BCcnInputProxy)bCcnProxyExt).setOverridden(true);
                        } else {
                            ((BCcnInputProxy)bCcnProxyExt).setOverridden(false);
                        }
                        String string3 = bCcnAlarmStatusEnum.getTag().equalsIgnoreCase("normal") ? "" : (bCcnAlarmStatusEnum.getTag().equalsIgnoreCase("HardwareCommError") ? "COMM..." : bCcnAlarmStatusEnum.getTag());
                        ((BCcnInputProxy)bCcnProxyExt).setFieldStatus(string3);
                    }
                    catch (CcnException ccnException) {
                        this.ccnTablesLog.error("<CcnFidTable: Fid table get No." + bCcnProxyExt.getFieldIndex() + " field from block 6 ERROR: " + (Object)((Object)ccnException));
                    }
                }
                ++n3;
            }
        } else {
            CcnResponseMessage ccnResponseMessage = null;
            if (n == 1284 || n == 1283 || n == 1285) {
                ccnResponseMessage = this.getReadTableResponse(2);
                this.ccnTablesLog.trace(this.getTableName() + " Poll Resposne for tabletype::" + n + "is" + (Object)((Object)ccnResponseMessage));
                if (ccnResponseMessage == null || this.vPollAttributeProxyExts.size() == 0) {
                    return;
                }
                this.ccnSubscribedPointLog.trace("Number of subscribed points-->::Device::" + bCcnDevice.getDeviceName() + "::Table-->" + this.getTableName() + " are::" + this.vPollAttributeProxyExts.size());
                int n4 = 0;
                while (n4 < this.vPollAttributeProxyExts.size()) {
                    try {
                        BCcnProxyExt bCcnProxyExt = (BCcnProxyExt)this.vPollAttributeProxyExts.get(n4);
                        if (bCcnProxyExt != null && bCcnProxyExt instanceof BCcnInputProxy) {
                            ((BCcnInputProxy)bCcnProxyExt).setValue(CcnRspFidUtil.getValue(ccnResponseMessage, bCcnProxyExt));
                        }
                    }
                    catch (Exception exception) {
                        this.ccnTablesLog.error("FID Poll value for device->" + bCcnDevice.getName() + ", table->" + this.getName() + ", point->" + bCcnPointEntryArray[n4].getFieldName() + " error::" + exception.getMessage());
                    }
                    ++n4;
                }
            }
        }
        long l2 = BAbsTime.now().getTimeOfDayMillis();
        this.ccnTimeLog.trace("FID_TABLE PollForData Device->" + bCcnDevice.getName() + ", table->" + this.getTableName() + ", polltime::" + (l2 - l) + " milliseconds");
    }

    private final BFidPointConfig getFidConfig(int n) {
        BFidPointConfig[] bFidPointConfigArray;
        BFidPointList bFidPointList = this.getFidPointList();
        Class clazz = class$com$tridium$ccn$components$BFidPointConfig;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BFidPointConfig = BCcnFidTable.class("[Lcom.tridium.ccn.components.BFidPointConfig;", false);
        }
        if ((bFidPointConfigArray = (BFidPointConfig[])bFidPointList.getChildren(clazz)) != null) {
            int n2 = 0;
            while (n2 < bFidPointConfigArray.length) {
                if (bFidPointConfigArray[n2].getPointIndex() == n) {
                    return bFidPointConfigArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public void setProxyValueFromEntry(BCcnPointEntry bCcnPointEntry, BCcnInputProxy bCcnInputProxy) {
        bCcnInputProxy.setValue(bCcnPointEntry.getPointValue());
        bCcnInputProxy.setForceLevel(CcnEnumsUtil.setProperForceLevel(bCcnPointEntry.getForceLevel().getTag()));
        bCcnInputProxy.setHiLimit(bCcnPointEntry.getHiLimit());
        bCcnInputProxy.setLoLimit(bCcnPointEntry.getLoLimit());
        bCcnInputProxy.setHiLimitBlock(bCcnPointEntry.getHiLimitBlock());
        bCcnInputProxy.setLoLimitBlock(bCcnPointEntry.getLoLimitBlock());
        bCcnInputProxy.setUnits(bCcnPointEntry.getUnits());
        bCcnInputProxy.setUnitsEnum(bCcnPointEntry.getUnitsEnum());
    }

    public CcnResponseMessage getReadTableResponse(int n, int n2, int n3) {
        BCcnDevice bCcnDevice = this.getCcnDevice();
        int n4 = bCcnDevice.getBusNo();
        int n5 = bCcnDevice.getElemNo();
        this.network = this.getCCNNetwork();
        CcnResponseMessage ccnResponseMessage = new CcnResponseMessage();
        int n6 = 0;
        while (n6 < 3) {
            CcnTableDef ccnTableDef = new CcnTableDef((byte)n5, (byte)n4, null, (short)n, (byte)n2, (byte)n3, 0, 0);
            CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(ccnTableDef);
            ccnResponseMessage = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
            if (ccnResponseMessage != null && ccnResponseMessage.getResponseCommand() == 6 && n3 == ccnResponseMessage.getBlock() && n2 == ccnResponseMessage.getTableInstance() && n == ccnResponseMessage.getTableType()) {
                return ccnResponseMessage;
            }
            ++n6;
        }
        return null;
    }

    public BCcnPointEntry[] createDefaultTSConfigTable() {
        BCcnPointEntry[] bCcnPointEntryArray = new BCcnPointEntry[21];
        String[] stringArray = new String[]{"TS01", "TS02", "TS03", "TS04", "TS05", "TS06", "TS07", "TS08", "TS09", "TS10", "TS11", "TS12", "TS13", "TS14", "TS15", "TS16", "TS17", "TS18", "TS19", "TS20", "TS21"};
        String[] stringArray2 = new String[]{"Period 1: Occupied from", "Period 1: Occupied to", "Period 1: Day of Week", "Period 2: Occupied from", "Period 2: Occupied to", "Period 2: Day of Week", "Period 3: Occupied from", "Period 3: Occupied to", "Period 3: Day of Week", "Period 4: Occupied from", "Period 4: Occupied to", "Period 4: Day of Week", "Period 5: Occupied from", "Period 5: Occupied to", "Period 5: Day of Week", "Period 6: Occupied from", "Period 6: Occupied to", "Period 6: Day of Week", "Period 7: Occupied from", "Period 7: Occupied to", "Period 7: Day of Week"};
        int n = 0;
        while (n < 21) {
            BCcnPointEntry bCcnPointEntry;
            bCcnPointEntryArray[n] = bCcnPointEntry = new BCcnPointEntry(n, stringArray[n], 12, false, 0, 1, 0, 0, 0, "", 2, n, 0, 0, "", 0, 0, "", 0, 0, 0, stringArray2[n], false, "");
            bCcnPointEntryArray[n + 1] = bCcnPointEntry = new BCcnPointEntry(n + 1, stringArray[n + 1], 12, false, 0, 1, 0, 0, 0, "", 2, n + 1, 0, 0, "", 0, 0, "", 0, 0, 0, stringArray2[n + 1], false, "");
            bCcnPointEntryArray[n + 2] = bCcnPointEntry = new BCcnPointEntry(n + 2, stringArray[n + 2], 0, false, -128, 1, 0, 0, 0, "", 2, n + 2, 0, 0, "0", 0, 0, "255", 0, 0, 0, stringArray2[n + 2], false, "");
            n += 3;
        }
        return bCcnPointEntryArray;
    }

    public BCcnPointEntry[] createDefaultHolConfigTable() {
        BCcnPointEntry[] bCcnPointEntryArray = new BCcnPointEntry[60];
        int n = 0;
        while (n < 30) {
            BCcnPointEntry bCcnPointEntry;
            bCcnPointEntryArray[n * 2] = bCcnPointEntry = new BCcnPointEntry(n * 2, "HOL" + CcnRspFidUtil.get2DigString(n * 2 + 1), 1, false, 32, 1, 0, 3, 0, "", 2, n * 2, 0, 0, "1", 0, 0, "12", 0, 0, 0, "Holiday " + (n + 1) + " - Month", false, "");
            bCcnPointEntryArray[n * 2 + 1] = bCcnPointEntry = new BCcnPointEntry(n * 2 + 1, "HOL" + CcnRspFidUtil.get2DigString(n * 2 + 2), 1, false, 32, 1, 0, 0, 0, "", 2, n * 2 + 1, 0, 0, "1", 0, 0, "31", 0, 0, 0, "Holiday " + (n + 1) + " - Day", false, "");
            ++n;
        }
        return bCcnPointEntryArray;
    }

    public CcnResponseMessage[] interrogateTableForPointData(int n, int n2, int n3, int n4, int n5) {
        BCcnDevice bCcnDevice = this.getCcnDevice();
        CcnResponseMessage[] ccnResponseMessageArray = new CcnResponseMessage[n5];
        if (!bCcnDevice.isDeviceFID()) {
            int n6 = 2;
            while (n6 <= n5) {
                if ((20 > n3 || n3 > 22) && n3 != 24 || n6 != 5 && n6 != 9) {
                    bCcnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                    ccnResponseMessageArray[n6 - 1] = this.getBlockDataFromTable(n, n2, n3, n4, n6);
                }
                ++n6;
            }
        } else {
            int n7 = 1;
            while (n7 <= n5) {
                if (n7 != 1 || n3 == 1281) {
                    bCcnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                    ccnResponseMessageArray[n7 - 1] = this.getBlockDataFromTable(n, n2, n3, n4, n7);
                    if (ccnResponseMessageArray[n7 - 1] == null) {
                        return null;
                    }
                }
                ++n7;
            }
        }
        return ccnResponseMessageArray;
    }

    private final CcnResponseMessage getBlockDataFromTable(int n, int n2, int n3, int n4, int n5) {
        CcnResponseMessage ccnResponseMessage = new CcnResponseMessage();
        int n6 = 0;
        while (n6 < 3) {
            ccnResponseMessage = new CcnResponseMessage();
            CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)n2, (byte)n, null, (short)n3, (byte)n4, (byte)n5, 0, 0));
            ccnResponseMessage = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
            if (ccnResponseMessage != null && ccnResponseMessage.getResponseCommand() == 21) {
                return ccnResponseMessage;
            }
            if (ccnResponseMessage != null && ccnResponseMessage.getResponseCommand() == 6 && n5 == ccnResponseMessage.getBlock() && n4 == ccnResponseMessage.getTableInstance() && n3 == ccnResponseMessage.getTableType()) {
                return ccnResponseMessage;
            }
            ++n6;
        }
        if (ccnResponseMessage != null) {
            this.ccnTablesLog.trace("\n****  createTablesRequest... return from block read, device: " + n + ',' + n2 + " for table= " + Integer.toHexString(n3) + ',' + n4 + " curBlock= " + n5 + " blockLen= " + ccnResponseMessage.getBlockLen());
        }
        if (ccnResponseMessage == null) {
            this.ccnTablesLog.error("\n****  createTablesRequest... getBlockDataFromTable failed to get block from block read, device: " + n + ',' + n2 + " for table= " + Integer.toHexString(n3) + ',' + n4 + " curBlock= " + n5);
        }
        return ccnResponseMessage;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.changingDisplay = false;
    }

    public BCcnFidTable() {
        this.this();
    }

    public BCcnFidTable(BCcnTableEntry bCcnTableEntry) {
        super(bCcnTableEntry);
        this.this();
        this.entry = bCcnTableEntry;
        this.setTableBlockCount(bCcnTableEntry.getBlockCount());
        this.setTableInstance(bCcnTableEntry.getTableInstance());
        this.setTableName(bCcnTableEntry.getTableName());
        this.setTableNum(bCcnTableEntry.getTableNum());
        this.setTableType(bCcnTableEntry.getTableType());
        this.setTableTypeString(bCcnTableEntry.getTableTypeString());
    }

    static {
        Class clazz = class$com$tridium$ccn$tables$BCcnFidTable;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$tables$BCcnFidTable = BCcnFidTable.class("[Lcom.tridium.ccn.tables.BCcnFidTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

