/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnDataTablesJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnLearnPocTableRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnNetwork network;
    private BCcnDevice ccnDevice;
    BCcnLearnDataTablesJob job;
    private int maxTableNum;
    private Vector vt;
    private BCcnPocTable pocTable;
    Log ccnMessageLog;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnTableEntry;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnDataTable.add");
        }
        this.pocTable.setLearnStatus("Learn-> Start discovery process... disable deviceStatus and polling");
        try {
            block11: {
                try {
                    this.vt = new Vector();
                    this.pocTable.setDataTableLearnCount(0);
                    int n = this.ccnDevice.getBusNo();
                    int n2 = this.ccnDevice.getElemNo();
                    int n3 = this.pocTable.getTableType();
                    int n4 = this.pocTable.getTableInstance();
                    this.ccnMessageLog.trace("\n****  learnPocTableRequest... Interrogate device at busNo=" + n + ", elemNo=" + n2 + ", pocTableType=" + n3 + ", pocTableInstance=" + n4);
                    int n5 = this.pocTable.getDataTableType();
                    this.maxTableNum = this.ccnDevice.getMaxTableNumber();
                    int n6 = 1;
                    while (n6 <= 255) {
                        this.network.setDiscoveryInProgress(true);
                        if (this.job != null) {
                            this.job.progress((100 * n6 + 1) / 256);
                        }
                        this.pocTable.setLearnStatus("Learn-> process data table type " + n5 + " dataTableInstance " + n6);
                        this.ccnMessageLog.trace("\n****  learnPocTableRequest... Interrogate pocTable:" + n + ',' + n2 + " for table type=" + n5 + " for dataTableInstance=" + n6);
                        if (!this.interrogateDataTableInstance(n, n2, n5, n6)) break;
                        ++n6;
                    }
                    this.ccnMessageLog.trace("\n****  learnPocTableRequest... closing out learn: vt= " + this.vt.size());
                    if (this.vt.size() == 0) {
                        this.pocTable.setLearnStatus("Learn-> Assembling Table list-> No Tables found ");
                        this.pocTable.setDataTableLearnCount(0);
                        break block11;
                    }
                    this.pocTable.setLearnStatus("Learn-> Assembling Table list-> Tables found = " + this.vt.size());
                    BCcnTableEntry[] bCcnTableEntryArray = new BCcnTableEntry[this.vt.size()];
                    this.vt.copyInto((Object[])bCcnTableEntryArray);
                    int n7 = 0;
                    while (true) {
                        if (n7 >= bCcnTableEntryArray.length) {
                            this.pocTable.setDataTableLearnCount(bCcnTableEntryArray.length);
                        }
                        this.addLearnedDataTable(bCcnTableEntryArray[n7]);
                        ++n7;
                    }
                }
                catch (Exception exception) {
                    this.ccnMessageLog.error("exception received in CcnLearnPocTableRequest - " + exception);
                    exception.printStackTrace();
                }
            }
            Object var2_12 = null;
        }
        catch (Throwable throwable) {
            Object var2_11 = null;
            this.pocTable.setLearnStatus("Learn-> Complete");
            this.pocTable.setLearnStatus("Idle");
            throw throwable;
        }
        this.pocTable.setLearnStatus("Learn-> Complete");
        this.pocTable.setLearnStatus("Idle");
    }

    private final boolean interrogateDataTableInstance(int n, int n2, int n3, int n4) {
        CcnResponseMessage ccnResponseMessage = this.getBlockDataFromDataTable(n, n2, n3, n4, 1);
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            return false;
        }
        if (this.maxTableNum != 0 && ccnResponseMessage.getTableNumber() > this.maxTableNum) {
            return false;
        }
        BCcnTableEntry bCcnTableEntry = this.convertBlockDataToDataTableData(ccnResponseMessage, n3, n4, 1);
        this.vt.addElement(new BCcnTableEntry(bCcnTableEntry));
        return true;
    }

    private final BCcnTableEntry convertBlockDataToDataTableData(CcnResponseMessage ccnResponseMessage, int n, int n2, int n3) {
        BCcnTableEntry bCcnTableEntry = new BCcnTableEntry();
        try {
            bCcnTableEntry.setTableType(CcnRspTableUtil.getTableType(ccnResponseMessage));
            bCcnTableEntry.setTableTypeString(this.pocTable.getGroup().getTableGroupDescription());
            bCcnTableEntry.setTableInstance(n2);
            int n4 = ccnResponseMessage.getTableNumber();
            bCcnTableEntry.setTableNum(n4);
            String string = CcnRspTableUtil.getTableName(ccnResponseMessage).trim();
            bCcnTableEntry.setTableName(CcnRspTableUtil.getTableName(ccnResponseMessage).trim());
            int n5 = CcnRspTableUtil.getBlockCount(ccnResponseMessage);
            bCcnTableEntry.setBlockCount(n5);
            BCcnByteEntry[] bCcnByteEntryArray = new BCcnByteEntry[n5];
            BCcnByteList bCcnByteList = new BCcnByteList();
            int n6 = 0;
            while (n6 < n5) {
                bCcnByteEntryArray[n6] = new BCcnByteEntry();
                bCcnByteEntryArray[n6].setIndex(n6 + 1);
                bCcnByteEntryArray[n6].setValue(CcnRspTableUtil.getBlockAccessRights(ccnResponseMessage, n6 + 1));
                if (bCcnByteList.get("index" + n4 + bCcnByteEntryArray[n6].getIndex()) == null) {
                    bCcnByteList.add("index" + n4 + bCcnByteEntryArray[n6].getIndex(), (BValue)bCcnByteEntryArray[n6]);
                }
                ++n6;
            }
            if (this.ccnDevice.getTableAccessRights().get(SlotPath.escape((String)string) + n4) == null) {
                this.ccnDevice.getTableAccessRights().add(SlotPath.escape((String)string) + n4, (BValue)bCcnByteList);
            }
            bCcnTableEntry.setPointCount(this.pocTable.getPointLearnCount());
        }
        catch (CcnException ccnException) {
            this.ccnMessageLog.error("<CcnLearnPocTableRequest: ERROR: " + (Object)((Object)ccnException));
        }
        return bCcnTableEntry;
    }

    private final CcnResponseMessage getBlockDataFromDataTable(int n, int n2, int n3, int n4, int n5) {
        CcnResponseMessage ccnResponseMessage = null;
        int n6 = 0;
        while (n6 < 3) {
            CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)n2, (byte)n, null, (short)n3, (byte)n4, (byte)n5, 0, 0));
            ccnResponseMessage = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
            if (ccnResponseMessage != null) break;
            ++n6;
        }
        this.ccnMessageLog.error("\n****  learnPocTableRequest... return from block read, device:" + n + ',' + n2 + " for table=" + n3 + ',' + n4 + " curBlock=" + n5);
        return ccnResponseMessage;
    }

    void addLearnedDataTable(BCcnTableEntry bCcnTableEntry) {
        boolean bl = false;
        BFolder bFolder = this.pocTable.getLearnedDataTables();
        Class clazz = class$com$tridium$ccn$components$BCcnTableEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnTableEntry = CcnLearnPocTableRequest.class("[Lcom.tridium.ccn.components.BCcnTableEntry;", false);
        }
        BCcnTableEntry[] bCcnTableEntryArray = (BCcnTableEntry[])bFolder.getChildren(clazz);
        int n = 0;
        while (n < bCcnTableEntryArray.length) {
            if (bCcnTableEntryArray[n].getTableName().equalsIgnoreCase(bCcnTableEntry.getTableName()) && bCcnTableEntryArray[n].getTableNum() == bCcnTableEntry.getTableNum() && bCcnTableEntryArray[n].getTableInstance() == bCcnTableEntry.getTableInstance() && bCcnTableEntryArray[n].getTableType() == bCcnTableEntry.getTableType()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.pocTable.getLearnedDataTables().add(SlotPath.escape((String)(bCcnTableEntry.getTableName().trim() + '_' + bCcnTableEntry.getTableType() + '_' + bCcnTableEntry.getTableNum() + '_' + bCcnTableEntry.getTableInstance() + '_' + bCcnTableEntry.getTableTypeString())), (BValue)bCcnTableEntry);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pocTable = null;
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnLearnPocTableRequest(BCcnPocTable bCcnPocTable) {
        this.this();
        this.pocTable = bCcnPocTable;
        this.ccnDevice = this.pocTable.getCcnDevice();
        this.network = this.ccnDevice.getCcnNetwork();
    }

    public CcnLearnPocTableRequest(BCcnDevice bCcnDevice, BCcnPocTable bCcnPocTable, BCcnLearnDataTablesJob bCcnLearnDataTablesJob) {
        this.this();
        this.job = bCcnLearnDataTablesJob;
        this.pocTable = bCcnPocTable;
        this.ccnDevice = bCcnDevice;
        this.network = bCcnDevice.getCcnNetwork();
    }
}

