/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnBridgesEntry;
import com.tridium.ccn.components.BCcnBridgesList;
import com.tridium.ccn.components.BCcnControllerEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnDevicesJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadObjectDataRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnRequestMessage;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDevUtil;
import com.tridium.platCcn.CcnObjectDef;
import com.tridium.platCcn.CcnTableDef;
import java.io.OutputStream;
import java.util.Vector;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnLearnNetworkRequest
extends CcnRequestMessage
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnNetwork ccnNetwork;
    private Vector vector;
    private BCcnLearnDevicesJob job;
    boolean isNewDevice;
    Log ccnMessageLog;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnBridgesEntry;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnControllerEntry;

    public Message toResponse(ReceivedMessage receivedMessage) {
        return null;
    }

    public void write(OutputStream outputStream) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (!this.ccnNetwork.isNetworkStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnDevice.add");
        }
        this.ccnNetwork.setLearnStatus("Learn-> Start discovery process... ");
        this.job.log().message("Learn-> Start discovery process... ");
        this.ccnNetwork.setDeviceLearnCount(0);
        try {
            try {
                var3_1 = this.ccnNetwork.getBusAddress();
                if (var3_1 != 0 && !this.ccnNetwork.isBridge(var3_1)) {
                    this.ccnNetwork.setLearnStatus("Learn-> Jace is on secondary bus " + var3_1 + ", determining if address 0:" + var3_1 + " is a bridge....");
                    this.job.log().message("Learn-> Jace is on secondary bus " + var3_1 + ", determining if address 0:" + var3_1 + " is a bridge....");
                    if (this.testForBridge(var3_1)) {
                        this.updateBridgesList(var3_1);
                        this.ccnNetwork.setLearnStatus("Learn-> bridge does exist at address 0:" + var3_1 + "... can reach primary bus ");
                        this.job.log().message("Learn-> bridge does exist at address 0:" + var3_1 + "... can reach primary bus ");
                    } else {
                        this.ccnNetwork.setLearnStatus("Learn-> bridge not responding at address 0:" + var3_1 + "... will try but, may not be able to reach primary bus or any other secondary bus");
                        this.job.log().message("Learn-> bridge not responding at address 0:" + var3_1 + "... will try but, may not be able to reach primary bus or any other secondary bus");
                        this.ccnMessageLog.trace("<CcnLearnNetworkRequest: bridge not responding at address 0:" + var3_1 + " ... may not be able to discover devices on any bus except local bus " + var3_1 + ", but will try");
                    }
                }
                this.vector = new Vector<E>();
                this.ccnMessageLog.trace("\n**** CcnLearnNetworkRequest... Start process");
                var4_3 = this.ccnNetwork.getFirstBusNo();
                var5_4 = this.ccnNetwork.getLastBusNo();
                var6_5 = this.ccnNetwork.getLowElemNo();
                var7_6 = this.ccnNetwork.getHighElemNo();
                if (this.ccnNetwork.getClearBridgeList()) {
                    this.ccnNetwork.getBridges().removeAll();
                    this.ccnNetwork.setClearBridgeList(false);
                    this.ccnMessageLog.trace("\n**** CcnLearnNetworkRequest... All bridges cleared per user request");
                    this.ccnNetwork.setLearnStatus("Learn-> all bridges cleared per user request....");
                    this.job.log().message("Learn-> all bridges cleared per user request....");
                }
                if (var4_3 > var5_4) throw new RuntimeException("Setup Valid Bus and Controller Range before starting Network Learn");
                if (var6_5 > var7_6) throw new RuntimeException("Setup Valid Bus and Controller Range before starting Network Learn");
                this.job.progress(1);
                var8_7 = var4_3;
                while (var8_7 <= var5_4) {
                    if (!this.job.isAlive() || this.job.getJobState() == BJobState.canceled) {
                        this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation requested by user during network learn -> bus:" + var8_7);
                        this.job.log().message("Cancelled-> Cancellation requested by user during network learn -> bus:" + var8_7);
                        this.ccnNetwork.setAbort(false);
                        break;
                    }
                    if (var8_7 == 0 || var8_7 == var3_1) ** GOTO lbl55
                    this.ccnNetwork.setLearnStatus("Learn-> determining if address 0:" + var8_7 + " is a bridge....");
                    this.job.log().message("Learn-> determining if address 0:" + var8_7 + " is a bridge....");
                    if (this.ccnNetwork.isBridge(var8_7)) ** GOTO lbl53
                    if (!this.testForBridge(var8_7)) {
                        this.ccnNetwork.setLearnStatus("Learn-> no bridge at address 0:" + var8_7 + " skip discovery on bus " + var8_7);
                        this.job.log().message("Learn-> no bridge at address 0:" + var8_7 + " skip discovery on bus " + var8_7);
                        this.ccnMessageLog.trace("<CcnLearnNetworkRequest: currentBridges does not include 0:" + var8_7 + " ... cannot discover devices on bus " + var8_7);
                        this.job.progress((100 * var8_7 + 1) / (var5_4 + 1));
                    } else {
                        this.updateBridgesList(var8_7);
lbl53:
                        // 2 sources

                        this.ccnNetwork.setLearnStatus("Learn-> bridge at address 0:" + var8_7 + "... path exist from Jace bus " + var3_1 + " to secondary bus " + var8_7 + ", now attempt to discover elements");
                        this.job.log().message("Learn-> bridge at address 0:" + var8_7 + "... path exist from Jace bus " + var3_1 + " to secondary bus " + var8_7 + ", now attempt to discover elements");
lbl55:
                        // 2 sources

                        var9_9 = 0;
                        if (var3_1 == 0 && var8_7 == 0) {
                            var9_9 = 1;
                        } else if (var3_1 == 0 && var8_7 != 0) {
                            var9_9 = this.ccnNetwork.isBridge(var8_7);
                        } else if (var3_1 != 0 && var3_1 == var8_7) {
                            var9_9 = 1;
                        } else if (var3_1 != 0 && var8_7 == 0) {
                            var9_9 = this.ccnNetwork.isBridge(var3_1);
                            if (var9_9 == 0) {
                                this.ccnMessageLog.trace("\n****  learnNetDevicesRequest... Jace on secondary bus " + var3_1 + " and bridge to primary bus not responding, will continue but questionable if learn will succeed, you may need to verify your bridge to primary bus ");
                                var9_9 = 1;
                            }
                        } else if (var3_1 != 0 && var3_1 != var8_7) {
                            var9_9 = this.ccnNetwork.isBridge(var8_7);
                        }
                        if (var9_9 == 0) {
                            this.ccnNetwork.setLearnStatus("Learn-> discovery on bus " + var8_7 + " terminated... no path from Jace bus " + var3_1 + " to bus " + var8_7);
                            this.job.log().message("Learn-> discovery on bus " + var8_7 + " terminated... no path from Jace bus " + var3_1 + " to bus " + var8_7);
                            this.ccnMessageLog.trace("\n****  learnNetDevicesRequest... currentBridges does not support a path from Jace bus " + var3_1 + " to bus " + var8_7 + ", skip all elements on secondary bus=" + var8_7);
                            this.job.progress((100 * var8_7 + 1) / (var5_4 + 1));
                        } else {
                            var10_10 = var6_5;
                            while (var10_10 <= var7_6) {
                                if (!this.ccnNetwork.isBridge(var8_7)) {
                                    this.job.progress((var8_7 + 1) * var10_10 * 100 / ((var5_4 + 1) * var7_6));
                                }
                                this.ccnNetwork.setDiscoveryInProgress(true);
                                this.ccnNetwork.setLearnStatus("Learn-> try element at bus:" + var8_7 + " element:" + var10_10);
                                this.job.log().message("Learn-> try element at bus:" + var8_7 + " element:" + var10_10);
                                this.ccnMessageLog.trace("\n****  learnNetDevicesRequest... Interrogate device at bus=" + var8_7 + " element=" + var10_10);
                                this.ccnMessageLog.trace("\n****  learnNetDevicesRequest... Interrogate device at bus=" + var8_7 + " element=" + var10_10);
                                this.interrogateDevice(var8_7, var10_10);
                                this.ccnMessageLog.trace("\n****  learnNetDevicesRequest... Interrogate device return at bus=" + var8_7 + " element=" + var10_10 + " |abort= " + this.ccnNetwork.isAbort());
                                if (!this.job.isAlive() || this.job.getJobState() == BJobState.canceled) {
                                    this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation requested by user during network learn ->  element:" + var10_10);
                                    this.job.log().message("Cancelled-> Cancellation requested by user during network learn ->  element:" + var10_10);
                                    break;
                                }
                                ++var10_10;
                            }
                            if (!this.job.isAlive() || this.job.getJobState() == BJobState.canceled) {
                                this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation requested by user during network learn -> bus:" + var8_7);
                                this.job.log().message("Cancelled-> Cancellation requested by user during network learn -> bus:" + var8_7);
                                this.ccnNetwork.setAbort(false);
                                break;
                            }
                        }
                    }
                    ++var8_7;
                }
                this.job.progress(100);
                this.ccnNetwork.setDeviceLearnCount(this.vector.size());
                this.ccnMessageLog.trace("\n****  learnNetDevicesRequest... closing out learn: v= " + this.vector.size());
                if (!this.job.isAlive() || this.job.getJobState() == BJobState.canceled) {
                    this.ccnNetwork.setLearnStatus("Cancelled-> Cancellation in process-> assembling Controller list");
                    this.job.log().message("Cancelled-> Cancellation in process-> assembling Controller list");
                }
                if (this.vector.size() == 0) {
                    this.ccnNetwork.setLearnStatus("Learn-> Assembling Controller list-> No Controllers found ");
                    this.job.log().message("Learn-> Assembling Controller list-> No Controllers found ");
                    this.ccnNetwork.setDeviceLearnCount(0);
                } else {
                    var8_8 = new BCcnControllerEntry[this.vector.size()];
                    this.vector.copyInto((Object[])var8_8);
                    this.ccnNetwork.getLearnedDevices().removeAll();
                    var9_9 = 0;
                    while (var9_9 < var8_8.length) {
                        this.addLearnedDevice(var8_8[var9_9]);
                        ++var9_9;
                    }
                }
            }
            catch (Exception var3_2) {
                this.ccnMessageLog.error("<CcnLearnNetworkRequest: ERROR:" + var3_2);
                var3_2.printStackTrace();
            }
        }
        catch (Throwable var1_11) {
            var2_12 = null;
            this.ccnNetwork.setLearnStatus("Learn-> Complete");
            this.job.log().message("Learn-->complete");
            this.ccnNetwork.setLearnStatus("Idle");
            throw var1_11;
        }
        {
            var2_13 = null;
            this.ccnNetwork.setLearnStatus("Learn-> Complete");
        }
        this.job.log().message("Learn-->complete");
        this.ccnNetwork.setLearnStatus("Idle");
    }

    private final void interrogateDevice(int n, int n2) {
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)n2, (byte)n, null, 32, 1, 1, 0, 0));
        CcnResponseMessage ccnResponseMessage = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            return;
        }
        BCcnControllerEntry bCcnControllerEntry = new BCcnControllerEntry();
        try {
            bCcnControllerEntry.setDevName(CcnRspDevUtil.getDevName(ccnResponseMessage).trim());
            this.ccnMessageLog.trace("<CcnLearnNetworkRequest: devName: " + CcnRspDevUtil.getDevName(ccnResponseMessage));
        }
        catch (CcnException ccnException) {
            ccnException.printStackTrace();
            this.ccnMessageLog.error("<CcnLearnNetworkRequest: ERROR: " + (Object)((Object)ccnException));
        }
        bCcnControllerEntry.setBusNo(n);
        bCcnControllerEntry.setElemNo(n2);
        this.vector.addElement(new BCcnControllerEntry(bCcnControllerEntry));
        this.ccnNetwork.setDeviceLearnCount(this.vector.size());
    }

    private final void updateBridgesList(int n) {
        BCcnBridgesEntry[] bCcnBridgesEntryArray;
        BCcnBridgesList bCcnBridgesList = new BCcnBridgesList();
        Vector<BCcnBridgesEntry> vector = new Vector<BCcnBridgesEntry>();
        boolean bl = false;
        BCcnBridgesList bCcnBridgesList2 = this.ccnNetwork.getBridges();
        Class clazz = class$com$tridium$ccn$components$BCcnBridgesEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnBridgesEntry = CcnLearnNetworkRequest.class("[Lcom.tridium.ccn.components.BCcnBridgesEntry;", false);
        }
        if ((bCcnBridgesEntryArray = (BCcnBridgesEntry[])bCcnBridgesList2.getChildren(clazz)) != null) {
            this.ccnMessageLog.error("<CcnLearnNetworkRequest: previousBridges: " + bCcnBridgesEntryArray.length);
            int n2 = 0;
            while (n2 < bCcnBridgesEntryArray.length) {
                if (bCcnBridgesEntryArray[n2].getBridgeBus() == n) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                vector.addElement(new BCcnBridgesEntry(n));
            }
        }
        BCcnBridgesEntry[] bCcnBridgesEntryArray2 = new BCcnBridgesEntry[vector.size()];
        vector.copyInto((Object[])bCcnBridgesEntryArray2);
        int n3 = 0;
        while (n3 < bCcnBridgesEntryArray2.length) {
            this.addBridge(bCcnBridgesEntryArray2[n3]);
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean testForBridge(int n) {
        byte[] byArray;
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)n, 0, null, 32, 1, 6, 0, 0));
        CcnResponseMessage ccnResponseMessage = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        if (ccnResponseMessage != null) {
            this.ccnMessageLog.trace("<CcnLearnNetworkRequest: testForBridge responseCommand: " + ccnResponseMessage.getResponseCommand() + "\nresponseBuffer: " + new String(ccnResponseMessage.getResponseBuffer().getResponseData()));
        }
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            return false;
        }
        String string = CcnRspDevUtil.getPICType(ccnResponseMessage).trim();
        this.ccnMessageLog.trace("<CcnLearnNetworkRequest: testForBridge picType: " + string);
        if (!string.startsWith("100")) return false;
        if (!string.startsWith("100EN")) return true;
        byte[] byArray2 = new String("CCNENET\u0000").getBytes();
        CcnReadObjectDataRequest ccnReadObjectDataRequest = new CcnReadObjectDataRequest(new CcnObjectDef((byte)n, 0, byArray2, 9, 8, 1, 0, 0));
        CcnResponseMessage ccnResponseMessage2 = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadObjectDataRequest);
        if (ccnResponseMessage2 != null) {
            this.ccnMessageLog.trace("<CcnLearnNetworkRequest: testForBridge getResponseCommand: " + ccnResponseMessage2.getResponseCommand() + " getResponseData " + ccnResponseMessage2.getResponseBuffer().getResponseData());
        }
        if (ccnResponseMessage2 != null && ccnResponseMessage2.getResponseCommand() == 21) {
            return true;
        }
        if (ccnResponseMessage2 != null && ccnResponseMessage2.getResponseCommand() == 6 && (byArray = ccnResponseMessage2.getResponseBuffer().getResponseData())[0] == 1) {
            return true;
        }
        try {
            return false;
        }
        catch (CcnException ccnException) {
            this.ccnMessageLog.error("<CcnLearnNetworkRequest: ERROR: " + (Object)((Object)ccnException));
        }
        return false;
    }

    void addLearnedDevice(BCcnControllerEntry bCcnControllerEntry) {
        boolean bl = false;
        BFolder bFolder = this.ccnNetwork.getLearnedDevices();
        Class clazz = class$com$tridium$ccn$components$BCcnControllerEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnControllerEntry = CcnLearnNetworkRequest.class("[Lcom.tridium.ccn.components.BCcnControllerEntry;", false);
        }
        BCcnControllerEntry[] bCcnControllerEntryArray = (BCcnControllerEntry[])bFolder.getChildren(clazz);
        if (bCcnControllerEntry.getBusNo() == 0 && this.ccnNetwork.isBridge(bCcnControllerEntry.getElemNo())) {
            bCcnControllerEntry.setDevType(2);
        } else {
            bCcnControllerEntry.setDevType(1);
        }
        int n = 0;
        while (n < bCcnControllerEntryArray.length) {
            if (bCcnControllerEntryArray[n].getDevName().equalsIgnoreCase(bCcnControllerEntry.getDevName()) && bCcnControllerEntryArray[n].getBusNo() == bCcnControllerEntry.getBusNo() && bCcnControllerEntryArray[n].getElemNo() == bCcnControllerEntry.getElemNo()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.ccnNetwork.getLearnedDevices().add(SlotPath.escape((String)(bCcnControllerEntry.getDevName().trim() + '_' + bCcnControllerEntry.getBusNo() + '_' + bCcnControllerEntry.getElemNo() + '_' + bCcnControllerEntry.getDevType())), (BValue)bCcnControllerEntry);
        }
    }

    void addBridge(BCcnBridgesEntry bCcnBridgesEntry) {
        boolean bl = false;
        BCcnBridgesList bCcnBridgesList = this.ccnNetwork.getBridges();
        Class clazz = class$com$tridium$ccn$components$BCcnBridgesEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnBridgesEntry = CcnLearnNetworkRequest.class("[Lcom.tridium.ccn.components.BCcnBridgesEntry;", false);
        }
        BCcnBridgesEntry[] bCcnBridgesEntryArray = (BCcnBridgesEntry[])bCcnBridgesList.getChildren(clazz);
        int n = 0;
        while (n < bCcnBridgesEntryArray.length) {
            if (bCcnBridgesEntryArray[n].getBridgeBus() == bCcnBridgesEntry.getBridgeBus()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.ccnNetwork.getBridges().add(SlotPath.escape((String)("" + bCcnBridgesEntry.getBridgeBus())), (BValue)bCcnBridgesEntry);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnLearnNetworkRequest(BCcnNetwork bCcnNetwork, BCcnLearnDevicesJob bCcnLearnDevicesJob) {
        this.this();
        this.ccnNetwork = bCcnNetwork;
        this.job = bCcnLearnDevicesJob;
    }
}

