/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnDataPointsJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnDataTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnUtil;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnLearnDataPointsRequest
implements AsynchronousRequest,
CcnMessageConst {
    BCcnDevice ccnDevice;
    BCcnDataTable ccnDataTable;
    BCcnPocTable ccnPocTable;
    BCcnDataTableWithTimeSchedule ccnDataTableWTS;
    BCcnPointEntry[] pointEntries;
    private BCcnPointEntry pointEntry;
    BCcnLearnDataPointsJob job;
    Log ccnMessageLog;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnPointEntry;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnTimeScheduleEntry;

    public void execute() {
        int n;
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnPoint.add");
        }
        int n2 = this.ccnDataTable.getTableInstance();
        int n3 = n = this.ccnDataTable.getDataBlock();
        int n4 = this.ccnDataTable.getTableType();
        int n5 = this.ccnPocTable.getDataTableType();
        int n6 = this.ccnPocTable.getTableType();
        if (n == 255) {
            n = this.ccnPocTable.getDataTableStartBlock();
            n3 = this.ccnPocTable.getDataTableEndBlock();
        }
        int n7 = n;
        while (n7 <= n3) {
            CcnResponseMessage ccnResponseMessage;
            int n8 = n7;
            this.job.progress((100 * n7 + 1) / (n3 + 1));
            if (n4 != 1556 || n8 != 2) {
                ccnResponseMessage = new CcnResponseMessage();
                if (n4 == n5 && n6 == this.ccnDataTable.getPocTableType()) {
                    ccnResponseMessage = CcnUtil.interrogateDataTableForPointData(this.ccnDevice, n4, n2, n8);
                }
                if (ccnResponseMessage != null) {
                    this.pointEntries = new BCcnPointEntry[this.ccnPocTable.getPointLearnCount()];
                    if (n4 == n5 && n6 == this.ccnDataTable.getPocTableType()) {
                        this.convertBlockDataToDataTableData(n4, ccnResponseMessage, n8);
                    }
                    int n9 = 0;
                    while (n9 < this.pointEntries.length) {
                        if (!this.pointEntries[n9].getFieldName().trim().equalsIgnoreCase("")) {
                            this.addLearnedPoints(this.ccnDataTable, this.pointEntries[n9]);
                        }
                        ++n9;
                    }
                    this.ccnDataTable.setPointLearnCount(this.pointEntries.length);
                }
            } else {
                ccnResponseMessage = new CcnResponseMessage();
                this.ccnMessageLog.trace("<CcnCreateDataTablesRequest: interrogateTableForPointData data" + this.ccnDevice.getBusNo() + '|' + this.ccnDevice.getElemNo() + '|' + n4 + '|' + n2 + '|' + n8 + " >");
                if (n4 == n5 && n6 == this.ccnDataTable.getPocTableType()) {
                    ccnResponseMessage = CcnUtil.interrogateDataTableForPointData(this.ccnDevice, n4, n2, n8);
                }
                if (ccnResponseMessage != null) {
                    this.pointEntries = new BCcnPointEntry[this.ccnPocTable.getPointLearnCount()];
                    this.ccnMessageLog.trace("<CcnCreateDataTablesRequest: convertBlockDataToTableData " + n4 + '|' + n2 + '|' + this.pointEntries.length + '|' + ccnResponseMessage.getBlockLen() + " >");
                    if (n4 == n5 && n6 == this.ccnDataTable.getPocTableType()) {
                        this.convertBlockDataToDataTableData(n4, ccnResponseMessage, n8);
                    }
                    int n10 = 0;
                    while (n10 < this.pointEntries.length) {
                        if (!this.pointEntries[n10].getFieldName().trim().equalsIgnoreCase("")) {
                            this.addLearnedPointsToDataTableTimeSchedule(this.ccnDataTableWTS, this.pointEntries[n10]);
                        }
                        ++n10;
                    }
                    BCcnTimeScheduleEntry[] bCcnTimeScheduleEntryArray = CcnRspDataUtil.buildTimeSchedules(this.pointEntries);
                    this.ccnMessageLog.trace("CcnLearnDataPointsRequest::" + bCcnTimeScheduleEntryArray.length);
                    this.ccnDataTableWTS.getTimeScheduleList().setTimeScheduleList(bCcnTimeScheduleEntryArray);
                }
            }
            ++n7;
        }
    }

    void addLearnedPoints(BCcnDataTable bCcnDataTable, BCcnPointEntry bCcnPointEntry) {
        boolean bl = false;
        BCcnPointList bCcnPointList = bCcnDataTable.getPointList();
        Class clazz = class$com$tridium$ccn$components$BCcnPointEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnPointEntry = CcnLearnDataPointsRequest.class("[Lcom.tridium.ccn.components.BCcnPointEntry;", false);
        }
        BCcnPointEntry[] bCcnPointEntryArray = (BCcnPointEntry[])bCcnPointList.getChildren(clazz);
        int n = 0;
        while (n < bCcnPointEntryArray.length) {
            if (bCcnPointEntryArray[n].getFieldName().equalsIgnoreCase(bCcnPointEntry.getFieldName()) && bCcnPointEntryArray[n].getDescription().equalsIgnoreCase(bCcnPointEntry.getDescription()) && bCcnPointEntryArray[n].getValueBlock() == bCcnPointEntry.getValueBlock() && bCcnPointEntryArray[n].getFieldIndex() == bCcnPointEntry.getFieldIndex()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl && bCcnPointEntry != null) {
            bCcnDataTable.getPointList().add(SlotPath.escape((String)(bCcnPointEntry.getFieldIndex() + bCcnPointEntry.getFieldName().trim() + '_' + bCcnPointEntry.getPointDataType() + '_' + bCcnPointEntry.getDescription() + '_' + bCcnPointEntry.getConfigFlags() + '_' + bCcnPointEntry.getDiscreteTextOffset())), (BValue)new BCcnPointEntry(bCcnPointEntry.getFieldIndex(), SlotPath.escape((String)bCcnPointEntry.getFieldName()).trim(), bCcnPointEntry.getPointDataType(), this.ccnDevice.getCcnNetwork().getDisplayMetric(), bCcnPointEntry.getDisplayDigits(), bCcnPointEntry.getFieldByteCount(), bCcnPointEntry.getDiscreteTextOffset(), bCcnPointEntry.getConfigFlags(), bCcnPointEntry.getUnits(), bCcnPointEntry.getPointValue(), bCcnPointEntry.getValueBlock(), bCcnPointEntry.getValueBlockOffset(), bCcnPointEntry.getAlrmStatus().getOrdinal(), bCcnPointEntry.getForceLevel().getOrdinal(), bCcnPointEntry.getLoLimit(), bCcnPointEntry.getLoLimitBlock(), bCcnPointEntry.getLoLimitBlockOffset(), bCcnPointEntry.getHiLimit(), bCcnPointEntry.getHiLimitBlock(), bCcnPointEntry.getHiLimitBlockOffset(), bCcnPointEntry.getVariableNo(), bCcnPointEntry.getDescription(), bCcnPointEntry.getForceableFlag(), bCcnPointEntry.getPointType()));
        }
    }

    void addLearnedPointsToDataTableTimeSchedule(BCcnDataTableWithTimeSchedule bCcnDataTableWithTimeSchedule, BCcnPointEntry bCcnPointEntry) {
        boolean bl = false;
        BCcnPointList bCcnPointList = bCcnDataTableWithTimeSchedule.getPointList();
        Class clazz = class$com$tridium$ccn$components$BCcnPointEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnPointEntry = CcnLearnDataPointsRequest.class("[Lcom.tridium.ccn.components.BCcnPointEntry;", false);
        }
        BCcnPointEntry[] bCcnPointEntryArray = (BCcnPointEntry[])bCcnPointList.getChildren(clazz);
        int n = 0;
        while (n < bCcnPointEntryArray.length) {
            if (bCcnPointEntryArray[n].getFieldName().equalsIgnoreCase(bCcnPointEntry.getFieldName()) && bCcnPointEntryArray[n].getFieldIndex() == bCcnPointEntry.getFieldIndex()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            bCcnDataTableWithTimeSchedule.getPointList().add(SlotPath.escape((String)(bCcnPointEntry.getFieldName().trim() + '_' + bCcnPointEntry.getPointDataType() + '_' + bCcnPointEntry.getDescription() + '_' + bCcnPointEntry.getConfigFlags() + '_' + bCcnPointEntry.getDiscreteTextOffset())), (BValue)bCcnPointEntry);
        }
    }

    void addTimeScheduleList(BCcnDataTableWithTimeSchedule bCcnDataTableWithTimeSchedule, BCcnTimeScheduleEntry bCcnTimeScheduleEntry) {
        boolean bl = false;
        BFolder bFolder = bCcnDataTableWithTimeSchedule.getLearnedTimeSchedules();
        Class clazz = class$com$tridium$ccn$components$BCcnTimeScheduleEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnTimeScheduleEntry = CcnLearnDataPointsRequest.class("[Lcom.tridium.ccn.components.BCcnTimeScheduleEntry;", false);
        }
        BCcnTimeScheduleEntry[] bCcnTimeScheduleEntryArray = (BCcnTimeScheduleEntry[])bFolder.getChildren(clazz);
        int n = 0;
        while (n < bCcnTimeScheduleEntryArray.length) {
            if (bCcnTimeScheduleEntryArray[n].getPeriodNo().equalsIgnoreCase(bCcnTimeScheduleEntry.getPeriodNo())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            bCcnDataTableWithTimeSchedule.getLearnedTimeSchedules().add(SlotPath.escape((String)bCcnTimeScheduleEntry.getPeriodNo()), (BValue)bCcnTimeScheduleEntry);
        }
    }

    private final void convertBlockDataToDataTableData(int n, CcnResponseMessage ccnResponseMessage, int n2) {
        int n3 = this.pointEntries.length;
        int n4 = 0;
        this.ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... start convertBlockDataToTableData: " + n + '|' + n3);
        BFolder bFolder = this.ccnPocTable.getLearnedSplPoints();
        Class clazz = class$com$tridium$ccn$components$BCcnPointEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnPointEntry = CcnLearnDataPointsRequest.class("[Lcom.tridium.ccn.components.BCcnPointEntry;", false);
        }
        BCcnPointEntry[] bCcnPointEntryArray = (BCcnPointEntry[])bFolder.getChildren(clazz);
        int n5 = 0;
        while (n5 < n3) {
            this.pointEntry = new BCcnPointEntry(bCcnPointEntryArray[n5]);
            this.pointEntry.setValueBlock((byte)n2);
            int n6 = this.getDataBlock_Data(n, n3, this.pointEntry, ccnResponseMessage, n4);
            if (n6 == -1) break;
            n4 = n6;
            this.pointEntries[n5] = this.pointEntry;
            ++n5;
        }
    }

    private final int getDataBlock_Data(int n, int n2, BCcnPointEntry bCcnPointEntry, CcnResponseMessage ccnResponseMessage, int n3) {
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            return -1;
        }
        int n4 = ccnResponseMessage.getBlockLen() - 3;
        int n5 = bCcnPointEntry.getFieldByteCount();
        if (n3 + n5 <= n4) {
            try {
                bCcnPointEntry.setPointValue(CcnRspDataUtil.getValue(ccnResponseMessage, n3, bCcnPointEntry));
                bCcnPointEntry.setValueBlockOffset(n3);
            }
            catch (CcnException ccnException) {
                this.ccnMessageLog.error("<CcnCreateDataTablesRequest: Data table getDataBlock_Data ERROR: " + (Object)((Object)ccnException));
            }
            return n3 += n5;
        }
        return -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnLearnDataPointsRequest(BCcnDevice bCcnDevice, BCcnDataTable bCcnDataTable, BCcnLearnDataPointsJob bCcnLearnDataPointsJob) {
        this.this();
        if (bCcnDataTable instanceof BCcnDataTable) {
            this.ccnDataTable = bCcnDataTable;
            this.ccnPocTable = bCcnDataTable.getParentPoc();
        }
        if (bCcnDataTable instanceof BCcnDataTableWithTimeSchedule) {
            this.ccnDataTableWTS = (BCcnDataTableWithTimeSchedule)bCcnDataTable;
            this.ccnPocTable = this.ccnDataTableWTS.getParentPoc();
        }
        this.ccnDevice = bCcnDevice;
        this.job = bCcnLearnDataPointsJob;
    }
}

