/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnCreateDataTablesRequest;
import com.tridium.ccn.messages.CcnCreateTablesRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnFetchTableDataRequest
implements AsynchronousRequest,
CcnMessageConst {
    BCcnDevice dev;
    int controllerNum;
    int busNum;
    BCcnTable table;
    int tableType;
    int tableInstance;
    int tableNum;
    boolean upload;
    Log ccnMessageLog;

    public void execute() {
        block43: {
            if (!this.dev.isDeviceStatusOk()) {
                throw new LocalizableRuntimeException("ccn", "Device is Out Of Service.Cannot fetch table data at this time");
            }
            try {
                block41: {
                    String string = this.table.getTableName();
                    if (string.equalsIgnoreCase("SPSCHPOC")) {
                        this.ccnMessageLog.trace("<CcnFetchTableDataRequest... fetch table data not allowed for this table: " + string);
                        return;
                    }
                    if (!this.upload) {
                        this.table.setLearnStatus("Learn-> process table type " + this.tableType + " tableInstance " + this.tableInstance);
                    }
                    CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, (short)this.tableType, (byte)this.tableInstance, 1, 0, 0));
                    CcnResponseMessage ccnResponseMessage = this.dev.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
                    if (ccnResponseMessage == null) {
                        this.ccnMessageLog.trace("CcnFetchTableDataRequest... rsp from CcnReadTableRequest is null");
                        if (!this.upload) {
                            this.table.setLearnStatus("Idle");
                        }
                        return;
                    }
                    this.ccnMessageLog.trace("CcnFetchTableDataRequest... rsp.getResponseCommand()=" + ccnResponseMessage.getResponseCommand());
                    if (ccnResponseMessage.getResponseCommand() == 6 || ccnResponseMessage.getResponseCommand() == 21 && (this.tableType == 1283 || this.tableType == 1284 || this.tableType == 1285) && ccnResponseMessage.getResponseCode() == 16) {
                        BCcnTableEntry bCcnTableEntry = new BCcnTableEntry();
                        try {
                            Object object;
                            Object object2;
                            block42: {
                                if (!this.dev.isDeviceFID()) {
                                    BCcnByteList bCcnByteList;
                                    BCcnByteEntry[] bCcnByteEntryArray;
                                    BCcnTableGroup bCcnTableGroup = this.table.getGroup();
                                    String string2 = this.table.getGroup().getTableGroupDescription();
                                    bCcnTableEntry.setTableType(this.tableType);
                                    bCcnTableEntry.setTableTypeString(string2);
                                    bCcnTableEntry.setTableInstance(this.tableInstance);
                                    this.table.setTableTypeString(string2);
                                    int n = ccnResponseMessage.getTableNumber();
                                    this.table.setTableNum(n);
                                    bCcnTableEntry.setTableNum(n);
                                    this.tableNum = this.table.getTableNum();
                                    String string3 = CcnRspTableUtil.getTableName(ccnResponseMessage).trim();
                                    this.table.setTableName(string3);
                                    bCcnTableEntry.setTableName(string3);
                                    try {
                                        String string4 = CcnRspTableUtil.getTableName(ccnResponseMessage).trim();
                                        if (!(this.table instanceof BCcnDataTable)) {
                                            if (!this.table.getName().equalsIgnoreCase(string4)) {
                                                bCcnByteEntryArray = bCcnTableGroup.getProperty(this.table.getName().trim());
                                                if (bCcnTableGroup.getSlot(this.table.getName()) != null) {
                                                    bCcnTableGroup.rename(bCcnTableGroup.getSlot(bCcnByteEntryArray.getName().trim()).asProperty(), string4);
                                                }
                                                this.table.setDuplicateTableName(string4);
                                            }
                                        } else if (((BCcnDataTable)this.table).getDataBlock() != 0 && !this.table.getName().equalsIgnoreCase(string4)) {
                                            bCcnByteEntryArray = ((BCcnDataTable)this.table).getParentPoc();
                                            bCcnByteList = null;
                                            if (bCcnTableGroup.getSlot(bCcnByteEntryArray.getName()) != null) {
                                                bCcnByteList = bCcnByteEntryArray.getProperty(this.table.getName().trim());
                                            }
                                            if (bCcnByteEntryArray.getSlot(this.table.getName()) != null && bCcnByteList != null) {
                                                bCcnByteEntryArray.rename(bCcnByteEntryArray.getSlot(bCcnByteList.getName().trim()).asProperty(), string4);
                                            }
                                            this.table.setDuplicateTableName(string4);
                                        }
                                    }
                                    catch (Exception exception) {
                                        this.ccnMessageLog.error("CcnFetchTableDataRequest... can not rename the object" + exception);
                                        if (!this.upload) {
                                            this.table.setLearnStatus("Idle");
                                        }
                                        exception.printStackTrace();
                                        this.table.setTableName(this.table.getName());
                                        return;
                                    }
                                    int n2 = CcnRspTableUtil.getBlockCount(ccnResponseMessage);
                                    bCcnTableEntry.setBlockCount(n2);
                                    this.table.setTableBlockCount(n2);
                                    bCcnByteEntryArray = new BCcnByteEntry[n2];
                                    bCcnByteList = new BCcnByteList();
                                    int n3 = 0;
                                    while (n3 < n2) {
                                        bCcnByteEntryArray[n3] = new BCcnByteEntry();
                                        bCcnByteEntryArray[n3].setIndex(n3 + 1);
                                        bCcnByteEntryArray[n3].setValue(CcnRspTableUtil.getBlockAccessRights(ccnResponseMessage, n3 + 1));
                                        if (bCcnByteList.get("index" + this.tableNum + bCcnByteEntryArray[n3].getIndex()) == null) {
                                            bCcnByteList.add("index" + this.tableNum + bCcnByteEntryArray[n3].getIndex(), (BValue)bCcnByteEntryArray[n3]);
                                        }
                                        ++n3;
                                    }
                                    if (this.dev.getTableAccessRights().get(SlotPath.escape((String)string3) + this.tableNum) == null) {
                                        this.dev.getTableAccessRights().add(SlotPath.escape((String)string3) + this.tableNum, (BValue)bCcnByteList);
                                    }
                                    this.table.setPreMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                    this.table.setCurMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                    if (this.table instanceof BCcnDataTable) {
                                        BCcnPocTable bCcnPocTable = ((BCcnDataTable)this.table).getParentPoc();
                                        n3 = bCcnPocTable.getPointLearnCount();
                                        ((BCcnDataTable)this.table).setPointLearnCount(n3);
                                        bCcnTableEntry.setPointCount(n3);
                                        BCcnTableEntry[] bCcnTableEntryArray = new BCcnTableEntry[]{bCcnTableEntry};
                                        CcnCreateDataTablesRequest ccnCreateDataTablesRequest = new CcnCreateDataTablesRequest(bCcnPocTable, bCcnTableEntryArray, (BCcnDataTable)this.table, true, true, this.upload);
                                        ccnCreateDataTablesRequest.execute();
                                    } else if (this.table instanceof BCcnPocTable) {
                                        n3 = CcnRspTableUtil.getPointCount(ccnResponseMessage);
                                        bCcnTableEntry.setPointCount(n3);
                                        BCcnTableEntry[] bCcnTableEntryArray = new BCcnTableEntry[]{bCcnTableEntry};
                                        CcnCreateTablesRequest ccnCreateTablesRequest = new CcnCreateTablesRequest(this.dev, new BCcnTableList(bCcnTableEntryArray), this.table, true, this.upload);
                                        ccnCreateTablesRequest.execute();
                                    } else if (this.table instanceof BCcnPicTable) {
                                        n3 = CcnRspTableUtil.getPointCount(ccnResponseMessage);
                                        this.table.setPointLearnCount(n3);
                                        bCcnTableEntry.setPointCount(n3);
                                        BCcnTableEntry[] bCcnTableEntryArray = new BCcnTableEntry[]{bCcnTableEntry};
                                        CcnCreateTablesRequest ccnCreateTablesRequest = new CcnCreateTablesRequest(this.dev, new BCcnTableList(bCcnTableEntryArray), this.table, true, this.upload);
                                        ccnCreateTablesRequest.execute();
                                    }
                                    break block41;
                                }
                                BCcnTableGroup bCcnTableGroup = this.table.getGroup();
                                String string5 = this.table.getGroup().getTableGroupDescription();
                                bCcnTableEntry.setTableType(this.tableType);
                                bCcnTableEntry.setTableTypeString(string5);
                                bCcnTableEntry.setTableInstance(this.tableInstance);
                                this.table.setTableTypeString(string5);
                                String string6 = new String();
                                int n = 0;
                                int n4 = 0;
                                switch (this.tableType) {
                                    case 1281: {
                                        string6 = new String("IO_Points");
                                        n = 6;
                                        object2 = new byte[]{1, 1, 2, 3, 3, 1, 4, 1, 5, 1, 6, 3};
                                        this.setBlockAccessRightsForFIDTable((byte[])object2, 6, this.tableType, string6);
                                        n4 = 64;
                                        break;
                                    }
                                    case 1283: {
                                        string6 = new String("TST" + this.tableInstance);
                                        n = 3;
                                        byte[] byArray = new byte[6];
                                        byArray[0] = 1;
                                        byArray[2] = 2;
                                        byArray[3] = 3;
                                        byArray[4] = 3;
                                        byArray[5] = 1;
                                        object = byArray;
                                        this.setBlockAccessRightsForFIDTable((byte[])object, 3, this.tableType, string6);
                                        n4 = 21;
                                        break;
                                    }
                                    case 1284: {
                                        string6 = new String("SP" + this.tableInstance);
                                        n = 2;
                                        byte[] byArray = new byte[4];
                                        byArray[0] = 1;
                                        byArray[2] = 2;
                                        byArray[3] = 3;
                                        byte[] byArray2 = byArray;
                                        this.setBlockAccessRightsForFIDTable(byArray2, 2, this.tableType, string6);
                                        n4 = 4;
                                        break;
                                    }
                                    case 1285: {
                                        string6 = new String("HO" + this.tableInstance);
                                        n = 2;
                                        byte[] byArray = new byte[4];
                                        byArray[0] = 1;
                                        byArray[2] = 2;
                                        byArray[3] = 3;
                                        byte[] byArray3 = byArray;
                                        this.setBlockAccessRightsForFIDTable(byArray3, 2, this.tableType, string6);
                                        n4 = 60;
                                        break;
                                    }
                                    default: {
                                        this.ccnMessageLog.trace("CcnFetchTableDataRequest... ERROR: table type = " + this.tableType + " or table instance = " + this.tableInstance + " not valid for a FID device");
                                        return;
                                    }
                                }
                                this.table.setTableName(string6);
                                bCcnTableEntry.setTableName(new String(string6));
                                bCcnTableEntry.setBlockCount(n);
                                this.table.setTableBlockCount(n);
                                this.table.setPreMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                this.table.setCurMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                bCcnTableEntry.setPointCount(n4);
                                this.table.setPointLearnCount(n4);
                                try {
                                    if (!this.table.getName().equalsIgnoreCase(string6)) {
                                        object2 = bCcnTableGroup.getProperty(this.table.getName().trim());
                                        if (bCcnTableGroup.getSlot(this.table.getName()) != null) {
                                            bCcnTableGroup.rename(bCcnTableGroup.getSlot(object2.getName().trim()).asProperty(), string6);
                                        }
                                        this.table.setDuplicateTableName(string6);
                                    }
                                }
                                catch (Exception exception) {
                                    this.ccnMessageLog.error("CcnFetchTableDataRequest... can not rename the object" + exception);
                                    if (this.upload) break block42;
                                    this.table.setLearnStatus("Idle");
                                }
                            }
                            object2 = new BCcnTableEntry[1];
                            object2[0] = (byte)bCcnTableEntry;
                            object = new CcnCreateTablesRequest(this.dev, new BCcnTableList((BCcnTableEntry[])object2), this.table, true, this.upload);
                            ((CcnCreateTablesRequest)object).execute();
                        }
                        catch (CcnException ccnException) {
                            this.ccnMessageLog.error("CcnFetchTableDataRequest... ERROR: " + (Object)((Object)ccnException));
                            if (this.upload) break block41;
                            this.table.setLearnStatus("Idle");
                        }
                    }
                }
                if (!this.upload) {
                    this.table.setLearnStatus("Idle");
                } else {
                    this.dev.setLearnStatus("Upload-> Table " + this.table.getTableName());
                }
            }
            catch (Exception exception) {
                this.ccnMessageLog.error("CcnFetchTableDataRequest... ERROR: " + exception);
                if (this.upload) break block43;
                this.table.setLearnStatus("Idle");
            }
        }
    }

    private final void setBlockAccessRightsForFIDTable(byte[] byArray, int n, int n2, String string) {
        BCcnByteEntry[] bCcnByteEntryArray = new BCcnByteEntry[n];
        BCcnByteList bCcnByteList = new BCcnByteList();
        int n3 = 0;
        while (n3 < n) {
            bCcnByteEntryArray[n3] = new BCcnByteEntry();
            bCcnByteEntryArray[n3].setIndex(n3 + 1);
            bCcnByteEntryArray[n3].setValue(byArray[(n3 + 1) * 2 - 1]);
            if (bCcnByteList.get("index" + n2 + bCcnByteEntryArray[n3].getIndex()) == null) {
                bCcnByteList.add("index" + n2 + bCcnByteEntryArray[n3].getIndex(), (BValue)bCcnByteEntryArray[n3]);
            }
            ++n3;
        }
        if (this.dev.getTableAccessRights().get(SlotPath.escape((String)string) + n2) == null) {
            this.dev.getTableAccessRights().add(SlotPath.escape((String)string) + n2, (BValue)bCcnByteList);
        }
    }

    private final /* synthetic */ void this() {
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnFetchTableDataRequest(BCcnTable bCcnTable, BCcnDevice bCcnDevice) {
        this.this();
        this.table = bCcnTable;
        this.dev = bCcnDevice;
        this.controllerNum = bCcnDevice.getElemNo();
        this.busNum = bCcnDevice.getBusNo();
        this.tableType = bCcnTable.getTableType();
        this.tableInstance = bCcnTable.getTableInstance();
        this.tableNum = bCcnTable.getTableNum();
        this.upload = false;
    }
}

