/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.messages.CcnWriteTableRequest;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CcnChangeBaudRateRequest
implements AsynchronousRequest {
    private static boolean PRIMARY_BAUD_RATE = true;
    private static boolean SECONDARY_BAUD_RATE = false;
    private BCcnDevice device;
    private Integer primaryBaudRate;
    private Integer secondaryBaudRate;
    Log ccnMessageLog;

    public static boolean isSupportedBaudRate(int n) {
        switch (n) {
            case 9600: 
            case 19200: 
            case 38400: {
                return true;
            }
        }
        return false;
    }

    private final void setBaudRate(Integer n, boolean bl) {
        if (n != null && !CcnChangeBaudRateRequest.isSupportedBaudRate(n)) {
            throw new CcnRuntimeException(6488274, "Baud rate not supported");
        }
        if (bl) {
            this.primaryBaudRate = n;
        } else {
            this.secondaryBaudRate = n;
        }
    }

    private final void validateBaudRateRsp(CcnResponseMessage ccnResponseMessage, int n, String string) throws CcnException {
        if (ccnResponseMessage == null || ccnResponseMessage.getResponseCommand() != 6) {
            throw new CcnException(n, new String("Baud rate change error occurred " + string + '.'));
        }
    }

    private final byte[] readBaudRateBlockData() throws CcnException {
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)this.device.getElemNo(), (byte)this.device.getBusNo(), null, 32, 1, 3, 0, 0));
        CcnResponseMessage ccnResponseMessage = this.device.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        this.validateBaudRateRsp(ccnResponseMessage, 6488177, "during initial baud rate read");
        return ccnResponseMessage.getData();
    }

    private final void changeBaudRateInBuffer(byte[] byArray, int n, boolean bl) {
        int n2 = bl ? 0 : 2;
        int n3 = bl ? 1 : 3;
        byArray[n2] = (byte)((n & 0xFF00) >> 8);
        byArray[n3] = (byte)(n & 0xFF);
    }

    private final void overwriteBaudRateTableBlock(byte[] byArray) throws CcnException {
        CcnWriteTableRequest ccnWriteTableRequest = new CcnWriteTableRequest(new CcnTableDef((byte)this.device.getElemNo(), (byte)this.device.getBusNo(), null, 32, 1, 3, (byte)byArray.length, 0), byArray);
        CcnResponseMessage ccnResponseMessage = this.device.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnWriteTableRequest);
        this.validateBaudRateRsp(ccnResponseMessage, 6488175, "writing new baud rate data");
    }

    public void execute() {
        try {
            byte[] byArray = this.readBaudRateBlockData();
            if (this.primaryBaudRate != null) {
                this.changeBaudRateInBuffer(byArray, this.primaryBaudRate, PRIMARY_BAUD_RATE);
            }
            if (this.secondaryBaudRate != null) {
                this.changeBaudRateInBuffer(byArray, this.secondaryBaudRate, SECONDARY_BAUD_RATE);
            }
            if (this.primaryBaudRate != null || this.secondaryBaudRate != null) {
                this.overwriteBaudRateTableBlock(byArray);
            }
        }
        catch (Throwable throwable) {
            this.ccnMessageLog.trace(">CcnChangeBaudRateRequest: could not change baud rate(s).\n>Cause = " + throwable + ">Reason = " + throwable.getLocalizedMessage() + "\n>Stack Print = ");
            throwable.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.device = null;
        this.primaryBaudRate = null;
        this.secondaryBaudRate = null;
        this.ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }

    public CcnChangeBaudRateRequest(BCcnDevice bCcnDevice, int n) {
        this(bCcnDevice, new Integer(n), null);
    }

    public CcnChangeBaudRateRequest(BCcnDevice bCcnDevice, int n, int n2) {
        this(bCcnDevice, new Integer(n), new Integer(n2));
    }

    public CcnChangeBaudRateRequest(BCcnDevice bCcnDevice, Integer n, Integer n2) {
        this.this();
        this.device = bCcnDevice;
        boolean bl = false;
        String string = "";
        try {
            this.setBaudRate(n, PRIMARY_BAUD_RATE);
        }
        catch (CcnRuntimeException ccnRuntimeException) {
            if (ccnRuntimeException.getCode() == 6488274) {
                bl = true;
                string = string + "\nThe proposed new primary baud rate, " + n + " is not supported.";
            }
            throw ccnRuntimeException;
        }
        try {
            this.setBaudRate(n2, SECONDARY_BAUD_RATE);
        }
        catch (CcnRuntimeException ccnRuntimeException) {
            if (ccnRuntimeException.getCode() == 6488274) {
                bl = true;
                string = string + "\nThe proposed new secondary baud rate, " + n2 + " is not supported.";
            }
            throw ccnRuntimeException;
        }
        if (bl) {
            throw new CcnRuntimeException(6488274, string);
        }
    }
}

