/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.UDPMessageProcessor;
import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class UDPRoutingTableEntry
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final int IP_ADDR_FIRST_LOC = 20;
    public static final int IP_ADDR_LAST_LOC = 23;
    public static final int PORT_HI_LOC = 24;
    public static final int PORT_LO_LOC = 25;
    public static final int CCN_ADDR_LOC = 26;
    public static final int DEV_TYPE_LOC = 27;
    public static final int ACTION_LOC = 28;
    public static final int ACTION_ADD_1 = 0;
    public static final int ACTION_ADD_2 = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_CHANGE = 3;
    public static final int DEFAULT_UDP_IP_PORT = 0;
    public static final int DEVICE_TYPE_COMFORT_WORKS = 2;
    public static final int DEVICE_TYPE_GATEWAY = 3;
    public static final int[] DEFAULT_UNUSED_IP_ADDR = new int[4];
    public int iCcnAddress;
    public int iUdpPort;
    public int iDeviceType;
    public int iAction;
    public int[] iUdpAddress;
    public long iLastUpdateTicks;

    public String toString() {
        return "IP=" + this.iUdpAddress[0] + '.' + this.iUdpAddress[1] + '.' + this.iUdpAddress[2] + '.' + this.iUdpAddress[3] + " Port=" + this.iUdpPort;
    }

    public boolean isActionDelete() {
        boolean bl = false;
        if (this.iAction == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isActionAdd() {
        boolean bl = false;
        if (this.iAction == 0 || this.iAction == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isActionChange() {
        boolean bl = false;
        if (this.iAction == 3) {
            bl = true;
        }
        return bl;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        String string = "" + this.iUdpAddress[0] + '.' + this.iUdpAddress[1] + '.' + this.iUdpAddress[2] + '.' + this.iUdpAddress[3];
        return InetAddress.getByName(string);
    }

    public static void addBlankEntryTo(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(DEFAULT_UNUSED_IP_ADDR[0]);
        byteArrayOutputStream.write(DEFAULT_UNUSED_IP_ADDR[1]);
        byteArrayOutputStream.write(DEFAULT_UNUSED_IP_ADDR[2]);
        byteArrayOutputStream.write(DEFAULT_UNUSED_IP_ADDR[3]);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
    }

    public void addEntryTo(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(this.iUdpAddress[0]);
        byteArrayOutputStream.write(this.iUdpAddress[1]);
        byteArrayOutputStream.write(this.iUdpAddress[2]);
        byteArrayOutputStream.write(this.iUdpAddress[3]);
        byteArrayOutputStream.write((this.iUdpPort & 0xFF00) >> 8 & 0xFF);
        byteArrayOutputStream.write(this.iUdpPort & 0xFF & 0xFF);
    }

    private final void parseUdpIpAddress(byte[] byArray) {
        this.iUdpAddress = new int[4];
        int n = 20;
        int n2 = 0;
        while (n <= 23) {
            this.iUdpAddress[n2] = byArray[n] & 0xFF;
            ++n;
            ++n2;
        }
    }

    private final void parseUdpPort(byte[] byArray) {
        this.iUdpPort = (byArray[24] & 0xFF) << 8 | byArray[25] & 0xFF;
    }

    private final void parseCcnAddress(byte[] byArray) {
        this.iCcnAddress = byArray[26] & 0xFF;
    }

    public static int getDeviceType(byte[] byArray) {
        return byArray[27] & 0xFF;
    }

    private final void parseDeviceType(byte[] byArray) {
        this.iDeviceType = UDPRoutingTableEntry.getDeviceType(byArray);
    }

    private final void parseAction(byte[] byArray) {
        this.iAction = byArray[28] & 0xFF;
    }

    public int hashCode() {
        return this.iCcnAddress;
    }

    public boolean equals(Object object) {
        if (object instanceof UDPRoutingTableEntry) {
            UDPRoutingTableEntry uDPRoutingTableEntry = (UDPRoutingTableEntry)object;
            if (uDPRoutingTableEntry.iCcnAddress == this.iCcnAddress && uDPRoutingTableEntry.iUdpPort == this.iUdpPort) {
                int n = 0;
                while (n < 4) {
                    if (this.iUdpAddress[n] != uDPRoutingTableEntry.iUdpAddress[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.iUdpAddress = new int[4];
    }

    public UDPRoutingTableEntry(UDPMessageProcessor uDPMessageProcessor) {
        this(uDPMessageProcessor.iPacket.getData());
    }

    public UDPRoutingTableEntry(DatagramPacket datagramPacket) {
        this(datagramPacket.getData());
    }

    public UDPRoutingTableEntry(int[] nArray, int n, int n2, int n3) {
        this.this();
        int n4 = 0;
        while (n4 < 4) {
            this.iUdpAddress[n4] = nArray[n4];
            ++n4;
        }
        this.iCcnAddress = n;
        this.iUdpPort = n2;
        this.iDeviceType = n3;
        this.iAction = 1;
        this.iLastUpdateTicks = Clock.ticks();
    }

    public UDPRoutingTableEntry(byte[] byArray) {
        this.this();
        this.parseUdpIpAddress(byArray);
        this.parseUdpPort(byArray);
        this.parseCcnAddress(byArray);
        this.parseDeviceType(byArray);
        this.parseAction(byArray);
        this.iLastUpdateTicks = Clock.ticks();
    }
}

