/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.UDPRoutingTableEntry;
import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.log.Log;
import javax.baja.sys.Clock;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class CcnUdpRoutingTable
extends IntHashMap {
    public static final String ROUTING_TABLE_NAME = "ROUTETAB";
    private static final int FIFTEEN_MINUTES = 900000;
    private volatile boolean updatedButNotTransmitted;
    Log tunnelLog;

    public synchronized boolean isUpdatedButNotTransmitted() {
        return this.updatedButNotTransmitted;
    }

    public synchronized void resetUpdatedButNotTransmitted() {
        this.updatedButNotTransmitted = false;
    }

    public synchronized void purgeStaleEntries() {
        UDPRoutingTableEntry uDPRoutingTableEntry = null;
        IntHashMap.Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            uDPRoutingTableEntry = (UDPRoutingTableEntry)iterator.next();
            if (uDPRoutingTableEntry.iDeviceType == 3 || Clock.ticks() - uDPRoutingTableEntry.iLastUpdateTicks <= 900000L) continue;
            this.tunnelLog.trace("Removing stale entry, " + uDPRoutingTableEntry + ". It has been " + (Clock.ticks() - uDPRoutingTableEntry.iLastUpdateTicks) + " ms since its last update.");
            this.removeEntry(uDPRoutingTableEntry);
        }
    }

    private final synchronized void removeEntry(UDPRoutingTableEntry uDPRoutingTableEntry) {
        super.remove(uDPRoutingTableEntry.hashCode());
        this.generateAlarm(false, uDPRoutingTableEntry.toString());
        this.updatedButNotTransmitted = true;
        ((Object)((Object)this)).notifyAll();
    }

    private final synchronized void addEntry(UDPRoutingTableEntry uDPRoutingTableEntry) {
        super.put(uDPRoutingTableEntry.hashCode(), (Object)uDPRoutingTableEntry);
        this.generateAlarm(true, uDPRoutingTableEntry.toString());
        this.updatedButNotTransmitted = true;
        ((Object)((Object)this)).notifyAll();
    }

    private final void generateAlarm(boolean bl, String string) {
        BAlarmState bAlarmState = bl ? BAlarmState.normal : BAlarmState.offnormal;
        BAlarmState bAlarmState2 = bl ? BAlarmState.offnormal : BAlarmState.normal;
        String string2 = "Tunnel Client (" + string + ") Logged " + (bl ? "into" : "out of") + " Routing Table.";
    }

    public synchronized void giveEntry(UDPRoutingTableEntry uDPRoutingTableEntry) {
        if (uDPRoutingTableEntry.isActionAdd() || uDPRoutingTableEntry.isActionChange()) {
            this.addEntry(uDPRoutingTableEntry);
        } else if (uDPRoutingTableEntry.isActionDelete()) {
            this.removeEntry(uDPRoutingTableEntry);
        }
    }

    private final byte[] getCcnRoutingTableUdpPacketData(int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.addRoutingTableHeaderToPacket(byteArrayOutputStream, n, n2);
        this.addTableNameToPacket(byteArrayOutputStream);
        this.addRoutingTableToPacket(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private final void addRoutingTableHeaderToPacket(ByteArrayOutputStream byteArrayOutputStream, int n, int n2) {
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(241);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(12);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(255);
    }

    private final void addRoutingTableToPacket(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = this.getCcnRoutingTable();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    private final void addTableNameToPacket(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = ROUTING_TABLE_NAME.getBytes();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    public void sendToAll(CcnTunnelBack ccnTunnelBack, int n, int n2) {
        UDPRoutingTableEntry uDPRoutingTableEntry = null;
        byte[] byArray = this.getCcnRoutingTableUdpPacketData(n, n2);
        IntHashMap.Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            uDPRoutingTableEntry = (UDPRoutingTableEntry)iterator.next();
            if (uDPRoutingTableEntry.iCcnAddress == n2) continue;
            try {
                ccnTunnelBack.putQueue(new DatagramPacket(byArray, byArray.length, uDPRoutingTableEntry.getInetAddress(), uDPRoutingTableEntry.iUdpPort));
            }
            catch (UnknownHostException unknownHostException) {
                this.tunnelLog.trace("Unable to send routing table to element " + uDPRoutingTableEntry.iCcnAddress + "(unknown I.P. host)");
                System.out.println(unknownHostException);
            }
        }
    }

    public byte[] getCcnRoutingTable() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byteArrayOutputStream2.write(0);
        int n = 1;
        while (n <= 239) {
            UDPRoutingTableEntry uDPRoutingTableEntry = (UDPRoutingTableEntry)this.get(n);
            if (uDPRoutingTableEntry == null) {
                UDPRoutingTableEntry.addBlankEntryTo(byteArrayOutputStream);
                byteArrayOutputStream2.write(0);
            } else {
                uDPRoutingTableEntry.addEntryTo(byteArrayOutputStream);
                byteArrayOutputStream2.write(uDPRoutingTableEntry.iDeviceType);
            }
            ++n;
        }
        UDPRoutingTableEntry.addBlankEntryTo(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        byteArrayOutputStream3.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        byteArrayOutputStream3.write(byteArrayOutputStream2.toByteArray(), 0, byteArrayOutputStream2.size());
        return byteArrayOutputStream3.toByteArray();
    }

    private final /* synthetic */ void this() {
        this.updatedButNotTransmitted = false;
        this.tunnelLog = Log.getLog((String)"CCNTunnelLog");
    }

    public CcnUdpRoutingTable(BCcnNetwork bCcnNetwork) {
        super(12);
        this.this();
    }
}

