/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.CcnTunnelProcess;
import com.tridium.ccn.CcnUdpRoutingTable;
import com.tridium.ccn.ClientNotInRoutingTableException;
import com.tridium.ccn.ClientSameAddressAsJaceException;
import com.tridium.ccn.UDPRoutingTableEntry;
import com.tridium.ccn.UDPUnsolicitedReceiveProcesser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import javax.baja.util.ByteArrayUtil;

class CcnTunnelUp
extends CcnTunnelProcess {
    public static final int CCN_UDP_UNSOLICITED_RX_PORT = 50005;
    private CcnTunnelBack iCcnTunnelBack;

    protected String getDebugIntro() {
        return "IP Rx: ";
    }

    protected boolean isDebugOn() {
        return this.iCcnTunnelHelper.getTunnelRxDebugOn();
    }

    protected boolean isDisplayDots() {
        return this.iCcnTunnelHelper.getTunnelRxDisplayDots();
    }

    protected void setStatus(String string) {
        this.iCcnTunnelHelper.setTunnelRxStatus(string);
    }

    protected void cycle() {
        this.receiveIncomingUdp();
    }

    private final void debugRx(DatagramPacket datagramPacket) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(datagramPacket.getData(), 0, datagramPacket.getLength());
        this.debugLn(ByteArrayUtil.toHexString((byte[])byteArrayOutputStream.toByteArray()) + ' ');
    }

    private final void receiveIncomingUdp() {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(new byte[256], 256);
            this.setStatus("Waiting to receive next UDP/IP transmission.");
            this.iSocket.setSoTimeout(this.iCcnTunnelHelper.getTunnelRxResponseTimeout());
            this.iSocket.receive(datagramPacket);
            if (datagramPacket.getLength() > 0) {
                this.setStatus("Received " + datagramPacket.getLength() + " bytes of data over IP.");
                this.processTunnelRx(datagramPacket);
            }
        }
        catch (ClientSameAddressAsJaceException clientSameAddressAsJaceException) {
            this.debugLn("" + clientSameAddressAsJaceException);
        }
        catch (ClientNotInRoutingTableException clientNotInRoutingTableException) {
            this.debugLn("" + clientNotInRoutingTableException);
        }
        catch (UDPRoutingTableEntry uDPRoutingTableEntry) {
            this.iRoutingTable.giveEntry(uDPRoutingTableEntry);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.setStatus("Receive timeout.");
        }
        catch (SocketException socketException) {
            this.setStatus("Received SocketException " + socketException);
            this.briefRest();
        }
        catch (IOException iOException) {
            this.debugLn("Received IOException " + iOException);
            this.setStatus("IOException.");
            this.briefRest();
        }
    }

    private final void processTunnelRx(DatagramPacket datagramPacket) {
        this.debugRx(datagramPacket);
        new UDPUnsolicitedReceiveProcesser(datagramPacket, this.iSocket, this.iCcnTunnelHelper, this.iCcnTunnelHelper.ccnNetwork.getElemAddress(), this.iCcnTunnelHelper.ccnNetwork.getBusAddress(), this.isDebugOn());
    }

    public CcnTunnelUp(BCcnTunnelHelper bCcnTunnelHelper, CcnTunnelBack ccnTunnelBack, CcnUdpRoutingTable ccnUdpRoutingTable) {
        super(bCcnTunnelHelper, ccnUdpRoutingTable, "CcnRxTnl", 50005, 'U');
        this.iCcnTunnelBack = ccnTunnelBack;
    }
}

