/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnUdpRoutingTable;
import java.net.DatagramSocket;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
abstract class CcnTunnelProcess
extends Thread {
    protected DatagramSocket iSocket;
    protected BCcnTunnelHelper iCcnTunnelHelper;
    protected CcnUdpRoutingTable iRoutingTable;
    protected volatile boolean quittingTime;
    private int iBindPort;
    private String iThreadName;
    private char iDotChar;
    private Object briefRestMonitor;
    Log tunnelLog;

    protected int getBindPort() {
        return this.iBindPort;
    }

    public void start() {
        try {
            this.setStatus("Starting...");
            if (this.iBindPort > 0) {
                this.iSocket = new DatagramSocket(this.iBindPort);
            }
            this.quittingTime = false;
            super.start();
        }
        catch (SocketException socketException) {
            this.tunnelLog.trace("Unable to start CCN/UDP-IP " + this.iThreadName + " thread. Unable to open socket connection.");
            this.tunnelLog.trace("Caught SocketException while binding datagram socket to port " + this.iBindPort);
            System.out.println("** " + socketException);
        }
    }

    public void pleaseStop() {
        this.setStatus("Stopped.");
        this.quittingTime = true;
    }

    public void run() {
        while (!this.quittingTime) {
            if (this.isDisplayDots()) {
                System.out.print(this.iDotChar);
            }
            try {
                this.cycle();
            }
            catch (Exception exception) {
                this.setStatus("Exception: " + exception.getClass().getName());
                this.debugLn(this.iThreadName + " - caught exception " + exception);
                if (this.isDebugOn()) {
                    exception.printStackTrace();
                }
                this.briefRest();
            }
        }
        this.closeSocket();
        this.setStatus("Stopped.");
    }

    protected void closeSocket() {
        if (this.iSocket != null) {
            this.iSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopResting() {
        Object object = this.briefRestMonitor;
        synchronized (object) {
            this.briefRestMonitor.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void briefRest() {
        Object object = this.briefRestMonitor;
        synchronized (object) {
            try {
                this.briefRestMonitor.wait(100L);
            }
            catch (Exception exception) {}
            return;
        }
    }

    protected void setStatus(String string) {
    }

    protected boolean isDebugOn() {
        return false;
    }

    protected boolean isDisplayDots() {
        return false;
    }

    protected String getDebugIntro() {
        return this.getClass().getName();
    }

    protected void debugLn(String string) {
        this.tunnelLog.trace(this.getDebugIntro() + " - " + string + '[' + Clock.ticks() + ']');
    }

    protected abstract void cycle();

    private final /* synthetic */ void this() {
        this.briefRestMonitor = new Object();
        this.tunnelLog = Log.getLog((String)"CCNTunnelLog");
    }

    public CcnTunnelProcess(BCcnTunnelHelper bCcnTunnelHelper, CcnUdpRoutingTable ccnUdpRoutingTable, String string, int n, char c) {
        super(string);
        this.this();
        this.iThreadName = string;
        this.iCcnTunnelHelper = bCcnTunnelHelper;
        this.iRoutingTable = ccnUdpRoutingTable;
        this.iBindPort = n;
        this.iDotChar = c;
    }
}

