/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelProcess;
import com.tridium.ccn.CcnUdpRoutingTable;
import com.tridium.ccn.UDPRoutingTableEntry;
import com.tridium.ccn.UDPUnsolicitedReceiveProcesser;
import com.tridium.ccn.messages.CcnResponseMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class CcnTunnelBack
extends CcnTunnelProcess {
    private static final int CCN_UDP_SEND_PORT = 50006;
    private Vector iPackets;
    private int iNextPacketId;

    private final synchronized int getNextUdpPacketId() {
        return this.iNextPacketId++ % 256;
    }

    private final byte[] convertCcnToUdp(CcnResponseMessage ccnResponseMessage, UDPUnsolicitedReceiveProcesser uDPUnsolicitedReceiveProcesser) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.getNextUdpPacketId());
        byteArrayOutputStream.write(uDPUnsolicitedReceiveProcesser.iSourceAddr);
        byteArrayOutputStream.write(uDPUnsolicitedReceiveProcesser.iSourceBus);
        byteArrayOutputStream.write(uDPUnsolicitedReceiveProcesser.iDestAddr);
        byteArrayOutputStream.write(uDPUnsolicitedReceiveProcesser.iDestBus);
        byteArrayOutputStream.write(ccnResponseMessage.getBlockLen());
        byteArrayOutputStream.write(uDPUnsolicitedReceiveProcesser.iPID);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(ccnResponseMessage.getResponseCommand());
        byte[] byArray = ccnResponseMessage.getData();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    public void putQueue(CcnResponseMessage ccnResponseMessage, UDPUnsolicitedReceiveProcesser uDPUnsolicitedReceiveProcesser) {
        int n = uDPUnsolicitedReceiveProcesser.iSourceAddr;
        UDPRoutingTableEntry uDPRoutingTableEntry = (UDPRoutingTableEntry)this.iRoutingTable.get(n);
        boolean bl = false;
        if (uDPRoutingTableEntry != null) {
            try {
                byte[] byArray = this.convertCcnToUdp(ccnResponseMessage, uDPUnsolicitedReceiveProcesser);
                int n2 = byArray.length;
                DatagramPacket datagramPacket = new DatagramPacket(byArray, n2, uDPRoutingTableEntry.getInetAddress(), uDPRoutingTableEntry.iUdpPort);
                this.putQueue(datagramPacket);
            }
            catch (UnknownHostException unknownHostException) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.debugLn("Unable to route packet back to UDP client. Client address, " + n + " not in Jace routing table.");
        }
    }

    public synchronized void putQueue(DatagramPacket datagramPacket) {
        this.iPackets.addElement(datagramPacket);
        this.stopResting();
    }

    private final synchronized DatagramPacket getNextPacketToSend() throws NoNextPacketToSendException {
        DatagramPacket datagramPacket = null;
        if (this.iPackets.size() <= 0) {
            throw new NoNextPacketToSendException();
        }
        datagramPacket = (DatagramPacket)this.iPackets.firstElement();
        this.iPackets.removeElement(datagramPacket);
        return datagramPacket;
    }

    private final boolean readAck02() throws IOException {
        byte[] byArray = new byte[10];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 10);
        this.iSocket.setSoTimeout(this.iCcnTunnelHelper.getTunnelRxResponseTimeout());
        try {
            this.iSocket.receive(datagramPacket);
        }
        catch (InterruptedIOException interruptedIOException) {
            datagramPacket = null;
        }
        boolean bl = false;
        if (datagramPacket != null) {
            bl = true;
        }
        return bl;
    }

    protected String getDebugIntro() {
        return "IP Tx: ";
    }

    private final void debugTx(DatagramPacket datagramPacket) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(datagramPacket.getData(), 0, datagramPacket.getLength());
        this.debugLn(ByteArrayUtil.toHexString((byte[])byteArrayOutputStream.toByteArray()) + ' ');
    }

    private final void sendUdpPacket(DatagramPacket datagramPacket) throws UdpSendFailureException {
        try {
            int n = 0;
            while (n < this.iCcnTunnelHelper.getTunnelRxRetryCount() + 1) {
                this.debugTx(datagramPacket);
                this.tunnelLog.trace(System.currentTimeMillis() + "::Sending packet 2 started");
                this.iSocket.send(datagramPacket);
                this.tunnelLog.trace(System.currentTimeMillis() + "::Sending packet 2 finished");
                if (!this.readAck02()) {
                    this.debugLn("Attempt No " + n + " - Transmisison not acknowledged..");
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new UdpSendFailureException(datagramPacket, iOException);
        }
    }

    protected boolean isDebugOn() {
        return this.iCcnTunnelHelper.getTunnelTxDebugOn();
    }

    protected boolean isDisplayDots() {
        return this.iCcnTunnelHelper.getTunnelTxDisplayDots();
    }

    protected void setStatus(String string) {
        this.iCcnTunnelHelper.setTunnelTxStatus(string);
    }

    protected void cycle() {
        try {
            this.setStatus("Checking for TX packet in Q");
            DatagramPacket datagramPacket = this.getNextPacketToSend();
            this.setStatus("Sending packet, " + CcnTunnelBack.getPacketString(datagramPacket));
            this.sendUdpPacket(datagramPacket);
            this.setStatus("Packet Sent, " + CcnTunnelBack.getPacketString(datagramPacket));
        }
        catch (NoNextPacketToSendException noNextPacketToSendException) {
            this.setStatus("No TX packets in Q");
            this.briefRest();
        }
        catch (UdpSendFailureException udpSendFailureException) {
            this.setStatus("Tunnel Tx Failure. See station standard out.");
            System.out.println(udpSendFailureException);
            this.briefRest();
        }
    }

    private static final String getPacketString(DatagramPacket datagramPacket) {
        return "packet  DATA='" + ByteArrayUtil.toHexString((byte[])datagramPacket.getData()) + '\'';
    }

    private final /* synthetic */ void this() {
        this.iNextPacketId = 0;
    }

    public CcnTunnelBack(BCcnTunnelHelper bCcnTunnelHelper, CcnUdpRoutingTable ccnUdpRoutingTable) {
        super(bCcnTunnelHelper, ccnUdpRoutingTable, "CcnTxTnl", 50006, 'B');
        this.this();
        this.iPackets = new Vector(20);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class NoNextPacketToSendException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NoNextPacketToSendException() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UdpSendFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private IOException iE;
        private DatagramPacket iP;

        public String toString() {
            return "Unable to send " + CcnTunnelBack.getPacketString(this.iP) + " because of " + this.iE;
        }

        public UdpSendFailureException(DatagramPacket datagramPacket, IOException iOException) {
            this.iP = datagramPacket;
            this.iE = iOException;
        }
    }
}

