/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnDeviceFolder;
import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.comm.BCcnUnsolicitedReceive;
import com.tridium.ccn.comm.CcnComm;
import com.tridium.ccn.comm.CcnCommReceiver;
import com.tridium.ccn.components.BCcnBridgesEntry;
import com.tridium.ccn.components.BCcnBridgesList;
import com.tridium.ccn.components.BCcnControllerList;
import com.tridium.ccn.enums.BCcnBaudRateEnum;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.job.BCcnAddDevicesJob;
import com.tridium.ccn.job.BCcnLearnDevicesJob;
import com.tridium.ccn.messages.CcnBroadcastDateTimeRequest;
import com.tridium.ccn.point.BCcnPointDeviceExt;
import com.tridium.ccn.point.BCcnPointTuningPolicy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.CcnRspDTUtil;
import com.tridium.platCcn.BCcnPlatformService;
import com.tridium.platCcn.CcnCommProps;
import com.tridium.platCcn.CcnUnsolMsgListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcnNetwork
extends BBasicNetwork {
    public static final Property debugOn = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property clearBridgeList = BCcnNetwork.newProperty((int)2, (boolean)false, null);
    public static final Property createTables = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property autoCreatePoints = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property bridges = BCcnNetwork.newProperty((int)1, (BValue)new BCcnBridgesList(), null);
    public static final Property controllerList = BCcnNetwork.newProperty((int)4, (BValue)new BCcnControllerList(), null);
    public static final Property learnStatus = BCcnNetwork.newProperty((int)3, (String)"Idle", null);
    public static final Property firstBusNo = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)239));
    public static final Property lastBusNo = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)239));
    public static final Property lowElemNo = BCcnNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)239));
    public static final Property highElemNo = BCcnNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)239));
    public static final Property deviceLearnCount = BCcnNetwork.newProperty((int)1, (int)0, null);
    public static final Property displayMetric = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property unsolicitedReceiveHandler = BCcnNetwork.newProperty((int)0, (BValue)new BCcnUnsolicitedReceive(), null);
    public static final Property retryCount = BCcnNetwork.newProperty((int)0, (int)3, (BFacets)BFacets.makeInt((int)0, (int)24));
    public static final Property alarmAcknowledger = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property broadcastAcknowledger = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property timeSyncStat = BCcnNetwork.newProperty((int)1, (String)"Stopped", null);
    public static final Property timeBroadcaster = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property timeSyncDisplayDots = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property busAddress = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)239));
    public static final Property elemAddress = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)1, (int)239));
    public static final Property tunnelEnable = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property tunnelHelper = BCcnNetwork.newProperty((int)0, (BValue)new BCcnTunnelHelper(), null);
    public static final Property lowLevelDebug = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property lowLevelDebugMask = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property commPort = BCcnNetwork.newProperty((int)64, (String)"COM2", null);
    public static final Property hostBaudRate = BCcnNetwork.newProperty((int)0, (BValue)BCcnBaudRateEnum.Baud9600, null);
    public static final Property learnedDevices = BCcnNetwork.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Property isFullyLicensed = BCcnNetwork.newProperty((int)4, (boolean)true, null);
    public static final Action submitDeviceDiscoveryJob = BCcnNetwork.newAction((int)4, null);
    public static final Action submitAddDevicesJob = BCcnNetwork.newAction((int)4, (BValue)new BCcnControllerList(), null);
    public static final Action getStationSideComponents = BCcnNetwork.newAction((int)4, null);
    public static final Action timeBroadCasting = BCcnNetwork.newAction((int)0, null);
    public static final Action periodicTimeBroadCasting = BCcnNetwork.newAction((int)4, null);
    public static final Type TYPE;
    private static final BAbsTime oneAm;
    private static final BAbsTime onePm;
    private BAbsTime timeLastOneOclockCheck;
    BIcon icon;
    private boolean abort;
    private boolean changingDisplay;
    private boolean discoveryInProgress;
    boolean lowLevelDebugPending;
    boolean lowLevelDebugPendingValue;
    int lowLevelDebugPendingMask;
    public boolean driverStarted;
    public BCcnPlatformService ccnPlatSrvc;
    Vector devs;
    private Clock.Ticket ticket;
    BCcnUnsolicitedReceive unsolicitRx;
    Type networkType;
    Log ccnNetworkLog;
    BCcnTable ccnTable;
    private BAlarmService alarmServ;
    static /* synthetic */ Class class$com$tridium$ccn$BCcnNetwork;
    static /* synthetic */ Class class$com$tridium$ccn$BCcnDevice;
    static /* synthetic */ Class class$com$tridium$ccn$tables$BCcnTableGroup;
    static /* synthetic */ Class class$com$tridium$ccn$tables$BCcnTable;
    static /* synthetic */ Class class$com$tridium$ccn$tables$BCcnDataTable;
    static /* synthetic */ Class class$com$tridium$ccn$components$BCcnBridgesEntry;

    public boolean getDebugOn() {
        return this.getBoolean(debugOn);
    }

    public void setDebugOn(boolean bl) {
        this.setBoolean(debugOn, bl, null);
    }

    public boolean getClearBridgeList() {
        return this.getBoolean(clearBridgeList);
    }

    public void setClearBridgeList(boolean bl) {
        this.setBoolean(clearBridgeList, bl, null);
    }

    public boolean getCreateTables() {
        return this.getBoolean(createTables);
    }

    public void setCreateTables(boolean bl) {
        this.setBoolean(createTables, bl, null);
    }

    public boolean getAutoCreatePoints() {
        return this.getBoolean(autoCreatePoints);
    }

    public void setAutoCreatePoints(boolean bl) {
        this.setBoolean(autoCreatePoints, bl, null);
    }

    public BCcnBridgesList getBridges() {
        return (BCcnBridgesList)this.get(bridges);
    }

    public void setBridges(BCcnBridgesList bCcnBridgesList) {
        this.set(bridges, (BValue)bCcnBridgesList, null);
    }

    public BCcnControllerList getControllerList() {
        return (BCcnControllerList)this.get(controllerList);
    }

    public void setControllerList(BCcnControllerList bCcnControllerList) {
        this.set(controllerList, (BValue)bCcnControllerList, null);
    }

    public String getLearnStatus() {
        return this.getString(learnStatus);
    }

    public void setLearnStatus(String string) {
        this.setString(learnStatus, string, null);
    }

    public int getFirstBusNo() {
        return this.getInt(firstBusNo);
    }

    public void setFirstBusNo(int n) {
        this.setInt(firstBusNo, n, null);
    }

    public int getLastBusNo() {
        return this.getInt(lastBusNo);
    }

    public void setLastBusNo(int n) {
        this.setInt(lastBusNo, n, null);
    }

    public int getLowElemNo() {
        return this.getInt(lowElemNo);
    }

    public void setLowElemNo(int n) {
        this.setInt(lowElemNo, n, null);
    }

    public int getHighElemNo() {
        return this.getInt(highElemNo);
    }

    public void setHighElemNo(int n) {
        this.setInt(highElemNo, n, null);
    }

    public int getDeviceLearnCount() {
        return this.getInt(deviceLearnCount);
    }

    public void setDeviceLearnCount(int n) {
        this.setInt(deviceLearnCount, n, null);
    }

    public boolean getDisplayMetric() {
        return this.getBoolean(displayMetric);
    }

    public void setDisplayMetric(boolean bl) {
        this.setBoolean(displayMetric, bl, null);
    }

    public BCcnUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BCcnUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BCcnUnsolicitedReceive bCcnUnsolicitedReceive) {
        this.set(unsolicitedReceiveHandler, (BValue)bCcnUnsolicitedReceive, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int n) {
        this.setInt(retryCount, n, null);
    }

    public boolean getAlarmAcknowledger() {
        return this.getBoolean(alarmAcknowledger);
    }

    public void setAlarmAcknowledger(boolean bl) {
        this.setBoolean(alarmAcknowledger, bl, null);
    }

    public boolean getBroadcastAcknowledger() {
        return this.getBoolean(broadcastAcknowledger);
    }

    public void setBroadcastAcknowledger(boolean bl) {
        this.setBoolean(broadcastAcknowledger, bl, null);
    }

    public String getTimeSyncStat() {
        return this.getString(timeSyncStat);
    }

    public void setTimeSyncStat(String string) {
        this.setString(timeSyncStat, string, null);
    }

    public boolean getTimeBroadcaster() {
        return this.getBoolean(timeBroadcaster);
    }

    public void setTimeBroadcaster(boolean bl) {
        this.setBoolean(timeBroadcaster, bl, null);
    }

    public boolean getTimeSyncDisplayDots() {
        return this.getBoolean(timeSyncDisplayDots);
    }

    public void setTimeSyncDisplayDots(boolean bl) {
        this.setBoolean(timeSyncDisplayDots, bl, null);
    }

    public int getBusAddress() {
        return this.getInt(busAddress);
    }

    public void setBusAddress(int n) {
        this.setInt(busAddress, n, null);
    }

    public int getElemAddress() {
        return this.getInt(elemAddress);
    }

    public void setElemAddress(int n) {
        this.setInt(elemAddress, n, null);
    }

    public boolean getTunnelEnable() {
        return this.getBoolean(tunnelEnable);
    }

    public void setTunnelEnable(boolean bl) {
        this.setBoolean(tunnelEnable, bl, null);
    }

    public BCcnTunnelHelper getTunnelHelper() {
        return (BCcnTunnelHelper)this.get(tunnelHelper);
    }

    public void setTunnelHelper(BCcnTunnelHelper bCcnTunnelHelper) {
        this.set(tunnelHelper, (BValue)bCcnTunnelHelper, null);
    }

    public boolean getLowLevelDebug() {
        return this.getBoolean(lowLevelDebug);
    }

    public void setLowLevelDebug(boolean bl) {
        this.setBoolean(lowLevelDebug, bl, null);
    }

    public int getLowLevelDebugMask() {
        return this.getInt(lowLevelDebugMask);
    }

    public void setLowLevelDebugMask(int n) {
        this.setInt(lowLevelDebugMask, n, null);
    }

    public String getCommPort() {
        return this.getString(commPort);
    }

    public void setCommPort(String string) {
        this.setString(commPort, string, null);
    }

    public BCcnBaudRateEnum getHostBaudRate() {
        return (BCcnBaudRateEnum)this.get(hostBaudRate);
    }

    public void setHostBaudRate(BCcnBaudRateEnum bCcnBaudRateEnum) {
        this.set(hostBaudRate, (BValue)bCcnBaudRateEnum, null);
    }

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public boolean getIsFullyLicensed() {
        return this.getBoolean(isFullyLicensed);
    }

    public void setIsFullyLicensed(boolean bl) {
        this.setBoolean(isFullyLicensed, bl, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public BOrd submitAddDevicesJob(BCcnControllerList bCcnControllerList) {
        return (BOrd)this.invoke(submitAddDevicesJob, (BValue)bCcnControllerList, null);
    }

    public BCcnNetwork getStationSideComponents() {
        return (BCcnNetwork)this.invoke(getStationSideComponents, null, null);
    }

    public void timeBroadCasting() {
        this.invoke(timeBroadCasting, null, null);
    }

    public void periodicTimeBroadCasting() {
        this.invoke(periodicTimeBroadCasting, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BCcnDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BCcnDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        try {
            if (Sys.getLicenseManager().getFeature("Tridium", "ccn").getFeatureName().equalsIgnoreCase("ccn")) {
                this.setIsFullyLicensed(true);
            }
            return Sys.getLicenseManager().getFeature("Tridium", "ccn");
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {
            if (Sys.getLicenseManager().getFeature("Tridium", "ccnl").getFeatureName().equalsIgnoreCase("ccnl")) {
                this.setIsFullyLicensed(false);
                return Sys.getLicenseManager().getFeature("Tridium", "ccnl");
            }
            featureNotLicensedException.printStackTrace();
            return null;
        }
    }

    public void pingOk() {
        BCcnDevice[] bCcnDeviceArray;
        super.pingOk();
        Class clazz = class$com$tridium$ccn$BCcnDevice;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$BCcnDevice = BCcnNetwork.class("[Lcom.tridium.ccn.BCcnDevice;", false);
        }
        if ((bCcnDeviceArray = (BCcnDevice[])this.getChildren(clazz)) != null && bCcnDeviceArray.length > 0) {
            int n = 0;
            while (n < bCcnDeviceArray.length) {
                bCcnDeviceArray[n].doPing();
                ++n;
            }
        }
    }

    public void started() throws Exception {
        super.started();
        Class clazz = class$com$tridium$ccn$BCcnNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$BCcnNetwork = BCcnNetwork.class("[Lcom.tridium.ccn.BCcnNetwork;", false);
        }
        this.networkType = Sys.loadType((Class)clazz);
        if (Sys.getService((Type)this.networkType) != this) {
            this.configFail("Duplicate CCN network");
            throw new IllegalStateException("Only one CCN Network allowed per station.");
        }
        boolean bl = false;
        BTuningPolicy[] bTuningPolicyArray = this.getTuningPolicies().getPolicies();
        if (bTuningPolicyArray != null && bTuningPolicyArray.length > 0) {
            int n = 0;
            while (n < bTuningPolicyArray.length) {
                if (bTuningPolicyArray[n].getName().equalsIgnoreCase("BCcnPointTuningPolicy")) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl) {
            this.getTuningPolicies().add("BCcnPointTuningPolicy", (BValue)new BCcnPointTuningPolicy());
        }
        this.unsolicitRx = this.getUnsolicitedReceiveHandler();
        this.ccnPlatSrvc = (BCcnPlatformService)Sys.getService((Type)BCcnPlatformService.TYPE);
        CcnCommProps ccnCommProps = new CcnCommProps(this.getCommPort(), (long)this.getHostBaudRate().getOrdinal(), (byte)this.getElemAddress(), (byte)this.getBusAddress(), (short)this.getResponseTimeout().getMillis(), this.getAlarmAcknowledger(), this.getBroadcastAcknowledger());
        this.ccnPlatSrvc.registerUnsolMsgListener((CcnUnsolMsgListener)this.unsolicitRx);
        this.ccnPlatSrvc.openDriverComm(ccnCommProps);
        this.driverStarted = true;
        if (this.getTimeBroadcaster()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)180000L), (Action)periodicTimeBroadCasting, null);
        }
        if (this.getTunnelEnable()) {
            this.getTunnelHelper().tunnelStart(this);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.driverStarted) {
            this.driverStarted = false;
            this.getTunnelHelper().tunnelStop();
            this.ccnPlatSrvc.closeDriver();
        }
    }

    public boolean isParentLegal(BComponent bComponent) throws LocalizableRuntimeException {
        super.isParentLegal(bComponent);
        if (!(bComponent instanceof BDriverContainer)) {
            throw new LocalizableRuntimeException("ccn", "CcnNetwork.Drop");
        }
        return true;
    }

    public boolean isChildLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BCcnNetwork) {
            throw new LocalizableRuntimeException("ccn", "CcnNetwork.ChildDrop");
        }
        return true;
    }

    protected Comm makeComm() {
        return new CcnComm(this, new CcnCommReceiver());
    }

    public CcnComm getCcnComm() {
        return (CcnComm)this.getComm();
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        BCcnLearnDevicesJob bCcnLearnDevicesJob = new BCcnLearnDevicesJob(this);
        return bCcnLearnDevicesJob.submit(null);
    }

    public BCcnNetwork doGetStationSideComponents() {
        return this;
    }

    public BOrd doSubmitAddDevicesJob(BCcnControllerList bCcnControllerList) {
        BCcnAddDevicesJob bCcnAddDevicesJob = new BCcnAddDevicesJob(this, bCcnControllerList);
        return bCcnAddDevicesJob.submit(null);
    }

    public void doTimeBroadCasting() {
        this.getCcnComm().ccnAsyncRequest().submitRequest(new CcnBroadcastDateTimeRequest(this.getCcnComm().ccnAsyncRequest(), true));
    }

    public void doPeriodicTimeBroadCasting() {
        try {
            this.checkOneOclockTimeBroadCast();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setTimeSyncStat("Running.");
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getName().equalsIgnoreCase("displaymetric")) {
            this.changingDisplay = true;
            this.updateTables((BComponent)this, ((BBoolean)this.get("displayMetric")).getBoolean());
            this.changingDisplay = false;
        }
        if (property.getName().equalsIgnoreCase("timeBroadcaster")) {
            this.toggleTimeBroadcaster();
        } else if (property.getName().equalsIgnoreCase("broadcastAcknowledger") || property.getName().equalsIgnoreCase("alarmAcknowledger") || property.getName().equalsIgnoreCase("hostBaudRate") || property.getName().equalsIgnoreCase("responseTimeout") || property.getName().equalsIgnoreCase("busAddress") || property.getName().equalsIgnoreCase("elemAddress")) {
            this.ccnPlatSrvc.changeExtendedParams(this.isBcastAck(), this.isAlarmAck(), (short)this.getResponseTimeout().getMillis(), (byte)this.getElemAddress(), (byte)this.getBusAddress(), this.getHostBaudRate().getOrdinal());
            Class clazz = class$com$tridium$ccn$BCcnDevice;
            if (clazz == null) {
                clazz = class$com$tridium$ccn$BCcnDevice = BCcnNetwork.class("[Lcom.tridium.ccn.BCcnDevice;", false);
            }
            BCcnDevice[] bCcnDeviceArray = (BCcnDevice[])this.getChildren(clazz);
            int n = 0;
            while (n < bCcnDeviceArray.length) {
                bCcnDeviceArray[n].doPing();
                ++n;
            }
        } else if (property.getName().equalsIgnoreCase("lowLevelDebug") || property.getName().equalsIgnoreCase("lowLevelDebugMask")) {
            this.ccnPlatSrvc.setLowLevelDebug(((BBoolean)this.get("lowLevelDebug")).getBoolean(), this.getLowLevelDebugMask());
        } else if (property.getName().equalsIgnoreCase("commPort")) {
            this.ccnPlatSrvc.closeDriver();
            CcnCommProps ccnCommProps = new CcnCommProps(this.getCommPort(), (long)this.getHostBaudRate().getOrdinal(), (byte)this.getElemAddress(), (byte)this.getBusAddress(), (short)this.getResponseTimeout().getMillis(), this.getAlarmAcknowledger(), this.getBroadcastAcknowledger());
            this.ccnPlatSrvc.openDriverComm(ccnCommProps);
            Class clazz = class$com$tridium$ccn$BCcnDevice;
            if (clazz == null) {
                clazz = class$com$tridium$ccn$BCcnDevice = BCcnNetwork.class("[Lcom.tridium.ccn.BCcnDevice;", false);
            }
            BCcnDevice[] bCcnDeviceArray = (BCcnDevice[])this.getChildren(clazz);
            int n = 0;
            while (n < bCcnDeviceArray.length) {
                bCcnDeviceArray[n].doPing();
                ++n;
            }
        } else if (property.getName().equalsIgnoreCase("tunnelEnable")) {
            if (this.getTunnelEnable() && this.isCommActive()) {
                this.getTunnelHelper().tunnelStart(this);
            } else {
                this.getTunnelHelper().tunnelStop();
            }
        }
    }

    public final void updateTables(BComponent bComponent, boolean bl) {
        block6: {
            ArrayList arrayList = this.getCcnTables();
            if (arrayList == null) break block6;
            int n = 0;
            while (n < arrayList.size()) {
                block8: {
                    BCcnProxyExt[] bCcnProxyExtArray;
                    BCcnTable bCcnTable;
                    block9: {
                        block7: {
                            this.ccnTable = (BCcnTable)((Object)arrayList.get(n));
                            if (!(this.ccnTable instanceof BCcnDataTable)) break block7;
                            this.changingDisplay = true;
                            bCcnTable = (BCcnDataTable)((Object)arrayList.get(n));
                            bCcnTable.setPreMetricDisplay(this.ccnTable.getCurMetricDisplay());
                            bCcnTable.setCurMetricDisplay(bl);
                            bCcnProxyExtArray = bCcnTable.getCreatedPoints();
                            if (((BCcnDataTable)bCcnTable).getPointCreateCount() == 0 || bCcnProxyExtArray == null || bCcnProxyExtArray.length == 0) break block8;
                            bCcnTable.changePointsDisplay(bCcnProxyExtArray);
                            this.changingDisplay = false;
                        }
                        if (!(this.ccnTable instanceof BCcnPicTable)) break block9;
                        this.changingDisplay = true;
                        bCcnTable = (BCcnPicTable)((Object)arrayList.get(n));
                        bCcnTable.setPreMetricDisplay(this.ccnTable.getCurMetricDisplay());
                        bCcnTable.setCurMetricDisplay(bl);
                        bCcnProxyExtArray = bCcnTable.getCreatedPoints();
                        if (((BCcnPicTable)bCcnTable).getPointCreateCount() == 0 || bCcnProxyExtArray == null || bCcnProxyExtArray.length == 0) break block8;
                        bCcnTable.changePointsDisplay(bCcnProxyExtArray);
                        this.changingDisplay = false;
                    }
                    if (this.ccnTable instanceof BCcnFidTable) {
                        this.changingDisplay = true;
                        bCcnTable = (BCcnFidTable)((Object)arrayList.get(n));
                        bCcnTable.setPreMetricDisplay(this.ccnTable.getCurMetricDisplay());
                        bCcnTable.setCurMetricDisplay(bl);
                        bCcnProxyExtArray = bCcnTable.getCreatedPoints();
                        if (((BCcnFidTable)bCcnTable).getPointCreateCount() != 0 && bCcnProxyExtArray != null && bCcnProxyExtArray.length != 0) {
                            bCcnTable.changePointsDisplay(bCcnProxyExtArray);
                            this.changingDisplay = false;
                        }
                    }
                }
                ++n;
            }
        }
    }

    public ArrayList getCcnTables() {
        BCcnDevice[] bCcnDeviceArray;
        ArrayList<BCcnTable> arrayList = new ArrayList<BCcnTable>();
        Class clazz = class$com$tridium$ccn$BCcnDevice;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$BCcnDevice = BCcnNetwork.class("[Lcom.tridium.ccn.BCcnDevice;", false);
        }
        if ((bCcnDeviceArray = (BCcnDevice[])this.getChildren(clazz)) != null) {
            int n = 0;
            while (n < bCcnDeviceArray.length) {
                BCcnTableGroup[] bCcnTableGroupArray;
                BCcnPointDeviceExt bCcnPointDeviceExt = bCcnDeviceArray[n].getPoints();
                Class clazz2 = class$com$tridium$ccn$tables$BCcnTableGroup;
                if (clazz2 == null) {
                    clazz2 = BCcnNetwork.class("[Lcom.tridium.ccn.tables.BCcnTableGroup;", false);
                }
                if ((bCcnTableGroupArray = (BCcnTableGroup[])bCcnPointDeviceExt.getChildren(clazz2)) != null) {
                    int n2 = 0;
                    while (n2 < bCcnTableGroupArray.length) {
                        BCcnTable[] bCcnTableArray;
                        BCcnTableGroup bCcnTableGroup = bCcnTableGroupArray[n2];
                        Class clazz3 = class$com$tridium$ccn$tables$BCcnTable;
                        if (clazz3 == null) {
                            clazz3 = BCcnNetwork.class("[Lcom.tridium.ccn.tables.BCcnTable;", false);
                        }
                        if ((bCcnTableArray = (BCcnTable[])bCcnTableGroup.getChildren(clazz3)) != null) {
                            int n3 = 0;
                            while (n3 < bCcnTableArray.length) {
                                if (bCcnTableArray[n3] instanceof BCcnPocTable) {
                                    BCcnDataTable[] bCcnDataTableArray;
                                    BCcnTable bCcnTable = bCcnTableArray[n3];
                                    Class clazz4 = class$com$tridium$ccn$tables$BCcnDataTable;
                                    if (clazz4 == null) {
                                        clazz4 = BCcnNetwork.class("[Lcom.tridium.ccn.tables.BCcnDataTable;", false);
                                    }
                                    if ((bCcnDataTableArray = (BCcnDataTable[])bCcnTable.getChildren(clazz4)) != null) {
                                        int n4 = 0;
                                        while (n4 < bCcnDataTableArray.length) {
                                            arrayList.add(bCcnDataTableArray[n4]);
                                            ++n4;
                                        }
                                    }
                                }
                                arrayList.add(bCcnTableArray[n3]);
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    public void setLowLevelDebug(boolean bl, int n) {
        if (this.driverStarted) {
            this.lowLevelDebugPending = false;
            this.ccnPlatSrvc.setLowLevelDebug(bl, n);
        } else {
            this.lowLevelDebugPending = true;
            this.lowLevelDebugPendingValue = bl;
            this.lowLevelDebugPendingMask = n;
        }
    }

    private final void toggleTimeBroadcaster() {
        if (this.isTimeBroadCaster()) {
            this.setTimeSyncStat("Running...");
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)180000L), (Action)periodicTimeBroadCasting, null);
        } else {
            this.ticket = null;
            this.setTimeSyncStat("Stopped...");
        }
    }

    public boolean isTimeBroadCaster() {
        return ((BBoolean)this.get("timeBroadcaster")).getBoolean();
    }

    public boolean isBcastAck() {
        return ((BBoolean)this.get("broadcastAcknowledger")).getBoolean();
    }

    public boolean isAlarmAck() {
        return ((BBoolean)this.get("alarmAcknowledger")).getBoolean();
    }

    public boolean isDiscoveryInProgress() {
        if (!this.discoveryInProgress) {
            return false;
        }
        this.discoveryInProgress = false;
        return true;
    }

    public void setDiscoveryInProgress(boolean bl) {
        this.discoveryInProgress = bl;
    }

    public Vector getCcnDevices() {
        this.devs = new Vector(50);
        BCcnNetwork.getDevices((BComponent)this, this.devs);
        return this.devs;
    }

    public static void getDevices(BComponent bComponent, Vector vector) {
        if (bComponent == null) {
            return;
        }
        vector.removeAllElements();
        BComponent[] bComponentArray = bComponent.getChildComponents();
        if (bComponentArray == null || bComponentArray.length < 1) {
            return;
        }
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] instanceof BCcnDevice) {
                vector.addElement(bComponentArray[n]);
            } else {
                BCcnNetwork.getDevices(bComponentArray[n], vector);
            }
            ++n;
        }
    }

    public boolean isBridge(int n) {
        BCcnBridgesEntry[] bCcnBridgesEntryArray;
        if (n == 0) {
            return false;
        }
        BCcnBridgesList bCcnBridgesList = this.getBridges();
        Class clazz = class$com$tridium$ccn$components$BCcnBridgesEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$components$BCcnBridgesEntry = BCcnNetwork.class("[Lcom.tridium.ccn.components.BCcnBridgesEntry;", false);
        }
        if ((bCcnBridgesEntryArray = (BCcnBridgesEntry[])bCcnBridgesList.getChildren(clazz)) == null) {
            return false;
        }
        if (bCcnBridgesEntryArray == null) {
            return false;
        }
        if (n != 0) {
            int n2 = 0;
            while (n2 < bCcnBridgesEntryArray.length) {
                if (bCcnBridgesEntryArray[n2].getBridgeBus() == n) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean bl) {
        this.abort = bl;
    }

    public boolean isChangingDisplay() {
        return this.changingDisplay;
    }

    public BCcnDevice findCcnDevice(BComponent bComponent) {
        BComponent[] bComponentArray = this.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            BComponent bComponent2 = bComponentArray[n];
            if (bComponent2 instanceof BCcnDevice) {
                BCcnDevice bCcnDevice = (BCcnDevice)bComponent2;
                return bCcnDevice;
            }
            ++n;
        }
        return null;
    }

    public void changeExtendedSettings(boolean bl, boolean bl2, short s, byte by, byte by2, int n) {
        String string = null;
        int n2 = 0;
        if (this.driverStarted) {
            int n3 = this.ccnPlatSrvc.changeExtendedParams(bl, bl2, s, by, by2, n);
            if (n3 == 0) {
                return;
            }
            n2 = this.convertChangeExtendedSettingReturnValToCcnErrorCode(n3);
            string = new String("Unable to change native settings.  Native return code = " + n3);
        } else {
            string = new String("Cannot change extended settings because the native driver has not yet been started.");
        }
        throw new CcnRuntimeException(n2, string);
    }

    private final int convertChangeExtendedSettingReturnValToCcnErrorCode(int n) {
        if (n == -4) {
            return 6488272;
        }
        if (n == -5) {
            return 6488271;
        }
        return 6488273;
    }

    public void checkOneOclockTimeBroadCast() {
        BAbsTime bAbsTime = BAbsTime.now();
        if (this.timeLastOneOclockCheck != null && (CcnRspDTUtil.timeJustPassed(oneAm, this.timeLastOneOclockCheck, bAbsTime) || CcnRspDTUtil.timeJustPassed(onePm, this.timeLastOneOclockCheck, bAbsTime))) {
            this.getCcnComm().ccnAsyncRequest().submitRequest(new CcnBroadcastDateTimeRequest(this.getCcnComm().ccnAsyncRequest(), true));
        }
        this.timeLastOneOclockCheck = bAbsTime;
    }

    public AgentList getAgents(Context context) {
        TypeInfo typeInfo = Sys.getRegistry().getType("workbench:PropertySheet");
        AgentList agentList = super.getAgents(context);
        int n = 0;
        while (n < agentList.size()) {
            if (agentList.get(n).getAgentType().is(typeInfo)) {
                agentList.remove(n);
                break;
            }
            ++n;
        }
        return agentList;
    }

    public void addAlarm(BString bString, BString bString2, BString bString3) {
        try {
            if (this.alarmServ == null) {
                this.alarmServ = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            }
            BFacets bFacets = BFacets.make((Map)this.ccnHashMap(bString, bString2, bString3));
            BAlarmRecord bAlarmRecord = new BAlarmRecord();
            bAlarmRecord.setSource(BOrdList.make((BOrd)this.getAlarmSourceInfo().getNavOrd()));
            bAlarmRecord.setAlarmClass(this.getAlarmSourceInfo().getAlarmClass());
            bAlarmRecord.setAlarmData(bFacets);
            this.alarmServ.routeAlarm(bAlarmRecord);
        }
        catch (Exception exception) {
            this.ccnNetworkLog.error("Exception on add Alarm ::: " + exception.toString());
        }
    }

    private final HashMap ccnHashMap(BString bString, BString bString2, BString bString3) {
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmText", bString);
        hashMap.put("alarmType", bString2);
        hashMap.put("alarmValue", bString3);
        return hashMap;
    }

    public boolean isNetworkStatusOk() {
        return !this.isDown() && !this.isDisabled() && !this.isFatalFault();
    }

    public BIcon getIcon() {
        return this.icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.timeLastOneOclockCheck = null;
        this.icon = BIcon.make((BOrd)BOrd.make((String)"local:|module://ccn/com/tridium/ccn/images/CcnNetwork.gif"));
        this.abort = false;
        this.changingDisplay = false;
        this.discoveryInProgress = false;
        this.lowLevelDebugPending = false;
        this.lowLevelDebugPendingValue = false;
        this.lowLevelDebugPendingMask = 0;
        this.driverStarted = false;
        this.ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");
        this.alarmServ = null;
    }

    public BCcnNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ccn$BCcnNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$BCcnNetwork = BCcnNetwork.class("[Lcom.tridium.ccn.BCcnNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        oneAm = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.make((int)1, (int)0, (int)0, (int)0));
        onePm = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.make((int)13, (int)0, (int)0, (int)0));
    }
}

