/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.ccn.BCcnDeviceFolder;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnControllerEntry;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.enums.BCcnBaudRateEnum;
import com.tridium.ccn.enums.BCcnDeviceTypeEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.job.BCcnAddTablesJob;
import com.tridium.ccn.job.BCcnLearnTablesJob;
import com.tridium.ccn.messages.CcnFetchDeviceDataRequest;
import com.tridium.ccn.messages.CcnPointConfigDownloadRequest;
import com.tridium.ccn.messages.CcnPointConfigUploadRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnRequestMessage;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnPointDeviceExt;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnAlarmUtil;
import com.tridium.ccn.util.CcnRspDTUtil;
import com.tridium.ccn.util.CcnRspDevUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnDataWrapper;
import com.tridium.platCcn.CcnTableDef;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcnDevice
extends BBasicDevice {
    public static final Property busNo = BCcnDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)238));
    public static final Property elemNo = BCcnDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)238));
    public static final Property deviceName = BCcnDevice.newProperty((int)0, (String)"CcnDevice", null);
    public static final Property duplicateDeviceName = BCcnDevice.newProperty((int)4, (String)"CcnDevice", null);
    public static final Property picType = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property applicationVersion = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property deviceStatus = BCcnDevice.newProperty((int)1, (String)"Off-Line", null);
    public static final Property deviceDescription = BCcnDevice.newProperty((int)65, (String)" ", null);
    public static final Property location = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property partNo = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property modelNo = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property serialNo = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property referenceNo = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property platformNo = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property osVersion = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property deviceType = BCcnDevice.newProperty((int)1, (BValue)BCcnDeviceTypeEnum.Unknown, null);
    public static final Property primaryBaudRate = BCcnDevice.newProperty((int)65, (BValue)BCcnBaudRateEnum.Baud9600, null);
    public static final Property secondaryBaudRate = BCcnDevice.newProperty((int)65, (BValue)BCcnBaudRateEnum.Baud9600, null);
    public static final Property maxTableNumber = BCcnDevice.newProperty((int)64, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property tableLearnCount = BCcnDevice.newProperty((int)1, (int)0, null);
    public static final Property learnStatus = BCcnDevice.newProperty((int)1, (String)"Idle", null);
    public static final Property tableCreateCount = BCcnDevice.newProperty((int)1, (int)0, null);
    public static final Property deviceTime = BCcnDevice.newProperty((int)65, (BValue)BAbsTime.make(), null);
    public static final Property devicePingStatus = BCcnDevice.newProperty((int)65, (String)"", null);
    public static final Property overWriteEnabled = BCcnDevice.newProperty((int)0, (boolean)false, null);
    public static final Property lrnUsrCfgPic10 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnStaDspPic11 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnMaintPic12 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnSvcCfgPic13 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnUsrCfgPoc14 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnMaintPoc15 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnSvcCfgPoc16 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnSetPtsPic17 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnSetPtsPoc18 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnAlmHstPic43 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnTimSchDTT614 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnStaDspTT500 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnTimSchTT503 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnSetPtsTT504 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property lrnHolSchTT505 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    public static final Property isEnhancedVersion = BCcnDevice.newProperty((int)1, (boolean)false, null);
    public static final Property statusDisplay = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property userConfiguration = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property maintenance = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property serviceConfiguration = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property setPoints = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property timeSchedules = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property alarmHistory = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property holiday = BCcnDevice.newProperty((int)0, (boolean)true, null);
    public static final Property learnedTables = BCcnDevice.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Property points = BCcnDevice.newProperty((int)0, (BValue)new BCcnPointDeviceExt(), null);
    public static final Property pollProxyExtCount = BCcnDevice.newProperty((int)4, (int)0, null);
    public static final Property tableAccessRights = BCcnDevice.newProperty((int)4, (BValue)new BCcnByteList(), null);
    public static final Action submitTableDiscoveryJob = BCcnDevice.newAction((int)4, null);
    public static final Action submitAddTablesJob = BCcnDevice.newAction((int)4, (BValue)new BCcnTableList(), null);
    public static final Action fetch = BCcnDevice.newAction((int)0, null);
    public static final Type TYPE;
    BIcon icon;
    private boolean hasHadAtLeastOneRealPing;
    private boolean unsuccessfulPingFlag;
    private long lastUnsuccessfulPingTicks;
    private long maxSuccessfulPingInterval;
    private boolean pingForTimeAsOpposedToDate;
    private boolean abort;
    private Hashtable registeredTableGroups;
    public Vector tablesVector;
    private Vector registeredObjects;
    public BCcnTable[] pollTableExts;
    public BCcnTable[] allTableExts;
    public Vector vPollTableExts;
    public Vector vAllTableExts;
    BCcnControllerEntry entry;
    private Vector vTable;
    BCcnDeviceFolder devFolder;
    BCcnNetwork objNetwork;
    Log ccnNetworkLog;
    private BAlarmService alarmServ;
    static /* synthetic */ Class class$com$tridium$ccn$BCcnDevice;

    public int getBusNo() {
        return this.getInt(busNo);
    }

    public void setBusNo(int n) {
        this.setInt(busNo, n, null);
    }

    public int getElemNo() {
        return this.getInt(elemNo);
    }

    public void setElemNo(int n) {
        this.setInt(elemNo, n, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public String getDuplicateDeviceName() {
        return this.getString(duplicateDeviceName);
    }

    public void setDuplicateDeviceName(String string) {
        this.setString(duplicateDeviceName, string, null);
    }

    public String getPicType() {
        return this.getString(picType);
    }

    public void setPicType(String string) {
        this.setString(picType, string, null);
    }

    public String getApplicationVersion() {
        return this.getString(applicationVersion);
    }

    public void setApplicationVersion(String string) {
        this.setString(applicationVersion, string, null);
    }

    public String getDeviceStatus() {
        return this.getString(deviceStatus);
    }

    public void setDeviceStatus(String string) {
        this.setString(deviceStatus, string, null);
    }

    public String getDeviceDescription() {
        return this.getString(deviceDescription);
    }

    public void setDeviceDescription(String string) {
        this.setString(deviceDescription, string, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String string) {
        this.setString(location, string, null);
    }

    public String getPartNo() {
        return this.getString(partNo);
    }

    public void setPartNo(String string) {
        this.setString(partNo, string, null);
    }

    public String getModelNo() {
        return this.getString(modelNo);
    }

    public void setModelNo(String string) {
        this.setString(modelNo, string, null);
    }

    public String getSerialNo() {
        return this.getString(serialNo);
    }

    public void setSerialNo(String string) {
        this.setString(serialNo, string, null);
    }

    public String getReferenceNo() {
        return this.getString(referenceNo);
    }

    public void setReferenceNo(String string) {
        this.setString(referenceNo, string, null);
    }

    public String getPlatformNo() {
        return this.getString(platformNo);
    }

    public void setPlatformNo(String string) {
        this.setString(platformNo, string, null);
    }

    public String getOsVersion() {
        return this.getString(osVersion);
    }

    public void setOsVersion(String string) {
        this.setString(osVersion, string, null);
    }

    public BCcnDeviceTypeEnum getDeviceType() {
        return (BCcnDeviceTypeEnum)this.get(deviceType);
    }

    public void setDeviceType(BCcnDeviceTypeEnum bCcnDeviceTypeEnum) {
        this.set(deviceType, (BValue)bCcnDeviceTypeEnum, null);
    }

    public BCcnBaudRateEnum getPrimaryBaudRate() {
        return (BCcnBaudRateEnum)this.get(primaryBaudRate);
    }

    public void setPrimaryBaudRate(BCcnBaudRateEnum bCcnBaudRateEnum) {
        this.set(primaryBaudRate, (BValue)bCcnBaudRateEnum, null);
    }

    public BCcnBaudRateEnum getSecondaryBaudRate() {
        return (BCcnBaudRateEnum)this.get(secondaryBaudRate);
    }

    public void setSecondaryBaudRate(BCcnBaudRateEnum bCcnBaudRateEnum) {
        this.set(secondaryBaudRate, (BValue)bCcnBaudRateEnum, null);
    }

    public int getMaxTableNumber() {
        return this.getInt(maxTableNumber);
    }

    public void setMaxTableNumber(int n) {
        this.setInt(maxTableNumber, n, null);
    }

    public int getTableLearnCount() {
        return this.getInt(tableLearnCount);
    }

    public void setTableLearnCount(int n) {
        this.setInt(tableLearnCount, n, null);
    }

    public String getLearnStatus() {
        return this.getString(learnStatus);
    }

    public void setLearnStatus(String string) {
        this.setString(learnStatus, string, null);
    }

    public int getTableCreateCount() {
        return this.getInt(tableCreateCount);
    }

    public void setTableCreateCount(int n) {
        this.setInt(tableCreateCount, n, null);
    }

    public BAbsTime getDeviceTime() {
        return (BAbsTime)this.get(deviceTime);
    }

    public void setDeviceTime(BAbsTime bAbsTime) {
        this.set(deviceTime, (BValue)bAbsTime, null);
    }

    public String getDevicePingStatus() {
        return this.getString(devicePingStatus);
    }

    public void setDevicePingStatus(String string) {
        this.setString(devicePingStatus, string, null);
    }

    public boolean getOverWriteEnabled() {
        return this.getBoolean(overWriteEnabled);
    }

    public void setOverWriteEnabled(boolean bl) {
        this.setBoolean(overWriteEnabled, bl, null);
    }

    public boolean getLrnUsrCfgPic10() {
        return this.getBoolean(lrnUsrCfgPic10);
    }

    public void setLrnUsrCfgPic10(boolean bl) {
        this.setBoolean(lrnUsrCfgPic10, bl, null);
    }

    public boolean getLrnStaDspPic11() {
        return this.getBoolean(lrnStaDspPic11);
    }

    public void setLrnStaDspPic11(boolean bl) {
        this.setBoolean(lrnStaDspPic11, bl, null);
    }

    public boolean getLrnMaintPic12() {
        return this.getBoolean(lrnMaintPic12);
    }

    public void setLrnMaintPic12(boolean bl) {
        this.setBoolean(lrnMaintPic12, bl, null);
    }

    public boolean getLrnSvcCfgPic13() {
        return this.getBoolean(lrnSvcCfgPic13);
    }

    public void setLrnSvcCfgPic13(boolean bl) {
        this.setBoolean(lrnSvcCfgPic13, bl, null);
    }

    public boolean getLrnUsrCfgPoc14() {
        return this.getBoolean(lrnUsrCfgPoc14);
    }

    public void setLrnUsrCfgPoc14(boolean bl) {
        this.setBoolean(lrnUsrCfgPoc14, bl, null);
    }

    public boolean getLrnMaintPoc15() {
        return this.getBoolean(lrnMaintPoc15);
    }

    public void setLrnMaintPoc15(boolean bl) {
        this.setBoolean(lrnMaintPoc15, bl, null);
    }

    public boolean getLrnSvcCfgPoc16() {
        return this.getBoolean(lrnSvcCfgPoc16);
    }

    public void setLrnSvcCfgPoc16(boolean bl) {
        this.setBoolean(lrnSvcCfgPoc16, bl, null);
    }

    public boolean getLrnSetPtsPic17() {
        return this.getBoolean(lrnSetPtsPic17);
    }

    public void setLrnSetPtsPic17(boolean bl) {
        this.setBoolean(lrnSetPtsPic17, bl, null);
    }

    public boolean getLrnSetPtsPoc18() {
        return this.getBoolean(lrnSetPtsPoc18);
    }

    public void setLrnSetPtsPoc18(boolean bl) {
        this.setBoolean(lrnSetPtsPoc18, bl, null);
    }

    public boolean getLrnAlmHstPic43() {
        return this.getBoolean(lrnAlmHstPic43);
    }

    public void setLrnAlmHstPic43(boolean bl) {
        this.setBoolean(lrnAlmHstPic43, bl, null);
    }

    public boolean getLrnTimSchDTT614() {
        return this.getBoolean(lrnTimSchDTT614);
    }

    public void setLrnTimSchDTT614(boolean bl) {
        this.setBoolean(lrnTimSchDTT614, bl, null);
    }

    public boolean getLrnStaDspTT500() {
        return this.getBoolean(lrnStaDspTT500);
    }

    public void setLrnStaDspTT500(boolean bl) {
        this.setBoolean(lrnStaDspTT500, bl, null);
    }

    public boolean getLrnTimSchTT503() {
        return this.getBoolean(lrnTimSchTT503);
    }

    public void setLrnTimSchTT503(boolean bl) {
        this.setBoolean(lrnTimSchTT503, bl, null);
    }

    public boolean getLrnSetPtsTT504() {
        return this.getBoolean(lrnSetPtsTT504);
    }

    public void setLrnSetPtsTT504(boolean bl) {
        this.setBoolean(lrnSetPtsTT504, bl, null);
    }

    public boolean getLrnHolSchTT505() {
        return this.getBoolean(lrnHolSchTT505);
    }

    public void setLrnHolSchTT505(boolean bl) {
        this.setBoolean(lrnHolSchTT505, bl, null);
    }

    public boolean getIsEnhancedVersion() {
        return this.getBoolean(isEnhancedVersion);
    }

    public void setIsEnhancedVersion(boolean bl) {
        this.setBoolean(isEnhancedVersion, bl, null);
    }

    public boolean getStatusDisplay() {
        return this.getBoolean(statusDisplay);
    }

    public void setStatusDisplay(boolean bl) {
        this.setBoolean(statusDisplay, bl, null);
    }

    public boolean getUserConfiguration() {
        return this.getBoolean(userConfiguration);
    }

    public void setUserConfiguration(boolean bl) {
        this.setBoolean(userConfiguration, bl, null);
    }

    public boolean getMaintenance() {
        return this.getBoolean(maintenance);
    }

    public void setMaintenance(boolean bl) {
        this.setBoolean(maintenance, bl, null);
    }

    public boolean getServiceConfiguration() {
        return this.getBoolean(serviceConfiguration);
    }

    public void setServiceConfiguration(boolean bl) {
        this.setBoolean(serviceConfiguration, bl, null);
    }

    public boolean getSetPoints() {
        return this.getBoolean(setPoints);
    }

    public void setSetPoints(boolean bl) {
        this.setBoolean(setPoints, bl, null);
    }

    public boolean getTimeSchedules() {
        return this.getBoolean(timeSchedules);
    }

    public void setTimeSchedules(boolean bl) {
        this.setBoolean(timeSchedules, bl, null);
    }

    public boolean getAlarmHistory() {
        return this.getBoolean(alarmHistory);
    }

    public void setAlarmHistory(boolean bl) {
        this.setBoolean(alarmHistory, bl, null);
    }

    public boolean getHoliday() {
        return this.getBoolean(holiday);
    }

    public void setHoliday(boolean bl) {
        this.setBoolean(holiday, bl, null);
    }

    public BFolder getLearnedTables() {
        return (BFolder)this.get(learnedTables);
    }

    public void setLearnedTables(BFolder bFolder) {
        this.set(learnedTables, (BValue)bFolder, null);
    }

    public BCcnPointDeviceExt getPoints() {
        return (BCcnPointDeviceExt)this.get(points);
    }

    public void setPoints(BCcnPointDeviceExt bCcnPointDeviceExt) {
        this.set(points, (BValue)bCcnPointDeviceExt, null);
    }

    public int getPollProxyExtCount() {
        return this.getInt(pollProxyExtCount);
    }

    public void setPollProxyExtCount(int n) {
        this.setInt(pollProxyExtCount, n, null);
    }

    public BCcnByteList getTableAccessRights() {
        return (BCcnByteList)this.get(tableAccessRights);
    }

    public void setTableAccessRights(BCcnByteList bCcnByteList) {
        this.set(tableAccessRights, (BValue)bCcnByteList, null);
    }

    public BOrd submitTableDiscoveryJob() {
        return (BOrd)this.invoke(submitTableDiscoveryJob, null, null);
    }

    public BOrd submitAddTablesJob(BCcnTableList bCcnTableList) {
        return (BOrd)this.invoke(submitAddTablesJob, (BValue)bCcnTableList, null);
    }

    public void fetch() {
        this.invoke(fetch, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isDeviceFID() {
        boolean bl = false;
        if (this.getPicType().equalsIgnoreCase("203UC") || this.getPicType().equalsIgnoreCase("201X")) {
            bl = true;
        }
        return bl;
    }

    public final BCcnNetwork getCcnNetwork() {
        return (BCcnNetwork)this.getNetwork();
    }

    public BCcnDeviceFolder getDeviceFolder() {
        if (this.devFolder == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BCcnDeviceFolder) {
                    this.devFolder = (BCcnDeviceFolder)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.devFolder;
    }

    public BCcnNetwork getCarrierNetwork() {
        if (this.objNetwork == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BCcnNetwork) {
                    this.objNetwork = (BCcnNetwork)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.objNetwork;
    }

    public Type getNetworkType() {
        return BCcnNetwork.TYPE;
    }

    public BOrd doSubmitTableDiscoveryJob() {
        BCcnLearnTablesJob bCcnLearnTablesJob = new BCcnLearnTablesJob(this);
        return bCcnLearnTablesJob.submit(null);
    }

    public BOrd doSubmitAddTablesJob(BCcnTableList bCcnTableList) {
        BCcnAddTablesJob bCcnAddTablesJob = new BCcnAddTablesJob(this, bCcnTableList);
        return bCcnAddTablesJob.submit(null);
    }

    public boolean isParentLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BCcnNetwork || bComponent instanceof BCcnDeviceFolder) {
            return true;
        }
        throw new LocalizableRuntimeException("ccn", "CcnDevice.Drop");
    }

    public boolean isChildLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BCcnDevice) {
            throw new LocalizableRuntimeException("ccn", "CcnDevice.ChildDrop");
        }
        return true;
    }

    public void started() throws Exception {
        super.started();
        if (this.isDeviceFID()) {
            this.loadTableGroupsForFID();
        }
        this.reviewLicense();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getName().equalsIgnoreCase("statusDisplay")) {
            if (!this.isDeviceFID()) {
                this.setLrnStaDspPic11(((BBoolean)this.get("statusDisplay")).getBoolean());
            } else {
                this.setLrnStaDspTT500(((BBoolean)this.get("statusDisplay")).getBoolean());
            }
        }
        if (property.getName().equalsIgnoreCase("userConfiguration")) {
            this.setLrnUsrCfgPic10(((BBoolean)this.get("userConfiguration")).getBoolean());
            this.setLrnUsrCfgPoc14(((BBoolean)this.get("userConfiguration")).getBoolean());
        }
        if (property.getName().equalsIgnoreCase("Maintenance")) {
            this.setLrnMaintPic12(((BBoolean)this.get("maintenance")).getBoolean());
            this.setLrnMaintPoc15(((BBoolean)this.get("maintenance")).getBoolean());
        }
        if (property.getName().equalsIgnoreCase("setPoints")) {
            if (!this.isDeviceFID()) {
                this.setLrnSetPtsPic17(((BBoolean)this.get("setPoints")).getBoolean());
                this.setLrnSetPtsPoc18(((BBoolean)this.get("setPoints")).getBoolean());
            } else {
                this.setLrnSetPtsTT504(((BBoolean)this.get("setPoints")).getBoolean());
            }
        }
        if (property.getName().equalsIgnoreCase("timeSchedules")) {
            if (!this.isDeviceFID()) {
                this.setLrnUsrCfgPoc14(((BBoolean)this.get("userConfiguration")).getBoolean());
                this.setLrnTimSchDTT614(((BBoolean)this.get("timeSchedules")).getBoolean());
            } else {
                this.setLrnTimSchTT503(((BBoolean)this.get("timeSchedules")).getBoolean());
            }
        }
        if (property.getName().equalsIgnoreCase("serviceConfiguration")) {
            this.setLrnSvcCfgPic13(((BBoolean)this.get("serviceConfiguration")).getBoolean());
            this.setLrnSvcCfgPoc16(((BBoolean)this.get("serviceConfiguration")).getBoolean());
        }
        if (property.getName().equalsIgnoreCase("alarmHistory")) {
            this.setLrnAlmHstPic43(((BBoolean)this.get("alarmHistory")).getBoolean());
        }
        if (property.getName().equalsIgnoreCase("holiday")) {
            this.setLrnHolSchTT505(((BBoolean)this.get("holiday")).getBoolean());
        } else if ((property.getName().equalsIgnoreCase("lrnUsrCfgPic10") || property.getName().equalsIgnoreCase("lrnMaintPic12") || property.getName().equalsIgnoreCase("lrnSvcCfgPic13") || property.getName().equalsIgnoreCase("lrnUsrCfgPoc14") || property.getName().equalsIgnoreCase("lrnMaintPoc15") || property.getName().equalsIgnoreCase("lrnSvcCfgPoc16")) && ((BBoolean)this.get(property)).getBoolean() && !this.getIsEnhancedVersion()) {
            throw new CcnRuntimeException(6488275, this.getSummaryString() + "Sorry, station not licensed to set " + property.getName() + " to true.");
        }
        if (property.getName().equalsIgnoreCase("busNo") || property.getName().equalsIgnoreCase("elemNo")) {
            this.doPing();
        }
    }

    public void loadTableGroupsForFID() {
        this.setFlags(this.getSlot("userConfiguration"), 4);
        this.setFlags(this.getSlot("maintenance"), 4);
        this.setFlags(this.getSlot("serviceConfiguration"), 4);
        this.setFlags(this.getSlot("alarmHistory"), 4);
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    protected IFuture postUpload(BUploadParameters bUploadParameters, Context context) {
        try {
            this.doUpload(bUploadParameters, context);
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected IFuture postDownload(BDownloadParameters bDownloadParameters, Context context) {
        try {
            this.doDownload(bDownloadParameters, context);
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void doUpload(BUploadParameters bUploadParameters, Context context) throws Exception {
        switch (this.readyUploadDownload()) {
            case 0: {
                break;
            }
            case 1: {
                throw new LocalizableRuntimeException("ccn", "CcnUpload.error1");
            }
            case 2: {
                throw new LocalizableRuntimeException("ccn", "CcnUpload.error2");
            }
            default: {
                throw new LocalizableRuntimeException("ccn", "CcnUpload.error3");
            }
        }
        CcnPointConfigUploadRequest ccnPointConfigUploadRequest = new CcnPointConfigUploadRequest(this);
        this.getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(ccnPointConfigUploadRequest);
    }

    public void doDownload(BDownloadParameters bDownloadParameters, Context context) throws Exception {
        switch (this.readyUploadDownload()) {
            case 0: {
                break;
            }
            case 1: {
                throw new LocalizableRuntimeException("ccn", "CcnDownload.error1");
            }
            case 2: {
                throw new LocalizableRuntimeException("ccn", "CcnDownload.error1");
            }
            default: {
                throw new LocalizableRuntimeException("ccn", "CcnDownload.error1");
            }
        }
        this.vTable = new Vector();
        this.getExistingTableArray((BComponent)this, this.vTable);
        BCcnTable[] bCcnTableArray = new BCcnTable[this.vTable.size()];
        this.vTable.copyInto((Object[])bCcnTableArray);
        CcnPointConfigDownloadRequest ccnPointConfigDownloadRequest = new CcnPointConfigDownloadRequest(bCcnTableArray, this);
        this.getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(ccnPointConfigDownloadRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPing() {
        String string;
        block13: {
            block14: {
                string = "swept under rug";
                try {
                    try {
                        if (this.getCcnNetwork().isDiscoveryInProgress()) {
                            string = "skipped, discovery in progress";
                            break block13;
                        }
                        if (this.amIOutOfService()) {
                            string = "skipped, device is out of service";
                            this.pingFail(string);
                            this.setDeviceStatus("Off-Line");
                            Object var3_2 = null;
                            this.setDevicePingStatus(string);
                            return;
                        }
                        CcnResponseMessage ccnResponseMessage = this.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(this.getPingMessage());
                        if (ccnResponseMessage == null) {
                            string = "error, no response to ping " + this.descPingType() + " request";
                            this.pingFail(string);
                            this.setDeviceStatus("Off-Line");
                            break block14;
                        }
                        if (ccnResponseMessage.getResponseBuffer().getResponseCommand() == 6) {
                            this.pingOk();
                            this.setStatus(BStatus.ok);
                            this.setDeviceStatus("On-Line");
                            try {
                                this.processPingResponse(ccnResponseMessage);
                                string = "succeeded and parsed " + this.descPingType() + " from ping message";
                            }
                            catch (CcnException ccnException) {
                                string = "succeeded but could not parse " + this.descPingType() + " because:" + ccnException.toString();
                            }
                            break block13;
                        }
                        this.pingOk();
                        try {
                            string = "received " + this.descPingType() + " response but with NAK " + CcnRspTableUtil.parseRejectStatus(ccnResponseMessage);
                        }
                        catch (CcnException ccnException) {
                            string = "received " + this.descPingType() + " response but with command " + ccnResponseMessage.getResponseCommand();
                        }
                    }
                    catch (Throwable throwable) {
                        string = "could not complete last ping: " + throwable;
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.setDevicePingStatus(string);
                    throw throwable;
                }
            }
            Object var3_3 = null;
            this.setDevicePingStatus(string);
            return;
        }
        Object var3_5 = null;
        this.setDevicePingStatus(string);
    }

    public void doFetch() {
        this.getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(new CcnFetchDeviceDataRequest(this, this.getCcnNetwork()));
    }

    private final void reviewLicense() {
        boolean bl = false;
        if (!this.getCcnNetwork().getIsFullyLicensed()) {
            bl = true;
            this.setLrnUsrCfgPic10(false);
            this.setLrnMaintPic12(false);
            this.setLrnSvcCfgPic13(false);
            this.setLrnUsrCfgPoc14(false);
            this.setLrnMaintPoc15(false);
            this.setLrnSvcCfgPoc16(false);
        } else {
            bl = false;
        }
        this.setIsEnhancedVersion(bl ^ true);
    }

    public int readyUploadDownload() {
        if (this.getApplicationVersion() == null) {
            this.ccnNetworkLog.trace("Requested download for " + (Object)((Object)this) + " cannot be performed... it's applicationVersion()==null");
            return 2;
        }
        CcnReadTableRequest ccnReadTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)this.getElemNo(), (byte)this.getBusNo(), null, 32, 1, 6, 0, 0));
        CcnResponseMessage ccnResponseMessage = this.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(ccnReadTableRequest);
        if (ccnResponseMessage == null) {
            return 1;
        }
        if (ccnResponseMessage.getResponseCommand() != 6) {
            return 2;
        }
        try {
            if (CcnRspDevUtil.getPICType(ccnResponseMessage).equalsIgnoreCase("203UC") || CcnRspDevUtil.getPICType(ccnResponseMessage).equalsIgnoreCase("201X")) {
                return 0;
            }
            if (this.getPicType().trim().equals(CcnRspDevUtil.getPICType(ccnResponseMessage).trim()) && this.getApplicationVersion().trim().equals(CcnRspDevUtil.getPICApplSwVerNum(ccnResponseMessage).trim())) {
                return 0;
            }
        }
        catch (CcnException ccnException) {
            this.ccnNetworkLog.error("<readyUploadDownload, fetchBlock6: ERROR: " + (Object)((Object)ccnException));
        }
        return 2;
    }

    public String getSummaryString() {
        return this.getType() + '`' + this.getName() + '`';
    }

    public boolean areYouOutOfService() {
        return this.amIOutOfService();
    }

    private final boolean amIOutOfService() {
        boolean bl = this.getCcnNetwork().getComm().isCommStarted();
        boolean bl2 = this.getCcnNetwork().getEnabled();
        boolean bl3 = this.getEnabled();
        int n = this.getElemNo();
        int n2 = this.getBusNo();
        boolean bl4 = false;
        if (n > 0 && n < 239) {
            bl4 = true;
        }
        boolean bl5 = bl4;
        boolean bl6 = false;
        if (n2 >= 0 && n2 < 239) {
            bl6 = true;
        }
        boolean bl7 = bl6;
        boolean bl8 = false;
        if (bl3 && bl && bl2 && bl5 && bl7) {
            bl8 = true;
        }
        return bl8 ^ true;
    }

    private final CcnRequestMessage getPingMessage() {
        CcnRequestMessage ccnRequestMessage = null;
        ccnRequestMessage = this.pingForTimeAsOpposedToDate ? this.getPingTimeMessage() : this.getPingDateMessage();
        return ccnRequestMessage;
    }

    private final CcnRequestMessage getPingTimeMessage() {
        return this.getDateTimeMessage(CcnRspDTUtil.TIME_BLOCK);
    }

    private final CcnRequestMessage getPingDateMessage() {
        return this.getDateTimeMessage(CcnRspDTUtil.DATE_BLOCK);
    }

    private final String descPingType() {
        return this.pingForTimeAsOpposedToDate ? "time" : "date";
    }

    private final CcnRequestMessage getDateTimeMessage(int n) {
        short s = 33;
        byte by = 1;
        CcnTableDef ccnTableDef = new CcnTableDef((byte)this.getElemNo(), (byte)this.getBusNo(), null, s, by, (byte)n, 0, 0);
        return new CcnReadTableRequest(ccnTableDef);
    }

    private final void processPingResponse(CcnResponseMessage ccnResponseMessage) throws CcnException {
        BAbsTime bAbsTime = this.getDeviceTime();
        this.setDeviceTime(bAbsTime);
    }

    public boolean isDsCcnTableEntryLicensed(BCcnTableEntry bCcnTableEntry) {
        boolean bl = false;
        if (this.getIsEnhancedVersion() || !this.isTableTypeRestricted(bCcnTableEntry.getTableType(), bCcnTableEntry.getTableTypeString())) {
            bl = true;
        }
        return bl;
    }

    private final boolean isTableTypeRestricted(int n, String string) {
        boolean bl = false;
        if (n == 16 || n == 18 || n == 19 || n == 20 && !string.equals("Time_Schedules") || n == 21 || n == 22) {
            bl = true;
        }
        return bl;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean bl) {
        this.abort = bl;
    }

    public void getExistingTableArray(BComponent bComponent, Vector vector) {
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] instanceof BCcnTable) {
                BCcnTable bCcnTable = (BCcnTable)bComponentArray[n];
                if (bCcnTable instanceof BCcnPicTable || bCcnTable instanceof BCcnPocTable) {
                    if (bCcnTable.getTableType() < 16 || bCcnTable.getTableType() > 24) {
                        String string = bCcnTable instanceof BCcnPicTable ? "CcnPicTable" : "CcnPocTable";
                    } else {
                        vector.addElement(bCcnTable);
                        if (bCcnTable instanceof BCcnPocTable) {
                            this.getExistingTableArray(bCcnTable, vector);
                        }
                    }
                } else if (bCcnTable instanceof BCcnAHTable) {
                    if (bCcnTable.getTableType() == 67 && bCcnTable.getTableInstance() == 1) {
                        vector.addElement(bCcnTable);
                    }
                } else {
                    vector.addElement(bCcnTable);
                }
            }
            this.getExistingTableArray(bComponentArray[n], vector);
            ++n;
        }
    }

    public void unsolicitedAlarmReceived(CcnUnsolicitedMsg ccnUnsolicitedMsg) throws CcnException {
        this.addAlarm(BString.make((String)CcnAlarmUtil.getAlarmConsoleSummary(ccnUnsolicitedMsg, ((BCcnNetwork)this.getNetwork()).getDisplayMetric())), BString.make((String)(CcnAlarmUtil.getTypeDesc((CcnDataWrapper)ccnUnsolicitedMsg) + " - " + CcnAlarmUtil.getSourceDesc((CcnDataWrapper)ccnUnsolicitedMsg))), BString.make((String)CcnAlarmUtil.getFormattedValue((CcnDataWrapper)ccnUnsolicitedMsg, false, ((BCcnNetwork)this.getNetwork()).getDisplayMetric())));
    }

    public void addAlarm(BString bString, BString bString2, BString bString3) {
        try {
            if (this.alarmServ == null) {
                this.alarmServ = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            }
            BFacets bFacets = BFacets.make((Map)this.ccnHashMap(bString, bString2, bString3));
            BAlarmRecord bAlarmRecord = new BAlarmRecord();
            bAlarmRecord.setSource(BOrdList.make((BOrd)this.getAlarmSourceInfo().getNavOrd()));
            bAlarmRecord.setAlarmClass(this.getAlarmSourceInfo().getAlarmClass());
            bAlarmRecord.setAlarmData(bFacets);
            this.alarmServ.routeAlarm(bAlarmRecord);
        }
        catch (Exception exception) {
            this.ccnNetworkLog.error("Exception on add Alarm ::: " + exception.toString());
        }
    }

    private final HashMap ccnHashMap(BString bString, BString bString2, BString bString3) {
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmText", bString);
        hashMap.put("alarmType", bString2);
        hashMap.put("alarmValue", bString3);
        return hashMap;
    }

    public boolean isDeviceStatusOk() {
        return !this.isDown() && !this.isDisabled() && !this.isFatalFault() && !this.isFault();
    }

    public BIcon getIcon() {
        return this.icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.icon = BIcon.make((BOrd)BOrd.make((String)"local:|module://ccn/com/tridium/ccn/images/CcnDevice.gif"));
        this.hasHadAtLeastOneRealPing = false;
        this.unsuccessfulPingFlag = false;
        this.lastUnsuccessfulPingTicks = 0L;
        this.maxSuccessfulPingInterval = 120000L;
        this.pingForTimeAsOpposedToDate = true;
        this.abort = false;
        this.registeredTableGroups = new Hashtable();
        this.tablesVector = new Vector(0);
        this.registeredObjects = new Vector(2);
        this.pollTableExts = new BCcnTable[0];
        this.allTableExts = new BCcnTable[0];
        this.vPollTableExts = new Vector(0);
        this.vAllTableExts = new Vector(0);
        this.devFolder = null;
        this.objNetwork = null;
        this.ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");
        this.alarmServ = null;
    }

    public BCcnDevice() {
        this.this();
    }

    public BCcnDevice(BCcnControllerEntry bCcnControllerEntry) {
        this.this();
        this.entry = bCcnControllerEntry;
        this.setBusNo(bCcnControllerEntry.getBusNo());
        this.setElemNo(bCcnControllerEntry.getElemNo());
        this.setDeviceName(bCcnControllerEntry.getDevName());
        this.setDuplicateDeviceName(bCcnControllerEntry.getDevName());
        this.setDeviceType(BCcnDeviceTypeEnum.make(bCcnControllerEntry.getDevType()));
    }

    static {
        Class clazz = class$com$tridium$ccn$BCcnDevice;
        if (clazz == null) {
            clazz = class$com$tridium$ccn$BCcnDevice = BCcnDevice.class("[Lcom.tridium.ccn.BCcnDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

