/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.qnx;

import com.tridium.platSerial.BSerialPort;
import com.tridium.platform.NativePlatformLibraryTridium;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSerialPortQnx
extends BSerialPort {
    public static final Type TYPE;
    private static String STATION_PREFIX;
    private int fd;
    private BBaudRate baudrate;
    private BSerialDataBits databits;
    private BSerialStopBits stopbits;
    private BSerialParity parity;
    private BSerialFlowControlMode flowControl;
    private int rcvThreshold;
    private int rcvTimeout;
    static /* synthetic */ Class class$com$tridium$platSerial$qnx$BSerialPortQnx;

    public Type getType() {
        return TYPE;
    }

    public synchronized void lock(String string) throws PortNotFoundException, PortDeniedException {
        this.checkOwner();
        if (!this.getOwner().equals("none")) {
            throw new PortDeniedException(this.getName() + " is already owned by " + this.getOwner());
        }
        this.setOwner(string);
        this.locked = true;
        String string2 = this.getOsPortName().indexOf("gprs") == -1 ? "/dev/shmem/ser" + Integer.toString(this.getPortIndex()) + ".owner" : "/dev/shmem/sergprs" + Integer.toString(this.getPortIndex()) + ".owner";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write((STATION_PREFIX + string).getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.setOwner("none");
            throw new PortDeniedException("Unable to create lock for " + this.getName() + ": " + exception.getMessage());
        }
    }

    public synchronized void unlock() throws PortDeniedException {
        if (!this.locked) {
            throw new PortDeniedException(this.getName() + " does not have the port lock");
        }
        File file = new File("/dev/shmem/ser" + Integer.toString(this.getPortIndex()) + ".owner");
        file.delete();
        this.setOwner("none");
        this.locked = false;
    }

    public synchronized void initOwner() {
        String string = this.getOsPortName().indexOf("gprs") == -1 ? "/dev/shmem/ser" + Integer.toString(this.getPortIndex()) + ".owner" : "/dev/shmem/sergprs" + Integer.toString(this.getPortIndex()) + ".owner";
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n = fileInputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = fileInputStream.read();
            }
            fileInputStream.close();
            String string2 = stringBuffer.toString();
            if (string2.startsWith(STATION_PREFIX)) {
                log.trace("Cleaning up old lock file " + string + " old owner: " + string2);
                new File(string).delete();
                this.setOwner("none");
                this.locked = false;
            } else {
                log.trace("Port owned by " + string2 + ", lock file " + string);
                this.locked = true;
                this.setOwner(string2);
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            log.error("Problem reading lock file for " + this.getName(), (Throwable)exception);
        }
        this.setOwner("none");
    }

    public synchronized void checkOwner() {
        String string = this.getOsPortName().indexOf("gprs") == -1 ? "/dev/shmem/ser" + Integer.toString(this.getPortIndex()) + ".owner" : "/dev/shmem/sergprs" + Integer.toString(this.getPortIndex()) + ".owner";
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n = fileInputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = fileInputStream.read();
            }
            fileInputStream.close();
            this.locked = true;
            this.setOwner(stringBuffer.toString());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            log.error("Problem reading lock file for " + this.getName(), (Throwable)exception);
        }
        this.setOwner("none");
    }

    protected void openPort() {
        this.fd = this.open0(this.getOsPortName());
    }

    protected void closePort() {
        if (this.fd > 0) {
            this.close0(this.fd);
            this.fd = 0;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Invalid file descriptor");
        }
        return new SerialInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Invalid file descriptor");
        }
        return new SerialOutputStream();
    }

    public void enableReceiveThreshold(int n) throws UnsupportedOperationException {
        if (n <= 0) {
            throw new UnsupportedOperationException("Threshold must be >= 1");
        }
        this.rcvThreshold = n;
    }

    public void disableReceiveThreshold() {
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        boolean bl = false;
        if (this.rcvThreshold >= 0) {
            bl = true;
        }
        return bl;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int n) throws UnsupportedOperationException {
        this.rcvTimeout = n;
    }

    public void disableReceiveTimeout() {
        this.rcvTimeout = -1;
    }

    public boolean isReceiveTimeoutEnabled() {
        boolean bl = false;
        if (this.rcvTimeout >= 0) {
            bl = true;
        }
        return bl;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    public BBaudRate getBaudRate() {
        return this.baudrate;
    }

    public BSerialDataBits getDataBits() {
        return this.databits;
    }

    public BSerialStopBits getStopBits() {
        return this.stopbits;
    }

    public BSerialParity getParity() {
        return this.parity;
    }

    public void sendBreak(int n) {
        if (this.fd <= 0) {
            return;
        }
        this.sendBreak0(this.fd, n);
    }

    public void setFlowControlMode(BSerialFlowControlMode bSerialFlowControlMode) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        if (bSerialFlowControlMode != BSerialFlowControlMode.none && bSerialFlowControlMode != BSerialFlowControlMode.rtsCtsOnInput && bSerialFlowControlMode != BSerialFlowControlMode.rtsCtsOnOutput && bSerialFlowControlMode != BSerialFlowControlMode.xonXoffOnInput && bSerialFlowControlMode != BSerialFlowControlMode.xonXoffOnOutput) {
            throw new UnsupportedOperationException("Invalid flow control mode.");
        }
        this.setFlowControlMode0(this.fd, bSerialFlowControlMode.getBits());
        this.flowControl = bSerialFlowControlMode;
    }

    public BSerialFlowControlMode getFlowControlMode() {
        return this.flowControl;
    }

    public void setSerialPortParams(BBaudRate bBaudRate, BSerialDataBits bSerialDataBits, BSerialStopBits bSerialStopBits, BSerialParity bSerialParity) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        this.setSerialPortParams0(this.fd, bBaudRate.getOrdinal(), bSerialDataBits.getOrdinal(), bSerialStopBits.getOrdinal(), bSerialParity.getOrdinal());
        this.baudrate = bBaudRate;
        this.databits = bSerialDataBits;
        this.stopbits = bSerialStopBits;
        this.parity = bSerialParity;
    }

    public void setDTR(boolean bl) {
        if (this.fd <= 0) {
            return;
        }
        this.setDTR0(this.fd, bl);
    }

    public boolean isDTR() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isDTR0(this.fd);
    }

    public void setRTS(boolean bl) {
        if (this.fd <= 0) {
            return;
        }
        this.setRTS0(this.fd, bl);
    }

    public boolean isRTS() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isRTS0(this.fd);
    }

    public boolean isCTS() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isCTS0(this.fd);
    }

    public boolean isDSR() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isDSR0(this.fd);
    }

    public boolean isRI() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isRI0(this.fd);
    }

    public boolean isCD() {
        if (this.fd <= 0) {
            return false;
        }
        return this.isCD0(this.fd);
    }

    private final native int open0(String var1);

    private final native int available0(int var1);

    private final native void close0(int var1);

    private final native int read0(int var1, int var2);

    private final native int read0(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    private final native void write0(int var1, int var2);

    private final native void write0(int var1, byte[] var2, int var3, int var4);

    private final native void flush0(int var1);

    private final native void setSerialPortParams0(int var1, int var2, int var3, int var4, int var5);

    private final native boolean isCD0(int var1);

    private final native boolean isCTS0(int var1);

    private final native boolean isDSR0(int var1);

    private final native boolean isDTR0(int var1);

    private final native boolean isRI0(int var1);

    private final native boolean isRTS0(int var1);

    private final native void setFlowControlMode0(int var1, int var2);

    private final native void setRTS0(int var1, boolean var2);

    private final native void setDTR0(int var1, boolean var2);

    private final native void sendBreak0(int var1, int var2);

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fd = 0;
        this.baudrate = BSerialBaudRate.baud9600;
        this.databits = BSerialDataBits.dataBits8;
        this.stopbits = BSerialStopBits.stopBit1;
        this.parity = BSerialParity.none;
        this.flowControl = BSerialFlowControlMode.none;
        this.rcvThreshold = -1;
        this.rcvTimeout = -1;
    }

    public BSerialPortQnx() {
        this.this();
    }

    public BSerialPortQnx(String string, int n) {
        this.this();
        NativePlatformLibraryTridium.load();
        this.setOsPortName(string);
        this.setPortIndex(n);
        this.initOwner();
    }

    static {
        Class clazz = class$com$tridium$platSerial$qnx$BSerialPortQnx;
        if (clazz == null) {
            clazz = class$com$tridium$platSerial$qnx$BSerialPortQnx = BSerialPortQnx.class("[Lcom.tridium.platSerial.qnx.BSerialPortQnx;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        STATION_PREFIX = "station:";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SerialInputStream
    extends InputStream {
        boolean closed;

        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            int n = BSerialPortQnx.this.available0(BSerialPortQnx.this.fd);
            if (n < 0) {
                throw new IOException("Unable to read available bytes");
            }
            return n;
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            return BSerialPortQnx.this.read0(BSerialPortQnx.this.fd, BSerialPortQnx.this.rcvTimeout);
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            return BSerialPortQnx.this.read0(BSerialPortQnx.this.fd, BSerialPortQnx.this.rcvTimeout, BSerialPortQnx.this.rcvThreshold, byArray, n, n2);
        }

        public void close() throws IOException {
            this.closed = true;
        }

        private final /* synthetic */ void this() {
            this.closed = false;
        }

        SerialInputStream() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SerialOutputStream
    extends OutputStream {
        boolean closed;

        public void write(int n) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortQnx.this.write0(BSerialPortQnx.this.fd, n);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortQnx.this.write0(BSerialPortQnx.this.fd, byArray, n, n2);
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortQnx.this.flush0(BSerialPortQnx.this.fd);
        }

        public void close() throws IOException {
            this.closed = true;
        }

        private final /* synthetic */ void this() {
            this.closed = false;
        }

        SerialOutputStream() {
            this.this();
        }
    }
}

