/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.point;

import com.tridium.jcin2.BJciDx9100Device;
import com.tridium.jcin2.BJciS91Device;
import com.tridium.jcin2.BJciTc9100Device;
import com.tridium.jcin2.BJciXt9100Device;
import com.tridium.jcin2.messages.JciN2MessageConst;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.S91ReadBlockExtMessage;
import com.tridium.jcin2.messages.S91ReadMessage;
import com.tridium.jcin2.messages.S91ReadResponse;
import com.tridium.jcin2.messages.S91ReadSingleItemExtMessage;
import com.tridium.jcin2.messages.S91ReadSingleItemMessage;
import com.tridium.jcin2.point.BJciN2ProxyExt;
import com.tridium.jcin2.point.BJciS91PointDeviceExt;
import com.tridium.jcin2.util.JciDx9100MapData;
import com.tridium.jcin2.util.JciS91MapData;
import com.tridium.jcin2.util.JciTc9100MapData;
import com.tridium.jcin2.util.JciXt9100MapData;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJciS91ProxyExt
extends BJciN2ProxyExt
implements JciN2MessageConst {
    public static final Type TYPE;
    JciS91MapData mapData;
    boolean trace;
    int deviceType;
    static /* synthetic */ Class class$com$tridium$jcin2$point$BJciS91ProxyExt;

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BJciS91PointDeviceExt.TYPE;
    }

    public void started() {
        super.started();
        if (this.getN2Device() != null) {
            this.genMapData();
            if (this.mapData.isBackgroundPolled()) {
                ((BJciS91Device)this.getN2Device()).registerListener(this);
            }
            if (this.mapData.isGroupPolled()) {
                ((BJciS91Device)this.getN2Device()).registerToPollGroup(this);
            }
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)networkPointType) || property.equals((Object)networkPointAddress)) {
            ((BJciS91Device)this.getN2Device()).unregisterListener(this);
            if (this.mapData.isGroupPolled()) {
                ((BJciS91Device)this.getN2Device()).unregisterToPollGroup(this);
            }
            this.genMapData();
            if (this.mapData.isBackgroundPolled()) {
                ((BJciS91Device)this.getN2Device()).registerListener(this);
            }
            if (this.mapData.isGroupPolled()) {
                ((BJciS91Device)this.getN2Device()).registerToPollGroup(this);
                if (this.isSubscribedDesired()) {
                    try {
                        ((BJciS91Device)this.getN2Device()).subscribeToPollGroup(this);
                    }
                    catch (Exception exception) {
                        this.getN2Log().trace("exception re-subscribing " + this + " after property change");
                    }
                }
            }
        }
        if (property.equals((Object)status)) {
            BStatus bStatus = this.getStatus();
            BStatusValue bStatusValue = this.getReadValue();
            if (bStatus.isFault()) {
                String string = "???";
                if (this.getN2Device() != null) {
                    string = this.getN2Device().getName();
                }
                this.getN2Log().trace("S91 STATUS Changed for: " + string + ": " + this + ", status: " + bStatus + ", value: " + bStatusValue + ", cause: " + this.getFaultCause());
            }
        }
    }

    public void stopped() throws Exception {
        if (this.getN2Device() != null) {
            ((BJciS91Device)this.getN2Device()).unregisterListener(this);
            if (this.mapData.isGroupPolled()) {
                ((BJciS91Device)this.getN2Device()).unregisterToPollGroup(this);
            }
            this.mapData = null;
        }
        super.stopped();
    }

    public void readSubscribed(Context context) throws Exception {
        this.getN2Log().trace("readSubscribed on " + this);
        if (this.mapData.isBackgroundPolled()) {
            return;
        }
        if (this.mapData.isGroupPolled()) {
            ((BJciS91Device)this.getN2Device()).subscribeToPollGroup(this);
        } else {
            this.getN2Network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void readUnsubscribed(Context context) throws Exception {
        this.getN2Log().trace("readUnsubscribed on " + this);
        if (this.mapData.isBackgroundPolled()) {
            return;
        }
        if (this.mapData.isGroupPolled()) {
            ((BJciS91Device)this.getN2Device()).unsubscribeToPollGroup(this);
        } else {
            this.getN2Network().getPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    private final void genMapData() {
        if (this.getN2Device().getType().is(BJciTc9100Device.TYPE)) {
            this.mapData = new JciTc9100MapData(this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress() - 1);
            this.getN2Log().trace("GENERATE TC9100 MAP DATA FOR " + this);
        } else if (this.getN2Device().getType().is(BJciDx9100Device.TYPE)) {
            this.mapData = new JciDx9100MapData(this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress() - 1);
            this.getN2Log().trace("GENERATE DX9100 MAP DATA FOR " + this);
        } else if (this.getN2Device().getType().is(BJciXt9100Device.TYPE)) {
            this.mapData = new JciXt9100MapData(this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress() - 1);
            this.getN2Log().trace("GENERATE XT9100 MAP DATA FOR " + this);
        } else {
            this.getN2Log().trace("CANNOT GENERATE MAP DATA FOR POINT " + this.getName());
        }
    }

    public void poll() {
        S91ReadMessage s91ReadMessage;
        this.trace = this.getN2Log().isTraceOn();
        this.deviceType = this.getN2Device().getDeviceCode();
        if (!((BJciS91Device)this.getN2Device()).isDeviceCodeValid()) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        this.pointTrace(this, true);
        if (this.mapData.getReadCmd() == 172) {
            s91ReadMessage = new S91ReadBlockExtMessage(this.getN2Device().getAddress(), this.mapData.getReadStartAddress(), this.mapData.getItemsToRead());
        } else if (this.mapData.getReadCmd() == 132) {
            s91ReadMessage = new S91ReadSingleItemExtMessage(this.getN2Device().getAddress(), this.mapData.getReadStartAddress());
        } else if (this.mapData.getReadCmd() == 128) {
            s91ReadMessage = new S91ReadSingleItemMessage(this.getN2Device().getAddress(), this.mapData.getReadStartAddress());
        } else {
            this.readFail("cmd type not found");
            return;
        }
        S91ReadResponse s91ReadResponse = (S91ReadResponse)this.getN2Network().sendSync(s91ReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (s91ReadResponse != null) {
            if (!s91ReadResponse.isError()) {
                this.getN2Device().pingOk();
                this.setValue(s91ReadResponse);
            } else {
                this.getN2Log().trace("Read Response is Error! " + s91ReadResponse.getError());
                this.readFail(s91ReadResponse.getError());
            }
        } else {
            this.getN2Log().trace("Read Failed S91 - null response!");
            this.readFail("Null Response");
            this.getN2Device().pingFail("null response to point poll of " + this);
        }
        this.pointTrace(this, false);
    }

    public abstract void setValue(BStatusValue var1);

    public void setValue(JciN2Response jciN2Response) {
        this.pointTrace(this, true);
        switch (this.getN2Device().getDeviceCode()) {
            case 1: 
            case 6: 
            case 17: 
            case 22: 
            case 118: {
                ((BJciTc9100Device)this.getN2Device()).setValue(jciN2Response, this);
                break;
            }
            case 2: 
            case 18: {
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 21: 
            case 117: 
            case 133: {
                ((BJciDx9100Device)this.getN2Device()).setValue(jciN2Response, this);
                break;
            }
            case 8: 
            case 24: 
            case 40: {
                ((BJciXt9100Device)this.getN2Device()).setValue(jciN2Response, this);
                break;
            }
        }
        this.pointTrace(this, false);
    }

    public void setValueFromBackgroundPoll(int n) {
        switch (this.mapData.getNpt()) {
            case 2: 
            case 7: 
            case 8: {
                int n2 = this.mapData.getItemValueMask();
                boolean bl = false;
                if ((n & n2) != 0) {
                    bl = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
                int n3 = this.mapData.getFaultMask();
                this.setValue((BStatusValue)bStatusBoolean);
                break;
            }
        }
    }

    public void setValueFromBackgroundPoll(int n, BStatus bStatus) {
        switch (this.mapData.getNpt()) {
            case 2: 
            case 7: 
            case 8: {
                int n2 = this.mapData.getItemValueMask();
                boolean bl = false;
                if ((n & n2) != 0) {
                    bl = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
                bStatusBoolean.setStatus(bStatus);
                this.setValue((BStatusValue)bStatusBoolean);
                break;
            }
        }
    }

    void write(BStatusValue bStatusValue) {
        ((BJciS91Device)this.getN2Device()).write(bStatusValue, this);
    }

    public boolean sendWrite(S91ReadMessage s91ReadMessage, BStatusValue bStatusValue) {
        JciN2Response jciN2Response = (JciN2Response)this.getN2Network().sendSync(s91ReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (this.isResponseError(jciN2Response, bStatusValue)) {
            this.getN2Log().trace("S91 Set Value Failed!");
            this.writeFail("Error writing point");
            return false;
        }
        this.doForceRead();
        if (this.trace) {
            this.getN2Log().trace("S91 doForceRead on: " + this.getN2Device().getName() + ": " + this);
        }
        return true;
    }

    public boolean isResponseError(JciN2Response jciN2Response, BStatusValue bStatusValue) {
        if (jciN2Response != null) {
            if (!jciN2Response.isError()) {
                this.getN2Device().pingOk();
                this.writeOk(bStatusValue);
                return false;
            }
            this.getN2Log().trace("S91 Write Operation Error!");
            if (jciN2Response.getErrorCode() == 0) {
                this.getN2Device().setNeedsId(true);
                this.getN2Device().ping();
                try {
                    this.write(rewriteCx);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.writeFail(jciN2Response.getError());
            return true;
        }
        this.getN2Log().trace("S91 Write Operation Failed - null response!");
        this.writeFail("Null Response");
        this.getN2Device().pingFail("null response to point poll of " + this);
        return true;
    }

    void setpoint(BValue bValue) {
        Type type;
        if (this.getN2Log().isTraceOn()) {
            this.getN2Log().trace("S91 setpoint");
        }
        if ((type = bValue.getType()).is(BDouble.TYPE)) {
            this.write((BStatusValue)new BStatusNumeric(BJciS91ProxyExt.getReal(bValue)));
        }
        if (type.is(BBoolean.TYPE)) {
            this.write((BStatusValue)new BStatusBoolean(BJciS91ProxyExt.getBinary(bValue)));
        }
        if (type.is(BEnum.TYPE)) {
            this.write((BStatusValue)new BStatusEnum((BEnum)bValue));
        }
        if (type.is(BString.TYPE)) {
            this.write((BStatusValue)new BStatusString(((BString)bValue).getString()));
        }
    }

    public static double getReal(BValue bValue) {
        Type type = bValue.getType();
        if (type.is(BStatusNumeric.TYPE)) {
            return ((BStatusNumeric)bValue).getValue();
        }
        if (type.is(BDouble.TYPE)) {
            return ((BDouble)bValue).getDouble();
        }
        if (type.is(BStatusBoolean.TYPE)) {
            return ((BStatusBoolean)bValue).getValue() ? 1.0 : 0.0;
        }
        if (type.is(BBoolean.TYPE)) {
            return ((BBoolean)bValue).getBoolean() ? 1.0 : 0.0;
        }
        if (type.is(BStatusEnum.TYPE)) {
            return ((BStatusEnum)bValue).getValue().getOrdinal();
        }
        if (type.is(BEnum.TYPE)) {
            return ((BEnum)bValue).getOrdinal();
        }
        if (type.is(BStatusString.TYPE)) {
            return Double.parseDouble(((BStatusString)bValue).getValue());
        }
        if (type.is(BString.TYPE)) {
            return Double.parseDouble(((BString)bValue).getString());
        }
        return 0.0;
    }

    public static boolean getBinary(BValue bValue) {
        Type type = bValue.getType();
        if (type.is(BStatusBoolean.TYPE)) {
            return ((BStatusBoolean)bValue).getValue();
        }
        if (type.is(BBoolean.TYPE)) {
            return ((BBoolean)bValue).getBoolean();
        }
        if (type.is(BStatusNumeric.TYPE)) {
            boolean bl = false;
            if (((BStatusNumeric)bValue).getValue() != 0.0) {
                bl = true;
            }
            return bl;
        }
        if (type.is(BDouble.TYPE)) {
            boolean bl = false;
            if (((BDouble)bValue).getDouble() != 0.0) {
                bl = true;
            }
            return bl;
        }
        if (type.is(BStatusEnum.TYPE)) {
            boolean bl = false;
            if (((BStatusEnum)bValue).getValue().getOrdinal() != 0) {
                bl = true;
            }
            return bl;
        }
        if (type.is(BEnum.TYPE)) {
            boolean bl = false;
            if (((BEnum)bValue).getOrdinal() != 0) {
                bl = true;
            }
            return bl;
        }
        if (type.is(BStatusString.TYPE)) {
            boolean bl = false;
            if (Integer.parseInt(((BStatusString)bValue).getValue()) != 0) {
                bl = true;
            }
            return bl;
        }
        if (type.is(BString.TYPE)) {
            boolean bl = false;
            if (Integer.parseInt(((BString)bValue).getString()) != 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static long getLong(BValue bValue) {
        Type type = bValue.getType();
        if (type.is(BStatusBoolean.TYPE)) {
            return ((BStatusBoolean)bValue).getValue() ? 1L : 0L;
        }
        if (type.is(BBoolean.TYPE)) {
            return ((BBoolean)bValue).getBoolean() ? 1L : 0L;
        }
        if (type.is(BStatusNumeric.TYPE)) {
            return (long)((BStatusNumeric)bValue).getValue();
        }
        if (type.is(BDouble.TYPE)) {
            return ((BDouble)bValue).getLong();
        }
        if (type.is(BStatusEnum.TYPE)) {
            return ((BStatusEnum)bValue).getValue().getOrdinal();
        }
        if (type.is(BEnum.TYPE)) {
            return ((BEnum)bValue).getOrdinal();
        }
        if (type.is(BStatusString.TYPE)) {
            return Long.parseLong(((BStatusString)bValue).getValue());
        }
        if (type.is(BString.TYPE)) {
            return Long.parseLong(((BString)bValue).getString());
        }
        return 0L;
    }

    public boolean isValid() {
        boolean bl = ((BJciS91Device)this.getN2Device()).isValidPointForDeviceType(this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress() - 1);
        boolean bl2 = super.isValid();
        return bl2 & bl;
    }

    private final String debugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dev: " + this.getN2Device().getDeviceCode() + ' ');
        stringBuffer.append("adr: " + this.getN2Device().getAddress() + ' ');
        stringBuffer.append("npt: " + this.getNetworkPointType().getOrdinal() + ' ');
        stringBuffer.append("npa: " + (this.getNetworkPointAddress() - 1) + '\n');
        return stringBuffer.toString();
    }

    public JciS91MapData getMapData() {
        return this.mapData;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$jcin2$point$BJciS91ProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$point$BJciS91ProxyExt = BJciS91ProxyExt.class("[Lcom.tridium.jcin2.point.BJciS91ProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

